/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.factory;

import java.io.File;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.h2.Driver;
import org.h2.jdbcx.JdbcDataSource;
import org.h2gis.functions.factory.H2GISFunctions;

public class H2GISDBFactory {
    public static final String H2_PARAMETERS = ";DB_CLOSE_ON_EXIT=FALSE";
    public static final String JDBC_URL = "url";
    public static final String JDBC_USER = "user";
    public static final String JDBC_PASSWORD = "password";
    public static final String START_URL = "jdbc:h2:";
    public static final String JDBC_DATABASE_NAME = "databaseName";
    public static final String JDBC_NETWORK_PROTOCOL = "networkProtocol";
    public static final String JDBC_PORT_NUMBER = "portNumber";
    public static final String JDBC_SERVER_NAME = "serverName";
    public static final String DEFAULT_USER = "sa";
    public static final String DEFAULT_PASSWORD = "sa";

    private H2GISDBFactory() {
    }

    public static Connection openSpatialDataBase(String dbName) throws SQLException {
        String dbFilePath = H2GISDBFactory.getDataBasePath(dbName);
        String databasePath = START_URL + dbFilePath + H2_PARAMETERS;
        Driver.load();
        return DriverManager.getConnection(databasePath, "sa", "sa");
    }

    public static Connection createSpatialDataBase(String dbName) throws SQLException {
        return H2GISDBFactory.createSpatialDataBase(dbName, true);
    }

    private static String getDataBasePath(String dbName) {
        if (dbName.startsWith("file://")) {
            return new File(URI.create(dbName)).getAbsolutePath();
        }
        return new File("target/test-resources/dbH2" + dbName).getAbsolutePath();
    }

    public static DataSource createDataSource(String dbName, boolean initSpatial) throws SQLException {
        return H2GISDBFactory.createDataSource(dbName, initSpatial, H2_PARAMETERS);
    }

    public static DataSource createDataSource(Properties properties) throws SQLException {
        return H2GISDBFactory.createDataSource(properties, true);
    }

    public static DataSource createDataSource(Properties properties, boolean initSpatial) throws SQLException {
        JdbcDataSource dataSource = new JdbcDataSource();
        H2GISDBFactory.setupH2DataSource(dataSource, properties);
        if (initSpatial) {
            try (Connection connection = dataSource.getConnection();){
                H2GISFunctions.load(connection);
            }
        }
        return dataSource;
    }

    public static DataSource createDataSource(String dbName, boolean initSpatial, String h2Parameters) throws SQLException {
        Properties properties = new Properties();
        String databasePath = H2GISDBFactory.initDBFile(dbName, h2Parameters);
        properties.setProperty(JDBC_URL, databasePath);
        properties.setProperty(JDBC_USER, "sa");
        properties.setProperty(JDBC_PASSWORD, "sa");
        JdbcDataSource dataSource = new JdbcDataSource();
        H2GISDBFactory.setupH2DataSource(dataSource, properties);
        if (initSpatial) {
            try (Connection connection = dataSource.getConnection();){
                H2GISFunctions.load(connection);
            }
        }
        return dataSource;
    }

    private static String initDBFile(String dbName, String h2_PARAMETERS) {
        String dbFilePath = H2GISDBFactory.getDataBasePath(dbName);
        File dbFile = new File(dbFilePath + ".mv.db");
        String databasePath = START_URL + dbFilePath + h2_PARAMETERS;
        if (dbFile.exists()) {
            dbFile.delete();
        }
        if ((dbFile = new File(dbFilePath + ".mv.db")).exists()) {
            dbFile.delete();
        }
        return databasePath;
    }

    public static Connection createSpatialDataBase(String dbName, boolean initSpatial, String h2Parameters) throws SQLException {
        String databasePath = H2GISDBFactory.initDBFile(dbName, h2Parameters);
        Driver.load();
        Connection connection = DriverManager.getConnection(databasePath, "sa", "sa");
        if (initSpatial) {
            H2GISFunctions.load(connection);
        }
        return connection;
    }

    public static Connection createSpatialDataBase(String dbName, boolean initSpatial) throws SQLException {
        return H2GISDBFactory.createSpatialDataBase(dbName, initSpatial, H2_PARAMETERS);
    }

    private static void setupH2DataSource(JdbcDataSource dataSource, Properties props) {
        if (props.containsKey(JDBC_USER)) {
            dataSource.setUser(props.getProperty(JDBC_USER));
        }
        if (props.containsKey(JDBC_PASSWORD)) {
            dataSource.setPassword(props.getProperty(JDBC_PASSWORD));
        }
        if (props.containsKey(JDBC_URL)) {
            dataSource.setURL(props.getProperty(JDBC_URL));
        } else {
            StringBuilder connectionUrl = new StringBuilder();
            connectionUrl.append(START_URL);
            String protocol = "";
            if (props.containsKey(JDBC_NETWORK_PROTOCOL)) {
                protocol = props.getProperty(JDBC_NETWORK_PROTOCOL);
                connectionUrl.append(protocol).append(":");
            }
            if (props.containsKey(JDBC_SERVER_NAME)) {
                connectionUrl.append("//").append(props.getProperty(JDBC_SERVER_NAME));
                if (props.containsKey(JDBC_PORT_NUMBER)) {
                    connectionUrl.append(":").append(props.getProperty(JDBC_PORT_NUMBER));
                }
                connectionUrl.append("/");
            } else if (props.containsKey(JDBC_PORT_NUMBER)) {
                connectionUrl.append("//localhost:").append(props.getProperty(JDBC_PORT_NUMBER)).append("/");
            } else if (protocol.equals("tcp") || protocol.equals("ssl")) {
                connectionUrl.append("//localhost/");
            }
            if (props.containsKey(JDBC_DATABASE_NAME)) {
                connectionUrl.append(props.getProperty(JDBC_DATABASE_NAME));
            }
            dataSource.setURL(connectionUrl.toString());
        }
    }
}

