/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.data;

import org.javanetworkanalyzer.data.PathLengthData;

public class UnweightedPathLengthData
extends PathLengthData<Integer> {
    private int maxLength = 0;
    private int totalLength = 0;

    @Override
    public void clear() {
        super.clear();
        this.totalLength = 0;
        this.maxLength = 0;
    }

    @Override
    public void addSPLength(Integer length) {
        ++this.count;
        this.totalLength += length.intValue();
        if (this.maxLength < length) {
            this.maxLength = length;
        }
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public Integer getTotalLength() {
        return this.totalLength;
    }

    @Override
    public double getAverageLength() {
        if (this.getCount() == 0) {
            throw new IllegalStateException("No shortest path lengths accumulated in this instance.");
        }
        return (double)this.getTotalLength().intValue() / (double)this.getCount();
    }
}

