/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation.delaunay.sweep;

import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.delaunay.sweep.AdvancingFrontNode;

public class AdvancingFront {
    public AdvancingFrontNode head;
    public AdvancingFrontNode tail;
    protected AdvancingFrontNode search;

    public AdvancingFront(AdvancingFrontNode head, AdvancingFrontNode tail) {
        this.head = head;
        this.tail = tail;
        this.search = head;
        this.addNode(head);
        this.addNode(tail);
    }

    public void addNode(AdvancingFrontNode node) {
    }

    public void removeNode(AdvancingFrontNode node) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        AdvancingFrontNode node = this.head;
        while (node != this.tail) {
            sb.append(node.point.getX()).append("->");
            node = node.next;
        }
        sb.append(this.tail.point.getX());
        return sb.toString();
    }

    private final AdvancingFrontNode findSearchNode(double x) {
        return this.search;
    }

    public AdvancingFrontNode locateNode(TriangulationPoint point) {
        return this.locateNode(point.getX());
    }

    private AdvancingFrontNode locateNode(double x) {
        AdvancingFrontNode node = this.findSearchNode(x);
        if (x < node.value) {
            while ((node = node.prev) != null) {
                if (!(x >= node.value)) continue;
                this.search = node;
                return node;
            }
        } else {
            while ((node = node.next) != null) {
                if (!(x < node.value)) continue;
                this.search = node.prev;
                return node.prev;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AdvancingFrontNode locatePoint(TriangulationPoint point) {
        double px = point.getX();
        AdvancingFrontNode node = this.findSearchNode(px);
        double nx = node.point.getX();
        if (px == nx) {
            if (point != node.point) {
                if (point == node.prev.point) {
                    node = node.prev;
                } else {
                    if (point != node.next.point) throw new RuntimeException("Failed to find Node for given afront point");
                    node = node.next;
                }
            }
        } else if (px < nx) {
            while ((node = node.prev) != null && point != node.point) {
            }
        } else {
            while ((node = node.next) != null && point != node.point) {
            }
        }
        this.search = node;
        return node;
    }
}

