/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.h2gis.utilities.GeometryMetaData;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GeometryTableUtilities {
    public static Tuple<String, GeometryMetaData> getFirstColumnMetaData(Connection connection, String geometryTable) throws SQLException {
        return GeometryTableUtilities.getFirstColumnMetaData(connection, TableLocation.parse(geometryTable, DBUtils.getDBType(connection)));
    }

    public static Tuple<String, GeometryMetaData> getFirstColumnMetaData(Connection connection, TableLocation geometryTable) throws SQLException {
        DBTypes dbTypes = geometryTable.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            try (ResultSet geomResultSet = GeometryTableUtilities.getGeometryColumnsView(connection, geometryTable.getCatalog(), geometryTable.getSchema(), geometryTable.getTable());){
                while (geomResultSet.next()) {
                    String geometryColumnName = geomResultSet.getString("F_GEOMETRY_COLUMN");
                    if (geometryColumnName == null || geometryColumnName.isEmpty()) continue;
                    int dimension_ = geomResultSet.getInt("COORD_DIMENSION");
                    int srid_ = geomResultSet.getInt("SRID");
                    if (dbTypes == DBTypes.H2 || dbTypes == DBTypes.H2GIS) {
                        GeometryMetaData geometryMetaData = new GeometryMetaData();
                        geometryMetaData.setDimension(dimension_);
                        geometryMetaData.setGeometryTypeCode(geomResultSet.getInt("GEOMETRY_TYPE"));
                        geometryMetaData.setSRID(srid_);
                        geometryMetaData.initDimension();
                        geometryMetaData.initGeometryType();
                        Tuple<String, GeometryMetaData> tuple = new Tuple<String, GeometryMetaData>(geometryColumnName, geometryMetaData);
                        return tuple;
                    }
                    Tuple<String, GeometryMetaData> tuple = new Tuple<String, GeometryMetaData>(geometryColumnName, GeometryTableUtilities.createMetadataFromPostGIS(geomResultSet.getString("type"), dimension_, srid_));
                    return tuple;
                }
            }
            throw new SQLException(String.format("The table %s does not contain a geometry field", geometryTable));
        }
        throw new SQLException("Database not supported");
    }

    public static Tuple<String, GeometryMetaData> getFirstColumnMetaData(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metadata = resultSet.getMetaData();
        int columnCount = metadata.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            GeometryMetaData geomMeta = GeometryMetaData.getMetaDataFromTablePattern(metadata.getColumnTypeName(i));
            if (geomMeta == null) continue;
            return new Tuple<String, GeometryMetaData>(metadata.getColumnName(i), geomMeta);
        }
        throw new SQLException("The query does not contain a geometry field");
    }

    public static LinkedHashMap<String, GeometryMetaData> getMetaData(ResultSet resultSet) throws SQLException {
        LinkedHashMap<String, GeometryMetaData> geometryMetaDatas = new LinkedHashMap<String, GeometryMetaData>();
        ResultSetMetaData metadata = resultSet.getMetaData();
        int columnCount = metadata.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            GeometryMetaData geomMeta = GeometryMetaData.getMetaDataFromTablePattern(metadata.getColumnTypeName(i));
            if (geomMeta == null) continue;
            geometryMetaDatas.put(metadata.getColumnName(i), geomMeta);
        }
        return geometryMetaDatas;
    }

    public static LinkedHashMap<String, GeometryMetaData> getMetaData(Connection connection, String geometryTable) throws SQLException {
        return GeometryTableUtilities.getMetaData(connection, TableLocation.parse(geometryTable, DBUtils.getDBType(connection)));
    }

    public static LinkedHashMap<String, GeometryMetaData> getMetaData(Connection connection, TableLocation geometryTable) throws SQLException {
        DBTypes dbTypes = geometryTable.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            try (ResultSet geomResultSet = GeometryTableUtilities.getGeometryColumnsView(connection, geometryTable.getCatalog(), geometryTable.getSchema(), geometryTable.getTable());){
                LinkedHashMap<String, GeometryMetaData> geometryMetaDatas = new LinkedHashMap<String, GeometryMetaData>();
                while (geomResultSet.next()) {
                    String geometryColumnName = geomResultSet.getString("F_GEOMETRY_COLUMN");
                    if (geometryColumnName == null || geometryColumnName.isEmpty()) continue;
                    int dimension_ = geomResultSet.getInt("COORD_DIMENSION");
                    int srid_ = geomResultSet.getInt("SRID");
                    if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.H2) {
                        GeometryMetaData geometryMetaData = new GeometryMetaData();
                        geometryMetaData.setDimension(dimension_);
                        geometryMetaData.setGeometryTypeCode(geomResultSet.getInt("GEOMETRY_TYPE"));
                        geometryMetaData.setSRID(srid_);
                        geometryMetaData.initDimension();
                        geometryMetaData.initGeometryType();
                        geometryMetaDatas.put(geometryColumnName, geometryMetaData);
                        continue;
                    }
                    geometryMetaDatas.put(geometryColumnName, GeometryTableUtilities.createMetadataFromPostGIS(geomResultSet.getString("type"), dimension_, srid_));
                }
                LinkedHashMap<String, GeometryMetaData> linkedHashMap = geometryMetaDatas;
                return linkedHashMap;
            }
        }
        throw new SQLException("Database not supported");
    }

    public static GeometryMetaData getMetaData(Connection connection, String geometryTable, String geometryColumnName) throws SQLException {
        return GeometryTableUtilities.getMetaData(connection, TableLocation.parse(geometryTable, DBUtils.getDBType(connection)), geometryColumnName);
    }

    public static GeometryMetaData getMetaData(Connection connection, TableLocation geometryTable, String geometryColumnName) throws SQLException {
        GeometryMetaData geometryMetaData = null;
        DBTypes dbTypes = geometryTable.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.H2) {
            try (ResultSet geomResultSet = GeometryTableUtilities.getGeometryColumnsView(connection, geometryTable.getCatalog(), geometryTable.getSchema("PUBLIC"), geometryTable.getTable(), TableLocation.quoteIdentifier(geometryColumnName, dbTypes));){
                while (geomResultSet.next()) {
                    if (!geometryColumnName.isEmpty() && !geomResultSet.getString("F_GEOMETRY_COLUMN").equalsIgnoreCase(geometryColumnName)) continue;
                    int dimension_ = geomResultSet.getInt("COORD_DIMENSION");
                    int srid_ = geomResultSet.getInt("SRID");
                    geometryMetaData = new GeometryMetaData();
                    geometryMetaData.setDimension(dimension_);
                    geometryMetaData.setGeometryTypeCode(geomResultSet.getInt("GEOMETRY_TYPE"));
                    geometryMetaData.setSRID(srid_);
                    geometryMetaData.initDimension();
                    geometryMetaData.initGeometryType();
                    break;
                }
            }
            return geometryMetaData;
        }
        if (dbTypes == DBTypes.POSTGRESQL || dbTypes == DBTypes.POSTGIS) {
            try (ResultSet geomResultSet = GeometryTableUtilities.getGeometryColumnsView(connection, geometryTable.getCatalog(), geometryTable.getSchema("public"), geometryTable.getTable(), TableLocation.quoteIdentifier(geometryColumnName, dbTypes));){
                while (geomResultSet.next()) {
                    if (!geometryColumnName.isEmpty() && !geomResultSet.getString("F_GEOMETRY_COLUMN").equalsIgnoreCase(geometryColumnName)) continue;
                    int dimension_ = geomResultSet.getInt("COORD_DIMENSION");
                    int srid_ = geomResultSet.getInt("SRID");
                    geometryMetaData = GeometryTableUtilities.createMetadataFromPostGIS(geomResultSet.getString("type"), dimension_, srid_);
                    break;
                }
            }
            return geometryMetaData;
        }
        throw new SQLException("Database not supported");
    }

    private static GeometryMetaData createMetadataFromPostGIS(String type, int coord_dimension, int srid) {
        GeometryMetaData geometryMetaData = new GeometryMetaData();
        geometryMetaData.setSRID(srid);
        if (type == null) {
            return geometryMetaData;
        }
        int geometry_code = 0;
        String sfs_geometry_type = "GEOMETRY";
        Object geometry_type = "GEOMETRY";
        boolean hasz_ = false;
        boolean hasm_ = false;
        switch (type = type.replaceAll(" ", "").replaceAll("\"", "")) {
            case "POINT": {
                geometry_code = 1;
                sfs_geometry_type = "POINT";
                geometry_type = "POINT";
                if (coord_dimension > 3) {
                    hasz_ = true;
                    hasm_ = true;
                    geometry_type = (String)geometry_type + "ZM";
                    break;
                }
                if (coord_dimension <= 2) break;
                hasz_ = true;
                geometry_type = (String)geometry_type + "Z";
                break;
            }
            case "LINESTRING": {
                geometry_code = 2;
                sfs_geometry_type = "LINESTRING";
                geometry_type = "LINESTRING";
                if (coord_dimension > 3) {
                    hasz_ = true;
                    hasm_ = true;
                    geometry_type = (String)geometry_type + "ZM";
                    break;
                }
                if (coord_dimension <= 2) break;
                hasz_ = true;
                geometry_type = (String)geometry_type + "Z";
                break;
            }
            case "POLYGON": {
                geometry_code = 3;
                sfs_geometry_type = "POLYGON";
                geometry_type = "POLYGON";
                if (coord_dimension > 3) {
                    hasz_ = true;
                    hasm_ = true;
                    geometry_type = (String)geometry_type + "ZM";
                    break;
                }
                if (coord_dimension <= 2) break;
                hasz_ = true;
                geometry_type = (String)geometry_type + "Z";
                break;
            }
            case "MULTIPOINT": {
                geometry_code = 4;
                sfs_geometry_type = "MULTIPOINT";
                geometry_type = "MULTIPOINT";
                if (coord_dimension > 3) {
                    hasz_ = true;
                    hasm_ = true;
                    geometry_type = (String)geometry_type + "ZM";
                    break;
                }
                if (coord_dimension <= 2) break;
                hasz_ = true;
                geometry_type = (String)geometry_type + "Z";
                break;
            }
            case "MULTILINESTRING": {
                geometry_code = 5;
                sfs_geometry_type = "MULTILINESTRING";
                geometry_type = "MULTILINESTRING";
                if (coord_dimension > 3) {
                    hasz_ = true;
                    hasm_ = true;
                    geometry_type = (String)geometry_type + "ZM";
                    break;
                }
                if (coord_dimension <= 2) break;
                hasz_ = true;
                geometry_type = (String)geometry_type + "Z";
                break;
            }
            case "MULTIPOLYGON": {
                geometry_code = 6;
                sfs_geometry_type = "MULTIPOLYGON";
                geometry_type = "MULTIPOLYGON";
                if (coord_dimension > 3) {
                    hasz_ = true;
                    hasm_ = true;
                    geometry_type = (String)geometry_type + "ZM";
                    break;
                }
                if (coord_dimension <= 2) break;
                hasz_ = true;
                geometry_type = (String)geometry_type + "Z";
                break;
            }
            case "GEOMETRYCOLLECTION": {
                geometry_code = 7;
                sfs_geometry_type = "GEOMCOLLECTION";
                geometry_type = "GEOMCOLLECTION";
                if (coord_dimension > 3) {
                    hasz_ = true;
                    hasm_ = true;
                    geometry_type = (String)geometry_type + "ZM";
                    break;
                }
                if (coord_dimension <= 2) break;
                hasz_ = true;
                geometry_type = (String)geometry_type + "Z";
                break;
            }
            case "POINTZ": {
                geometry_code = 1001;
                sfs_geometry_type = "POINTZ";
                geometry_type = "POINTZ";
                hasz_ = true;
                break;
            }
            case "LINESTRINGZ": {
                geometry_code = 1002;
                sfs_geometry_type = "LINESTRINGZ";
                geometry_type = "LINESTRINGZ";
                hasz_ = true;
                break;
            }
            case "POLYGONZ": {
                geometry_code = 1003;
                sfs_geometry_type = "POLYGONZ";
                geometry_type = "POLYGONZ";
                hasz_ = true;
                break;
            }
            case "MULTIPOINTZ": {
                geometry_code = 1004;
                sfs_geometry_type = "MULTIPOINTZ";
                geometry_type = "MULTIPOINTZ";
                hasz_ = true;
                break;
            }
            case "MULTILINESTRINGZ": {
                geometry_code = 1005;
                sfs_geometry_type = "MULTILINESTRINGZ";
                geometry_type = "MULTILINESTRINGZ";
                hasz_ = true;
                break;
            }
            case "MULTIPOLYGONZ": {
                geometry_code = 1006;
                sfs_geometry_type = "MULTIPOLYGONZ";
                geometry_type = "MULTIPOLYGONZ";
                hasz_ = true;
                break;
            }
            case "GEOMETRYCOLLECTIONZ": {
                geometry_code = 1007;
                sfs_geometry_type = "GEOMETRYCOLLECTIONZ";
                geometry_type = "GEOMETRYCOLLECTIONZ";
                hasz_ = true;
                break;
            }
            case "POINTM": {
                geometry_code = 2001;
                sfs_geometry_type = "POINTM";
                geometry_type = "POINTM";
                hasm_ = true;
                break;
            }
            case "LINESTRINGM": {
                geometry_code = 2002;
                sfs_geometry_type = "LINESTRINGM";
                geometry_type = "LINESTRINGM";
                hasm_ = true;
                break;
            }
            case "POLYGONM": {
                geometry_code = 2003;
                sfs_geometry_type = "POLYGONM";
                geometry_type = "POLYGONM";
                hasm_ = true;
                break;
            }
            case "MULTIPOINTM": {
                geometry_code = 2004;
                sfs_geometry_type = "MULTIPOINTM";
                geometry_type = "MULTIPOINTM";
                hasm_ = true;
                break;
            }
            case "MULTILINESTRINGM": {
                geometry_code = 2005;
                sfs_geometry_type = "MULTILINESTRINGM";
                geometry_type = "MULTILINESTRINGM";
                hasm_ = true;
                break;
            }
            case "MULTIPOLYGONM": {
                geometry_code = 2006;
                sfs_geometry_type = "MULTIPOLYGONM";
                geometry_type = "MULTIPOLYGONM";
                hasm_ = true;
                break;
            }
            case "GEOMETRYCOLLECTIONM": {
                geometry_code = 2007;
                sfs_geometry_type = "GEOMETRYCOLLECTIONM";
                geometry_type = "GEOMETRYCOLLECTIONM";
                hasm_ = true;
                break;
            }
            case "POINTZM": {
                geometry_code = 3001;
                sfs_geometry_type = "POINTZM";
                geometry_type = "POINTZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "LINESTRINGZM": {
                geometry_code = 3002;
                sfs_geometry_type = "LINESTRINGZM";
                geometry_type = "LINESTRINGZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "POLYGONZM": {
                geometry_code = 3003;
                sfs_geometry_type = "POLYGONZM";
                geometry_type = "POLYGONZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "MULTIPOINTZM": {
                geometry_code = 3004;
                sfs_geometry_type = "MULTIPOINTZM";
                geometry_type = "MULTIPOINTZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "MULTILINESTRINGZM": {
                geometry_code = 3005;
                sfs_geometry_type = "MULTILINESTRINGZM";
                geometry_type = "MULTILINESTRINGZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "MULTIPOLYGONZM": {
                geometry_code = 3006;
                sfs_geometry_type = "MULTIPOLYGONZM";
                geometry_type = "MULTIPOLYGONZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "GEOMETRYCOLLECTIONZM": {
                geometry_code = 3007;
                sfs_geometry_type = "GEOMETRYCOLLECTIONZM";
                geometry_type = "GEOMETRYCOLLECTIONZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
        }
        geometryMetaData.setDimension(coord_dimension);
        geometryMetaData.setGeometryTypeCode(geometry_code);
        geometryMetaData.setSfs_geometryType(sfs_geometry_type);
        geometryMetaData.setGeometryType((String)geometry_type);
        geometryMetaData.setHasM(hasm_);
        geometryMetaData.setHasZ(hasz_);
        return geometryMetaData;
    }

    public static PreparedStatement prepareInformationSchemaStatement(Connection connection, String catalog, String schema, String table, String informationSchemaTable, String endQuery) throws SQLException {
        return GeometryTableUtilities.prepareInformationSchemaStatement(connection, catalog, schema, table, informationSchemaTable, endQuery, "f_table_catalog", "f_table_schema", "f_table_name");
    }

    public static PreparedStatement prepareInformationSchemaStatement(Connection connection, String catalog, String schema, String table, String informationSchemaTable, String endQuery, String catalog_field, String schema_field, String table_field) throws SQLException {
        Integer n;
        Integer n2;
        Integer catalogIndex = null;
        Integer schemaIndex = null;
        Integer tableIndex = 1;
        StringBuilder sb = new StringBuilder("SELECT * from " + informationSchemaTable + " where ");
        if (!catalog.isEmpty()) {
            sb.append("UPPER(");
            sb.append(catalog_field);
            sb.append(") = ? AND ");
            catalogIndex = 1;
            n2 = tableIndex;
            n = tableIndex = Integer.valueOf(tableIndex + 1);
        }
        if (!schema.isEmpty()) {
            sb.append("UPPER(");
            sb.append(schema_field);
            sb.append(") = ? AND ");
            schemaIndex = tableIndex;
            n2 = tableIndex;
            n = tableIndex = Integer.valueOf(tableIndex + 1);
        }
        sb.append("UPPER(");
        sb.append(table_field);
        sb.append(") = ? ");
        sb.append(endQuery);
        PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
        if (catalogIndex != null) {
            preparedStatement.setString(catalogIndex, catalog.toUpperCase());
        }
        if (schemaIndex != null) {
            preparedStatement.setString(schemaIndex, schema.toUpperCase());
        }
        preparedStatement.setString(tableIndex, table.toUpperCase());
        return preparedStatement;
    }

    public static Tuple<String, Integer> getFirstGeometryColumnNameAndIndex(ResultSet resultSet) throws SQLException {
        ResultSetMetaData meta = resultSet.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!meta.getColumnTypeName(i).toLowerCase().startsWith("geometry")) continue;
            return new Tuple<String, Integer>(meta.getColumnName(i), i);
        }
        throw new SQLException("The query doesn't contain any geometry field");
    }

    public static boolean hasGeometryColumn(ResultSet resultSet) throws SQLException {
        ResultSetMetaData meta = resultSet.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!meta.getColumnTypeName(i).toLowerCase().startsWith("geometry")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasGeometryColumn(Connection connection, String tableLocation) throws SQLException {
        return GeometryTableUtilities.hasGeometryColumn(connection, TableLocation.parse(tableLocation, DBUtils.getDBType(connection)));
    }

    public static boolean hasGeometryColumn(Connection connection, TableLocation tableLocation) throws SQLException {
        Statement statement = connection.createStatement();
        DBTypes dbTypes = tableLocation.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableLocation.toString() + " WHERE 1=0;");){
                ResultSetMetaData meta = resultSet.getMetaData();
                int columnCount = meta.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    if (!meta.getColumnTypeName(i).toLowerCase().startsWith("geometry")) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }
        throw new SQLException("Database not supported");
    }

    public static Geometry getEnvelope(ResultSet resultSet) throws SQLException {
        return GeometryTableUtilities.getEnvelope(resultSet, GeometryTableUtilities.getFirstGeometryColumnNameAndIndex(resultSet).first());
    }

    public static Geometry getEnvelope(ResultSet resultSet, String geometryColumnName) throws SQLException {
        resultSet.next();
        Geometry geom = (Geometry)resultSet.getObject(geometryColumnName);
        int firstSRID = geom.getSRID();
        Envelope aggregatedEnvelope = geom.getEnvelopeInternal();
        if (aggregatedEnvelope == null) {
            aggregatedEnvelope = new Envelope();
        }
        while (resultSet.next()) {
            geom = (Geometry)resultSet.getObject(geometryColumnName);
            if (geom.getSRID() != firstSRID) {
                throw new SQLException("The envelope cannot be computed on mixed SRID");
            }
            aggregatedEnvelope.expandToInclude(geom.getEnvelopeInternal());
        }
        Geometry geomEnv = new GeometryFactory().toGeometry(aggregatedEnvelope);
        geomEnv.setSRID(firstSRID);
        return geomEnv;
    }

    public static Geometry getEstimatedExtent(Connection connection, String tableName) throws SQLException {
        return GeometryTableUtilities.getEstimatedExtent(connection, TableLocation.parse(tableName, DBUtils.getDBType(connection)));
    }

    public static Geometry getEstimatedExtent(Connection connection, TableLocation tableLocation) throws SQLException {
        LinkedHashMap<String, Integer> geometryFields = GeometryTableUtilities.getGeometryColumnNamesAndIndexes(connection, tableLocation);
        if (geometryFields.isEmpty()) {
            throw new SQLException("Cannot find any geometry column");
        }
        return GeometryTableUtilities.getEstimatedExtent(connection, tableLocation, geometryFields.keySet().iterator().next());
    }

    public static Geometry getEstimatedExtent(Connection connection, String tableName, String geometryColumnName) throws SQLException {
        return GeometryTableUtilities.getEstimatedExtent(connection, TableLocation.parse(tableName, DBUtils.getDBType(connection)), geometryColumnName);
    }

    public static Geometry getEstimatedExtent(Connection connection, TableLocation tableLocation, String geometryColumnName) throws SQLException {
        DBTypes dbTypes = tableLocation.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            block26: {
                Geometry result;
                int srid = GeometryTableUtilities.getSRID(connection, tableLocation, geometryColumnName);
                if (dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.POSTGRESQL) {
                    StringBuilder query = new StringBuilder("SELECT  ST_EstimatedExtent(");
                    if (!tableLocation.getSchema().isEmpty()) {
                        query.append("'").append(tableLocation.getSchema()).append("',");
                    } else {
                        query.append("'").append("public").append("',");
                    }
                    query.append("'").append(tableLocation.getTable()).append("','").append(geometryColumnName).append("') :: geometry");
                    try (ResultSet rs = connection.createStatement().executeQuery(query.toString());){
                        if (rs.next()) {
                            Geometry result2 = (Geometry)rs.getObject(1);
                            if (result2 != null) {
                                result2.setSRID(srid);
                            }
                            Geometry geometry = result2;
                            return geometry;
                        }
                        break block26;
                    }
                }
                StringBuilder query = new StringBuilder("SELECT  ESTIMATED_ENVELOPE('");
                query.append(tableLocation.toString()).append("','").append(TableLocation.capsIdentifier(geometryColumnName, DBTypes.H2GIS)).append("')");
                try (ResultSet rs = connection.createStatement().executeQuery(query.toString());){
                    if (rs.next() && (result = (Geometry)rs.getObject(1)) != null) {
                        result.setSRID(srid);
                        Geometry geometry = result;
                        return geometry;
                    }
                }
                query = new StringBuilder("SELECT ENVELOPE(");
                query.append(TableLocation.capsIdentifier(geometryColumnName, DBTypes.H2GIS)).append(") FROM ").append(tableLocation.toString(DBTypes.H2GIS));
                try (ResultSet rsEnv = connection.createStatement().executeQuery(query.toString());){
                    if (rsEnv.next() && (result = (Geometry)rsEnv.getObject(1)) != null) {
                        result.setSRID(srid);
                        Geometry geometry = result;
                        return geometry;
                    }
                }
            }
            throw new SQLException("Unable to compute the estimated extent");
        }
        throw new SQLException("Database not supported");
    }

    public static int getSRID(Connection connection, String tableName, String geometryColumnName) throws SQLException {
        return GeometryTableUtilities.getSRID(connection, TableLocation.parse(tableName, DBUtils.getDBType(connection)), geometryColumnName);
    }

    public static int getSRID(Connection connection, TableLocation tableLocation, String geometryColumnName) throws SQLException {
        int srid = 0;
        String columnName = TableLocation.capsIdentifier(geometryColumnName, tableLocation.getDbTypes());
        try (ResultSet geomResultSet = GeometryTableUtilities.getGeometryColumnsView(connection, tableLocation.getCatalog(), tableLocation.getSchema("PUBLIC"), tableLocation.getTable(), columnName);){
            if (geomResultSet.next()) {
                srid = geomResultSet.getInt("srid");
            }
        }
        return srid;
    }

    public static int getSRID(Connection connection, String tableName) throws SQLException {
        return GeometryTableUtilities.getSRID(connection, TableLocation.parse(tableName, DBUtils.getDBType(connection)));
    }

    public static int getSRID(Connection connection, TableLocation tableLocation) throws SQLException {
        int srid = 0;
        try (ResultSet geomResultSet = GeometryTableUtilities.getGeometryColumnsView(connection, tableLocation.getCatalog(), tableLocation.getSchema("PUBLIC"), tableLocation.getTable());){
            if (geomResultSet.next()) {
                srid = geomResultSet.getInt("srid");
            }
        }
        return srid;
    }

    public static LinkedHashMap<String, Integer> getGeometryColumnNamesAndIndexes(Connection connection, String tableName) throws SQLException {
        return GeometryTableUtilities.getGeometryColumnNamesAndIndexes(connection, TableLocation.parse(tableName, DBUtils.getDBType(connection)));
    }

    public static LinkedHashMap<String, Integer> getGeometryColumnNamesAndIndexes(Connection connection, TableLocation tableLocation) throws SQLException {
        DBTypes dbTypes = tableLocation.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            try (ResultSet resultSet = connection.createStatement().executeQuery("SELECT * FROM " + tableLocation + " WHERE 1=0;");){
                LinkedHashMap<String, Integer> linkedHashMap = GeometryTableUtilities.getGeometryColumnNamesAndIndexes(resultSet.getMetaData());
                return linkedHashMap;
            }
        }
        throw new SQLException("Database not supported");
    }

    public static LinkedHashMap<String, Integer> getGeometryColumnNamesAndIndexes(ResultSetMetaData metadata) throws SQLException {
        LinkedHashMap<String, Integer> namesWithIndexes = new LinkedHashMap<String, Integer>();
        int columnCount = metadata.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!metadata.getColumnTypeName(i).toLowerCase().startsWith("geometry")) continue;
            namesWithIndexes.put(metadata.getColumnName(i), i);
        }
        return namesWithIndexes;
    }

    public static List<String> getGeometryColumnNames(Connection connection, String tableName) throws SQLException {
        return GeometryTableUtilities.getGeometryColumnNames(connection, TableLocation.parse(tableName, DBUtils.getDBType(connection)));
    }

    public static List<String> getGeometryColumnNames(Connection connection, TableLocation tableLocation) throws SQLException {
        DBTypes dbTypes = tableLocation.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            try (ResultSet resultSet = connection.createStatement().executeQuery("SELECT * FROM " + tableLocation + " WHERE 1=0;");){
                List<String> list = GeometryTableUtilities.getGeometryColumnNames(resultSet.getMetaData());
                return list;
            }
        }
        throw new SQLException("Database not supported");
    }

    public static List<String> getGeometryColumnNames(ResultSetMetaData metadata) throws SQLException {
        ArrayList<String> namesWithIndexes = new ArrayList<String>();
        int columnCount = metadata.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!metadata.getColumnTypeName(i).toLowerCase().startsWith("geometry")) continue;
            namesWithIndexes.add(metadata.getColumnName(i));
        }
        return namesWithIndexes;
    }

    public static Tuple<String, Integer> getFirstGeometryColumnNameAndIndex(Connection connection, String tableName) throws SQLException {
        return GeometryTableUtilities.getFirstGeometryColumnNameAndIndex(connection, TableLocation.parse(tableName, DBUtils.getDBType(connection)));
    }

    public static Tuple<String, Integer> getFirstGeometryColumnNameAndIndex(Connection connection, TableLocation tableLocation) throws SQLException {
        DBTypes dbTypes = tableLocation.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            Statement statement = connection.createStatement();
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableLocation + " WHERE 1=0;");){
                Tuple<String, Integer> tuple = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex(resultSet.getMetaData());
                return tuple;
            }
        }
        throw new SQLException("Database not supported");
    }

    public static Tuple<String, Integer> getFirstGeometryColumnNameAndIndex(ResultSetMetaData metadata) throws SQLException {
        int columnCount = metadata.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!metadata.getColumnTypeName(i).toLowerCase().startsWith("geometry")) continue;
            return new Tuple<String, Integer>(metadata.getColumnName(i), i);
        }
        throw new SQLException("The query doesn't contain any geometry field");
    }

    public static ResultSet getGeometryColumnsView(Connection connection, String catalog, String schema, String table) throws SQLException {
        PreparedStatement geomStatement = GeometryTableUtilities.prepareInformationSchemaStatement(connection, catalog, schema, table, "geometry_columns", "");
        return geomStatement.executeQuery();
    }

    public static ResultSet getGeometryColumnsView(Connection connection, String catalog, String schema, String table, String geometryField) throws SQLException {
        if (geometryField != null && !geometryField.isEmpty()) {
            PreparedStatement geomStatement = GeometryTableUtilities.prepareInformationSchemaStatement(connection, catalog, schema, table, "geometry_columns", String.format(" and F_GEOMETRY_COLUMN ='%s'", geometryField));
            return geomStatement.executeQuery();
        }
        throw new SQLException("Unable to get geometry metadata from a null or empty column name");
    }

    public static Geometry getEnvelope(Connection connection, String table, String geometryColumn) throws SQLException {
        return GeometryTableUtilities.getEnvelope(connection, TableLocation.parse(geometryColumn, DBUtils.getDBType(connection)), geometryColumn);
    }

    public static Geometry getEnvelope(Connection connection, TableLocation location, String geometryColumn) throws SQLException {
        DBTypes dbTypes = location.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            block17: {
                if (geometryColumn == null || geometryColumn.isEmpty()) {
                    throw new SQLException("The table " + location + " does not contain a Geometry field, then the extent cannot be computed");
                }
                if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.H2) {
                    try (ResultSet rs = connection.createStatement().executeQuery("SELECT ST_Extent(" + TableLocation.quoteIdentifier(geometryColumn) + ") as ext FROM " + location);){
                        if (rs.next()) {
                            Geometry geometry = (Geometry)rs.getObject(1);
                            return geometry;
                        }
                        break block17;
                    }
                }
                try (ResultSet rs = connection.createStatement().executeQuery("SELECT ST_SetSRID(ST_Extent(" + TableLocation.quoteIdentifier(geometryColumn) + "), MAX(ST_SRID(" + TableLocation.quoteIdentifier(geometryColumn) + "))) as ext FROM " + location);){
                    if (rs.next()) {
                        Geometry geometry = (Geometry)rs.getObject(1);
                        return geometry;
                    }
                }
            }
            throw new SQLException("Unable to get the table extent it may be empty");
        }
        throw new SQLException("Database not supported");
    }

    public static Geometry getEnvelope(Connection connection, TableLocation location, String ... geometryColumns) throws SQLException {
        return GeometryTableUtilities.getEnvelope(connection, location, geometryColumns, null);
    }

    public static Geometry getEnvelope(Connection connection, TableLocation location, String[] geometryColumns, String filter) throws SQLException {
        DBTypes dbTypes = location.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            String columnName;
            String geomField;
            int i;
            if (geometryColumns == null || geometryColumns.length == 0) {
                throw new SQLException("The table " + location + " does not contain a geometry columns, then the extent cannot be computed");
            }
            int columnCount = 0;
            StringBuilder mainSelect = new StringBuilder("SELECT ");
            StringBuilder subSELECT = new StringBuilder("SELECT ");
            if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.H2) {
                for (i = 0; i < geometryColumns.length; ++i) {
                    geomField = geometryColumns[i];
                    if (i > 0) {
                        mainSelect.append(",");
                        subSELECT.append(",");
                    }
                    if (geomField == null || geomField.isEmpty()) continue;
                    columnName = "geom_" + i;
                    subSELECT.append(geomField).append(" as ").append(columnName);
                    mainSelect.append("ST_EXTENT(").append(columnName).append(")").append(" as ").append(columnName);
                    ++columnCount;
                }
            } else {
                for (i = 0; i < geometryColumns.length; ++i) {
                    geomField = geometryColumns[i];
                    if (i > 0) {
                        mainSelect.append(",");
                        subSELECT.append(",");
                    }
                    if (geomField == null || geomField.isEmpty()) continue;
                    columnName = "geom_" + i;
                    subSELECT.append(geomField).append(" as ").append(columnName);
                    mainSelect.append(" ST_SetSRID(ST_EXTENT(").append(columnName).append("), MAX(ST_SRID(").append(columnName).append(" ))) as ").append(columnName);
                    ++columnCount;
                }
            }
            mainSelect.append(" FROM ");
            subSELECT.append(" FROM ").append(location.toString()).append(" ");
            if (filter != null && !filter.isEmpty()) {
                subSELECT.append(filter);
            }
            subSELECT.append(" ) as foo");
            mainSelect.append("(").append(subSELECT.toString());
            Envelope aggregatedEnvelope = new Envelope();
            int srid = 0;
            try (ResultSet rs = connection.createStatement().executeQuery(mainSelect.toString());){
                if (rs.next()) {
                    for (int i2 = 0; i2 < columnCount; ++i2) {
                        int currentSRID;
                        Geometry geom = (Geometry)rs.getObject(i2 + 1);
                        if (geom == null) continue;
                        int n = currentSRID = geom.isEmpty() ? 0 : geom.getSRID();
                        if (srid == 0) {
                            srid = currentSRID;
                        } else if (srid != currentSRID) {
                            throw new SQLException("Operation on mixed SRID geometries not supported");
                        }
                        aggregatedEnvelope.expandToInclude(geom.getEnvelopeInternal());
                    }
                }
            }
            if (aggregatedEnvelope.isNull()) {
                return null;
            }
            Geometry geom = new GeometryFactory().toGeometry(aggregatedEnvelope);
            geom.setSRID(srid);
            return geom;
        }
        throw new SQLException("Database not supported");
    }

    public static Geometry getEnvelope(Connection connection, String subQuery, String[] geometryColumns) throws SQLException {
        return GeometryTableUtilities.getEnvelope(connection, subQuery, geometryColumns, null);
    }

    public static Geometry getEnvelope(Connection connection, String subQuery, String[] geometryColumns, String filter) throws SQLException {
        if (geometryColumns == null || geometryColumns.length == 0) {
            throw new SQLException("Geometry columns cannot be null or empty");
        }
        if (subQuery == null || subQuery.isEmpty()) {
            throw new SQLException("The subquery cannot be null or empty");
        }
        DBTypes dbTypes = DBUtils.getDBType(connection);
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            String geomField;
            int i;
            int columnCount = 0;
            StringBuilder sb = new StringBuilder("SELECT ");
            if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.H2) {
                for (i = 0; i < geometryColumns.length; ++i) {
                    geomField = geometryColumns[i];
                    if (i > 0) {
                        sb.append(",");
                    }
                    if (geomField == null || geomField.isEmpty()) continue;
                    sb.append("ST_EXTENT(").append(geomField).append(")").append(" as geom_").append(i);
                    ++columnCount;
                }
            } else {
                for (i = 0; i < geometryColumns.length; ++i) {
                    geomField = geometryColumns[i];
                    if (i > 0) {
                        sb.append(",");
                    }
                    if (geomField == null || geomField.isEmpty()) continue;
                    sb.append(" ST_SetSRID(ST_EXTENT(").append(geomField).append("), MAX(ST_SRID(").append(geomField).append(" ))) as geom_").append(i);
                    ++columnCount;
                }
            }
            sb.append(" FROM ").append("(").append(subQuery).append(") as foo");
            if (filter != null && !filter.isEmpty()) {
                sb.append(" ").append(filter);
            }
            Envelope aggregatedEnvelope = new Envelope();
            int srid = 0;
            try (ResultSet rs = connection.createStatement().executeQuery(sb.toString());){
                if (rs.next()) {
                    for (int i2 = 0; i2 < columnCount; ++i2) {
                        int currentSRID;
                        Geometry geom = (Geometry)rs.getObject(i2 + 1);
                        if (geom == null) continue;
                        int n = currentSRID = geom.isEmpty() ? 0 : geom.getSRID();
                        if (srid == 0) {
                            srid = currentSRID;
                        } else if (srid != currentSRID) {
                            throw new SQLException("Operation on mixed SRID geometries not supported");
                        }
                        aggregatedEnvelope.expandToInclude(geom.getEnvelopeInternal());
                    }
                }
            }
            if (aggregatedEnvelope.isNull()) {
                return null;
            }
            Geometry geom = new GeometryFactory().toGeometry(aggregatedEnvelope);
            geom.setSRID(srid);
            return geom;
        }
        throw new SQLException("DataBase not supported");
    }

    public static Geometry getEnvelope(Connection connection, String table) throws SQLException {
        return GeometryTableUtilities.getEnvelope(connection, TableLocation.parse(table, DBUtils.getDBType(connection)));
    }

    public static Geometry getEnvelope(Connection connection, TableLocation location) throws SQLException {
        LinkedHashMap<String, Integer> geometryFields = GeometryTableUtilities.getGeometryColumnNamesAndIndexes(connection, location);
        if (geometryFields.isEmpty()) {
            throw new SQLException("The table " + location + " does not contain a Geometry field, then the extent cannot be computed");
        }
        return GeometryTableUtilities.getEnvelope(connection, location, (String)geometryFields.keySet().stream().findFirst().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAuthorityAndSRID(Connection connection, int srid) throws SQLException {
        String authority = null;
        String sridCode = null;
        if (srid != 0) {
            ps.setInt(1, srid);
            try (PreparedStatement ps = connection.prepareStatement("SELECT AUTH_NAME FROM PUBLIC.SPATIAL_REF_SYS  WHERE SRID = ?");
                 ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    authority = rs.getString(1);
                    sridCode = String.valueOf(srid);
                    String[] stringArray = new String[]{authority, sridCode};
                    return stringArray;
                }
            }
        }
        return null;
    }

    public static String[] getAuthorityAndSRID(Connection connection, String table, String geometryColumnName) throws SQLException {
        return GeometryTableUtilities.getAuthorityAndSRID(connection, TableLocation.parse(table, DBUtils.getDBType(connection)), geometryColumnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAuthorityAndSRID(Connection connection, TableLocation table, String geometryColumnName) throws SQLException {
        int srid = GeometryTableUtilities.getSRID(connection, table, geometryColumnName);
        String authority = null;
        String sridCode = null;
        if (srid != 0) {
            ps.setInt(1, srid);
            try (PreparedStatement ps = connection.prepareStatement("SELECT AUTH_NAME FROM PUBLIC.SPATIAL_REF_SYS  WHERE SRID = ?");
                 ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    authority = rs.getString(1);
                    sridCode = String.valueOf(srid);
                }
            }
        }
        return new String[]{authority, sridCode};
    }

    public static boolean alterSRID(Connection connection, String table, String geometryColumnName, int srid) throws SQLException {
        return GeometryTableUtilities.alterSRID(connection, TableLocation.parse(table, DBUtils.getDBType(connection)), geometryColumnName, srid);
    }

    public static boolean alterSRID(Connection connection, TableLocation tableLocation, String geometryColumnName, int srid) throws SQLException {
        DBTypes dbTypes = tableLocation.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            if (srid >= 0) {
                String tableName = tableLocation.toString();
                if (tableName.isEmpty()) {
                    throw new SQLException("The table name cannot be empty");
                }
                String fieldName = TableLocation.capsIdentifier(geometryColumnName, dbTypes);
                GeometryMetaData metadata = GeometryTableUtilities.getMetaData(connection, tableLocation, fieldName);
                if (metadata != null) {
                    if (metadata.getSRID() == srid) {
                        return false;
                    }
                    fieldName = TableLocation.quoteIdentifier(fieldName, dbTypes);
                    String geometrySignature = "GEOMETRY(" + metadata.geometryType + "," + srid + ")";
                    String query = "ALTER TABLE " + tableName + " ALTER COLUMN " + fieldName + " TYPE " + geometrySignature + " USING ST_SetSRID(" + fieldName + "," + srid + ")";
                    connection.createStatement().execute(query);
                    return true;
                }
                return false;
            }
            throw new SQLException("The SRID value must be greater or equal than 0");
        }
        throw new SQLException("DataBase not supported");
    }

    public static boolean isSpatialIndexed(Connection connection, TableLocation tableLocation, String geometryColumnName) throws SQLException {
        return JDBCUtilities.isSpatialIndexed(connection, tableLocation, geometryColumnName);
    }
}

