/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.operators;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;

public class ST_Intersection
extends DeterministicScalarFunction {
    public ST_Intersection() {
        this.addProperty("remarks", "Compute the intersection of two Geometries.\nIf the gridSize argument is provided, the inputs geometries are snapped to a grid of the given size.");
    }

    public String getJavaStaticMethod() {
        return "intersection";
    }

    public static Geometry intersection(Geometry a, Geometry b) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        if (a.getSRID() == b.getSRID()) {
            return OverlayNGRobust.overlay((Geometry)a, (Geometry)b, (int)1);
        }
        throw new SQLException("Operation on mixed SRID geometries not supported");
    }

    public static Geometry intersection(Geometry a, Geometry b, double gridSize) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        if (a.getSRID() == b.getSRID()) {
            if (gridSize >= 0.0) {
                PrecisionModel pm = new PrecisionModel(1.0 / gridSize);
                return OverlayNG.overlay((Geometry)a, (Geometry)b, (int)1, (PrecisionModel)pm);
            }
            return OverlayNGRobust.overlay((Geometry)a, (Geometry)b, (int)1);
        }
        throw new SQLException("Operation on mixed SRID geometries not supported");
    }
}

