/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.operators;

import java.sql.SQLException;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNumeric;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.algorithm.hull.ConcaveHull;
import org.locationtech.jts.geom.Geometry;

public class ST_ConcaveHull
extends DeterministicScalarFunction {
    public ST_ConcaveHull() {
        this.addProperty("remarks", "Computes the concave geometry that encloses the vertices of the input geometry.\nSet allow_holes to true to allow hole in the concave geometry.\nSet a ratio value between 0 and 1 to increase the hull concaveness.\nValues between 0.3 and 0.1 produce reasonable results ");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        ConcaveHull concaveHull = new ConcaveHull(geometry);
        return concaveHull.getHull();
    }

    public static Geometry execute(Geometry geometry, Value param) throws SQLException {
        if (geometry == null) {
            return null;
        }
        ConcaveHull concaveHull = new ConcaveHull(geometry);
        if (param instanceof ValueBoolean) {
            concaveHull.setHolesAllowed(param.getBoolean());
        } else if (param instanceof ValueNumeric) {
            concaveHull.setMaximumEdgeLengthRatio(param.getDouble());
        } else {
            throw new SQLException("Parameter type not allowed.");
        }
        return concaveHull.getHull();
    }

    public static Geometry execute(Geometry geometry, double ratio, boolean allow_holes) {
        if (geometry == null) {
            return null;
        }
        ConcaveHull concaveHull = new ConcaveHull(geometry);
        concaveHull.setMaximumEdgeLengthRatio(ratio);
        concaveHull.setHolesAllowed(allow_holes);
        return concaveHull.getHull();
    }
}

