/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.crs;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cts.parser.prj.PrjParser;
import org.cts.parser.proj.ProjKeyParameters;
import org.cts.registry.AbstractProjRegistry;
import org.cts.registry.Registry;
import org.cts.registry.RegistryException;

public class SpatialRefRegistry
extends AbstractProjRegistry
implements Registry {
    private Connection connection;
    private static final Pattern regex = Pattern.compile("\\s+");
    PrjParser prjParser = null;

    public String getRegistryName() {
        return "epsg";
    }

    public Map<String, String> getParameters(String code) throws RegistryException {
        try {
            PreparedStatement prepStmt = this.connection.prepareStatement("SELECT proj4text, auth_name FROM SPATIAL_REF_SYS where srid=?");
            prepStmt.setInt(1, Integer.valueOf(code));
            ResultSet rs = prepStmt.executeQuery();
            if (rs.next()) {
                String proj4Text = rs.getString(1);
                String authcode = rs.getString(2) + ":" + code;
                if (proj4Text.isEmpty()) {
                    throw new RegistryException("No translation for " + authcode + " to PROJ format is known");
                }
                String[] tokens = regex.split(proj4Text);
                HashMap<String, String> v = new HashMap<String, String>();
                for (String token : tokens) {
                    String key;
                    String[] keyValue = token.split("=");
                    if (keyValue.length == 2) {
                        key = SpatialRefRegistry.formatKey(keyValue[0]);
                        ProjKeyParameters.checkUnsupported((String)key);
                        v.put(key, keyValue[1]);
                        continue;
                    }
                    key = SpatialRefRegistry.formatKey(token);
                    ProjKeyParameters.checkUnsupported((String)key);
                    v.put(key, null);
                }
                if (!v.containsKey("title")) {
                    v.put("title", authcode);
                }
                prepStmt.close();
                return v;
            }
        }
        catch (SQLException ex) {
            throw new RegistryException("Cannot obtain the CRS parameters", (Exception)ex);
        }
        return null;
    }

    private static String formatKey(String prjKey) {
        String formatKey = prjKey;
        if (prjKey.startsWith("+")) {
            formatKey = prjKey.substring(1);
        }
        return formatKey;
    }

    public Set<String> getSupportedCodes() throws RegistryException {
        try {
            Statement st = this.connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT srid from SPATIAL_REF_SYS;");
            HashSet<String> codes = new HashSet<String>();
            while (rs.next()) {
                codes.add(rs.getString(1));
            }
            st.close();
            return codes;
        }
        catch (SQLException ex) {
            throw new RegistryException("Cannot load the EPSG registry", (Exception)ex);
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

