/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.GeometricShapeFactory;

public class ST_MakeEllipse
extends DeterministicScalarFunction {
    private static final GeometricShapeFactory GSF = new GeometricShapeFactory();

    public ST_MakeEllipse() {
        this.addProperty("remarks", "Constructs an elliptical POLYGON with the given width and height centered at the given point. Each ellipse contains 100 line segments.");
    }

    public String getJavaStaticMethod() {
        return "makeEllipse";
    }

    public static Polygon makeEllipse(Point p, double width, double height) throws SQLException {
        if (p == null) {
            return null;
        }
        if (height < 0.0 || width < 0.0) {
            throw new SQLException("Both width and height must be positive.");
        }
        GSF.setCentre(new Coordinate(p.getX(), p.getY()));
        GSF.setWidth(width);
        GSF.setHeight(height);
        Polygon geom = GSF.createEllipse();
        geom.setSRID(p.getSRID());
        return geom;
    }
}

