/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ST_Multi
extends DeterministicScalarFunction {
    public ST_Multi() {
        this.addProperty("remarks", "Returns the geometry as a geometry collection. \nIf the geometry is already a collection, it is returned unchanged.");
    }

    public String getJavaStaticMethod() {
        return "toCollection";
    }

    public static Geometry toCollection(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof Point) {
            return geometry.getFactory().createMultiPoint(new Point[]{(Point)geometry});
        }
        if (geometry instanceof LineString) {
            return geometry.getFactory().createMultiLineString(new LineString[]{(LineString)geometry});
        }
        if (geometry instanceof Polygon) {
            return geometry.getFactory().createMultiPolygon(new Polygon[]{(Polygon)geometry});
        }
        return geometry;
    }
}

