/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.gpx.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2gis.functions.io.gpx.model.GPXTags;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;

public class GPXTablesFactory {
    public static final String WAYPOINT = "_waypoint";
    public static final String ROUTE = "_route";
    public static final String ROUTEPOINT = "_routepoint";
    public static final String TRACK = "_track";
    public static final String TRACKSEGMENT = "_tracksegment";
    public static final String TRACKPOINT = "_trackpoint";

    private GPXTablesFactory() {
    }

    public static PreparedStatement createWayPointsTable(Connection connection, String wayPointsTableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(wayPointsTableName).append(" (");
            sb.append("the_geom GEOMETRY(POINT, 4326),");
            sb.append(" id INT,");
            sb.append(GPXTags.LAT.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.LON.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.ELE.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.TIME.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.MAGVAR.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.GEOIDHEIGHT.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.NAME.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.CMT.toLowerCase()).append(" TEXT,");
            sb.append("description").append(" TEXT,");
            sb.append(GPXTags.SRC.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.HREF.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.HREFTITLE.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.SYM.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.TYPE.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.FIX.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.SAT.toLowerCase()).append(" INT,");
            sb.append(GPXTags.HDOP.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.VDOP.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.PDOP.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.AGEOFDGPSDATA.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.DGPSID.toLowerCase()).append(" INT,");
            sb.append(GPXTags.EXTENSIONS.toLowerCase()).append(" BOOLEAN);");
            stmt.execute(sb.toString());
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ").append(wayPointsTableName).append(" VALUES ( ?");
        for (int i = 1; i < 24; ++i) {
            insert.append(",?");
        }
        insert.append(");");
        return connection.prepareStatement(insert.toString());
    }

    public static PreparedStatement createRouteTable(Connection connection, String routeTableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(routeTableName).append(" (");
            sb.append("the_geom GEOMETRY(LINESTRING, 4326),");
            sb.append(" id INT,");
            sb.append(GPXTags.NAME.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.CMT.toLowerCase()).append(" TEXT,");
            sb.append("description").append(" TEXT,");
            sb.append(GPXTags.SRC.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.HREF.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.HREFTITLE.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.NUMBER.toLowerCase()).append(" INT,");
            sb.append(GPXTags.TYPE.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.EXTENSIONS.toLowerCase()).append(" TEXT);");
            stmt.execute(sb.toString());
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ").append(routeTableName).append(" VALUES ( ?");
        for (int i = 1; i < 11; ++i) {
            insert.append(",?");
        }
        insert.append(");");
        return connection.prepareStatement(insert.toString());
    }

    public static PreparedStatement createRoutePointsTable(Connection connection, String routePointsTable) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(routePointsTable).append(" (");
            sb.append("the_geom GEOMETRY(POINT, 4326),");
            sb.append(" id INT,");
            sb.append(GPXTags.LAT.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.LON.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.ELE.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.TIME.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.MAGVAR.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.GEOIDHEIGHT.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.NAME.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.CMT.toLowerCase()).append(" TEXT,");
            sb.append("description").append(" TEXT,");
            sb.append(GPXTags.SRC.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.HREF.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.HREFTITLE.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.SYM.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.TYPE.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.FIX.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.SAT.toLowerCase()).append(" INT,");
            sb.append(GPXTags.HDOP.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.VDOP.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.PDOP.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.AGEOFDGPSDATA.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.DGPSID.toLowerCase()).append(" INT,");
            sb.append(GPXTags.EXTENSIONS.toLowerCase()).append(" BOOLEAN,");
            sb.append("route_id").append(" INT);");
            stmt.execute(sb.toString());
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ").append(routePointsTable).append(" VALUES ( ?");
        for (int i = 1; i < 25; ++i) {
            insert.append(",?");
        }
        insert.append(");");
        return connection.prepareStatement(insert.toString());
    }

    public static PreparedStatement createTrackTable(Connection connection, String trackTableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(trackTableName).append(" (");
            sb.append("the_geom GEOMETRY(MULTILINESTRING, 4326),");
            sb.append(" id INT,");
            sb.append(GPXTags.NAME.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.CMT.toLowerCase()).append(" TEXT,");
            sb.append("description").append(" TEXT,");
            sb.append(GPXTags.SRC.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.HREF.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.HREFTITLE.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.NUMBER.toLowerCase()).append(" INT,");
            sb.append(GPXTags.TYPE.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.EXTENSIONS.toLowerCase()).append(" TEXT);");
            stmt.execute(sb.toString());
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ").append(trackTableName).append(" VALUES ( ?");
        for (int i = 1; i < 11; ++i) {
            insert.append(",?");
        }
        insert.append(");");
        return connection.prepareStatement(insert.toString());
    }

    public static PreparedStatement createTrackSegmentsTable(Connection connection, String trackSegementsTableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(trackSegementsTableName).append(" (");
            sb.append("the_geom GEOMETRY(LINESTRING, 4326),");
            sb.append(" id INT,");
            sb.append(GPXTags.EXTENSIONS).append(" TEXT,");
            sb.append("id_track INT);");
            stmt.execute(sb.toString());
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ").append(trackSegementsTableName).append(" VALUES ( ?");
        for (int i = 1; i < 4; ++i) {
            insert.append(",?");
        }
        insert.append(");");
        return connection.prepareStatement(insert.toString());
    }

    public static PreparedStatement createTrackPointsTable(Connection connection, String trackPointsTableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(trackPointsTableName).append(" (");
            sb.append("the_geom GEOMETRY(POINT, 4326),");
            sb.append(" id INT,");
            sb.append(GPXTags.LAT.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.LON.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.ELE.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.TIME.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.MAGVAR.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.GEOIDHEIGHT.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.NAME.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.CMT.toLowerCase()).append(" TEXT,");
            sb.append("description").append(" TEXT,");
            sb.append(GPXTags.SRC.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.HREF.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.HREFTITLE.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.SYM.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.TYPE.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.FIX.toLowerCase()).append(" TEXT,");
            sb.append(GPXTags.SAT.toLowerCase()).append(" INT,");
            sb.append(GPXTags.HDOP.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.VDOP.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.PDOP.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.AGEOFDGPSDATA.toLowerCase()).append(" FLOAT8,");
            sb.append(GPXTags.DGPSID.toLowerCase()).append(" INT,");
            sb.append(GPXTags.EXTENSIONS.toLowerCase()).append(" BOOLEAN,");
            sb.append("track_segment_id").append(" INT);");
            stmt.execute(sb.toString());
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ").append(trackPointsTableName).append(" VALUES ( ?");
        for (int i = 1; i < 25; ++i) {
            insert.append(",?");
        }
        insert.append(");");
        return connection.prepareStatement(insert.toString());
    }

    public static void dropOSMTables(Connection connection, TableLocation tablePrefix) throws SQLException {
        DBTypes dbType = DBUtils.getDBType((Connection)connection);
        String gpxTableName = tablePrefix.toString();
        String[] gpxTables = new String[]{WAYPOINT, ROUTE, ROUTEPOINT, TRACK, TRACKPOINT, TRACKSEGMENT};
        StringBuilder sb = new StringBuilder("drop table if exists ");
        String gpxTableSuffix = gpxTables[0];
        String gpxTable = TableUtilities.caseIdentifier((TableLocation)tablePrefix, (String)(gpxTableName + gpxTableSuffix), (DBTypes)dbType);
        sb.append(gpxTable);
        for (int i = 1; i < gpxTables.length; ++i) {
            gpxTableSuffix = gpxTables[i];
            gpxTable = TableUtilities.caseIdentifier((TableLocation)tablePrefix, (String)(gpxTableName + gpxTableSuffix), (DBTypes)dbType);
            sb.append(",").append(gpxTable);
        }
        try (Statement stmt = connection.createStatement();){
            stmt.execute(sb.toString());
        }
    }
}

