/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.file_table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVSecondaryIndex;
import org.h2.mvstore.db.MVSpatialIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.MathUtils;
import org.h2.value.TypeInfo;
import org.h2gis.api.FileDriver;
import org.h2gis.functions.io.file_table.H2TableIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2MVTable
extends MVTable {
    private FileDriver driver;
    private static final Logger LOG = LoggerFactory.getLogger(H2MVTable.class);
    private final ArrayList<Index> indexes = new ArrayList();
    private Column rowIdColumn;

    public H2MVTable(FileDriver driver, CreateTableData data) {
        super(data, data.session.getDatabase().getStore());
        IndexColumn indexColumn = new IndexColumn("PK");
        indexColumn.column = (Column)data.columns.get(0);
        indexColumn.sortType = 0;
        this.indexes.add(new H2TableIndex(driver, (Table)this, this.getId(), data.schema.getUniqueIndexName(data.session, (Table)this, data.tableName + "." + ((Column)data.columns.get(0)).getName() + "_INDEX_"), indexColumn));
        this.driver = driver;
    }

    public void init(Session session) {
        IndexColumn indexColumn = new IndexColumn("pk");
        indexColumn.column = new Column("pk", TypeInfo.TYPE_BIGINT);
        this.indexes.add(0, new H2TableIndex(this.driver, (Table)this, this.getId(), indexColumn));
    }

    public boolean lock(SessionLocal session, int lockType) {
        return false;
    }

    public void close(SessionLocal session) {
        for (Index index : this.indexes) {
            index.close(session);
        }
        try {
            this.driver.close();
        }
        catch (IOException ex) {
            LOG.error("Error while closing the SHP driver", (Throwable)ex);
        }
    }

    public void unlock(SessionLocal session) {
    }

    public Row getRow(SessionLocal session, long key) {
        return this.indexes.get(0).getRow(session, key);
    }

    public Index addIndex(SessionLocal session, String indexName, int indexId, IndexColumn[] cols, int uniqueColumnCount, IndexType indexType, boolean create, String indexComment) {
        Object index;
        boolean isSessionTemporary;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn c : cols) {
                Column column = c.column;
                if (column.isNullable()) {
                    throw DbException.get((int)90023, (String)column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl = isSessionTemporary = this.isTemporary() && !this.isGlobalTemporary();
        if (!isSessionTemporary) {
            this.database.lockMeta(session);
        }
        if ((index = indexType.isSpatial() ? new MVSpatialIndex(session.getDatabase(), (MVTable)this, indexId, indexName, cols, uniqueColumnCount, indexType) : new MVSecondaryIndex(session.getDatabase(), (MVTable)this, indexId, indexName, cols, uniqueColumnCount, indexType)).needRebuild() && this.getRowCount(session) > 0L) {
            this.rebuild(session, (Index)index);
        }
        index.setTemporary(this.isTemporary());
        if (index.getCreateSQL() != null) {
            index.setComment(indexComment);
            if (isSessionTemporary) {
                session.addLocalTempTableIndex((Index)index);
            } else {
                this.database.addSchemaObject(session, (SchemaObject)index);
            }
        }
        this.indexes.add((Index)index);
        this.setModified();
        return index;
    }

    private void rebuild(SessionLocal session, Index index) {
        long remaining;
        Index scan = this.getScanIndex(session);
        long total = remaining = scan.getRowCount(session);
        Cursor cursor = scan.find(session, null, null, false);
        long i = 0L;
        int bufferSize = (int)Math.min(total, (long)this.database.getMaxMemoryRows());
        ArrayList<Row> buffer = new ArrayList<Row>(bufferSize);
        String n = this.getName() + ":" + index.getName();
        int t = MathUtils.convertLongToInt((long)total);
        while (cursor.next()) {
            Row row = cursor.get();
            buffer.add(row);
            this.database.setProgress(1, n, (long)MathUtils.convertLongToInt((long)i++), (long)t);
            if (buffer.size() >= bufferSize) {
                H2MVTable.addRowsToIndex(session, buffer, index);
            }
            --remaining;
        }
        H2MVTable.addRowsToIndex(session, buffer, index);
        if (remaining != 0L) {
            throw DbException.getInternalError((String)("rowcount remaining=" + remaining + " " + this.getName()));
        }
    }

    public void removeChildrenAndResources(SessionLocal session) {
        while (this.indexes.size() > 2) {
            Index index = this.indexes.get(2);
            index.remove(session);
            if (index.getName() != null) {
                this.database.removeSchemaObject(session, (SchemaObject)index);
            }
            this.indexes.remove(index);
        }
        super.removeChildrenAndResources(session);
    }

    public static void addRowsToIndex(SessionLocal session, ArrayList<Row> list, Index index) {
        final Index idx = index;
        Collections.sort(list, new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                return idx.compareRows((SearchRow)r1, (SearchRow)r2);
            }
        });
        for (Row row : list) {
            index.add(session, row);
        }
        list.clear();
    }

    public void removeRow(SessionLocal session, Row row) {
        throw DbException.get((int)50100, (String)"removeRow in this driver file");
    }

    public long truncate(SessionLocal session) {
        long result = this.getRowCountApproximation(session);
        for (Index index : this.indexes) {
            index.truncate(session);
        }
        return result;
    }

    public void addRow(SessionLocal session, Row row) {
        throw DbException.get((int)50100, (String)"addRow in this driver file");
    }

    public void checkSupportAlter() {
        throw DbException.get((int)50100, (String)"addRow in this driver file");
    }

    public TableType getTableType() {
        return TableType.EXTERNAL_TABLE_ENGINE;
    }

    public Index getScanIndex(SessionLocal session) {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isScan()) continue;
            return index;
        }
        return null;
    }

    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(SessionLocal session) {
        return this.driver.getRowCount();
    }

    public long getRowCountApproximation(SessionLocal session) {
        return this.driver.getRowCount();
    }

    public long getDiskSpaceUsed(boolean total, boolean approximate) {
        return 0L;
    }

    public void checkRename() {
    }

    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", TypeInfo.TYPE_BIGINT);
            this.rowIdColumn.setTable((Table)this, -1);
        }
        return this.rowIdColumn;
    }
}

