/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.network.functions;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2gis.api.Function;
import org.h2gis.functions.factory.H2GISFunctions;
import org.h2gis.network.functions.ST_Accessibility;
import org.h2gis.network.functions.ST_ConnectedComponents;
import org.h2gis.network.functions.ST_GraphAnalysis;
import org.h2gis.network.functions.ST_ShortestPath;
import org.h2gis.network.functions.ST_ShortestPathLength;
import org.h2gis.network.functions.ST_ShortestPathTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkFunctions.class);

    public static Function[] getBuiltInsFunctions() throws SQLException {
        return new Function[]{new ST_Accessibility(), new ST_ConnectedComponents(), new ST_GraphAnalysis(), new ST_ShortestPathLength(), new ST_ShortestPathTree(), new ST_ShortestPath()};
    }

    public static void load(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        for (Function function : NetworkFunctions.getBuiltInsFunctions()) {
            try {
                H2GISFunctions.registerFunction((Statement)st, (Function)function, (String)"");
            }
            catch (SQLException ex) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }
}

