/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.network.functions;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2gis.network.functions.GraphFunction;
import org.h2gis.network.functions.GraphFunctionParser;
import org.h2gis.utilities.TableUtilities;
import org.javanetworkanalyzer.data.VId;
import org.javanetworkanalyzer.model.DirectedPseudoG;
import org.javanetworkanalyzer.model.DirectedWeightedPseudoG;
import org.javanetworkanalyzer.model.Edge;
import org.javanetworkanalyzer.model.KeyedGraph;
import org.javanetworkanalyzer.model.PseudoG;
import org.javanetworkanalyzer.model.WeightedPseudoG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCreator<V extends VId, E extends Edge> {
    private final Class<? extends V> vertexClass;
    private final Class<? extends E> edgeClass;
    private final Connection connection;
    private int startNodeIndex = -1;
    private int endNodeIndex = -1;
    private int edgeIDIndex = -1;
    private int weightColumnIndex = -1;
    private int edgeOrientationIndex = -1;
    private final String inputTable;
    private final String weightColumn;
    private final GraphFunctionParser.Orientation globalOrientation;
    private final String edgeOrientationColumnName;
    public static final int DIRECTED_EDGE = 1;
    public static final int REVERSED_EDGE = -1;
    public static final int UNDIRECTED_EDGE = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("gui." + GraphCreator.class));

    public GraphCreator(Connection connection, String inputTable, GraphFunctionParser.Orientation globalOrientation, String edgeOrientationColumnName, String weightColumn, Class<? extends V> vertexClass, Class<? extends E> edgeClass) {
        this.connection = connection;
        this.inputTable = inputTable;
        this.weightColumn = weightColumn;
        this.globalOrientation = globalOrientation;
        this.edgeOrientationColumnName = edgeOrientationColumnName;
        this.vertexClass = vertexClass;
        this.edgeClass = edgeClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyedGraph<V, E> prepareGraph() throws SQLException {
        LOGGER.debug("Loading graph into memory...");
        long start = System.currentTimeMillis();
        Object graph = !this.globalOrientation.equals((Object)GraphFunctionParser.Orientation.UNDIRECTED) ? (this.weightColumn != null ? new DirectedWeightedPseudoG(this.vertexClass, this.edgeClass) : new DirectedPseudoG(this.vertexClass, this.edgeClass)) : (this.weightColumn != null ? new WeightedPseudoG(this.vertexClass, this.edgeClass) : new PseudoG(this.vertexClass, this.edgeClass));
        Statement st = this.connection.createStatement();
        ResultSet edges = st.executeQuery("SELECT * FROM " + TableUtilities.parseInputTable((Connection)this.connection, (String)this.inputTable));
        this.initIndices(edges);
        try {
            while (edges.next()) {
                this.loadEdge((KeyedGraph<V, E>)graph, edges);
            }
            GraphFunction.logTime(LOGGER, start);
            DirectedWeightedPseudoG directedWeightedPseudoG = graph;
            return directedWeightedPseudoG;
        }
        catch (SQLException e) {
            LOGGER.error("Could not store edges in graph.", (Throwable)e);
            KeyedGraph<V, E> keyedGraph = null;
            return keyedGraph;
        }
        finally {
            edges.close();
            st.close();
        }
    }

    private void initIndices(ResultSet edges) {
        try {
            ResultSetMetaData metaData = edges.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = metaData.getColumnName(i);
                if (columnName.equalsIgnoreCase("START_NODE")) {
                    this.startNodeIndex = i;
                }
                if (columnName.equalsIgnoreCase("END_NODE")) {
                    this.endNodeIndex = i;
                }
                if (columnName.equalsIgnoreCase("EDGE_ID")) {
                    this.edgeIDIndex = i;
                }
                if (columnName.equalsIgnoreCase(this.edgeOrientationColumnName)) {
                    this.edgeOrientationIndex = i;
                }
                if (!columnName.equalsIgnoreCase(this.weightColumn)) continue;
                this.weightColumnIndex = i;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Problem accessing edge table metadata.", (Throwable)e);
        }
        GraphCreator.verifyIndex(this.startNodeIndex, "START_NODE");
        GraphCreator.verifyIndex(this.endNodeIndex, "END_NODE");
        GraphCreator.verifyIndex(this.edgeIDIndex, "EDGE_ID");
        if (!this.globalOrientation.equals((Object)GraphFunctionParser.Orientation.UNDIRECTED)) {
            GraphCreator.verifyIndex(this.edgeOrientationIndex, this.edgeOrientationColumnName);
        }
        if (this.weightColumn != null) {
            GraphCreator.verifyIndex(this.weightColumnIndex, this.weightColumn);
        }
    }

    private static void verifyIndex(int index, String missingField) {
        if (index == -1) {
            throw new IndexOutOfBoundsException("Column \"" + missingField + "\" not found.");
        }
    }

    private E loadEdge(KeyedGraph<V, E> graph, ResultSet edges) throws SQLException {
        Object edge;
        int startNode = edges.getInt(this.startNodeIndex);
        int endNode = edges.getInt(this.endNodeIndex);
        int edgeID = edges.getInt(this.edgeIDIndex);
        double weight = 1.0;
        if (this.weightColumnIndex != -1) {
            weight = edges.getDouble(this.weightColumnIndex);
        }
        if (this.globalOrientation.equals((Object)GraphFunctionParser.Orientation.UNDIRECTED)) {
            edge = (Edge)graph.addEdge(endNode, startNode, edgeID);
        } else {
            int edgeOrientation;
            int n = edgeOrientation = this.edgeOrientationIndex == -1 ? 1 : edges.getInt(this.edgeOrientationIndex);
            if (edges.wasNull()) {
                throw new IllegalArgumentException("Invalid edge orientation: NULL.");
            }
            if (edgeOrientation == 0) {
                edge = this.globalOrientation.equals((Object)GraphFunctionParser.Orientation.DIRECTED) ? this.loadDoubleEdge(graph, startNode, endNode, edgeID, weight) : this.loadDoubleEdge(graph, endNode, startNode, edgeID, weight);
            } else if (edgeOrientation == 1) {
                edge = this.globalOrientation.equals((Object)GraphFunctionParser.Orientation.REVERSED) ? (Edge)graph.addEdge(endNode, startNode, edgeID) : (Edge)graph.addEdge(startNode, endNode, edgeID);
            } else if (edgeOrientation == -1) {
                edge = this.globalOrientation.equals((Object)GraphFunctionParser.Orientation.REVERSED) ? (Edge)graph.addEdge(startNode, endNode, edgeID) : (Edge)graph.addEdge(endNode, startNode, edgeID);
            } else {
                throw new IllegalArgumentException("Invalid edge orientation: " + edgeOrientation);
            }
        }
        this.setEdgeWeight(edge, weight);
        return (E)edge;
    }

    private E loadDoubleEdge(KeyedGraph<V, E> graph, int startNode, int endNode, int edgeID, double weight) throws SQLException {
        Edge edgeTo = (Edge)graph.addEdge(startNode, endNode, edgeID);
        this.setEdgeWeight(edgeTo, weight);
        Edge edgeFrom = (Edge)graph.addEdge(endNode, startNode, -edgeID);
        this.setEdgeWeight(edgeFrom, weight);
        return (E)edgeFrom;
    }

    private void setEdgeWeight(E edge, double weight) throws SQLException {
        if (edge != null && this.weightColumnIndex != -1) {
            edge.setWeight(weight);
        }
    }
}

