/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.GraphUnion;
import org.jgrapht.util.WeightCombiner;

public class MixedGraphUnion<V, E>
extends GraphUnion<V, E, Graph<V, E>>
implements DirectedGraph<V, E> {
    private static final long serialVersionUID = -1961714127770731054L;
    private final UndirectedGraph<V, E> undirectedGraph;
    private final DirectedGraph<V, E> directedGraph;

    public MixedGraphUnion(UndirectedGraph<V, E> g1, DirectedGraph<V, E> g2, WeightCombiner operator) {
        super(g1, g2, operator);
        this.undirectedGraph = g1;
        this.directedGraph = g2;
    }

    public MixedGraphUnion(UndirectedGraph<V, E> g1, DirectedGraph<V, E> g2) {
        super(g1, g2);
        this.undirectedGraph = g1;
        this.directedGraph = g2;
    }

    @Override
    public int inDegreeOf(V vertex) {
        Set<E> res = this.incomingEdgesOf(vertex);
        return res.size();
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        LinkedHashSet res = new LinkedHashSet();
        if (this.directedGraph.containsVertex(vertex)) {
            res.addAll(this.directedGraph.incomingEdgesOf(vertex));
        }
        if (this.undirectedGraph.containsVertex(vertex)) {
            res.addAll(this.undirectedGraph.edgesOf(vertex));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public int outDegreeOf(V vertex) {
        Set<E> res = this.outgoingEdgesOf(vertex);
        return res.size();
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        LinkedHashSet res = new LinkedHashSet();
        if (this.directedGraph.containsVertex(vertex)) {
            res.addAll(this.directedGraph.outgoingEdgesOf(vertex));
        }
        if (this.undirectedGraph.containsVertex(vertex)) {
            res.addAll(this.undirectedGraph.edgesOf(vertex));
        }
        return Collections.unmodifiableSet(res);
    }
}

