/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.properties.ST_3DLength;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class ST_3DPerimeter
extends DeterministicScalarFunction {
    public ST_3DPerimeter() {
        this.addProperty("remarks", "Returns the 3D length measurement of the boundary of a Polygon or a MultiPolygon. \nNote : For 2D geometries, returns the 2D length.");
    }

    public String getJavaStaticMethod() {
        return "st3Dperimeter";
    }

    public static Double st3Dperimeter(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry.getDimension() < 2) {
            return 0.0;
        }
        return ST_3DPerimeter.compute3DPerimeter(geometry);
    }

    private static double compute3DPerimeter(Geometry geometry) {
        double sum = 0.0;
        int size = geometry.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry subGeom = geometry.getGeometryN(i);
            if (!(subGeom instanceof Polygon)) continue;
            sum += ST_3DLength.length3D((LineString)((Polygon)subGeom).getExteriorRing());
        }
        return sum;
    }
}

