/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.predicates;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;

public class ST_Relate
extends DeterministicScalarFunction {
    public ST_Relate() {
        this.addProperty("remarks", " This function is used to compute the relation between two geometries, as described in the SFS specification. It can be used in two ways. First, if it is given two geometries,it returns a 9-character String representation of the 2 geometries IntersectionMatrix. If it is given two geometries and an IntersectionMatrix representation, it will return a boolean : true it the two geometries' IntersectionMatrix match the given one, false otherwise.");
    }

    public String getJavaStaticMethod() {
        return "relate";
    }

    public static String relate(Geometry a, Geometry b) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return null;
        }
        if (a.getSRID() != b.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return a.relate(b).toString();
    }

    public static Boolean relate(Geometry a, Geometry b, String iMatrix) {
        if (a == null || b == null || iMatrix == null) {
            return null;
        }
        return a.relate(b, iMatrix);
    }
}

