/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.predicates;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;

public class ST_EnvelopesIntersect
extends DeterministicScalarFunction {
    public ST_EnvelopesIntersect() {
        this.addProperty("remarks", "Return true if the envelope of Geometry A intersects the envelope of Geometry B");
    }

    public String getJavaStaticMethod() {
        return "intersects";
    }

    public static Boolean intersects(Geometry surface, Geometry testGeometry) throws SQLException {
        if (surface == null && testGeometry == null) {
            return null;
        }
        if (surface.isEmpty() || testGeometry.isEmpty()) {
            return false;
        }
        if (surface.getSRID() != testGeometry.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return testGeometry != null && surface != null && surface.getEnvelopeInternal().intersects(testGeometry.getEnvelopeInternal());
    }
}

