/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.generalize;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;

public class ST_SnapToGrid
extends DeterministicScalarFunction {
    public ST_SnapToGrid() {
        this.addProperty("remarks", "Snap all points of the input geometry to the grid defined by its origin and cell size.");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geometry, float cell_size) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (cell_size == 0.0f) {
            return geometry;
        }
        if (cell_size < 0.0f) {
            throw new SQLException("cell size has to be >= 0.");
        }
        PrecisionModel pm = new PrecisionModel((double)Math.round(1.0f / cell_size));
        GeometryPrecisionReducer geometryPrecisionReducer = new GeometryPrecisionReducer(pm);
        try {
            return geometryPrecisionReducer.reduce(geometry);
        }
        catch (IllegalArgumentException ex) {
            return geometry;
        }
    }

    public static double scaleFactorForDecimalPlaces(int decimalPlaces) {
        return Math.pow(10.0, decimalPlaces);
    }
}

