/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class ST_UpdateZ
extends DeterministicScalarFunction {
    static final GeometryFactory gf = new GeometryFactory();

    public ST_UpdateZ() {
        this.addProperty("remarks", "This function replace the z value of (each vertex of) the\n geometric parameter to the corresponding value given by a field.");
    }

    public String getJavaStaticMethod() {
        return "updateZ";
    }

    public static Geometry updateZ(Geometry geometry, double z) {
        if (geometry == null) {
            return null;
        }
        return ST_UpdateZ.force(geometry, z);
    }

    public static Geometry force(Geometry geom, double zValue) {
        Geometry g = geom;
        if (geom instanceof Point) {
            g = gf.createPoint((CoordinateSequence)ST_UpdateZ.convertSequence(((Point)geom).getCoordinateSequence(), zValue));
            g.setSRID(geom.getSRID());
        } else if (geom instanceof LineString) {
            g = gf.createLineString((CoordinateSequence)ST_UpdateZ.convertSequence(((LineString)geom).getCoordinateSequence(), zValue));
            g.setSRID(geom.getSRID());
        } else if (geom instanceof Polygon) {
            g = ST_UpdateZ.convert((Polygon)geom, zValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPoint) {
            g = ST_UpdateZ.convert((MultiPoint)geom, zValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiLineString) {
            g = ST_UpdateZ.convert((MultiLineString)geom, zValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPolygon) {
            g = ST_UpdateZ.convert((MultiPolygon)geom, zValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof GeometryCollection) {
            g = ST_UpdateZ.convert((GeometryCollection)geom, zValue);
            g.setSRID(geom.getSRID());
        }
        return g;
    }

    public static MultiPoint convert(MultiPoint mp, double zValue) {
        int nb = mp.getNumGeometries();
        Point[] geometries = new Point[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = (Point)ST_UpdateZ.force(mp.getGeometryN(i), zValue);
        }
        return gf.createMultiPoint(geometries);
    }

    public static GeometryCollection convert(GeometryCollection gc, double zValue) {
        int nb = gc.getNumGeometries();
        Geometry[] geometries = new Geometry[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = ST_UpdateZ.force(gc.getGeometryN(i), zValue);
        }
        return gf.createGeometryCollection(geometries);
    }

    public static MultiPolygon convert(MultiPolygon multiPolygon, double zValue) {
        int nb = multiPolygon.getNumGeometries();
        Polygon[] pl = new Polygon[nb];
        for (int i = 0; i < nb; ++i) {
            pl[i] = ST_UpdateZ.convert((Polygon)multiPolygon.getGeometryN(i), zValue);
        }
        return gf.createMultiPolygon(pl);
    }

    public static MultiLineString convert(MultiLineString multiLineString, double zValue) {
        int nb = multiLineString.getNumGeometries();
        LineString[] ls = new LineString[nb];
        for (int i = 0; i < nb; ++i) {
            ls[i] = ST_UpdateZ.convert((LineString)multiLineString.getGeometryN(i), zValue);
        }
        return gf.createMultiLineString(ls);
    }

    public static Polygon convert(Polygon polygon, double zValue) {
        LinearRing shell = gf.createLinearRing((CoordinateSequence)ST_UpdateZ.convertSequence(polygon.getExteriorRing().getCoordinateSequence(), zValue));
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = gf.createLinearRing((CoordinateSequence)ST_UpdateZ.convertSequence(polygon.getInteriorRingN(i).getCoordinateSequence(), zValue));
        }
        return gf.createPolygon(shell, holes);
    }

    public static LineString convert(LineString lineString, double zValue) {
        return gf.createLineString((CoordinateSequence)ST_UpdateZ.convertSequence(lineString.getCoordinateSequence(), zValue));
    }

    public static LinearRing convert(LinearRing linearRing, double zValue) {
        return gf.createLinearRing((CoordinateSequence)ST_UpdateZ.convertSequence(linearRing.getCoordinateSequence(), zValue));
    }

    private static CoordinateArraySequence convertSequence(CoordinateSequence cs, double zValue) {
        int dim = cs.getDimension();
        if (dim == 4) {
            Coordinate[] coords = new Coordinate[cs.size()];
            for (int i = 0; i < cs.size(); ++i) {
                CoordinateXYZM coord = (CoordinateXYZM)cs.getCoordinate(i);
                coord.setZ(zValue);
                coords[i] = coord;
            }
            return new CoordinateArraySequence(coords, dim);
        }
        if (cs.getMeasures() == 1) {
            Coordinate[] coords = new Coordinate[cs.size()];
            for (int i = 0; i < cs.size(); ++i) {
                Coordinate coord = cs.getCoordinate(i);
                coord = new CoordinateXYZM(coord);
                coord.setZ(zValue);
                coords[i] = coord;
            }
            return new CoordinateArraySequence(coords, 4);
        }
        Coordinate[] coords = new Coordinate[cs.size()];
        for (int i = 0; i < cs.size(); ++i) {
            Coordinate coord = cs.getCoordinate(i);
            coord = new Coordinate(coord);
            coord.setZ(zValue);
            coords[i] = coord;
        }
        return new CoordinateArraySequence(coords, 3);
    }
}

