/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class ST_Interpolate3DLine
extends DeterministicScalarFunction {
    public ST_Interpolate3DLine() {
        this.addProperty("remarks", "Interpolate the z values of a linestring or multilinestring based on\nthe start and the end z values. If the z values are equal to NaN return the\n input geometry.");
    }

    public String getJavaStaticMethod() {
        return "interpolateLine";
    }

    public static Geometry interpolateLine(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof LineString) {
            return ST_Interpolate3DLine.linearZInterpolation((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return ST_Interpolate3DLine.linearZInterpolation((MultiLineString)geometry);
        }
        return null;
    }

    private static LineString linearZInterpolation(LineString lineString) {
        double startz = lineString.getStartPoint().getCoordinate().z;
        double endz = lineString.getEndPoint().getCoordinate().z;
        if (Double.isNaN(startz) || Double.isNaN(endz)) {
            return lineString;
        }
        double length = lineString.getLength();
        lineString.apply((CoordinateSequenceFilter)new LinearZInterpolationFilter(startz, endz, length));
        return lineString;
    }

    private static MultiLineString linearZInterpolation(MultiLineString multiLineString) {
        int nbGeom = multiLineString.getNumGeometries();
        LineString[] lines = new LineString[nbGeom];
        for (int i = 0; i < nbGeom; ++i) {
            LineString subGeom = (LineString)multiLineString.getGeometryN(i);
            double startz = subGeom.getStartPoint().getCoordinates()[0].z;
            double endz = subGeom.getEndPoint().getCoordinates()[0].z;
            double length = subGeom.getLength();
            subGeom.apply((CoordinateSequenceFilter)new LinearZInterpolationFilter(startz, endz, length));
            lines[i] = subGeom;
        }
        return multiLineString.getFactory().createMultiLineString(lines);
    }

    private static class LinearZInterpolationFilter
    implements CoordinateSequenceFilter {
        private boolean done = false;
        private double startZ = 0.0;
        private double endZ = 0.0;
        private double dZ = 0.0;
        private final double length;
        private int seqSize = 0;
        private double sumLenght = 0.0;

        LinearZInterpolationFilter(double startZ, double endZ, double length) {
            this.startZ = startZ;
            this.endZ = endZ;
            this.length = length;
        }

        public void filter(CoordinateSequence seq, int i) {
            if (i == 0) {
                this.seqSize = seq.size();
                this.dZ = this.endZ - this.startZ;
            } else if (i == this.seqSize) {
                this.done = true;
            } else {
                Coordinate coord = seq.getCoordinate(i);
                Coordinate previousCoord = seq.getCoordinate(i - 1);
                this.sumLenght += coord.distance(previousCoord);
                seq.setOrdinate(i, 2, this.startZ + this.dZ * this.sumLenght / this.length);
            }
        }

        public boolean isGeometryChanged() {
            return true;
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

