/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.linearref.LengthIndexedLine;

public class ST_ProjectPoint
extends DeterministicScalarFunction {
    public ST_ProjectPoint() {
        this.addProperty("remarks", "Projet a point along a linestring. If the point projected is out of line the first or last point on the line will be returned otherwise the input point.");
    }

    public String getJavaStaticMethod() {
        return "projectPoint";
    }

    public static Point projectPoint(Geometry point, Geometry geometry) throws SQLException {
        if (point == null || geometry == null) {
            return null;
        }
        if (point.isEmpty() || geometry.isEmpty()) {
            return null;
        }
        if (point.getSRID() != geometry.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        if (point.getDimension() == 0 && geometry.getDimension() == 1) {
            LengthIndexedLine ll = new LengthIndexedLine(geometry);
            double index = ll.project(point.getCoordinate());
            return geometry.getFactory().createPoint(ll.extractPoint(index));
        }
        return null;
    }
}

