/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.crs;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.cts.CRSFactory;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.Geographic2DCRS;
import org.cts.crs.Geographic3DCRS;
import org.cts.op.CoordinateOperation;
import org.cts.registry.Registry;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.crs.EPSGTuple;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.h2gis.functions.spatial.crs.SpatialRefRegistry;
import org.locationtech.jts.geom.Geometry;

public class ST_IsGeographicCRS
extends DeterministicScalarFunction {
    private static CRSFactory crsf;
    private static SpatialRefRegistry srr;
    private static Map<EPSGTuple, CoordinateOperation> copPool;

    public ST_IsGeographicCRS() {
        this.addProperty("remarks", "ST_IsGeographicCRS takes a geometry and \nreturn true is the coordinate system is geographic, otherwise false. False is the geometry is null \nand or if its srid is equals to 0.");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Boolean execute(Connection connection, Geometry geometry) throws SQLException {
        if (geometry == null) {
            return false;
        }
        int inputSRID = geometry.getSRID();
        if (inputSRID == 0) {
            return false;
        }
        if (crsf == null) {
            crsf = new CRSFactory();
            crsf.getRegistryManager().addRegistry((Registry)srr);
        }
        srr.setConnection(connection);
        try {
            CoordinateReferenceSystem inputCRS = crsf.getCRS(srr.getRegistryName() + ":" + inputSRID);
            if (inputCRS instanceof Geographic2DCRS || inputCRS instanceof Geographic3DCRS) {
                Boolean bl = true;
                return bl;
            }
        }
        catch (CRSException ex) {
            throw new SQLException("Cannot create the CRS", ex);
        }
        finally {
            srr.setConnection(null);
        }
        return false;
    }

    static {
        srr = new SpatialRefRegistry();
        copPool = new ST_Transform.CopCache(5);
    }
}

