/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;

public class ST_ToMultiLine
extends DeterministicScalarFunction {
    public ST_ToMultiLine() {
        this.addProperty("remarks", "Constructs a MultiLineString from the given geometry's coordinates.");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static MultiLineString execute(Geometry geom) throws SQLException {
        if (geom != null) {
            if (geom.getDimension() > 0) {
                LinkedList<LineString> lineStrings = new LinkedList<LineString>();
                ST_ToMultiLine.toMultiLineString(geom, lineStrings);
                return geom.getFactory().createMultiLineString(lineStrings.toArray(new LineString[0]));
            }
            return geom.getFactory().createMultiLineString(null);
        }
        return null;
    }

    private static void toMultiLineString(Geometry geometry, List<LineString> lineStrings) throws SQLException {
        if (geometry instanceof LineString) {
            ST_ToMultiLine.toMultiLineString((LineString)geometry, lineStrings);
        } else if (geometry instanceof Polygon) {
            ST_ToMultiLine.toMultiLineString((Polygon)geometry, lineStrings);
        } else if (geometry instanceof GeometryCollection) {
            ST_ToMultiLine.toMultiLineString((GeometryCollection)geometry, lineStrings);
        }
    }

    private static void toMultiLineString(LineString lineString, List<LineString> lineStrings) {
        lineStrings.add(lineString);
    }

    private static void toMultiLineString(Polygon polygon, List<LineString> lineStrings) {
        lineStrings.add((LineString)polygon.getExteriorRing());
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            lineStrings.add((LineString)polygon.getInteriorRingN(i));
        }
    }

    private static void toMultiLineString(GeometryCollection geometryCollection, List<LineString> lineStrings) throws SQLException {
        int size = geometryCollection.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            ST_ToMultiLine.toMultiLineString(geometryCollection.getGeometryN(i), lineStrings);
        }
    }
}

