/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.buffer;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurve;

public class ST_OffSetCurve
extends DeterministicScalarFunction {
    public ST_OffSetCurve() {
        this.addProperty("remarks", "Return an offset line or collection of lines at a given distance and side from an input geometry.\nThe optional third parameter can either specify number of segments used\n to approximate a quarter circle (integer case, defaults to 8)\n or a list of blank-separated key=value pairs (string case) to manage line style parameters :\n'quad_segs=8' 'join=round|mitre|bevel' 'mitre_limit=5'");
    }

    public String getJavaStaticMethod() {
        return "offsetCurve";
    }

    public static Geometry offsetCurve(Geometry geometry, double offset, String parameters) {
        if (geometry == null) {
            return null;
        }
        String[] buffParemeters = parameters.split("\\s+");
        BufferParameters bufferParameters = new BufferParameters();
        for (String params : buffParemeters) {
            String[] keyValue = params.split("=");
            if (keyValue[0].equalsIgnoreCase("join")) {
                String param = keyValue[1];
                if (param.equalsIgnoreCase("bevel")) {
                    bufferParameters.setJoinStyle(3);
                    continue;
                }
                if (param.equalsIgnoreCase("mitre") || param.equalsIgnoreCase("miter")) {
                    bufferParameters.setJoinStyle(2);
                    continue;
                }
                if (param.equalsIgnoreCase("round")) {
                    bufferParameters.setJoinStyle(1);
                    continue;
                }
                throw new IllegalArgumentException("Supported join values are bevel, mitre, miter or round.");
            }
            if (keyValue[0].equalsIgnoreCase("mitre_limit") || keyValue[0].equalsIgnoreCase("miter_limit")) {
                bufferParameters.setMitreLimit(Double.valueOf(keyValue[1]).doubleValue());
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("quad_segs")) {
                bufferParameters.setQuadrantSegments(Integer.valueOf(keyValue[1]).intValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown parameters. Please read the documentation.");
        }
        return OffsetCurve.getCurve((Geometry)geometry, (double)offset, (int)bufferParameters.getQuadrantSegments(), (int)bufferParameters.getJoinStyle(), (double)bufferParameters.getMitreLimit());
    }

    public static Geometry offsetCurve(Geometry geometry, double offset) {
        return OffsetCurve.getCurve((Geometry)geometry, (double)offset);
    }
}

