/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.tsv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import org.h2.tools.Csv;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.DriverManager;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;

public class TSVDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "TSV file (Tab Separated Values)";
    private static final int BATCH_MAX_SIZE = 100;

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"tsv", "tsv.gz"};
    }

    public String[] getExportFormats() {
        return new String[]{"tsv", "tsv.gz"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("tsv")) {
            return DESCRIPTION;
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return false;
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, false, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, deleteFiles, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String encoding, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableReference);
        if (matcher.find()) {
            if (tableReference.startsWith("(") && tableReference.endsWith(")")) {
                if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"tsv")) {
                    if (deleteFiles) {
                        Files.deleteIfExists(fileName.toPath());
                    } else if (fileName.exists()) {
                        throw new IOException("The tsv file already exist.");
                    }
                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName)));){
                        String[] stringArray;
                        block92: {
                            Statement st = connection.createStatement();
                            try {
                                JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
                                this.exportFromResultSet(connection, st.executeQuery(tableReference), bw, encoding, progress);
                                stringArray = new String[]{fileName.getAbsolutePath()};
                                if (st == null) break block92;
                            }
                            catch (Throwable throwable) {
                                if (st != null) {
                                    try {
                                        st.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            st.close();
                        }
                        return stringArray;
                    }
                }
                if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"gz")) {
                    if (deleteFiles) {
                        Files.deleteIfExists(fileName.toPath());
                    } else if (fileName.exists()) {
                        throw new IOException("The gz file already exist.");
                    }
                    DBTypes dbType = DBUtils.getDBType((Connection)connection);
                    TableLocation location = TableLocation.parse((String)tableReference, (DBTypes)dbType);
                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(fileName))));){
                        String[] stringArray;
                        block93: {
                            Statement st = connection.createStatement();
                            try {
                                JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
                                this.exportFromResultSet(connection, st.executeQuery(location.toString()), bw, encoding, progress);
                                stringArray = new String[]{fileName.getAbsolutePath()};
                                if (st == null) break block93;
                            }
                            catch (Throwable throwable) {
                                if (st != null) {
                                    try {
                                        st.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                }
                                throw throwable;
                            }
                            st.close();
                        }
                        return stringArray;
                    }
                }
                if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"zip")) {
                    if (deleteFiles) {
                        Files.deleteIfExists(fileName.toPath());
                    } else if (fileName.exists()) {
                        throw new IOException("The zip file already exist.");
                    }
                    DBTypes dbType = DBUtils.getDBType((Connection)connection);
                    TableLocation location = TableLocation.parse((String)tableReference, (DBTypes)dbType);
                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new ZipOutputStream(new FileOutputStream(fileName))));){
                        String[] stringArray;
                        block94: {
                            Statement st = connection.createStatement();
                            try {
                                JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
                                this.exportFromResultSet(connection, st.executeQuery(location.toString()), bw, encoding, progress);
                                stringArray = new String[]{fileName.getAbsolutePath()};
                                if (st == null) break block94;
                            }
                            catch (Throwable throwable) {
                                if (st != null) {
                                    try {
                                        st.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                }
                                throw throwable;
                            }
                            st.close();
                        }
                        return stringArray;
                    }
                }
                throw new SQLException("Only .tsv, .gz or .zip extensions are supported");
            }
            throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
        }
        if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"tsv")) {
            if (deleteFiles) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The tsv file already exist.");
            }
            DBTypes dbType = DBUtils.getDBType((Connection)connection);
            TableLocation location = TableLocation.parse((String)tableReference, (DBTypes)dbType);
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName)));){
                String[] stringArray;
                block95: {
                    Statement st = connection.createStatement();
                    try {
                        JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
                        this.exportFromResultSet(connection, st.executeQuery("SELECT * FROM " + location.toString()), bw, encoding, progress);
                        stringArray = new String[]{fileName.getAbsolutePath()};
                        if (st == null) break block95;
                    }
                    catch (Throwable throwable) {
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        }
                        throw throwable;
                    }
                    st.close();
                }
                return stringArray;
            }
        }
        if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"gz")) {
            if (deleteFiles) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The gz file already exist.");
            }
            DBTypes dbType = DBUtils.getDBType((Connection)connection);
            TableLocation location = TableLocation.parse((String)tableReference, (DBTypes)dbType);
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(fileName))));){
                String[] stringArray;
                block96: {
                    Statement st = connection.createStatement();
                    try {
                        JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
                        this.exportFromResultSet(connection, st.executeQuery("SELECT * FROM " + location.toString()), bw, encoding, progress);
                        stringArray = new String[]{fileName.getAbsolutePath()};
                        if (st == null) break block96;
                    }
                    catch (Throwable throwable) {
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        }
                        throw throwable;
                    }
                    st.close();
                }
                return stringArray;
            }
        }
        if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"zip")) {
            if (deleteFiles) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The zip file already exist.");
            }
            DBTypes dbType = DBUtils.getDBType((Connection)connection);
            TableLocation location = TableLocation.parse((String)tableReference, (DBTypes)dbType);
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new ZipOutputStream(new FileOutputStream(fileName))));){
                String[] stringArray;
                block97: {
                    Statement st = connection.createStatement();
                    try {
                        JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
                        this.exportFromResultSet(connection, st.executeQuery("SELECT * FROM " + location.toString()), bw, encoding, progress);
                        stringArray = new String[]{fileName.getAbsolutePath()};
                        if (st == null) break block97;
                    }
                    catch (Throwable throwable) {
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        }
                        throw throwable;
                    }
                    st.close();
                }
                return stringArray;
            }
        }
        throw new SQLException("Only .tsv, .gz or .zip extensions are supported");
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String encoding, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, encoding, false, progress);
    }

    public void exportFromResultSet(Connection connection, ResultSet res, Writer writer, String encoding, ProgressVisitor progress) throws SQLException {
        Csv csv = new Csv();
        String csvOptions = "charset=UTF-8 fieldSeparator=\t fieldDelimiter=\t";
        if (encoding != null) {
            csvOptions = String.format("charset=%s fieldSeparator=\t fieldDelimiter=\t", encoding);
        }
        csv.setOptions(csvOptions);
        csv.write(writer, res);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, options, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, deleteTables, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] importFile(Connection connection, String tableReference, File fileName, String options, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        DBTypes dbType = DBUtils.getDBType((Connection)connection);
        TableLocation requestedTable = TableLocation.parse((String)tableReference, (DBTypes)dbType);
        if (fileName != null && fileName.getName().toLowerCase().endsWith(".tsv")) {
            if (!fileName.exists()) {
                throw new SQLException("The file " + requestedTable + " doesn't exist ");
            }
            if (deleteTables) {
                Statement stmt = connection.createStatement();
                stmt.execute("DROP TABLE IF EXISTS " + requestedTable);
                stmt.close();
            }
            String table = requestedTable.toString();
            int AVERAGE_NODE_SIZE = 500;
            FileInputStream fis = new FileInputStream(fileName);
            FileChannel fc = fis.getChannel();
            long fileSize = fc.size();
            long readFileSizeEachNode = Math.max(1L, fileSize / (long)AVERAGE_NODE_SIZE / 100L);
            int average_row_size = 0;
            Csv csv = new Csv();
            csv.setFieldDelimiter('\t');
            csv.setFieldSeparatorRead('\t');
            ResultSet reader = csv.read((Reader)new BufferedReader(new InputStreamReader(fis)), null);
            ResultSetMetaData metadata = reader.getMetaData();
            int columnCount = metadata.getColumnCount();
            StringBuilder createTable = new StringBuilder("CREATE TABLE ");
            createTable.append(table).append("(");
            StringBuilder insertTable = new StringBuilder("INSERT INTO ");
            insertTable.append(table).append(" VALUES(");
            for (int i = 0; i < columnCount; ++i) {
                if (i > 0) {
                    createTable.append(",");
                    insertTable.append(",");
                }
                createTable.append(metadata.getColumnName(i + 1)).append(" VARCHAR");
                insertTable.append("?");
            }
            createTable.append(")");
            insertTable.append(")");
            try (Statement stmt = connection.createStatement();){
                stmt.execute(createTable.toString());
            }
            connection.setAutoCommit(false);
            long batchSize = 0L;
            try (PreparedStatement pst = connection.prepareStatement(insertTable.toString());){
                while (reader.next()) {
                    if (progress.isCanceled()) {
                        throw new SQLException("Canceled by user");
                    }
                    for (int i = 0; i < columnCount; ++i) {
                        pst.setString(i + 1, reader.getString(i + 1));
                    }
                    pst.addBatch();
                    if (++batchSize >= 100L) {
                        pst.executeBatch();
                        connection.commit();
                        pst.clearBatch();
                        batchSize = 0L;
                    }
                    if ((long)average_row_size++ % readFileSizeEachNode != 0L) continue;
                    try {
                        progress.setStep((int)((double)fc.position() / (double)fileSize * 100.0));
                    }
                    catch (IOException iOException) {}
                }
                if (batchSize > 0L) {
                    pst.executeBatch();
                    connection.commit();
                }
                connection.setAutoCommit(true);
                String[] stringArray = new String[]{table};
                return stringArray;
            }
        }
        if (fileName != null && fileName.getName().toLowerCase().endsWith(".gz")) {
            if (!fileName.exists()) {
                throw new SQLException("The file " + requestedTable + " doesn't exist ");
            }
            if (deleteTables) {
                Statement stmt = connection.createStatement();
                stmt.execute("DROP TABLE IF EXISTS " + requestedTable);
                stmt.close();
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(fileName))));){
                String[] stringArray;
                String table = requestedTable.toString();
                Csv csv = new Csv();
                csv.setFieldDelimiter('\t');
                csv.setFieldSeparatorRead('\t');
                ResultSet reader = csv.read((Reader)br, null);
                ResultSetMetaData metadata = reader.getMetaData();
                int columnCount = metadata.getColumnCount();
                StringBuilder createTable = new StringBuilder("CREATE TABLE ");
                createTable.append(table).append("(");
                StringBuilder insertTable = new StringBuilder("INSERT INTO ");
                insertTable.append(table).append(" VALUES(");
                for (int i = 0; i < columnCount; ++i) {
                    if (i > 0) {
                        createTable.append(",");
                        insertTable.append(",");
                    }
                    createTable.append(metadata.getColumnName(i + 1)).append(" VARCHAR");
                    insertTable.append("?");
                }
                createTable.append(")");
                insertTable.append(")");
                try (Statement stmt = connection.createStatement();){
                    stmt.execute(createTable.toString());
                }
                connection.setAutoCommit(false);
                PreparedStatement pst = connection.prepareStatement(insertTable.toString());
                long batchSize = 0L;
                try {
                    while (reader.next()) {
                        if (progress.isCanceled()) {
                            throw new SQLException("Canceled by user");
                        }
                        for (int i = 0; i < columnCount; ++i) {
                            pst.setString(i + 1, reader.getString(i + 1));
                        }
                        pst.addBatch();
                        if (++batchSize < 100L) continue;
                        pst.executeBatch();
                        connection.commit();
                        pst.clearBatch();
                        batchSize = 0L;
                    }
                    if (batchSize > 0L) {
                        pst.executeBatch();
                        connection.commit();
                    }
                    stringArray = new String[]{table};
                }
                catch (Throwable throwable) {
                    connection.setAutoCommit(true);
                    pst.close();
                    throw throwable;
                }
                connection.setAutoCommit(true);
                pst.close();
                return stringArray;
            }
        }
        throw new SQLException("The TSV read driver supports only tsv or gz extensions");
    }
}

