/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.osgi;

import javax.sql.DataSource;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.Function;
import org.h2gis.functions.factory.H2GISFunctions;
import org.h2gis.functions.io.asc.AscDriverFunction;
import org.h2gis.functions.io.csv.CSVDriverFunction;
import org.h2gis.functions.io.dbf.DBFDriverFunction;
import org.h2gis.functions.io.geojson.GeoJsonDriverFunction;
import org.h2gis.functions.io.gpx.GPXDriverFunction;
import org.h2gis.functions.io.kml.KMLDriverFunction;
import org.h2gis.functions.io.osm.OSMDriverFunction;
import org.h2gis.functions.io.shp.SHPDriverFunction;
import org.h2gis.functions.io.tsv.TSVDriverFunction;
import org.h2gis.functions.osgi.DataSourceTracker;
import org.h2gis.functions.osgi.FunctionTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private ServiceTracker<DataSource, FunctionTracker> databaseTracker;

    public void start(BundleContext bc) {
        System.setProperty("jts.relate", "ng");
        for (Function function : H2GISFunctions.getBuiltInsFunctions()) {
            bc.registerService(Function.class, (Object)function, null);
            if (!(function instanceof DriverFunction)) continue;
            bc.registerService(DriverFunction.class, (Object)((DriverFunction)function), null);
        }
        bc.registerService(DriverFunction.class, (Object)new DBFDriverFunction(), null);
        bc.registerService(DriverFunction.class, (Object)new SHPDriverFunction(), null);
        bc.registerService(DriverFunction.class, (Object)new GPXDriverFunction(), null);
        bc.registerService(DriverFunction.class, (Object)new GeoJsonDriverFunction(), null);
        bc.registerService(DriverFunction.class, (Object)new OSMDriverFunction(), null);
        bc.registerService(DriverFunction.class, (Object)new KMLDriverFunction(), null);
        bc.registerService(DriverFunction.class, (Object)new CSVDriverFunction(), null);
        bc.registerService(DriverFunction.class, (Object)new TSVDriverFunction(), null);
        bc.registerService(DriverFunction.class, (Object)new AscDriverFunction(), null);
        DataSourceTracker dataSourceTracker = new DataSourceTracker(bc);
        this.databaseTracker = new ServiceTracker(bc, DataSource.class, (ServiceTrackerCustomizer)dataSourceTracker);
        this.databaseTracker.open();
    }

    public void stop(BundleContext bundleContext) {
        this.databaseTracker.close();
    }
}

