/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.postgis_jts_osgi;

import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.h2gis.postgis_jts.DataSourceWrapper;
import org.postgresql.ds.PGPoolingDataSource;

public class DataSourceFactoryImpl {
    String JDBC_DATABASE_NAME = "databaseName";
    String JDBC_DATASOURCE_NAME = "dataSourceName";
    String JDBC_PASSWORD = "password";
    String JDBC_PORT_NUMBER = "portNumber";
    String JDBC_SERVER_NAME = "serverName";
    String JDBC_USER = "user";
    String JDBC_URL = "url";
    private static AtomicInteger dataSourceCount = new AtomicInteger(0);

    public DataSource createDataSource(Properties properties) throws SQLException {
        PGPoolingDataSource dataSource;
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.getProperty(this.JDBC_DATASOURCE_NAME) == null) {
            properties.setProperty(this.JDBC_DATASOURCE_NAME, DataSourceFactoryImpl.class.getSimpleName() + "_" + dataSourceCount.getAndAdd(1));
        }
        if ((dataSource = PGPoolingDataSource.getDataSource(properties.getProperty(this.JDBC_DATASOURCE_NAME))) == null) {
            dataSource = new PGPoolingDataSource();
            dataSource.setDataSourceName(properties.getProperty(this.JDBC_DATASOURCE_NAME));
            String url = properties.getProperty(this.JDBC_URL);
            if (url != null) {
                dataSource.setUrl(url);
            }
            dataSource.setPortNumber(Integer.valueOf(properties.getProperty(this.JDBC_PORT_NUMBER, Integer.toString(dataSource.getPortNumber()))));
            dataSource.setServerName(properties.getProperty(this.JDBC_SERVER_NAME, dataSource.getServerName()));
            dataSource.setUser(properties.getProperty(this.JDBC_USER, dataSource.getUser()));
            dataSource.setPassword(properties.getProperty(this.JDBC_PASSWORD, dataSource.getPassword()));
            dataSource.setDatabaseName(properties.getProperty(this.JDBC_DATABASE_NAME, dataSource.getDatabaseName()));
        }
        return new DataSourceWrapper((DataSource)dataSource);
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties properties) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public XADataSource createXADataSource(Properties properties) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Driver createDriver(Properties properties) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

