/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.graphcreators;

import java.io.FileNotFoundException;
import java.util.Scanner;
import org.javanetworkanalyzer.data.VId;
import org.javanetworkanalyzer.graphcreators.GraphCreator;
import org.javanetworkanalyzer.model.DirectedWeightedPseudoG;
import org.javanetworkanalyzer.model.Edge;
import org.javanetworkanalyzer.model.KeyedGraph;
import org.javanetworkanalyzer.model.WeightedKeyedGraph;
import org.javanetworkanalyzer.model.WeightedPseudoG;

public class WeightedGraphCreator<V extends VId, E extends Edge>
extends GraphCreator<V, E> {
    private final String weightField;
    protected static int weightFieldIndex = -1;

    public WeightedGraphCreator(String csvFile, int orientation, Class<? extends V> vertexClass, Class<? extends E> edgeClass, String weightField) {
        super(csvFile, orientation, vertexClass, edgeClass);
        this.weightField = weightField;
    }

    @Override
    public WeightedKeyedGraph<V, E> loadGraph() throws FileNotFoundException, NoSuchMethodException {
        return (WeightedKeyedGraph)super.loadGraph();
    }

    @Override
    protected void initializeIndices(Scanner scanner) {
        String[] row = scanner.nextLine().split(";");
        for (int i = 0; i < row.length; ++i) {
            if (row[i].replace("\"", "").equals("start_node")) {
                startNodeIndex = i;
                continue;
            }
            if (row[i].replace("\"", "").equals("end_node")) {
                endNodeIndex = i;
                continue;
            }
            if (!row[i].replace("\"", "").equals(this.weightField)) continue;
            weightFieldIndex = i;
        }
    }

    @Override
    protected KeyedGraph<V, E> initializeGraph() throws NoSuchMethodException {
        WeightedKeyedGraph graph = this.orientation != 3 ? new DirectedWeightedPseudoG(this.vertexClass, this.edgeClass) : new WeightedPseudoG(this.vertexClass, this.edgeClass);
        return graph;
    }

    @Override
    protected E loadEdge(String[] row, KeyedGraph<V, E> graph, boolean reverse) {
        Edge edge = (Edge)super.loadEdge(row, graph, reverse);
        double weight = Double.parseDouble(this.deleteDoubleQuotes(row[weightFieldIndex]));
        edge.setWeight(weight);
        return (E)edge;
    }
}

