/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.alg;

import java.util.PriorityQueue;
import java.util.Stack;
import org.javanetworkanalyzer.alg.CentralityAlg;
import org.javanetworkanalyzer.alg.Dijkstra;
import org.javanetworkanalyzer.data.VWCent;
import org.javanetworkanalyzer.data.WeightedPathLengthData;
import org.javanetworkanalyzer.model.EdgeSPT;
import org.jgrapht.Graph;

public class DijkstraForCentrality<E extends EdgeSPT>
extends Dijkstra<VWCent, E>
implements CentralityAlg<VWCent, E, WeightedPathLengthData> {
    private final Stack<VWCent> stack;
    private final WeightedPathLengthData pathsFromStartNode;

    public DijkstraForCentrality(Graph<VWCent, E> graph, Stack<VWCent> stack) {
        super(graph);
        this.stack = stack;
        this.pathsFromStartNode = new WeightedPathLengthData();
    }

    @Override
    protected void init(VWCent startNode) {
        super.init(startNode);
        this.stack.clear();
        this.pathsFromStartNode.clear();
    }

    @Override
    protected boolean preRelaxStep(VWCent startNode, VWCent u) {
        if (!this.canPushToStack(u)) {
            throw new IllegalStateException("Cannot push node " + u.getID() + " to the stack.");
        }
        this.stack.push(u);
        if (!u.equals(startNode)) {
            this.pathsFromStartNode.addSPLength(u.getDistance());
        }
        return false;
    }

    private boolean canPushToStack(VWCent node) {
        return this.stack.size() == 0 || !(node.getDistance() < this.stack.peek().getDistance());
    }

    @Override
    protected void shortestPathSoFarUpdate(VWCent startNode, VWCent u, VWCent v, Double uvWeight, E e, PriorityQueue<VWCent> queue) {
        v.setSPCount(u.getSPCount());
        super.shortestPathSoFarUpdate(startNode, u, v, uvWeight, e, queue);
    }

    @Override
    protected void multipleShortestPathUpdate(VWCent u, VWCent v, E e) {
        v.accumulateSPCount(u.getSPCount());
        super.multipleShortestPathUpdate(u, v, e);
    }

    @Override
    public WeightedPathLengthData getPaths() {
        return this.pathsFromStartNode;
    }
}

