/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.h2gis.utilities.dbtypes.DBTypes;

public class TableLocation {
    private String catalog;
    private String schema;
    private String table;
    private static final String QUOTE_CHAR = "\"";
    private String defaultSchema = "public";
    private DBTypes dbTypes = null;
    public static final Pattern QUOTE_PATTERN = Pattern.compile("\\\"([^\\\"]+)\\\"|'([^']+)'|\\\\S+");

    public TableLocation(ResultSet rs) throws SQLException {
        this(rs.getString("TABLE_CAT"), rs.getString("TABLE_SCHEM"), rs.getString("TABLE_NAME"));
    }

    public TableLocation(String catalog, String schema, String table, DBTypes dbTypes) {
        if (table == null) {
            throw new IllegalArgumentException("Cannot construct table location with null table");
        }
        this.catalog = catalog == null ? "" : catalog;
        this.schema = schema == null || schema.isEmpty() ? "" : schema;
        this.table = table;
        this.dbTypes = dbTypes;
    }

    public TableLocation(String catalog, String schema, String table) {
        if (table == null) {
            throw new IllegalArgumentException("Cannot construct table location with null table");
        }
        this.catalog = catalog == null ? "" : catalog;
        this.schema = schema == null || schema.isEmpty() ? "" : schema;
        this.table = table;
    }

    public TableLocation(String schema, String table) {
        this("", schema, table);
    }

    public TableLocation(String table) {
        this("", table);
    }

    public static String quoteIdentifier(String identifier) {
        return QUOTE_CHAR + identifier.replace(QUOTE_CHAR, "\"\"") + QUOTE_CHAR;
    }

    public static String format(String identifier, DBTypes dbTypes) {
        if (identifier == null || identifier.isEmpty() || dbTypes == null) {
            return identifier;
        }
        if (QUOTE_PATTERN.matcher(identifier).find()) {
            return identifier;
        }
        if (dbTypes.getReservedWords().contains(identifier.toUpperCase())) {
            return TableLocation.quoteIdentifier(identifier);
        }
        if (!Objects.requireNonNull(dbTypes.specialNamePattern()).matcher(identifier).find()) {
            return TableLocation.quoteIdentifier(identifier);
        }
        return identifier;
    }

    public static String quoteIdentifier(String identifier, DBTypes dbTypes) {
        if (identifier == null || identifier.isEmpty() || dbTypes == null) {
            return identifier;
        }
        if (dbTypes.getReservedWords().contains(identifier.toUpperCase()) || !Objects.requireNonNull(dbTypes.specialNamePattern()).matcher(identifier).find()) {
            return TableLocation.quoteIdentifier(identifier);
        }
        return identifier;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.catalog.isEmpty()) {
            sb.append(TableLocation.format(this.catalog, this.getDbTypes()));
            sb.append(".");
        }
        if (!this.schema.isEmpty()) {
            sb.append(TableLocation.format(this.schema, this.getDbTypes()));
            sb.append(".");
        }
        sb.append(TableLocation.format(this.table, this.getDbTypes()));
        return sb.toString();
    }

    public String toString(DBTypes dbTypes) {
        StringBuilder sb = new StringBuilder();
        if (!this.catalog.isEmpty()) {
            sb.append(TableLocation.format(this.catalog, dbTypes));
            sb.append(".");
        }
        if (!this.schema.isEmpty()) {
            sb.append(TableLocation.format(this.schema, dbTypes));
            sb.append(".");
        }
        sb.append(TableLocation.format(this.table, dbTypes));
        return sb.toString();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getCatalog(String defaultValue) {
        return this.catalog.isEmpty() ? defaultValue : this.catalog;
    }

    public static TableLocation parse(String concatenatedTableLocation) {
        return TableLocation.parse(concatenatedTableLocation, null);
    }

    public static String[] split(String tableName) {
        LinkedList<String> parts = new LinkedList<String>();
        String catalog = "";
        String schema = "";
        String table = "";
        StringTokenizer st = new StringTokenizer(tableName, ".`\"", true);
        boolean openQuote = false;
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("`") || token.equals(QUOTE_CHAR)) {
                sb.append(QUOTE_CHAR);
                openQuote = !openQuote;
                continue;
            }
            if (token.equals(".")) {
                if (openQuote) {
                    sb.append(token);
                    continue;
                }
                parts.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(token);
        }
        if (sb.length() != 0) {
            parts.add(sb.toString());
        }
        String[] values = parts.toArray(new String[0]);
        switch (values.length) {
            case 1: {
                table = values[0].trim();
                break;
            }
            case 2: {
                schema = values[0].trim();
                table = values[1].trim();
                break;
            }
            case 3: {
                catalog = values[0].trim();
                schema = values[1].trim();
                table = values[2].trim();
            }
        }
        return new String[]{catalog, schema, table};
    }

    public static TableLocation parse(String concatenatedTableLocation, DBTypes dbTypes) {
        LinkedList<String> parts = new LinkedList<String>();
        String schema = "";
        String table = "";
        String catalog = "";
        StringTokenizer st = new StringTokenizer(concatenatedTableLocation, ".`\"", true);
        boolean openQuote = false;
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("`") || token.equals(QUOTE_CHAR)) {
                sb.append(QUOTE_CHAR);
                openQuote = !openQuote;
                continue;
            }
            if (token.equals(".")) {
                if (openQuote) {
                    sb.append(token);
                    continue;
                }
                parts.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (!openQuote && dbTypes != null) {
                token = TableLocation.capsIdentifier(token, dbTypes);
            }
            sb.append(token);
        }
        if (sb.length() != 0) {
            parts.add(sb.toString());
        }
        String[] values = parts.toArray(new String[0]);
        switch (values.length) {
            case 1: {
                table = values[0].trim();
                break;
            }
            case 2: {
                schema = values[0].trim();
                table = values[1].trim();
                break;
            }
            case 3: {
                catalog = values[0].trim();
                schema = values[1].trim();
                table = values[2].trim();
            }
        }
        return new TableLocation(catalog, schema, table, dbTypes);
    }

    public static String capsIdentifier(String identifier, DBTypes dbTypes) {
        if (dbTypes != null) {
            if (dbTypes == DBTypes.H2 || dbTypes == DBTypes.H2GIS) {
                return identifier.toUpperCase();
            }
            return identifier.toLowerCase();
        }
        return identifier;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSchema(String defaultValue) {
        return this.schema.isEmpty() ? defaultValue : this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableLocation)) {
            return false;
        }
        TableLocation that = (TableLocation)o;
        return (this.catalog.equals(that.catalog) || this.catalog.isEmpty() || that.catalog.isEmpty()) && (this.schema.equals(that.schema) || this.schema.equals(this.defaultSchema) && that.schema.isEmpty() || that.schema.equals(this.defaultSchema) && this.schema.isEmpty()) && this.table.equals(that.table);
    }

    public int hashCode() {
        int result = this.catalog.hashCode();
        result = 31 * result + this.schema.hashCode();
        result = 31 * result + this.table.hashCode();
        return result;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public DBTypes getDbTypes() {
        return this.dbTypes;
    }
}

