/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.value.ValueGeometry;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;

public class GeometryMetaData {
    public boolean hasZ = false;
    public boolean hasM = false;
    public int dimension = 2;
    public String geometryType = "GEOMETRY";
    public String sfs_geometryType = "GEOMETRY";
    public int SRID = 0;
    public static final int EWKB_Z = Integer.MIN_VALUE;
    public static final int EWKB_M = 0x40000000;
    public static final int EWKB_SRID = 0x20000000;
    static final String[] TYPES = new String[]{"POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION"};
    public int geometryTypeCode = 0;
    public int sfs_geometryTypeCode = 0;

    public GeometryMetaData() {
    }

    private GeometryMetaData(ValueGeometry valueGeometry) {
        this.SRID = valueGeometry.getSRID();
        this.geometryTypeCode = valueGeometry.getTypeAndDimensionSystem();
        this.sfs_geometryTypeCode = this.geometryTypeCode % 1000;
        this.initDimension();
        this.initGeometryType();
    }

    public void initDimension() {
        switch (this.geometryTypeCode / 1000) {
            case 0: {
                this.dimension = 2;
                break;
            }
            case 1: {
                this.dimension = 3;
                this.hasZ = true;
                this.hasM = false;
                break;
            }
            case 2: {
                this.dimension = 3;
                this.hasM = true;
                this.hasZ = false;
                break;
            }
            case 3: {
                this.dimension = 4;
                this.hasZ = true;
                this.hasM = true;
                break;
            }
        }
    }

    public void initGeometryType() {
        if (this.sfs_geometryTypeCode != 0) {
            this.sfs_geometryType = this.geometryType = TYPES[this.sfs_geometryTypeCode - 1];
            if (this.hasM && this.hasZ) {
                this.geometryType = this.geometryType + "ZM";
                this.dimension = 4;
            } else if (this.hasZ) {
                this.geometryType = this.geometryType + "Z";
                this.dimension = 3;
            } else if (this.hasM) {
                this.geometryType = this.geometryType + "M";
                this.dimension = 3;
            }
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getGeometryType() {
        return this.geometryType;
    }

    public int getGeometryTypeCode() {
        return this.geometryTypeCode;
    }

    public int getSRID() {
        return this.SRID;
    }

    public boolean hasM() {
        return this.hasM;
    }

    public boolean hasZ() {
        return this.hasZ;
    }

    public void setSfs_geometryTypeCode(int sfs_geometryTypeCode) {
        this.sfs_geometryTypeCode = sfs_geometryTypeCode;
    }

    public String getSfs_geometryType() {
        return this.sfs_geometryType;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setGeometryTypeCode(int geometryTypeCode) {
        this.geometryTypeCode = geometryTypeCode;
        this.sfs_geometryTypeCode = geometryTypeCode % 1000;
    }

    public void setGeometryType(String geometryType) {
        this.geometryType = geometryType;
    }

    public void setSRID(int SRID) {
        this.SRID = SRID;
    }

    public void setSfs_geometryType(String sfs_geometryType) {
        this.sfs_geometryType = sfs_geometryType;
    }

    public void setHasM(boolean hasM) {
        this.hasM = hasM;
    }

    public void setHasZ(boolean hasZ) {
        this.hasZ = hasZ;
    }

    public String getSQL() {
        StringBuilder sb = new StringBuilder("GEOMETRY");
        if (this.geometryTypeCode != 0) {
            sb.append("(").append(this.geometryType);
            if (this.SRID != 0) {
                sb.append(",").append(this.SRID);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public static GeometryMetaData getMetaData(byte[] bytes) {
        try {
            ByteOrderDataInStream dis = new ByteOrderDataInStream();
            dis.setInStream((InStream)new ByteArrayInStream(bytes));
            byte byteOrderWKB = dis.readByte();
            int byteOrder = byteOrderWKB == 1 ? 2 : 1;
            dis.setOrder(byteOrder);
            int typeInt = dis.readInt();
            int geometryType = typeInt & 0xFF;
            boolean hasZ = (typeInt & Integer.MIN_VALUE) != 0;
            boolean hasM = (typeInt & 0x40000000) != 0;
            int srid = (typeInt & 0x20000000) != 0 ? dis.readInt() : 0;
            GeometryMetaData geomMet = new GeometryMetaData();
            geomMet.setHasM(hasM);
            geomMet.setHasZ(hasZ);
            geomMet.setSRID(srid);
            geomMet.setSfs_geometryTypeCode(geometryType);
            geomMet.initGeometryType();
            return geomMet;
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read the geometry metadata");
        }
    }

    public static GeometryMetaData getMetaData(Geometry geometry) {
        ValueGeometry valueGeometry = ValueGeometry.getFromGeometry((Object)geometry);
        return new GeometryMetaData(valueGeometry);
    }

    public static GeometryMetaData getMetaData(String geometry) {
        if (geometry != null && !geometry.isEmpty()) {
            if (geometry.toUpperCase().startsWith("GEOMETRY")) {
                Pattern CREATE_TABLE_PATTERN = Pattern.compile("(?:(?:GEOMETRY\\s*\\(\\s*([a-zA-Z]+\\s*(?:[ZM]+)?)\\s*(?:,\\s*([\\d]+))?\\))|^\\s*([a-zA-Z]+\\s*(?:[ZM]+)?))", 2);
                Matcher matcher = CREATE_TABLE_PATTERN.matcher(geometry);
                if (matcher.find()) {
                    String type = matcher.group(1);
                    if (type == null) {
                        return new GeometryMetaData();
                    }
                    String srid = matcher.group(2);
                    if (srid != null && !srid.isEmpty()) {
                        return GeometryMetaData.createMetadataFromGeometryType(type, Integer.valueOf(srid));
                    }
                    return GeometryMetaData.createMetadataFromGeometryType(type);
                }
            } else {
                ValueGeometry valueGeometry = ValueGeometry.get((String)geometry);
                return new GeometryMetaData(valueGeometry);
            }
        }
        return null;
    }

    public static GeometryMetaData createMetadataFromGeometryType(String type) {
        return GeometryMetaData.createMetadataFromGeometryType(type, 0);
    }

    public static GeometryMetaData createMetadataFromGeometryType(String type, int srid) {
        GeometryMetaData geometryMetaData = new GeometryMetaData();
        geometryMetaData.setSRID(srid);
        if (type == null) {
            return geometryMetaData;
        }
        int dimension_ = 2;
        int geometry_code = 0;
        String sfs_geometry_type = "GEOMETRY";
        String geometry_type = "GEOMETRY";
        boolean hasz_ = false;
        boolean hasm_ = false;
        switch (type = type.replaceAll(" ", "").replaceAll("\"", "")) {
            case "POINT": {
                dimension_ = 2;
                geometry_code = 1;
                sfs_geometry_type = "POINT";
                geometry_type = "POINT";
                hasz_ = false;
                hasm_ = false;
                break;
            }
            case "LINESTRING": {
                dimension_ = 2;
                geometry_code = 2;
                sfs_geometry_type = "LINESTRING";
                geometry_type = "LINESTRING";
                hasz_ = false;
                hasm_ = false;
                break;
            }
            case "POLYGON": {
                dimension_ = 2;
                geometry_code = 3;
                sfs_geometry_type = "POLYGON";
                geometry_type = "POLYGON";
                hasz_ = false;
                hasm_ = false;
                break;
            }
            case "MULTIPOINT": {
                dimension_ = 2;
                geometry_code = 4;
                sfs_geometry_type = "MULTIPOINT";
                geometry_type = "MULTIPOINT";
                hasz_ = false;
                hasm_ = false;
                break;
            }
            case "MULTILINESTRING": {
                dimension_ = 2;
                geometry_code = 5;
                sfs_geometry_type = "MULTILINESTRING";
                geometry_type = "MULTILINESTRING";
                hasz_ = false;
                hasm_ = false;
                break;
            }
            case "MULTIPOLYGON": {
                dimension_ = 2;
                geometry_code = 6;
                sfs_geometry_type = "MULTIPOLYGON";
                geometry_type = "MULTIPOLYGON";
                hasz_ = false;
                hasm_ = false;
                break;
            }
            case "GEOMETRYCOLLECTION": {
                dimension_ = 2;
                geometry_code = 7;
                sfs_geometry_type = "GEOMCOLLECTION";
                geometry_type = "GEOMCOLLECTION";
                hasz_ = false;
                hasm_ = false;
                break;
            }
            case "POINTZ": {
                dimension_ = 3;
                geometry_code = 1001;
                sfs_geometry_type = "POINTZ";
                geometry_type = "POINTZ";
                hasz_ = true;
                hasm_ = false;
                break;
            }
            case "LINESTRINGZ": {
                dimension_ = 3;
                geometry_code = 1002;
                sfs_geometry_type = "LINESTRINGZ";
                geometry_type = "LINESTRINGZ";
                hasz_ = true;
                hasm_ = false;
                break;
            }
            case "POLYGONZ": {
                dimension_ = 3;
                geometry_code = 1003;
                sfs_geometry_type = "POLYGONZ";
                geometry_type = "POLYGONZ";
                hasz_ = true;
                hasm_ = false;
                break;
            }
            case "MULTIPOINTZ": {
                dimension_ = 3;
                geometry_code = 1004;
                sfs_geometry_type = "MULTIPOINTZ";
                geometry_type = "MULTIPOINTZ";
                hasz_ = true;
                hasm_ = false;
                break;
            }
            case "MULTILINESTRINGZ": {
                dimension_ = 3;
                geometry_code = 1005;
                sfs_geometry_type = "MULTILINESTRINGZ";
                geometry_type = "MULTILINESTRINGZ";
                hasz_ = true;
                hasm_ = false;
                break;
            }
            case "MULTIPOLYGONZ": {
                dimension_ = 3;
                geometry_code = 1006;
                sfs_geometry_type = "MULTIPOLYGONZ";
                geometry_type = "MULTIPOLYGONZ";
                hasz_ = true;
                hasm_ = false;
                break;
            }
            case "GEOMETRYCOLLECTIONZ": {
                dimension_ = 3;
                geometry_code = 1007;
                sfs_geometry_type = "GEOMETRYCOLLECTIONZ";
                geometry_type = "GEOMETRYCOLLECTIONZ";
                hasz_ = true;
                hasm_ = false;
                break;
            }
            case "POINTM": {
                dimension_ = 3;
                geometry_code = 2001;
                sfs_geometry_type = "POINTM";
                geometry_type = "POINTM";
                hasz_ = false;
                hasm_ = true;
                break;
            }
            case "LINESTRINGM": {
                dimension_ = 3;
                geometry_code = 2002;
                sfs_geometry_type = "LINESTRINGM";
                geometry_type = "LINESTRINGM";
                hasm_ = true;
                break;
            }
            case "POLYGONM": {
                dimension_ = 3;
                geometry_code = 2003;
                sfs_geometry_type = "POLYGONM";
                geometry_type = "POLYGONM";
                hasz_ = false;
                hasm_ = true;
                break;
            }
            case "MULTIPOINTM": {
                dimension_ = 3;
                geometry_code = 2004;
                sfs_geometry_type = "MULTIPOINTM";
                geometry_type = "MULTIPOINTM";
                hasz_ = false;
                hasm_ = true;
                break;
            }
            case "MULTILINESTRINGM": {
                dimension_ = 3;
                geometry_code = 2005;
                sfs_geometry_type = "MULTILINESTRINGM";
                geometry_type = "MULTILINESTRINGM";
                hasz_ = false;
                hasm_ = true;
                break;
            }
            case "MULTIPOLYGONM": {
                dimension_ = 3;
                geometry_code = 2006;
                sfs_geometry_type = "MULTIPOLYGONM";
                geometry_type = "MULTIPOLYGONM";
                hasz_ = false;
                hasm_ = true;
                break;
            }
            case "GEOMETRYCOLLECTIONM": {
                dimension_ = 3;
                geometry_code = 2007;
                sfs_geometry_type = "GEOMETRYCOLLECTIONM";
                geometry_type = "GEOMETRYCOLLECTIONM";
                hasz_ = false;
                hasm_ = true;
                break;
            }
            case "POINTZM": {
                dimension_ = 4;
                geometry_code = 3001;
                sfs_geometry_type = "POINTZM";
                geometry_type = "POINTZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "LINESTRINGZM": {
                dimension_ = 4;
                geometry_code = 3002;
                sfs_geometry_type = "LINESTRINGZM";
                geometry_type = "LINESTRINGZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "POLYGONZM": {
                dimension_ = 4;
                geometry_code = 3003;
                sfs_geometry_type = "POLYGONZM";
                geometry_type = "POLYGONZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "MULTIPOINTZM": {
                dimension_ = 4;
                geometry_code = 3004;
                sfs_geometry_type = "MULTIPOINTZM";
                geometry_type = "MULTIPOINTZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "MULTILINESTRINGZM": {
                dimension_ = 4;
                geometry_code = 3005;
                sfs_geometry_type = "MULTILINESTRINGZM";
                geometry_type = "MULTILINESTRINGZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "MULTIPOLYGONZM": {
                dimension_ = 4;
                geometry_code = 3006;
                sfs_geometry_type = "MULTIPOLYGONZM";
                geometry_type = "MULTIPOLYGONZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
            case "GEOMETRYCOLLECTIONZM": {
                dimension_ = 4;
                geometry_code = 3007;
                sfs_geometry_type = "GEOMETRYCOLLECTIONZM";
                geometry_type = "GEOMETRYCOLLECTIONZM";
                hasz_ = true;
                hasm_ = true;
                break;
            }
        }
        geometryMetaData.setDimension(dimension_);
        geometryMetaData.setGeometryTypeCode(geometry_code);
        geometryMetaData.setSfs_geometryType(sfs_geometry_type);
        geometryMetaData.setGeometryType(geometry_type);
        geometryMetaData.setHasM(hasm_);
        geometryMetaData.setHasZ(hasz_);
        return geometryMetaData;
    }

    public int getSfs_geometryTypeCode() {
        return this.sfs_geometryTypeCode;
    }
}

