/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.io.IOException;
import java.util.Properties;

public class Version {
    private static final String RESOURCE_FILENAME = "org/postgis/version.properties";
    private static final String VERSION_PROPERTY_NAME = "VERSION";
    public static final String VERSION;
    public static final int MAJOR;
    public static final int MINOR;
    public static final String MICRO;
    public static final String FULL;

    public static String getFullVersion() {
        return FULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int major = -1;
        int minor = -1;
        String micro = null;
        String version = null;
        try {
            ClassLoader loader = Version.class.getClassLoader();
            Properties prop = new Properties();
            try {
                prop.load(loader.getResourceAsStream(RESOURCE_FILENAME));
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version. Cause: Ressource org/postgis/version.properties cannot be read. " + e.getMessage());
            }
            catch (NullPointerException e) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version. Cause: Ressource org/postgis/version.properties not found. " + e.getMessage());
            }
            version = prop.getProperty(VERSION_PROPERTY_NAME);
            if (version == null) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version:  Missing VERSION property.");
            }
            if (version.equals("")) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version:  Empty VERSION property.");
            }
            String[] versions = version.split("\\.");
            if (version.length() < 3) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version:  FULL_VERSION (" + version + ") does not contain 3 components ");
            }
            if (versions.length >= 1) {
                try {
                    major = Integer.parseInt(versions[0]);
                }
                catch (NumberFormatException nfe) {
                    throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version! Error parsing major version ");
                }
            }
            if (versions.length >= 2) {
                try {
                    minor = Integer.parseInt(versions[1]);
                }
                catch (NumberFormatException nfe) {
                    throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version! Error parsing minor version ");
                }
            }
            if (version.length() >= 3) {
                micro = versions[2];
            }
        }
        finally {
            MAJOR = major;
            MINOR = minor;
            MICRO = micro;
            VERSION = version;
        }
        FULL = "PostGIS JDBC V" + MAJOR + "." + MINOR + "." + MICRO;
    }
}

