/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import org.h2.engine.CastDataProvider;
import org.h2.engine.Mode;
import org.h2.mvstore.db.RowDataType;
import org.h2.result.DefaultRow;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRowValue;
import org.h2.result.Sparse;
import org.h2.store.DataHandler;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public abstract class RowFactory {
    public static DefaultRowFactory getDefaultRowFactory() {
        return DefaultRowFactory.INSTANCE;
    }

    public static RowFactory getRowFactory() {
        return Holder.EFFECTIVE;
    }

    public RowFactory createRowFactory(CastDataProvider castDataProvider, CompareMode compareMode, Mode mode, DataHandler dataHandler, Column[] columnArray, IndexColumn[] indexColumnArray) {
        return this;
    }

    public abstract Row createRow(Value[] var1, int var2);

    public abstract SearchRow createRow();

    public abstract RowDataType getRowDataType();

    public abstract int[] getIndexes();

    public abstract int getColumnCount();

    public static final class DefaultRowFactory
    extends RowFactory {
        private final RowDataType dataType;
        private final int columnCount;
        private final int[] indexes;
        private final int[] map;
        public static final DefaultRowFactory INSTANCE = new DefaultRowFactory();

        DefaultRowFactory() {
            this(new RowDataType(null, CompareMode.getInstance(null, 0), Mode.getRegular(), null, null, null, 0), 0, null);
        }

        private DefaultRowFactory(RowDataType rowDataType, int n, int[] nArray) {
            this.dataType = rowDataType;
            this.columnCount = n;
            this.indexes = nArray;
            int[] nArray2 = this.map = nArray == null ? null : new int[n];
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.map[nArray[i]] = i + 1;
                }
            }
        }

        @Override
        public RowFactory createRowFactory(CastDataProvider castDataProvider, CompareMode compareMode, Mode mode, DataHandler dataHandler, Column[] columnArray, IndexColumn[] indexColumnArray) {
            int n;
            int[] nArray;
            int[] nArray2;
            block4: {
                nArray2 = null;
                nArray = null;
                n = 0;
                if (columnArray == null) break block4;
                n = columnArray.length;
                if (indexColumnArray == null) {
                    nArray = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = 0;
                    }
                } else {
                    int n2 = indexColumnArray.length;
                    nArray2 = new int[n2];
                    nArray = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        IndexColumn indexColumn = indexColumnArray[i];
                        nArray2[i] = indexColumn.column.getColumnId();
                        nArray[i] = indexColumn.sortType;
                    }
                }
            }
            return this.createRowFactory(castDataProvider, compareMode, mode, dataHandler, nArray, nArray2, n);
        }

        public RowFactory createRowFactory(CastDataProvider castDataProvider, CompareMode compareMode, Mode mode, DataHandler dataHandler, int[] nArray, int[] nArray2, int n) {
            RowDataType rowDataType = new RowDataType(castDataProvider, compareMode, mode, dataHandler, nArray, nArray2, n);
            DefaultRowFactory defaultRowFactory = new DefaultRowFactory(rowDataType, n, nArray2);
            rowDataType.setRowFactory(defaultRowFactory);
            return defaultRowFactory;
        }

        @Override
        public Row createRow(Value[] valueArray, int n) {
            return new DefaultRow(valueArray, n);
        }

        @Override
        public SearchRow createRow() {
            if (this.indexes == null) {
                return new DefaultRow(this.columnCount);
            }
            if (this.indexes.length == 1) {
                return new SimpleRowValue(this.columnCount, this.indexes[0]);
            }
            return new Sparse(this.columnCount, this.indexes.length, this.map);
        }

        @Override
        public RowDataType getRowDataType() {
            return this.dataType;
        }

        @Override
        public int[] getIndexes() {
            return this.indexes;
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }
    }

    private static final class Holder {
        static final RowFactory EFFECTIVE = DefaultRowFactory.INSTANCE;

        private Holder() {
        }
    }
}

