/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FreeSpaceBitSet;
import org.h2.mvstore.cache.FilePathCache;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.encrypt.FileEncrypt;
import org.h2.store.fs.encrypt.FilePathEncrypt;

public class FileStore {
    protected final AtomicLong readCount = new AtomicLong();
    protected final AtomicLong readBytes = new AtomicLong();
    protected final AtomicLong writeCount = new AtomicLong();
    protected final AtomicLong writeBytes = new AtomicLong();
    protected final FreeSpaceBitSet freeSpace = new FreeSpaceBitSet(2, 4096);
    private String fileName;
    private boolean readOnly;
    protected long fileSize;
    private FileChannel file;
    private FileChannel encryptedFile;
    private FileLock fileLock;

    public String toString() {
        return this.fileName;
    }

    public ByteBuffer readFully(long l, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        DataUtils.readFully(this.file, l, byteBuffer);
        this.readCount.incrementAndGet();
        this.readBytes.addAndGet(n);
        return byteBuffer;
    }

    public void writeFully(long l, ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        this.fileSize = Math.max(this.fileSize, l + (long)n);
        DataUtils.writeFully(this.file, l, byteBuffer);
        this.writeCount.incrementAndGet();
        this.writeBytes.addAndGet(n);
    }

    public void open(String string, boolean bl, char[] cArray) {
        if (this.file != null) {
            return;
        }
        FilePathCache.INSTANCE.getScheme();
        this.fileName = string;
        FilePath filePath = FilePath.get(string);
        FilePath filePath2 = filePath.getParent();
        if (filePath2 != null && !filePath2.exists()) {
            throw DataUtils.newIllegalArgumentException("Directory does not exist: {0}", filePath2);
        }
        if (filePath.exists() && !filePath.canWrite()) {
            bl = true;
        }
        this.readOnly = bl;
        try {
            this.file = filePath.open(bl ? "r" : "rw");
            if (cArray != null) {
                byte[] byArray = FilePathEncrypt.getPasswordBytes(cArray);
                this.encryptedFile = this.file;
                this.file = new FileEncrypt(string, byArray, this.file);
            }
            try {
                this.fileLock = bl ? this.file.tryLock(0L, Long.MAX_VALUE, true) : this.file.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                throw DataUtils.newIllegalStateException(7, "The file is locked: {0}", string, overlappingFileLockException);
            }
            if (this.fileLock == null) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw DataUtils.newIllegalStateException(7, "The file is locked: {0}", string);
            }
            this.fileSize = this.file.size();
        }
        catch (IOException iOException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw DataUtils.newIllegalStateException(1, "Could not open file {0}", string, iOException);
        }
    }

    public void close() {
        try {
            if (this.file != null && this.file.isOpen()) {
                if (this.fileLock != null) {
                    this.fileLock.release();
                }
                this.file.close();
            }
        }
        catch (Exception exception) {
            throw DataUtils.newIllegalStateException(2, "Closing failed for file {0}", this.fileName, exception);
        }
        finally {
            this.fileLock = null;
            this.file = null;
        }
    }

    public void sync() {
        if (this.file != null) {
            try {
                this.file.force(true);
            }
            catch (IOException iOException) {
                throw DataUtils.newIllegalStateException(2, "Could not sync file {0}", this.fileName, iOException);
            }
        }
    }

    public long size() {
        return this.fileSize;
    }

    public void truncate(long l) {
        int n = 0;
        while (true) {
            try {
                this.writeCount.incrementAndGet();
                this.file.truncate(l);
                this.fileSize = Math.min(this.fileSize, l);
                return;
            }
            catch (IOException iOException) {
                if (++n == 10) {
                    throw DataUtils.newIllegalStateException(2, "Could not truncate file {0} to size {1}", this.fileName, l, iOException);
                }
                System.gc();
                Thread.yield();
                continue;
            }
            break;
        }
    }

    public FileChannel getFile() {
        return this.file;
    }

    public FileChannel getEncryptedFile() {
        return this.encryptedFile;
    }

    public long getWriteCount() {
        return this.writeCount.get();
    }

    public long getWriteBytes() {
        return this.writeBytes.get();
    }

    public long getReadCount() {
        return this.readCount.get();
    }

    public long getReadBytes() {
        return this.readBytes.get();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getDefaultRetentionTime() {
        return 45000;
    }

    public void markUsed(long l, int n) {
        this.freeSpace.markUsed(l, n);
    }

    long allocate(int n, long l, long l2) {
        return this.freeSpace.allocate(n, l, l2);
    }

    long predictAllocation(int n, long l, long l2) {
        return this.freeSpace.predictAllocation(n, l, l2);
    }

    boolean isFragmented() {
        return this.freeSpace.isFragmented();
    }

    public void free(long l, int n) {
        this.freeSpace.free(l, n);
    }

    public int getFillRate() {
        return this.freeSpace.getFillRate();
    }

    public int getProjectedFillRate(int n) {
        return this.freeSpace.getProjectedFillRate(n);
    }

    long getFirstFree() {
        return this.freeSpace.getFirstFree();
    }

    long getFileLengthInUse() {
        return this.freeSpace.getLastFree();
    }

    int getMovePriority(int n) {
        return this.freeSpace.getMovePriority(n);
    }

    long getAfterLastBlock() {
        return this.freeSpace.getAfterLastBlock();
    }

    public void clear() {
        this.freeSpace.clear();
    }

    public String getFileName() {
        return this.fileName;
    }
}

