/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.aggregate.Aggregate;
import org.h2.expression.aggregate.AggregateType;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.ConditionIn;
import org.h2.expression.condition.NullPredicate;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.HasSQL;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class Comparison
extends Condition {
    public static final int NULL_SAFE = 16;
    public static final int EQUAL = 0;
    public static final int EQUAL_NULL_SAFE = 16;
    public static final int BIGGER_EQUAL = 1;
    public static final int BIGGER = 2;
    public static final int SMALLER_EQUAL = 3;
    public static final int SMALLER = 4;
    public static final int NOT_EQUAL = 5;
    public static final int NOT_EQUAL_NULL_SAFE = 21;
    public static final int FALSE = 6;
    public static final int IN_LIST = 7;
    public static final int IN_QUERY = 8;
    public static final int SPATIAL_INTERSECTS = 9;
    private int compareType;
    private Expression left;
    private Expression right;

    public Comparison(int n, Expression expression, Expression expression2) {
        this.left = expression;
        this.right = expression2;
        this.compareType = n;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        boolean bl = false;
        stringBuilder.append('(');
        switch (this.compareType) {
            case 9: {
                stringBuilder.append("INTERSECTS(");
                this.left.getSQL(stringBuilder, n).append(", ");
                this.right.getSQL(stringBuilder, n).append(')');
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.right instanceof Aggregate && ((Aggregate)this.right).getAggregateType() == AggregateType.ANY) {
                    bl = true;
                }
            }
            default: {
                this.left.getSQL(stringBuilder, n).append(' ').append(Comparison.getCompareOperator(this.compareType)).append(' ');
                if (bl) {
                    stringBuilder.append('(');
                }
                this.right.getSQL(stringBuilder, n);
                if (!bl) break;
                stringBuilder.append(')');
            }
        }
        return stringBuilder.append(')');
    }

    static String getCompareOperator(int n) {
        switch (n) {
            case 0: {
                return "=";
            }
            case 16: {
                return "IS NOT DISTINCT FROM";
            }
            case 1: {
                return ">=";
            }
            case 2: {
                return ">";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "<";
            }
            case 5: {
                return "<>";
            }
            case 21: {
                return "IS DISTINCT FROM";
            }
            case 9: {
                return "&&";
            }
        }
        throw DbException.throwInternalError("compareType=" + n);
    }

    @Override
    public Expression optimize(Session session) {
        HasSQL hasSQL;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.right.getType().getValueType() == 17 && this.left.getType().getValueType() != 17) {
            throw DbException.get(90110);
        }
        if (this.right instanceof ExpressionColumn && (this.left.isConstant() || this.left instanceof Parameter)) {
            hasSQL = this.left;
            this.left = this.right;
            this.right = hasSQL;
            this.compareType = this.getReversedCompareType(this.compareType);
        }
        if (this.left instanceof ExpressionColumn) {
            if (this.right.isConstant()) {
                TypeInfo typeInfo;
                hasSQL = this.right.getValue(session);
                if (hasSQL == ValueNull.INSTANCE && (this.compareType & 0x10) == 0) {
                    return TypedValueExpression.UNKNOWN;
                }
                TypeInfo typeInfo2 = this.left.getType();
                TypeInfo typeInfo3 = ((Value)hasSQL).getType();
                int n = typeInfo3.getValueType();
                if (n != typeInfo2.getValueType() && n != (typeInfo = Value.getHigherType(typeInfo2, typeInfo3)).getValueType()) {
                    Column column = ((ExpressionColumn)this.left).getColumn();
                    this.right = ValueExpression.get(((Value)hasSQL).convertTo(typeInfo, session, column));
                }
            } else if (this.right instanceof Parameter) {
                ((Parameter)this.right).setColumn(((ExpressionColumn)this.left).getColumn());
            }
        }
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.getBoolean(this.getValue(session));
        }
        if (this.left.isNullConstant() || this.right.isNullConstant()) {
            int n;
            if ((this.compareType & 0x10) == 0) {
                return TypedValueExpression.UNKNOWN;
            }
            if ((this.compareType == 16 || this.compareType == 21) && (n = ((Expression)(hasSQL = this.left.isNullConstant() ? this.right : this.left)).getType().getValueType()) != -1 && n != 39) {
                return new NullPredicate((Expression)hasSQL, this.compareType == 21);
            }
        }
        return this;
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE && (this.compareType & 0x10) == 0) {
            return ValueNull.INSTANCE;
        }
        return Comparison.compare(session, value, this.right.getValue(session), this.compareType);
    }

    static Value compare(Session session, Value value, Value value2, int n) {
        Value value3;
        switch (n) {
            case 0: {
                int n2 = session.compareWithNull(value, value2, true);
                if (n2 == 0) {
                    value3 = ValueBoolean.TRUE;
                    break;
                }
                if (n2 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.FALSE;
                break;
            }
            case 16: {
                value3 = ValueBoolean.get(session.areEqual(value, value2));
                break;
            }
            case 5: {
                int n3 = session.compareWithNull(value, value2, true);
                if (n3 == 0) {
                    value3 = ValueBoolean.FALSE;
                    break;
                }
                if (n3 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.TRUE;
                break;
            }
            case 21: {
                value3 = ValueBoolean.get(!session.areEqual(value, value2));
                break;
            }
            case 1: {
                int n4 = session.compareWithNull(value, value2, false);
                if (n4 >= 0) {
                    value3 = ValueBoolean.TRUE;
                    break;
                }
                if (n4 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.FALSE;
                break;
            }
            case 2: {
                int n5 = session.compareWithNull(value, value2, false);
                if (n5 > 0) {
                    value3 = ValueBoolean.TRUE;
                    break;
                }
                if (n5 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.FALSE;
                break;
            }
            case 3: {
                int n6 = session.compareWithNull(value, value2, false);
                if (n6 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.get(n6 <= 0);
                break;
            }
            case 4: {
                int n7 = session.compareWithNull(value, value2, false);
                if (n7 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.get(n7 < 0);
                break;
            }
            case 9: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.get(value.convertToGeometry(null).intersectsBoundingBox(value2.convertToGeometry(null)));
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n);
            }
        }
        return value3;
    }

    private int getReversedCompareType(int n) {
        switch (this.compareType) {
            case 0: 
            case 5: 
            case 9: 
            case 16: 
            case 21: {
                return n;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw DbException.throwInternalError("type=" + this.compareType);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        if (this.compareType == 9) {
            return null;
        }
        int n = this.getNotCompareType();
        return new Comparison(n, this.left, this.right);
    }

    private int getNotCompareType() {
        switch (this.compareType) {
            case 0: {
                return 5;
            }
            case 16: {
                return 21;
            }
            case 5: {
                return 0;
            }
            case 21: {
                return 16;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
        }
        throw DbException.throwInternalError("type=" + this.compareType);
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        boolean bl;
        ExpressionVisitor expressionVisitor;
        if (!tableFilter.getTable().isQueryComparable()) {
            return;
        }
        ExpressionColumn expressionColumn = null;
        if (this.left instanceof ExpressionColumn && tableFilter != (expressionColumn = (ExpressionColumn)this.left).getTableFilter()) {
            expressionColumn = null;
        }
        ExpressionColumn expressionColumn2 = null;
        if (this.right instanceof ExpressionColumn && tableFilter != (expressionColumn2 = (ExpressionColumn)this.right).getTableFilter()) {
            expressionColumn2 = null;
        }
        if (expressionColumn == null && expressionColumn2 == null) {
            return;
        }
        if (expressionColumn != null && expressionColumn2 != null) {
            return;
        }
        if (expressionColumn == null) {
            expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
            if (!this.left.isEverything(expressionVisitor)) {
                return;
            }
        } else if (expressionColumn2 == null) {
            expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
            if (!this.right.isEverything(expressionVisitor)) {
                return;
            }
        } else {
            return;
        }
        switch (this.compareType) {
            case 5: 
            case 21: {
                bl = false;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 16: {
                bl = true;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.compareType);
            }
        }
        if (bl) {
            if (expressionColumn != null) {
                int n = this.right.getType().getValueType();
                if (expressionColumn.getType().getValueType() == n || n != 14) {
                    tableFilter.addIndexCondition(IndexCondition.get(this.compareType, expressionColumn, this.right));
                }
            } else if (expressionColumn2 != null) {
                int n = this.left.getType().getValueType();
                if (expressionColumn2.getType().getValueType() == n || n != 14) {
                    int n2 = this.getReversedCompareType(this.compareType);
                    tableFilter.addIndexCondition(IndexCondition.get(n2, expressionColumn2, this.left));
                }
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        if (this.right != null) {
            this.right.updateAggregate(session, n);
        }
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        this.right.mapColumns(columnResolver, n, n2);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 1;
    }

    Expression getIfEquals(Expression expression) {
        if (this.compareType == 0) {
            String string = expression.getSQL(0);
            if (this.left.getSQL(0).equals(string)) {
                return this.right;
            }
            if (this.right.getSQL(0).equals(string)) {
                return this.left;
            }
        }
        return null;
    }

    Expression getAdditionalAnd(Session session, Comparison comparison) {
        if (this.compareType == 0 && comparison.compareType == 0) {
            boolean bl = this.left.isConstant();
            boolean bl2 = this.right.isConstant();
            boolean bl3 = comparison.left.isConstant();
            boolean bl4 = comparison.right.isConstant();
            String string = this.left.getSQL(0);
            String string2 = comparison.left.getSQL(0);
            String string3 = this.right.getSQL(0);
            String string4 = comparison.right.getSQL(0);
            if (!(bl2 && bl4 || !string.equals(string2))) {
                return new Comparison(0, this.right, comparison.right);
            }
            if (!(bl2 && bl3 || !string.equals(string4))) {
                return new Comparison(0, this.right, comparison.left);
            }
            if (!(bl && bl4 || !string3.equals(string2))) {
                return new Comparison(0, this.left, comparison.right);
            }
            if (!(bl && bl3 || !string3.equals(string4))) {
                return new Comparison(0, this.left, comparison.left);
            }
        }
        return null;
    }

    Expression optimizeOr(Session session, Comparison comparison) {
        if (this.compareType == 0 && comparison.compareType == 0) {
            boolean bl = this.left.isConstant();
            boolean bl2 = this.right.isConstant();
            boolean bl3 = comparison.left.isConstant();
            boolean bl4 = comparison.right.isConstant();
            String string = this.left.getSQL(0);
            String string2 = comparison.left.getSQL(0);
            String string3 = this.right.getSQL(0);
            String string4 = comparison.right.getSQL(0);
            if (bl2 && bl4 && string.equals(string2)) {
                return Comparison.getConditionIn(session, this.left, this.right, comparison.right);
            }
            if (bl2 && bl3 && string.equals(string4)) {
                return Comparison.getConditionIn(session, this.left, this.right, comparison.left);
            }
            if (bl && bl4 && string3.equals(string2)) {
                return Comparison.getConditionIn(session, this.right, this.left, comparison.right);
            }
            if (bl && bl3 && string3.equals(string4)) {
                return Comparison.getConditionIn(session, this.right, this.left, comparison.left);
            }
        }
        return null;
    }

    private static ConditionIn getConditionIn(Session session, Expression expression, Expression expression2, Expression expression3) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(2);
        arrayList.add(expression2);
        arrayList.add(expression3);
        return new ConditionIn(expression, arrayList);
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

