/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;

public class AlterTableDropConstraint
extends SchemaCommand {
    private String constraintName;
    private final boolean ifExists;
    private ConstraintActionType dropAction;

    public AlterTableDropConstraint(Session session, Schema schema, boolean bl) {
        super(session, schema);
        this.ifExists = bl;
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public void setDropAction(ConstraintActionType constraintActionType) {
        this.dropAction = constraintActionType;
    }

    @Override
    public int update() {
        Constraint.Type type;
        this.session.commit(true);
        Constraint constraint = this.getSchema().findConstraint(this.session, this.constraintName);
        if (constraint == null || (type = constraint.getConstraintType()) == Constraint.Type.DOMAIN) {
            if (!this.ifExists) {
                throw DbException.get(90057, this.constraintName);
            }
        } else {
            this.session.getUser().checkRight(constraint.getTable(), 15);
            this.session.getUser().checkRight(constraint.getRefTable(), 15);
            if (type == Constraint.Type.PRIMARY_KEY || type == Constraint.Type.UNIQUE) {
                for (Constraint constraint2 : constraint.getTable().getConstraints()) {
                    if (constraint2.getReferencedConstraint() != constraint) continue;
                    if (this.dropAction == ConstraintActionType.RESTRICT) {
                        throw DbException.get(90152, constraint.getTraceSQL(), constraint2.getTraceSQL());
                    }
                    this.session.getUser().checkRight(constraint2.getTable(), 15);
                }
            }
            this.session.getDatabase().removeSchemaObject(this.session, constraint);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 14;
    }
}

