/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.h2.api.IntervalQualifier;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.CommandList;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterDomainAddConstraint;
import org.h2.command.ddl.AlterDomainDropConstraint;
import org.h2.command.ddl.AlterIndexRename;
import org.h2.command.ddl.AlterSchemaRename;
import org.h2.command.ddl.AlterSequence;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.AlterTableAlterColumn;
import org.h2.command.ddl.AlterTableDropConstraint;
import org.h2.command.ddl.AlterTableRename;
import org.h2.command.ddl.AlterTableRenameColumn;
import org.h2.command.ddl.AlterTableRenameConstraint;
import org.h2.command.ddl.AlterUser;
import org.h2.command.ddl.AlterView;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CommandWithColumns;
import org.h2.command.ddl.CreateAggregate;
import org.h2.command.ddl.CreateConstant;
import org.h2.command.ddl.CreateDomain;
import org.h2.command.ddl.CreateFunctionAlias;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateLinkedTable;
import org.h2.command.ddl.CreateRole;
import org.h2.command.ddl.CreateSchema;
import org.h2.command.ddl.CreateSequence;
import org.h2.command.ddl.CreateSynonym;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.CreateTrigger;
import org.h2.command.ddl.CreateUser;
import org.h2.command.ddl.CreateView;
import org.h2.command.ddl.DeallocateProcedure;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.DropAggregate;
import org.h2.command.ddl.DropConstant;
import org.h2.command.ddl.DropDatabase;
import org.h2.command.ddl.DropDomain;
import org.h2.command.ddl.DropFunctionAlias;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropRole;
import org.h2.command.ddl.DropSchema;
import org.h2.command.ddl.DropSequence;
import org.h2.command.ddl.DropSynonym;
import org.h2.command.ddl.DropTable;
import org.h2.command.ddl.DropTrigger;
import org.h2.command.ddl.DropUser;
import org.h2.command.ddl.DropView;
import org.h2.command.ddl.GrantRevoke;
import org.h2.command.ddl.PrepareProcedure;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.ddl.SequenceOptions;
import org.h2.command.ddl.SetComment;
import org.h2.command.ddl.TruncateTable;
import org.h2.command.dml.AlterTableSet;
import org.h2.command.dml.BackupCommand;
import org.h2.command.dml.Call;
import org.h2.command.dml.CommandWithValues;
import org.h2.command.dml.DataChangeStatement;
import org.h2.command.dml.Delete;
import org.h2.command.dml.ExecuteImmediate;
import org.h2.command.dml.ExecuteProcedure;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.MergeUsing;
import org.h2.command.dml.NoOperation;
import org.h2.command.dml.Query;
import org.h2.command.dml.RunScriptCommand;
import org.h2.command.dml.ScriptCommand;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.command.dml.SelectUnion;
import org.h2.command.dml.Set;
import org.h2.command.dml.SetSessionCharacteristics;
import org.h2.command.dml.SetTypes;
import org.h2.command.dml.TableValueConstructor;
import org.h2.command.dml.TransactionCommand;
import org.h2.command.dml.Update;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.Database;
import org.h2.engine.DbSettings;
import org.h2.engine.FunctionAlias;
import org.h2.engine.IsolationLevel;
import org.h2.engine.Mode;
import org.h2.engine.Procedure;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.expression.Alias;
import org.h2.expression.BinaryOperation;
import org.h2.expression.ConcatenationOperation;
import org.h2.expression.DomainValueExpression;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionWithFlags;
import org.h2.expression.Format;
import org.h2.expression.Parameter;
import org.h2.expression.Rownum;
import org.h2.expression.SequenceValue;
import org.h2.expression.Subquery;
import org.h2.expression.TimeZoneOperation;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.UnaryOperation;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.expression.Wildcard;
import org.h2.expression.aggregate.AbstractAggregate;
import org.h2.expression.aggregate.Aggregate;
import org.h2.expression.aggregate.AggregateType;
import org.h2.expression.aggregate.JavaAggregate;
import org.h2.expression.analysis.DataAnalysisOperation;
import org.h2.expression.analysis.Window;
import org.h2.expression.analysis.WindowFrame;
import org.h2.expression.analysis.WindowFrameBound;
import org.h2.expression.analysis.WindowFrameBoundType;
import org.h2.expression.analysis.WindowFrameExclusion;
import org.h2.expression.analysis.WindowFrameUnits;
import org.h2.expression.analysis.WindowFunction;
import org.h2.expression.analysis.WindowFunctionType;
import org.h2.expression.condition.BooleanTest;
import org.h2.expression.condition.CompareLike;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.expression.condition.ConditionIn;
import org.h2.expression.condition.ConditionInParameter;
import org.h2.expression.condition.ConditionInQuery;
import org.h2.expression.condition.ConditionLocalAndGlobal;
import org.h2.expression.condition.ConditionNot;
import org.h2.expression.condition.ExistsPredicate;
import org.h2.expression.condition.IsJsonPredicate;
import org.h2.expression.condition.NullPredicate;
import org.h2.expression.condition.TypePredicate;
import org.h2.expression.condition.UniquePredicate;
import org.h2.expression.function.Function;
import org.h2.expression.function.FunctionCall;
import org.h2.expression.function.JavaFunction;
import org.h2.expression.function.TableFunction;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.DualTable;
import org.h2.table.FunctionTable;
import org.h2.table.IndexColumn;
import org.h2.table.IndexHints;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.util.HasSQL;
import org.h2.util.IntervalUtils;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.util.geometry.EWKTUtils;
import org.h2.util.json.JSONItemType;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.ExtTypeInfoArray;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.ExtTypeInfoGeometry;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueDate;
import org.h2.value.ValueInteger;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueRow;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

public class Parser {
    private static final String WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS = "WITH statement supports only SELECT, TABLE, VALUES, CREATE TABLE, INSERT, UPDATE, MERGE or DELETE statements";
    private static final int CHAR_END = 1;
    private static final int CHAR_VALUE = 2;
    private static final int CHAR_QUOTED = 3;
    private static final int CHAR_NAME = 4;
    private static final int CHAR_SPECIAL_1 = 5;
    private static final int CHAR_SPECIAL_2 = 6;
    private static final int CHAR_STRING = 7;
    private static final int CHAR_DOT = 8;
    private static final int CHAR_DOLLAR_QUOTED_STRING = 9;
    private static final int PARAMETER = 72;
    private static final int END = 73;
    private static final int LITERAL = 74;
    private static final int EQUAL = 75;
    private static final int BIGGER_EQUAL = 76;
    private static final int BIGGER = 77;
    private static final int SMALLER = 78;
    private static final int SMALLER_EQUAL = 79;
    private static final int NOT_EQUAL = 80;
    private static final int AT = 81;
    private static final int MINUS_SIGN = 82;
    private static final int PLUS_SIGN = 83;
    private static final int CONCATENATION = 84;
    private static final int OPEN_PAREN = 85;
    private static final int CLOSE_PAREN = 86;
    private static final int SPATIAL_INTERSECTS = 87;
    private static final int ASTERISK = 88;
    private static final int COMMA = 89;
    private static final int DOT = 90;
    private static final int OPEN_BRACE = 91;
    private static final int CLOSE_BRACE = 92;
    private static final int SLASH = 93;
    private static final int PERCENT = 94;
    private static final int SEMICOLON = 95;
    private static final int COLON = 96;
    private static final int OPEN_BRACKET = 97;
    private static final int CLOSE_BRACKET = 98;
    private static final int TILDE = 99;
    private static final int COLON_COLON = 100;
    private static final int COLON_EQ = 101;
    private static final int NOT_TILDE = 102;
    private static final String[] TOKENS = new String[]{null, null, null, "ALL", "ARRAY", "AS", "CASE", "CHECK", "CONSTRAINT", "CROSS", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DAY", "DISTINCT", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "HOUR", "IF", "INNER", "INTERSECT", "INTERSECTS", "INTERVAL", "IS", "JOIN", "KEY", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "MINUS", "MINUTE", "MONTH", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "ORDER", "PRIMARY", "QUALIFY", "RIGHT", "ROW", "ROWNUM", "SECOND", "SELECT", "SET", "TABLE", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "USING", "VALUE", "VALUES", "WHERE", "WINDOW", "WITH", "YEAR", "_ROWID_", "?", null, null, "=", ">=", ">", "<", "<=", "<>", "@", "-", "+", "||", "(", ")", "&&", "*", ",", ".", "{", "}", "/", "%", ";", ":", "[", "]", "~", "::", ":=", "!~"};
    private static final Comparator<TableFilter> TABLE_FILTER_COMPARATOR = (tableFilter, tableFilter2) -> {
        if (tableFilter == tableFilter2) {
            return 0;
        }
        assert (tableFilter.getOrderInFrom() != tableFilter2.getOrderInFrom());
        return tableFilter.getOrderInFrom() > tableFilter2.getOrderInFrom() ? 1 : -1;
    };
    private final Database database;
    private final Session session;
    private final boolean identifiersToLower;
    private final boolean identifiersToUpper;
    private final boolean variableBinary;
    private final BitSet nonKeywords;
    private int[] characterTypes;
    private int currentTokenType;
    private String currentToken;
    private boolean currentTokenQuoted;
    private Value currentValue;
    private String originalSQL;
    private String sqlCommand;
    private char[] sqlCommandChars;
    private int lastParseIndex;
    private int parseIndex;
    private CreateView createView;
    private Prepared currentPrepared;
    private Select currentSelect;
    private ArrayList<Parameter> parameters;
    private ArrayList<Parameter> indexedParameterList;
    private ArrayList<Parameter> suppliedParameters;
    private ArrayList<Parameter> suppliedParameterList;
    private String schemaName;
    private ArrayList<String> expectedList;
    private boolean rightsChecked;
    private boolean recompileAlways;
    private boolean literalsChecked;
    private int orderInFrom;
    private boolean parseDomainConstraint;

    public static BitSet parseNonKeywords(String[] stringArray) {
        if (stringArray.length == 0) {
            return null;
        }
        BitSet bitSet = new BitSet();
        for (String string : stringArray) {
            int n = Arrays.binarySearch(TOKENS, 3, 72, string);
            if (n < 0) continue;
            bitSet.set(n);
        }
        return bitSet.isEmpty() ? null : bitSet;
    }

    public static String formatNonKeywords(BitSet bitSet) {
        if (bitSet == null || bitSet.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        while ((n = bitSet.nextSetBit(n + 1)) >= 0) {
            if (n < 3 || n > 71) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(TOKENS[n]);
        }
        return stringBuilder.toString();
    }

    public Parser(Session session) {
        this.database = session.getDatabase();
        DbSettings dbSettings = this.database.getSettings();
        this.identifiersToLower = dbSettings.databaseToLower;
        this.identifiersToUpper = dbSettings.databaseToUpper;
        this.variableBinary = session.isVariableBinary();
        this.nonKeywords = session.getNonKeywords();
        this.session = session;
    }

    public Parser() {
        this.database = null;
        this.identifiersToLower = false;
        this.identifiersToUpper = false;
        this.variableBinary = false;
        this.nonKeywords = null;
        this.session = null;
    }

    public Prepared prepare(String string) {
        Prepared prepared = this.parse(string);
        prepared.prepare();
        if (this.currentTokenType != 73) {
            throw this.getSyntaxError();
        }
        return prepared;
    }

    public Command prepareCommand(String string) {
        try {
            String string2;
            Prepared prepared = this.parse(string);
            if (this.currentTokenType != 95 && this.currentTokenType != 73) {
                this.addExpected(95);
                throw this.getSyntaxError();
            }
            try {
                prepared.prepare();
            }
            catch (Throwable throwable) {
                CommandContainer.clearCTE(this.session, prepared);
                throw throwable;
            }
            if (this.parseIndex < string.length()) {
                string = string.substring(0, this.parseIndex);
            }
            CommandContainer commandContainer = new CommandContainer(this.session, string, prepared);
            if (this.currentTokenType == 95 && !StringUtils.isWhitespaceOrEmpty(string2 = this.originalSQL.substring(this.parseIndex))) {
                return this.prepareCommandList(commandContainer, prepared, string, string2);
            }
            return commandContainer;
        }
        catch (DbException dbException) {
            throw dbException.addSQL(this.originalSQL);
        }
    }

    private CommandList prepareCommandList(CommandContainer commandContainer, Prepared prepared, String string, String string2) {
        try {
            ArrayList<Prepared> arrayList = Utils.newSmallArrayList();
            do {
                if (prepared instanceof DefineCommand) {
                    return new CommandList(this.session, string, commandContainer, arrayList, this.parameters, string2);
                }
                this.suppliedParameters = this.parameters;
                this.suppliedParameterList = this.indexedParameterList;
                try {
                    prepared = this.parse(string2);
                }
                catch (DbException dbException) {
                    if (dbException.getErrorCode() == 90123) {
                        throw dbException;
                    }
                    return new CommandList(this.session, string, commandContainer, arrayList, this.parameters, string2);
                }
                arrayList.add(prepared);
                if (this.currentTokenType == 73) break;
                if (this.currentTokenType == 95) continue;
                this.addExpected(95);
                throw this.getSyntaxError();
            } while (!StringUtils.isWhitespaceOrEmpty(string2 = this.originalSQL.substring(this.parseIndex)));
            return new CommandList(this.session, string, commandContainer, arrayList, this.parameters, null);
        }
        catch (Throwable throwable) {
            commandContainer.clearCTE();
            throw throwable;
        }
    }

    Prepared parse(String string) {
        Prepared prepared;
        try {
            prepared = this.parse(string, false);
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 42000) {
                prepared = this.parse(string, true);
            }
            throw dbException.addSQL(string);
        }
        prepared.setPrepareAlways(this.recompileAlways);
        prepared.setParameterList(this.parameters);
        return prepared;
    }

    private Prepared parse(String string, boolean bl) {
        this.initialize(string);
        this.expectedList = bl ? new ArrayList() : null;
        this.parameters = this.suppliedParameters != null ? this.suppliedParameters : Utils.newSmallArrayList();
        this.indexedParameterList = this.suppliedParameterList;
        this.currentSelect = null;
        this.currentPrepared = null;
        this.createView = null;
        this.recompileAlways = false;
        this.read();
        return this.parsePrepared();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Prepared parsePrepared() {
        int n;
        int n2;
        int n3 = this.lastParseIndex;
        Prepared prepared = null;
        switch (this.currentTokenType) {
            case 73: 
            case 95: {
                prepared = new NoOperation(this.session);
                this.setSQL(prepared, n3);
                return prepared;
            }
            case 72: {
                this.readTerm();
                this.parameters.get(0).setValue(ValueNull.INSTANCE);
                this.read(75);
                this.read("CALL");
                prepared = this.parseCall();
                break;
            }
            case 57: 
            case 59: 
            case 66: 
            case 85: {
                prepared = this.parseQuery();
                break;
            }
            case 69: {
                this.read();
                prepared = this.parseWithStatementOrQuery(n3);
                break;
            }
            case 58: {
                this.read();
                prepared = this.parseSet();
                break;
            }
            case 2: {
                if (this.currentTokenQuoted) break;
                switch (this.currentToken.charAt(0) & 0xFFDF) {
                    case 65: {
                        if (this.readIf("ALTER")) {
                            prepared = this.parseAlter();
                            break;
                        }
                        if (!this.readIf("ANALYZE")) break;
                        prepared = this.parseAnalyze();
                        break;
                    }
                    case 66: {
                        if (this.readIf("BACKUP")) {
                            prepared = this.parseBackup();
                            break;
                        }
                        if (!this.readIf("BEGIN")) break;
                        prepared = this.parseBegin();
                        break;
                    }
                    case 67: {
                        if (this.readIf("COMMIT")) {
                            prepared = this.parseCommit();
                            break;
                        }
                        if (this.readIf("CREATE")) {
                            prepared = this.parseCreate();
                            break;
                        }
                        if (this.readIf("CALL")) {
                            prepared = this.parseCall();
                            break;
                        }
                        if (this.readIf("CHECKPOINT")) {
                            prepared = this.parseCheckpoint();
                            break;
                        }
                        if (!this.readIf("COMMENT")) break;
                        prepared = this.parseComment();
                        break;
                    }
                    case 68: {
                        if (this.readIf("DELETE")) {
                            prepared = this.parseDelete(n3);
                            break;
                        }
                        if (this.readIf("DROP")) {
                            prepared = this.parseDrop();
                            break;
                        }
                        if (this.readIf("DECLARE")) {
                            prepared = this.parseCreate();
                            break;
                        }
                        if (this.database.getMode().getEnum() == Mode.ModeEnum.MSSQLServer || !this.readIf("DEALLOCATE")) break;
                        prepared = this.parseDeallocate();
                        break;
                    }
                    case 69: {
                        if (this.readIf("EXPLAIN")) {
                            prepared = this.parseExplain();
                            break;
                        }
                        if (this.database.getMode().getEnum() != Mode.ModeEnum.MSSQLServer) {
                            if (!this.readIf("EXECUTE")) break;
                            prepared = this.parseExecutePostgre();
                            break;
                        }
                        if (!this.readIf("EXEC") && !this.readIf("EXECUTE")) break;
                        prepared = this.parseExecuteSQLServer();
                        break;
                    }
                    case 71: {
                        if (!this.readIf("GRANT")) break;
                        prepared = this.parseGrantRevoke(49);
                        break;
                    }
                    case 72: {
                        if (!this.readIf("HELP")) break;
                        prepared = this.parseHelp();
                        break;
                    }
                    case 73: {
                        if (!this.readIf("INSERT")) break;
                        prepared = this.parseInsert(n3);
                        break;
                    }
                    case 77: {
                        if (!this.readIf("MERGE")) break;
                        prepared = this.parseMerge(n3);
                        break;
                    }
                    case 80: {
                        if (this.database.getMode().getEnum() == Mode.ModeEnum.MSSQLServer || !this.readIf("PREPARE")) break;
                        prepared = this.parsePrepare();
                        break;
                    }
                    case 82: {
                        if (this.readIf("ROLLBACK")) {
                            prepared = this.parseRollback();
                            break;
                        }
                        if (this.readIf("REVOKE")) {
                            prepared = this.parseGrantRevoke(50);
                            break;
                        }
                        if (this.readIf("RUNSCRIPT")) {
                            prepared = this.parseRunScript();
                            break;
                        }
                        if (this.readIf("RELEASE")) {
                            prepared = this.parseReleaseSavepoint();
                            break;
                        }
                        if (!this.database.getMode().replaceInto || !this.readIf("REPLACE")) break;
                        prepared = this.parseReplace(n3);
                        break;
                    }
                    case 83: {
                        if (this.readIf("SAVEPOINT")) {
                            prepared = this.parseSavepoint();
                            break;
                        }
                        if (this.readIf("SCRIPT")) {
                            prepared = this.parseScript();
                            break;
                        }
                        if (this.readIf("SHUTDOWN")) {
                            prepared = this.parseShutdown();
                            break;
                        }
                        if (!this.readIf("SHOW")) break;
                        prepared = this.parseShow();
                        break;
                    }
                    case 84: {
                        if (!this.readIf("TRUNCATE")) break;
                        prepared = this.parseTruncate();
                        break;
                    }
                    case 85: {
                        if (this.readIf("UPDATE")) {
                            prepared = this.parseUpdate(n3);
                            break;
                        }
                        if (!this.readIf("USE")) break;
                        prepared = this.parseUse();
                    }
                }
                break;
            }
        }
        if (prepared == null) {
            throw this.getSyntaxError();
        }
        if (this.indexedParameterList != null) {
            n2 = this.indexedParameterList.size();
            for (n = 0; n < n2; ++n) {
                if (this.indexedParameterList.get(n) != null) continue;
                this.indexedParameterList.set(n, new Parameter(n));
            }
            this.parameters = this.indexedParameterList;
        }
        if ((n = this.readIf(91)) != 0) {
            do {
                if ((n2 = (int)this.readLong() - 1) < 0 || n2 >= this.parameters.size()) {
                    throw this.getSyntaxError();
                }
                Parameter parameter = this.parameters.get(n2);
                if (parameter == null) {
                    throw this.getSyntaxError();
                }
                this.read(96);
                Expression expression = this.readExpression();
                expression = expression.optimize(this.session);
                parameter.setValue(expression.getValue(this.session));
            } while (this.readIf(89));
            this.read(92);
            for (Parameter parameter : this.parameters) {
                parameter.checkSet();
            }
            this.parameters.clear();
        }
        if (n != 0 || prepared.getSQL() == null) {
            this.setSQL(prepared, n3);
        }
        return prepared;
    }

    private DbException getSyntaxError() {
        if (this.expectedList == null || this.expectedList.isEmpty()) {
            return DbException.getSyntaxError(this.sqlCommand, this.parseIndex);
        }
        return DbException.getSyntaxError(this.sqlCommand, this.parseIndex, StringUtils.join(new StringBuilder(), this.expectedList, ", ").toString());
    }

    private Prepared parseBackup() {
        BackupCommand backupCommand = new BackupCommand(this.session);
        this.read("TO");
        backupCommand.setFileName(this.readExpression());
        return backupCommand;
    }

    private Prepared parseAnalyze() {
        Analyze analyze = new Analyze(this.session);
        if (this.readIf(59)) {
            Table table = this.readTableOrView();
            analyze.setTable(table);
        }
        if (this.readIf("SAMPLE_SIZE")) {
            analyze.setTop(this.readNonNegativeInt());
        }
        return analyze;
    }

    private TransactionCommand parseBegin() {
        if (!this.readIf("WORK")) {
            this.readIf("TRANSACTION");
        }
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 83);
        return transactionCommand;
    }

    private TransactionCommand parseCommit() {
        if (this.readIf("TRANSACTION")) {
            TransactionCommand transactionCommand = new TransactionCommand(this.session, 78);
            transactionCommand.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand;
        }
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 71);
        this.readIf("WORK");
        return transactionCommand;
    }

    private TransactionCommand parseShutdown() {
        int n = 80;
        if (this.readIf("IMMEDIATELY")) {
            n = 81;
        } else if (this.readIf("COMPACT")) {
            n = 82;
        } else if (this.readIf("DEFRAG")) {
            n = 84;
        } else {
            this.readIf("SCRIPT");
        }
        return new TransactionCommand(this.session, n);
    }

    private TransactionCommand parseRollback() {
        TransactionCommand transactionCommand;
        if (this.readIf("TRANSACTION")) {
            TransactionCommand transactionCommand2 = new TransactionCommand(this.session, 79);
            transactionCommand2.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand2;
        }
        this.readIf("WORK");
        if (this.readIf("TO")) {
            this.read("SAVEPOINT");
            transactionCommand = new TransactionCommand(this.session, 75);
            transactionCommand.setSavepointName(this.readUniqueIdentifier());
        } else {
            transactionCommand = new TransactionCommand(this.session, 72);
        }
        return transactionCommand;
    }

    private Prepared parsePrepare() {
        Object object;
        if (this.readIf("COMMIT")) {
            TransactionCommand transactionCommand = new TransactionCommand(this.session, 77);
            transactionCommand.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand;
        }
        String string = this.readAliasIdentifier();
        if (this.readIf(85)) {
            object = Utils.newSmallArrayList();
            int n = 0;
            while (true) {
                Column column = this.parseColumnForTable("C" + n, true);
                ((ArrayList)object).add(column);
                if (!this.readIfMore()) break;
                ++n;
            }
        }
        this.read(5);
        object = this.parsePrepared();
        PrepareProcedure prepareProcedure = new PrepareProcedure(this.session);
        prepareProcedure.setProcedureName(string);
        prepareProcedure.setPrepared((Prepared)object);
        return prepareProcedure;
    }

    private TransactionCommand parseSavepoint() {
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 74);
        transactionCommand.setSavepointName(this.readUniqueIdentifier());
        return transactionCommand;
    }

    private Prepared parseReleaseSavepoint() {
        NoOperation noOperation = new NoOperation(this.session);
        this.readIf("SAVEPOINT");
        this.readUniqueIdentifier();
        return noOperation;
    }

    private Schema findSchema(String string) {
        if (string == null) {
            return null;
        }
        Schema schema = this.database.findSchema(string);
        if (schema == null && this.equalsToken("SESSION", string)) {
            schema = this.database.getSchema(this.session.getCurrentSchemaName());
        }
        return schema;
    }

    private Schema getSchema(String string) {
        if (string == null) {
            return null;
        }
        Schema schema = this.findSchema(string);
        if (schema == null) {
            throw DbException.get(90079, string);
        }
        return schema;
    }

    private Schema getSchema() {
        return this.getSchema(this.schemaName);
    }

    private Schema getSchemaWithDefault() {
        if (this.schemaName == null) {
            this.schemaName = this.session.getCurrentSchemaName();
        }
        return this.getSchema(this.schemaName);
    }

    private Column readTableColumn(TableFilter tableFilter) {
        boolean bl = false;
        String string = null;
        if (this.currentTokenType == 71) {
            this.read();
            bl = true;
        } else {
            string = this.readColumnIdentifier();
            if (this.readIf(90)) {
                String string2 = string;
                if (this.currentTokenType == 71) {
                    this.read();
                    bl = true;
                } else {
                    string = this.readColumnIdentifier();
                    if (this.readIf(90)) {
                        String string3 = string2;
                        string2 = string;
                        if (this.currentTokenType == 71) {
                            this.read();
                            bl = true;
                        } else {
                            string = this.readColumnIdentifier();
                            if (this.readIf(90)) {
                                this.checkDatabaseName(string3);
                                string3 = string2;
                                string2 = string;
                                if (this.currentTokenType == 71) {
                                    this.read();
                                    bl = true;
                                } else {
                                    string = this.readColumnIdentifier();
                                }
                            }
                        }
                        if (!this.equalsToken(string3, tableFilter.getTable().getSchema().getName())) {
                            throw DbException.get(90079, string3);
                        }
                    }
                }
                if (!this.equalsToken(string2, tableFilter.getTableAlias())) {
                    throw DbException.get(42102, string2);
                }
            }
        }
        return bl ? tableFilter.getRowIdColumn() : tableFilter.getTable().getColumn(string);
    }

    private Update parseUpdate(int n) {
        Update update = new Update(this.session);
        this.currentPrepared = update;
        Expression expression = null;
        if (this.database.getMode().getEnum() == Mode.ModeEnum.MSSQLServer && this.readIf("TOP")) {
            this.read(85);
            expression = this.readTerm().optimize(this.session);
            update.setLimit(expression);
            this.read(86);
        }
        TableFilter tableFilter = this.readSimpleTableFilter();
        update.setTableFilter(tableFilter);
        this.parseUpdateSetClause(update, tableFilter, n, expression == null);
        return update;
    }

    private void parseUpdateSetClause(Update update, TableFilter tableFilter, int n, boolean bl) {
        Object object;
        this.read(58);
        do {
            if (this.readIf(85)) {
                HasSQL hasSQL;
                object = Utils.newSmallArrayList();
                do {
                    hasSQL = this.readTableColumn(tableFilter);
                    ((ArrayList)object).add(hasSQL);
                } while (this.readIfMore());
                this.read(75);
                hasSQL = this.readExpression();
                int n2 = ((ArrayList)object).size();
                if (hasSQL instanceof ExpressionList) {
                    ExpressionList expressionList = (ExpressionList)hasSQL;
                    if (expressionList.getType().getValueType() != 39 || n2 != expressionList.getSubexpressionCount()) {
                        throw DbException.get(21002);
                    }
                    for (int i = 0; i < n2; ++i) {
                        update.setAssignment((Column)((ArrayList)object).get(i), expressionList.getSubexpression(i));
                    }
                } else {
                    if (n2 == 1) {
                        update.setAssignment((Column)((ArrayList)object).get(0), (Expression)hasSQL);
                        continue;
                    }
                    for (int i = 0; i < n2; ++i) {
                        update.setAssignment((Column)((ArrayList)object).get(i), Function.getFunctionWithArgs(this.database, 209, new Expression[]{hasSQL, ValueExpression.get(ValueInteger.get(i + 1))}));
                    }
                }
            } else {
                object = this.readTableColumn(tableFilter);
                this.read(75);
                update.setAssignment((Column)object, this.readExpressionOrDefault());
            }
        } while (this.readIf(89));
        if (this.readIf(67)) {
            object = this.readExpression();
            update.setCondition((Expression)object);
        }
        if (bl) {
            this.readIfOrderBy();
            if (this.readIf(39)) {
                object = this.readTerm().optimize(this.session);
                update.setLimit((Expression)object);
            }
        }
        this.setSQL(update, n);
    }

    private TableFilter readSimpleTableFilter() {
        return new TableFilter(this.session, this.readTableOrView(), this.readFromAlias(null), this.rightsChecked, this.currentSelect, 0, null);
    }

    private Delete parseDelete(int n) {
        Delete delete = new Delete(this.session);
        Expression expression = null;
        if (this.readIf("TOP")) {
            expression = this.readTerm().optimize(this.session);
        }
        this.currentPrepared = delete;
        if (!this.readIf(24) && this.database.getMode().getEnum() == Mode.ModeEnum.MySQL) {
            this.readIdentifierWithSchema();
            this.read(24);
        }
        delete.setTableFilter(this.readSimpleTableFilter());
        if (this.readIf(67)) {
            delete.setCondition(this.readExpression());
        }
        if (expression == null && this.readIf(39)) {
            expression = this.readTerm().optimize(this.session);
        }
        delete.setLimit(expression);
        this.setSQL(delete, n);
        return delete;
    }

    private IndexColumn[] parseIndexColumnList() {
        ArrayList<IndexColumn> arrayList = Utils.newSmallArrayList();
        do {
            IndexColumn indexColumn = new IndexColumn(this.readColumnIdentifier());
            indexColumn.sortType = this.parseSortType();
            arrayList.add(indexColumn);
        } while (this.readIfMore());
        return arrayList.toArray(new IndexColumn[0]);
    }

    private int parseSortType() {
        int n;
        int n2 = n = !this.readIf("ASC") && this.readIf("DESC") ? 1 : 0;
        if (this.readIf("NULLS")) {
            if (this.readIf("FIRST")) {
                n |= 2;
            } else {
                this.read("LAST");
                n |= 4;
            }
        }
        return n;
    }

    private String[] parseColumnList() {
        ArrayList<String> arrayList = Utils.newSmallArrayList();
        do {
            String string = this.readColumnIdentifier();
            arrayList.add(string);
        } while (this.readIfMore());
        return arrayList.toArray(new String[0]);
    }

    private Column[] parseColumnList(Table table) {
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        HashSet<Column> hashSet = new HashSet<Column>();
        if (!this.readIf(86)) {
            do {
                Column column;
                if (!hashSet.add(column = this.parseColumn(table))) {
                    throw DbException.get(42121, column.getTraceSQL());
                }
                arrayList.add(column);
            } while (this.readIfMore());
        }
        return arrayList.toArray(new Column[0]);
    }

    private Column parseColumn(Table table) {
        if (this.currentTokenType == 71) {
            this.read();
            return table.getRowIdColumn();
        }
        return table.getColumn(this.readColumnIdentifier());
    }

    private boolean readIfMore() {
        if (this.readIf(89)) {
            return true;
        }
        this.read(86);
        return false;
    }

    private Prepared parseHelp() {
        Select select = new Select(this.session, null);
        select.setWildcard();
        String string = this.database.sysIdentifier("INFORMATION_SCHEMA");
        Table table = this.database.getSchema(string).resolveTableOrView(this.session, this.database.sysIdentifier("HELP"));
        Function function = Function.getFunctionWithArgs(this.database, 76, new ExpressionColumn(this.database, string, this.database.sysIdentifier("HELP"), this.database.sysIdentifier("TOPIC"), false));
        TableFilter tableFilter = new TableFilter(this.session, table, null, this.rightsChecked, select, 0, null);
        select.addTableFilter(tableFilter, true);
        while (this.currentTokenType != 73) {
            String string2 = this.currentToken;
            this.read();
            CompareLike compareLike = new CompareLike(this.database, function, ValueExpression.get(ValueVarchar.get('%' + string2 + '%')), null, false);
            select.addCondition(compareLike);
        }
        select.init();
        return select;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Prepared parseShow() {
        Object object;
        String string;
        ArrayList<Value> arrayList = Utils.newSmallArrayList();
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (this.readIf("CLIENT_ENCODING")) {
            stringBuilder.append("'UNICODE' AS CLIENT_ENCODING FROM DUAL");
        } else if (this.readIf("DEFAULT_TRANSACTION_ISOLATION")) {
            stringBuilder.append("'read committed' AS DEFAULT_TRANSACTION_ISOLATION FROM DUAL");
        } else if (this.readIf("TRANSACTION")) {
            this.read("ISOLATION");
            this.read("LEVEL");
            stringBuilder.append("'read committed' AS TRANSACTION_ISOLATION FROM DUAL");
        } else if (this.readIf("DATESTYLE")) {
            stringBuilder.append("'ISO' AS DATESTYLE FROM DUAL");
        } else if (this.readIf("SERVER_VERSION")) {
            stringBuilder.append("'8.2.23' AS SERVER_VERSION FROM DUAL");
        } else if (this.readIf("SERVER_ENCODING")) {
            stringBuilder.append("'UTF8' AS SERVER_ENCODING FROM DUAL");
        } else if (this.readIf("TABLES")) {
            string = this.database.getMainSchema().getName();
            if (this.readIf(24)) {
                string = this.readUniqueIdentifier();
            }
            stringBuilder.append("TABLE_NAME, TABLE_SCHEMA FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? ORDER BY TABLE_NAME");
            arrayList.add(ValueVarchar.get(string));
        } else if (this.readIf("COLUMNS")) {
            this.read(24);
            string = this.readIdentifierWithSchema();
            object = this.getSchema().getName();
            arrayList.add(ValueVarchar.get(string));
            if (this.readIf(24)) {
                object = this.readUniqueIdentifier();
            }
            stringBuilder.append("C.COLUMN_NAME FIELD, C.TYPE_NAME || '(' || C.NUMERIC_PRECISION || ')' TYPE, C.IS_NULLABLE \"NULL\", CASE (SELECT MAX(I.INDEX_TYPE_NAME) FROM INFORMATION_SCHEMA.INDEXES I WHERE I.TABLE_SCHEMA=C.TABLE_SCHEMA AND I.TABLE_NAME=C.TABLE_NAME AND I.COLUMN_NAME=C.COLUMN_NAME)WHEN 'PRIMARY KEY' THEN 'PRI' WHEN 'UNIQUE INDEX' THEN 'UNI' ELSE '' END `KEY`, IFNULL(COLUMN_DEFAULT, 'NULL') DEFAULT FROM INFORMATION_SCHEMA.COLUMNS C WHERE C.TABLE_NAME=? AND C.TABLE_SCHEMA=? ORDER BY C.ORDINAL_POSITION");
            arrayList.add(ValueVarchar.get((String)object));
        } else if (this.readIf("DATABASES") || this.readIf("SCHEMAS")) {
            stringBuilder.append("SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA");
        }
        boolean bl = this.session.getAllowLiterals();
        try {
            this.session.setAllowLiterals(true);
            object = Parser.prepare(this.session, stringBuilder.toString(), arrayList);
            return object;
        }
        finally {
            this.session.setAllowLiterals(bl);
        }
    }

    private static Prepared prepare(Session session, String string, ArrayList<Value> arrayList) {
        Prepared prepared = session.prepare(string);
        ArrayList<Parameter> arrayList2 = prepared.getParameters();
        if (arrayList2 != null) {
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                Parameter parameter = arrayList2.get(i);
                parameter.setValue(arrayList.get(i));
            }
        }
        return prepared;
    }

    private boolean isQuery() {
        boolean bl;
        int n = this.lastParseIndex;
        while (this.readIf(85)) {
        }
        switch (this.currentTokenType) {
            case 57: 
            case 66: 
            case 69: {
                bl = true;
                break;
            }
            case 59: {
                this.read();
                bl = !this.readIf(85);
                break;
            }
            default: {
                bl = false;
            }
        }
        this.parseIndex = n;
        this.read();
        return bl;
    }

    private Prepared parseMerge(int n) {
        Column[] columnArray;
        this.read("INTO");
        TableFilter tableFilter = this.readSimpleTableFilter();
        if (this.readIf(64)) {
            return this.parseMergeUsing(tableFilter, n);
        }
        Merge merge = new Merge(this.session, false);
        this.currentPrepared = merge;
        merge.setTable(tableFilter.getTable());
        Table table = merge.getTable();
        if (this.readIf(85)) {
            if (this.isQuery()) {
                merge.setQuery(this.parseQuery());
                this.read(86);
                return merge;
            }
            columnArray = this.parseColumnList(table);
            merge.setColumns(columnArray);
        }
        if (this.readIf(36)) {
            this.read(85);
            columnArray = this.parseColumnList(table);
            merge.setKeys(columnArray);
        }
        if (this.readIf(66)) {
            this.parseValuesForCommand(merge);
        } else {
            merge.setQuery(this.parseQuery());
        }
        this.setSQL(merge, n);
        return merge;
    }

    private MergeUsing parseMergeUsing(TableFilter tableFilter, int n) {
        Object object;
        String[] stringArray;
        Object object2;
        MergeUsing mergeUsing = new MergeUsing(this.session, tableFilter);
        this.currentPrepared = mergeUsing;
        if (this.isQuery()) {
            mergeUsing.setQuery(this.parseQuery());
            object2 = this.readFromAlias(null);
            if (object2 == null) {
                object2 = "QUERY_ALIAS_" + this.parseIndex;
            }
            mergeUsing.setQueryAlias((String)object2);
            stringArray = new String[]{null};
            object = TableView.createQueryColumnTemplateList(null, mergeUsing.getQuery(), stringArray);
            TableView tableView = this.createCTEView((String)object2, stringArray[0], (List<Column>)object, false, false, true);
            TableFilter tableFilter2 = new TableFilter(this.session, tableView, (String)object2, this.rightsChecked, null, 0, null);
            mergeUsing.setSourceTableFilter(tableFilter2);
        } else {
            object2 = this.readTableFilter();
            mergeUsing.setSourceTableFilter((TableFilter)object2);
            stringArray = new Select(this.session, null);
            stringArray.setWildcard();
            object = new TableFilter(this.session, ((TableFilter)object2).getTable(), ((TableFilter)object2).getTableAlias(), this.rightsChecked, (Select)stringArray, 0, null);
            stringArray.addTableFilter((TableFilter)object, true);
            stringArray.init();
            mergeUsing.setQuery((Query)stringArray);
        }
        this.read(49);
        object2 = this.readExpression();
        mergeUsing.setOnCondition((Expression)object2);
        this.read("WHEN");
        do {
            boolean bl;
            if (bl = this.readIf("MATCHED")) {
                this.parseWhenMatched(mergeUsing);
                continue;
            }
            this.parseWhenNotMatched(mergeUsing);
        } while (this.readIf("WHEN"));
        this.setSQL(mergeUsing, n);
        return mergeUsing;
    }

    private void parseWhenMatched(MergeUsing mergeUsing) {
        Object object;
        Expression expression = this.readIf("AND") ? this.readExpression() : null;
        this.read("THEN");
        int n = this.lastParseIndex;
        Update update = null;
        if (this.readIf("UPDATE")) {
            update = new Update(this.session);
            object = mergeUsing.getTargetTableFilter();
            update.setTableFilter((TableFilter)object);
            this.parseUpdateSetClause(update, (TableFilter)object, n, false);
            n = this.lastParseIndex;
        }
        object = null;
        if (this.readIf("DELETE")) {
            object = new Delete(this.session);
            ((Delete)object).setTableFilter(mergeUsing.getTargetTableFilter());
            if (this.readIf(67)) {
                ((Delete)object).setCondition(this.readExpression());
            }
            this.setSQL((Prepared)object, n);
        }
        if (update == null && object == null) {
            throw this.getSyntaxError();
        }
        MergeUsing.WhenMatched whenMatched = new MergeUsing.WhenMatched(mergeUsing);
        whenMatched.setAndCondition(expression);
        whenMatched.setUpdateCommand(update);
        whenMatched.setDeleteCommand((Delete)object);
        mergeUsing.addWhen(whenMatched);
    }

    private void parseWhenNotMatched(MergeUsing mergeUsing) {
        this.read(46);
        this.read("MATCHED");
        Expression expression = this.readIf("AND") ? this.readExpression() : null;
        this.read("THEN");
        if (!this.readIf("INSERT")) {
            throw this.getSyntaxError();
        }
        Insert insert = new Insert(this.session);
        insert.setTable(mergeUsing.getTargetTable());
        this.parseInsertGivenTable(insert, mergeUsing.getTargetTable());
        MergeUsing.WhenNotMatched whenNotMatched = new MergeUsing.WhenNotMatched(mergeUsing);
        whenNotMatched.setAndCondition(expression);
        whenNotMatched.setInsertCommand(insert);
        mergeUsing.addWhen(whenNotMatched);
    }

    private Insert parseInsert(int n) {
        Insert insert = new Insert(this.session);
        this.currentPrepared = insert;
        Mode mode = this.database.getMode();
        if (mode.onDuplicateKeyUpdate && this.readIf("IGNORE")) {
            insert.setIgnore(true);
        }
        this.read("INTO");
        Table table = this.readTableOrView();
        insert.setTable(table);
        Insert insert2 = this.parseInsertGivenTable(insert, table);
        if (insert2 != null) {
            return insert2;
        }
        if (mode.onDuplicateKeyUpdate && this.readIf(49)) {
            this.read("DUPLICATE");
            this.read(36);
            this.read("UPDATE");
            do {
                Object object;
                String string = this.readColumnIdentifier();
                if (this.readIf(90)) {
                    object = string;
                    Object object2 = this.readColumnIdentifier();
                    if (this.readIf(90)) {
                        if (!table.getSchema().getName().equals(object)) {
                            throw DbException.get(90080);
                        }
                        string = this.readColumnIdentifier();
                    } else {
                        string = object2;
                        object2 = object;
                    }
                    if (!table.getName().equals(object2)) {
                        throw DbException.get(42102, (String)object2);
                    }
                }
                object = table.getColumn(string);
                this.read(75);
                insert.addAssignmentForDuplicate((Column)object, this.readExpressionOrDefault());
            } while (this.readIf(89));
        }
        if (mode.insertOnConflict && this.readIf(49)) {
            this.read("CONFLICT");
            this.read("DO");
            this.read("NOTHING");
            insert.setIgnore(true);
        }
        if (mode.isolationLevelInSelectOrInsertStatement) {
            this.parseIsolationClause();
        }
        this.setSQL(insert, n);
        return insert;
    }

    private Insert parseInsertGivenTable(Insert insert, Table table) {
        Column[] columnArray = null;
        if (this.readIf(85)) {
            if (this.isQuery()) {
                insert.setQuery(this.parseQuery());
                this.read(86);
                return insert;
            }
            columnArray = this.parseColumnList(table);
            insert.setColumns(columnArray);
        }
        if (this.readIf("DIRECT")) {
            insert.setInsertFromSelect(true);
        }
        if (this.readIf("SORTED")) {
            insert.setSortedInsertMode(true);
        }
        if (this.readIf("DEFAULT")) {
            this.read(66);
            insert.addRow(new Expression[0]);
        } else if (this.readIf(66)) {
            this.parseValuesForCommand(insert);
        } else if (this.readIf(58)) {
            if (columnArray != null) {
                throw this.getSyntaxError();
            }
            ArrayList<Column> arrayList = Utils.newSmallArrayList();
            ArrayList<Expression> arrayList2 = Utils.newSmallArrayList();
            do {
                arrayList.add(this.parseColumn(table));
                this.read(75);
                arrayList2.add(this.readExpressionOrDefault());
            } while (this.readIf(89));
            insert.setColumns(arrayList.toArray(new Column[0]));
            insert.addRow(arrayList2.toArray(new Expression[0]));
        } else {
            insert.setQuery(this.parseQuery());
        }
        return null;
    }

    private Merge parseReplace(int n) {
        Merge merge = new Merge(this.session, true);
        this.currentPrepared = merge;
        this.read("INTO");
        Table table = this.readTableOrView();
        merge.setTable(table);
        if (this.readIf(85)) {
            if (this.isQuery()) {
                merge.setQuery(this.parseQuery());
                this.read(86);
                return merge;
            }
            Column[] columnArray = this.parseColumnList(table);
            merge.setColumns(columnArray);
        }
        if (this.readIf(66)) {
            this.parseValuesForCommand(merge);
        } else {
            merge.setQuery(this.parseQuery());
        }
        this.setSQL(merge, n);
        return merge;
    }

    private void parseValuesForCommand(CommandWithValues commandWithValues) {
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        do {
            boolean bl;
            arrayList.clear();
            if (this.readIf(54)) {
                this.read(85);
                bl = true;
            } else {
                bl = this.readIf(85);
            }
            if (bl) {
                if (!this.readIf(86)) {
                    do {
                        arrayList.add(this.readExpressionOrDefault());
                    } while (this.readIfMore());
                }
            } else {
                arrayList.add(this.readExpressionOrDefault());
            }
            commandWithValues.addRow(arrayList.toArray(new Expression[0]));
        } while (this.readIf(89));
    }

    /*
     * Enabled aggressive block sorting
     */
    private TableFilter readTableFilter() {
        Object object;
        Table table;
        String string;
        block20: {
            block28: {
                Schema schema;
                block27: {
                    block26: {
                        block25: {
                            int n;
                            boolean bl;
                            block24: {
                                block23: {
                                    block22: {
                                        string = null;
                                        if (this.readIf(85)) {
                                            if (this.isQuery()) {
                                                Query query = this.parseSelectUnion();
                                                this.read(86);
                                                string = this.session.getNextSystemIdentifier(this.sqlCommand);
                                                table = query.toTable(string, this.parameters, this.createView != null, this.currentSelect);
                                                break block20;
                                            } else {
                                                TableFilter tableFilter = this.readTableFilter();
                                                tableFilter = this.readJoin(tableFilter);
                                                this.read(86);
                                                string = this.readFromAlias(null);
                                                if (string != null) {
                                                    tableFilter.setAlias(string);
                                                    ArrayList<String> arrayList = this.readDerivedColumnNames();
                                                    if (arrayList != null) {
                                                        tableFilter.setDerivedColumns(arrayList);
                                                    }
                                                }
                                                return tableFilter;
                                            }
                                        }
                                        if (!this.readIf(66)) break block22;
                                        TableValueConstructor tableValueConstructor = this.parseValues();
                                        string = this.session.getNextSystemIdentifier(this.sqlCommand);
                                        table = tableValueConstructor.toTable(string, this.parameters, this.createView != null, this.currentSelect);
                                        break block20;
                                    }
                                    if (!this.readIf(59)) break block23;
                                    this.read(85);
                                    Function function = this.readFunctionParameters(Function.getFunction(this.database, 223));
                                    table = new FunctionTable(this.database.getMainSchema(), this.session, function, function);
                                    break block20;
                                }
                                bl = this.currentTokenQuoted;
                                object = this.readColumnIdentifier();
                                n = this.parseIndex;
                                this.schemaName = null;
                                if (!this.readIf(90)) break block24;
                                object = this.readIdentifierWithSchema2((String)object);
                                break block25;
                            }
                            if (bl || !this.readIf(59)) break block25;
                            table = this.readDataChangeDeltaTable((String)object, n);
                            break block20;
                        }
                        if (this.schemaName != null) break block26;
                        schema = null;
                        break block27;
                    }
                    schema = this.findSchema(this.schemaName);
                    if (schema != null) break block27;
                    if (!this.isDualTable((String)object)) {
                        throw DbException.get(90079, this.schemaName);
                    }
                    table = new DualTable(this.database);
                    break block20;
                }
                boolean bl = this.readIf(85);
                if (bl && this.readIf("INDEX")) {
                    this.readIdentifierWithSchema(null);
                    this.read(86);
                    bl = false;
                }
                if (!bl) break block28;
                Schema schema2 = this.database.getMainSchema();
                if (this.equalsToken((String)object, "SYSTEM_RANGE") || this.equalsToken((String)object, "GENERATE_SERIES")) {
                    Expression expression = this.readExpression();
                    this.read(89);
                    Expression expression2 = this.readExpression();
                    if (this.readIf(89)) {
                        Expression expression3 = this.readExpression();
                        this.read(86);
                        table = new RangeTable(schema2, expression, expression2, expression3);
                        break block20;
                    } else {
                        this.read(86);
                        table = new RangeTable(schema2, expression, expression2);
                    }
                    break block20;
                } else {
                    table = this.readTableFunction((String)object, schema, schema2);
                }
                break block20;
            }
            table = this.readTableOrView((String)object);
        }
        ArrayList<String> arrayList = null;
        object = null;
        if (this.readIf("USE")) {
            if (this.readIf("INDEX")) {
                object = this.parseIndexHints(table);
            } else {
                string = "USE";
                arrayList = this.readDerivedColumnNames();
            }
        } else if ((string = this.readFromAlias(string)) != null) {
            arrayList = this.readDerivedColumnNames();
            if (this.readIf("USE")) {
                this.read("INDEX");
                object = this.parseIndexHints(table);
            }
        }
        if (this.database.getMode().discardWithTableHints) {
            this.discardWithTableHints();
        }
        if (table.isView() && table.isTableExpression() && string == null) {
            string = table.getName();
        }
        TableFilter tableFilter = new TableFilter(this.session, table, string, this.rightsChecked, this.currentSelect, this.orderInFrom++, (IndexHints)object);
        if (arrayList != null) {
            tableFilter.setDerivedColumns(arrayList);
        }
        return tableFilter;
    }

    private Table readDataChangeDeltaTable(String string, int n) {
        DataChangeStatement dataChangeStatement;
        this.read(85);
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        int n2 = this.lastParseIndex;
        DataChangeDeltaTable.ResultOption resultOption = DataChangeDeltaTable.ResultOption.FINAL;
        switch (string) {
            case "OLD": {
                resultOption = DataChangeDeltaTable.ResultOption.OLD;
                if (this.readIf("UPDATE")) {
                    dataChangeStatement = this.parseUpdate(n2);
                    break;
                }
                if (this.readIf("DELETE")) {
                    dataChangeStatement = this.parseDelete(n2);
                    break;
                }
                if (this.readIf("MERGE")) {
                    dataChangeStatement = (DataChangeStatement)((Object)this.parseMerge(n2));
                    break;
                }
                if (this.database.getMode().replaceInto && this.readIf("REPLACE")) {
                    dataChangeStatement = this.parseReplace(n2);
                    break;
                }
                throw this.getSyntaxError();
            }
            case "NEW": {
                resultOption = DataChangeDeltaTable.ResultOption.NEW;
            }
            case "FINAL": {
                if (this.readIf("INSERT")) {
                    dataChangeStatement = this.parseInsert(n2);
                    break;
                }
                if (this.readIf("UPDATE")) {
                    dataChangeStatement = this.parseUpdate(n2);
                    break;
                }
                if (this.readIf("MERGE")) {
                    dataChangeStatement = (DataChangeStatement)((Object)this.parseMerge(n2));
                    break;
                }
                if (this.database.getMode().replaceInto && this.readIf("REPLACE")) {
                    dataChangeStatement = this.parseReplace(n2);
                    break;
                }
                throw this.getSyntaxError();
            }
            default: {
                this.parseIndex = n;
                this.addExpected("OLD TABLE");
                this.addExpected("NEW TABLE");
                this.addExpected("FINAL TABLE");
                throw this.getSyntaxError();
            }
        }
        this.read(86);
        if (dataChangeStatement instanceof MergeUsing && ((MergeUsing)dataChangeStatement).hasCombinedMatchedClause()) {
            throw DbException.getUnsupportedException((Object)((Object)resultOption) + " TABLE with Oracle-style MERGE WHEN MATCHED THEN (UPDATE + DELETE)");
        }
        return new DataChangeDeltaTable(this.getSchemaWithDefault(), this.session, dataChangeStatement, resultOption);
    }

    private Table readTableFunction(String string, Schema schema, Schema schema2) {
        Expression expression = this.readFunction(schema, string);
        if (!(expression instanceof FunctionCall)) {
            throw this.getSyntaxError();
        }
        FunctionCall functionCall = (FunctionCall)((Object)expression);
        if (!functionCall.isDeterministic()) {
            this.recompileAlways = true;
        }
        return new FunctionTable(schema2, this.session, expression, functionCall);
    }

    private IndexHints parseIndexHints(Table table) {
        this.read(85);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (!this.readIf(86)) {
            do {
                String string = this.readIdentifierWithSchema();
                Index index = table.getIndex(string);
                linkedHashSet.add(index.getName());
            } while (this.readIfMore());
        }
        return IndexHints.createUseIndexHints(linkedHashSet);
    }

    private String readFromAlias(String string) {
        if (this.readIf(5) || this.isIdentifier()) {
            string = this.readAliasIdentifier();
        }
        return string;
    }

    private ArrayList<String> readDerivedColumnNames() {
        if (this.readIf(85)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            do {
                arrayList.add(this.readAliasIdentifier());
            } while (this.readIfMore());
            return arrayList;
        }
        return null;
    }

    private void discardWithTableHints() {
        if (this.readIf(69)) {
            this.read(85);
            do {
                this.discardTableHint();
            } while (this.readIfMore());
        }
    }

    private void discardTableHint() {
        if (this.readIf("INDEX")) {
            if (this.readIf(85)) {
                do {
                    this.readExpression();
                } while (this.readIfMore());
            } else {
                this.read(75);
                this.readExpression();
            }
        } else {
            this.readExpression();
        }
    }

    private Prepared parseTruncate() {
        this.read(59);
        Table table = this.readTableOrView();
        boolean bl = this.database.getMode().truncateTableRestartIdentity;
        if (this.readIf("CONTINUE")) {
            this.read("IDENTITY");
            bl = false;
        } else if (this.readIf("RESTART")) {
            this.read("IDENTITY");
            bl = true;
        }
        TruncateTable truncateTable = new TruncateTable(this.session);
        truncateTable.setTable(table);
        truncateTable.setRestart(bl);
        return truncateTable;
    }

    private boolean readIfExists(boolean bl) {
        if (this.readIf(29)) {
            this.read(19);
            bl = true;
        }
        return bl;
    }

    private Prepared parseComment() {
        String string;
        int n = 0;
        this.read(49);
        boolean bl = false;
        if (this.readIf(59) || this.readIf("VIEW")) {
            n = 0;
        } else if (this.readIf("COLUMN")) {
            bl = true;
            n = 0;
        } else if (this.readIf("CONSTANT")) {
            n = 11;
        } else if (this.readIf(8)) {
            n = 5;
        } else if (this.readIf("ALIAS")) {
            n = 9;
        } else if (this.readIf("INDEX")) {
            n = 1;
        } else if (this.readIf("ROLE")) {
            n = 7;
        } else if (this.readIf("SCHEMA")) {
            n = 10;
        } else if (this.readIf("SEQUENCE")) {
            n = 3;
        } else if (this.readIf("TRIGGER")) {
            n = 4;
        } else if (this.readIf("USER")) {
            n = 2;
        } else if (this.readIf("DOMAIN")) {
            n = 12;
        } else {
            throw this.getSyntaxError();
        }
        SetComment setComment = new SetComment(this.session);
        if (bl) {
            String string2;
            string = this.readColumnIdentifier();
            String string3 = null;
            this.read(90);
            boolean bl2 = this.database.getMode().allowEmptySchemaValuesAsDefaultSchema;
            String string4 = string2 = bl2 && this.currentTokenType == 90 ? null : this.readColumnIdentifier();
            if (this.readIf(90)) {
                string3 = string;
                string = string2;
                String string5 = string2 = bl2 && this.currentTokenType == 90 ? null : this.readColumnIdentifier();
                if (this.readIf(90)) {
                    this.checkDatabaseName(string3);
                    string3 = string;
                    string = string2;
                    string2 = this.readColumnIdentifier();
                }
            }
            if (string2 == null || string == null) {
                throw DbException.getSyntaxError(this.sqlCommand, this.lastParseIndex, "table.column");
            }
            this.schemaName = string3 != null ? string3 : this.session.getCurrentSchemaName();
            setComment.setColumn(true);
            setComment.setColumnName(string2);
        } else {
            string = this.readIdentifierWithSchema();
        }
        setComment.setSchemaName(this.schemaName);
        setComment.setObjectName(string);
        setComment.setObjectType(n);
        this.read(34);
        setComment.setCommentExpression(this.readExpression());
        return setComment;
    }

    private Prepared parseDrop() {
        if (this.readIf(59)) {
            boolean bl = this.readIfExists(false);
            DropTable dropTable = new DropTable(this.session);
            do {
                String string = this.readIdentifierWithSchema();
                dropTable.addTable(this.getSchema(), string);
            } while (this.readIf(89));
            bl = this.readIfExists(bl);
            dropTable.setIfExists(bl);
            if (this.readIf("CASCADE")) {
                dropTable.setDropAction(ConstraintActionType.CASCADE);
                this.readIf("CONSTRAINTS");
            } else if (this.readIf("RESTRICT")) {
                dropTable.setDropAction(ConstraintActionType.RESTRICT);
            } else if (this.readIf("IGNORE")) {
                dropTable.setDropAction(ConstraintActionType.SET_DEFAULT);
            }
            return dropTable;
        }
        if (this.readIf("INDEX")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropIndex dropIndex = new DropIndex(this.session, this.getSchema());
            dropIndex.setIndexName(string);
            bl = this.readIfExists(bl);
            dropIndex.setIfExists(bl);
            if (this.readIf(49)) {
                this.readIdentifierWithSchema();
            }
            return dropIndex;
        }
        if (this.readIf("USER")) {
            boolean bl = this.readIfExists(false);
            DropUser dropUser = new DropUser(this.session);
            dropUser.setUserName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            this.readIf("CASCADE");
            dropUser.setIfExists(bl);
            return dropUser;
        }
        if (this.readIf("SEQUENCE")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropSequence dropSequence = new DropSequence(this.session, this.getSchema());
            dropSequence.setSequenceName(string);
            bl = this.readIfExists(bl);
            dropSequence.setIfExists(bl);
            return dropSequence;
        }
        if (this.readIf("CONSTANT")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropConstant dropConstant = new DropConstant(this.session, this.getSchema());
            dropConstant.setConstantName(string);
            bl = this.readIfExists(bl);
            dropConstant.setIfExists(bl);
            return dropConstant;
        }
        if (this.readIf("TRIGGER")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropTrigger dropTrigger = new DropTrigger(this.session, this.getSchema());
            dropTrigger.setTriggerName(string);
            bl = this.readIfExists(bl);
            dropTrigger.setIfExists(bl);
            return dropTrigger;
        }
        if (this.readIf("VIEW")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropView dropView = new DropView(this.session, this.getSchema());
            dropView.setViewName(string);
            bl = this.readIfExists(bl);
            dropView.setIfExists(bl);
            ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
            if (constraintActionType != null) {
                dropView.setDropAction(constraintActionType);
            }
            return dropView;
        }
        if (this.readIf("ROLE")) {
            boolean bl = this.readIfExists(false);
            DropRole dropRole = new DropRole(this.session);
            dropRole.setRoleName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            dropRole.setIfExists(bl);
            return dropRole;
        }
        if (this.readIf("ALIAS")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropFunctionAlias dropFunctionAlias = new DropFunctionAlias(this.session, this.getSchema());
            dropFunctionAlias.setAliasName(string);
            bl = this.readIfExists(bl);
            dropFunctionAlias.setIfExists(bl);
            return dropFunctionAlias;
        }
        if (this.readIf("SCHEMA")) {
            boolean bl = this.readIfExists(false);
            DropSchema dropSchema = new DropSchema(this.session);
            dropSchema.setSchemaName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            dropSchema.setIfExists(bl);
            ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
            if (constraintActionType != null) {
                dropSchema.setDropAction(constraintActionType);
            }
            return dropSchema;
        }
        if (this.readIf(3)) {
            this.read("OBJECTS");
            DropDatabase dropDatabase = new DropDatabase(this.session);
            dropDatabase.setDropAllObjects(true);
            if (this.readIf("DELETE")) {
                this.read("FILES");
                dropDatabase.setDeleteFiles(true);
            }
            return dropDatabase;
        }
        if (this.readIf("DOMAIN") || this.readIf("TYPE") || this.readIf("DATATYPE")) {
            return this.parseDropDomain();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseDropAggregate();
        }
        if (this.readIf("SYNONYM")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropSynonym dropSynonym = new DropSynonym(this.session, this.getSchema());
            dropSynonym.setSynonymName(string);
            bl = this.readIfExists(bl);
            dropSynonym.setIfExists(bl);
            return dropSynonym;
        }
        throw this.getSyntaxError();
    }

    private DropDomain parseDropDomain() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        DropDomain dropDomain = new DropDomain(this.session, this.getSchema());
        dropDomain.setTypeName(string);
        bl = this.readIfExists(bl);
        dropDomain.setIfExists(bl);
        ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
        if (constraintActionType != null) {
            dropDomain.setDropAction(constraintActionType);
        }
        return dropDomain;
    }

    private DropAggregate parseDropAggregate() {
        boolean bl = this.readIfExists(false);
        DropAggregate dropAggregate = new DropAggregate(this.session);
        dropAggregate.setName(this.readUniqueIdentifier());
        bl = this.readIfExists(bl);
        dropAggregate.setIfExists(bl);
        return dropAggregate;
    }

    private TableFilter readJoin(TableFilter tableFilter) {
        TableFilter tableFilter2 = tableFilter;
        while (true) {
            TableFilter tableFilter3;
            switch (this.currentTokenType) {
                case 53: {
                    this.read();
                    this.readIf("OUTER");
                    this.read(35);
                    tableFilter3 = this.readTableFilter();
                    tableFilter3 = this.readJoin(tableFilter3);
                    Expression expression = this.readJoinSpecification(tableFilter, tableFilter3, true);
                    this.addJoin(tableFilter3, tableFilter, true, expression);
                    tableFilter = tableFilter3;
                    break;
                }
                case 37: {
                    this.read();
                    this.readIf("OUTER");
                    this.read(35);
                    tableFilter3 = this.readTableFilter();
                    tableFilter3 = this.readJoin(tableFilter3);
                    Expression expression = this.readJoinSpecification(tableFilter, tableFilter3, false);
                    this.addJoin(tableFilter, tableFilter3, true, expression);
                    break;
                }
                case 25: {
                    this.read();
                    throw this.getSyntaxError();
                }
                case 30: {
                    this.read();
                    this.read(35);
                    tableFilter3 = this.readTableFilter();
                    tableFilter = this.readJoin(tableFilter);
                    Expression expression = this.readJoinSpecification(tableFilter, tableFilter3, false);
                    this.addJoin(tableFilter, tableFilter3, false, expression);
                    break;
                }
                case 35: {
                    this.read();
                    tableFilter3 = this.readTableFilter();
                    tableFilter = this.readJoin(tableFilter);
                    Expression expression = this.readJoinSpecification(tableFilter, tableFilter3, false);
                    this.addJoin(tableFilter, tableFilter3, false, expression);
                    break;
                }
                case 9: {
                    this.read();
                    this.read(35);
                    tableFilter3 = this.readTableFilter();
                    this.addJoin(tableFilter, tableFilter3, false, null);
                    break;
                }
                case 45: {
                    this.read();
                    this.read(35);
                    tableFilter3 = this.readTableFilter();
                    Expression expression = null;
                    for (Column column : tableFilter2.getTable().getColumns()) {
                        Column column2 = tableFilter3.getColumn(tableFilter2.getColumnName(column), true);
                        if (column2 == null) continue;
                        expression = this.addJoinColumn(expression, tableFilter2, tableFilter3, column, column2, false);
                    }
                    this.addJoin(tableFilter, tableFilter3, false, expression);
                    break;
                }
                default: {
                    if (this.expectedList != null) {
                        this.addMultipleExpected(53, 37, 30, 35, 9, 45);
                    }
                    return tableFilter;
                }
            }
            tableFilter2 = tableFilter3;
        }
    }

    private Expression readJoinSpecification(TableFilter tableFilter, TableFilter tableFilter2, boolean bl) {
        Expression expression = null;
        if (this.readIf(49)) {
            expression = this.readExpression();
        } else if (this.readIf(64)) {
            this.read(85);
            do {
                String string = this.readColumnIdentifier();
                expression = this.addJoinColumn(expression, tableFilter, tableFilter2, tableFilter.getColumn(string, false), tableFilter2.getColumn(string, false), bl);
            } while (this.readIfMore());
        }
        return expression;
    }

    private Expression addJoinColumn(Expression expression, TableFilter tableFilter, TableFilter tableFilter2, Column column, Column column2, boolean bl) {
        if (bl) {
            tableFilter.addCommonJoinColumns(column, column2, tableFilter2);
            tableFilter2.addCommonJoinColumnToExclude(column2);
        } else {
            tableFilter.addCommonJoinColumns(column, column, tableFilter);
            tableFilter2.addCommonJoinColumnToExclude(column2);
        }
        ExpressionColumn expressionColumn = new ExpressionColumn(this.database, tableFilter.getSchemaName(), tableFilter.getTableAlias(), tableFilter.getColumnName(column), false);
        ExpressionColumn expressionColumn2 = new ExpressionColumn(this.database, tableFilter2.getSchemaName(), tableFilter2.getTableAlias(), tableFilter2.getColumnName(column2), false);
        Comparison comparison = new Comparison(0, expressionColumn, expressionColumn2);
        expression = expression == null ? comparison : new ConditionAndOr(0, expression, comparison);
        return expression;
    }

    private void addJoin(TableFilter tableFilter, TableFilter tableFilter2, boolean bl, Expression expression) {
        if (tableFilter2.getJoin() != null) {
            String string = "SYSTEM_JOIN_" + this.parseIndex;
            TableFilter tableFilter3 = new TableFilter(this.session, new DualTable(this.database), string, this.rightsChecked, this.currentSelect, tableFilter2.getOrderInFrom(), null);
            tableFilter3.setNestedJoin(tableFilter2);
            tableFilter2 = tableFilter3;
        }
        tableFilter.addJoin(tableFilter2, bl, expression);
    }

    private Prepared parseExecutePostgre() {
        if (this.readIf("IMMEDIATE")) {
            return new ExecuteImmediate(this.session, this.readExpression());
        }
        ExecuteProcedure executeProcedure = new ExecuteProcedure(this.session);
        String string = this.readAliasIdentifier();
        Procedure procedure = this.session.getProcedure(string);
        if (procedure == null) {
            throw DbException.get(90077, string);
        }
        executeProcedure.setProcedure(procedure);
        if (this.readIf(85)) {
            int n = 0;
            while (true) {
                executeProcedure.setExpression(n, this.readExpression());
                if (!this.readIfMore()) break;
                ++n;
            }
        }
        return executeProcedure;
    }

    private Prepared parseExecuteSQLServer() {
        FunctionAlias functionAlias;
        Expression[] expressionArray;
        Call call = new Call(this.session);
        this.currentPrepared = call;
        String string = null;
        String string2 = this.readColumnIdentifier();
        if (this.readIf(90)) {
            string = string2;
            string2 = this.readColumnIdentifier();
            if (this.readIf(90)) {
                this.checkDatabaseName(string);
                string = string2;
                string2 = this.readColumnIdentifier();
            }
        }
        if (string != null) {
            expressionArray = this.database.getSchema(string);
            functionAlias = expressionArray.findFunction(string2);
        } else {
            functionAlias = this.findFunctionAlias(this.session.getCurrentSchemaName(), string2);
        }
        if (functionAlias == null) {
            throw DbException.get(90022, string2);
        }
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        if (this.currentTokenType != 95 && this.currentTokenType != 73) {
            do {
                arrayList.add(this.readExpression());
            } while (this.readIf(89));
        }
        expressionArray = arrayList.toArray(new Expression[0]);
        call.setExpression(new JavaFunction(functionAlias, expressionArray));
        return call;
    }

    private DeallocateProcedure parseDeallocate() {
        this.readIf("PLAN");
        String string = this.readAliasIdentifier();
        DeallocateProcedure deallocateProcedure = new DeallocateProcedure(this.session);
        deallocateProcedure.setProcedureName(string);
        return deallocateProcedure;
    }

    private Explain parseExplain() {
        Explain explain = new Explain(this.session);
        if (this.readIf("ANALYZE")) {
            explain.setExecuteCommand(true);
        } else if (this.readIf("PLAN")) {
            this.readIf(22);
        }
        switch (this.currentTokenType) {
            case 57: 
            case 59: 
            case 66: 
            case 69: 
            case 85: {
                Query query = this.parseQuery();
                query.setNeverLazy(true);
                explain.setCommand(query);
                break;
            }
            default: {
                int n = this.lastParseIndex;
                if (this.readIf("DELETE")) {
                    explain.setCommand(this.parseDelete(n));
                    break;
                }
                if (this.readIf("UPDATE")) {
                    explain.setCommand(this.parseUpdate(n));
                    break;
                }
                if (this.readIf("INSERT")) {
                    explain.setCommand(this.parseInsert(n));
                    break;
                }
                if (this.readIf("MERGE")) {
                    explain.setCommand(this.parseMerge(n));
                    break;
                }
                throw this.getSyntaxError();
            }
        }
        return explain;
    }

    private Query parseQuery() {
        int n = this.parameters.size();
        Query query = this.parseSelectUnion();
        int n2 = this.parameters.size();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>(n2);
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.parameters.get(i));
        }
        query.setParameterList(arrayList);
        query.init();
        return query;
    }

    private Prepared parseWithStatementOrQuery(int n) {
        int n2 = this.parameters.size();
        Prepared prepared = this.parseWith();
        int n3 = this.parameters.size();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>(n3);
        for (int i = n2; i < n3; ++i) {
            arrayList.add(this.parameters.get(i));
        }
        prepared.setParameterList(arrayList);
        if (prepared instanceof Query) {
            Query query = (Query)prepared;
            query.init();
        }
        this.setSQL(prepared, n);
        return prepared;
    }

    private Query parseSelectUnion() {
        int n = this.lastParseIndex;
        Query query = this.parseQuerySub();
        while (true) {
            SelectUnion.UnionType unionType;
            if (this.readIf(61)) {
                if (this.readIf(3)) {
                    unionType = SelectUnion.UnionType.UNION_ALL;
                } else {
                    this.readIf(17);
                    unionType = SelectUnion.UnionType.UNION;
                }
            } else if (this.readIf(18) || this.readIf(42)) {
                unionType = SelectUnion.UnionType.EXCEPT;
            } else {
                if (!this.readIf(31)) break;
                unionType = SelectUnion.UnionType.INTERSECT;
            }
            query = new SelectUnion(this.session, unionType, query, this.parseQuerySub());
        }
        this.parseEndOfQuery(query);
        this.setSQL(query, n);
        return query;
    }

    private void parseEndOfQuery(Query query) {
        Object object;
        Select select;
        if (this.readIf(50)) {
            this.read("BY");
            select = this.currentSelect;
            if (query instanceof Select) {
                this.currentSelect = (Select)query;
            }
            ArrayList<SelectOrderBy> arrayList = Utils.newSmallArrayList();
            do {
                boolean bl = !this.readIf(75);
                object = new SelectOrderBy();
                Expression expression = this.readExpression();
                if (bl && expression instanceof ValueExpression && expression.getType().getValueType() == 4) {
                    ((SelectOrderBy)object).columnIndexExpr = expression;
                } else if (expression instanceof Parameter) {
                    this.recompileAlways = true;
                    ((SelectOrderBy)object).columnIndexExpr = expression;
                } else {
                    ((SelectOrderBy)object).expression = expression;
                }
                ((SelectOrderBy)object).sortType = this.parseSortType();
                arrayList.add((SelectOrderBy)object);
            } while (this.readIf(89));
            query.setOrder(arrayList);
            this.currentSelect = select;
        }
        if (query.getLimit() == null) {
            select = this.currentSelect;
            this.currentSelect = null;
            boolean bl = false;
            if (this.readIf(48)) {
                bl = true;
                query.setOffset(this.readExpression().optimize(this.session));
                if (!this.readIf(54)) {
                    this.readIf("ROWS");
                }
            }
            if (this.readIf(21)) {
                bl = true;
                if (!this.readIf("FIRST")) {
                    this.read("NEXT");
                }
                if (this.readIf(54) || this.readIf("ROWS")) {
                    query.setLimit(ValueExpression.get(ValueInteger.get(1)));
                } else {
                    Expression expression = this.readExpression().optimize(this.session);
                    query.setLimit(expression);
                    if (this.readIf("PERCENT")) {
                        query.setFetchPercent(true);
                    }
                    if (!this.readIf(54)) {
                        this.read("ROWS");
                    }
                }
                if (this.readIf(69)) {
                    this.read("TIES");
                    query.setWithTies(true);
                } else {
                    this.read("ONLY");
                }
            }
            if (!bl && this.readIf(39)) {
                Expression expression = this.readExpression().optimize(this.session);
                query.setLimit(expression);
                if (this.readIf(48)) {
                    object = this.readExpression().optimize(this.session);
                    query.setOffset((Expression)object);
                } else if (this.readIf(89)) {
                    object = expression;
                    expression = this.readExpression().optimize(this.session);
                    query.setOffset((Expression)object);
                    query.setLimit(expression);
                }
            }
            this.currentSelect = select;
        }
        if (this.readIf(22)) {
            if (this.readIf("UPDATE")) {
                if (this.readIf("OF")) {
                    do {
                        this.readIdentifierWithSchema();
                    } while (this.readIf(89));
                } else if (this.readIf("NOWAIT")) {
                    // empty if block
                }
                query.setForUpdate(true);
            } else if (this.readIf("READ") || this.readIf(21)) {
                this.read("ONLY");
            }
        }
        if (this.database.getMode().isolationLevelInSelectOrInsertStatement) {
            this.parseIsolationClause();
        }
    }

    private void parseIsolationClause() {
        if (this.readIf(69)) {
            if (this.readIf("RR") || this.readIf("RS")) {
                if (this.readIf("USE")) {
                    this.read("AND");
                    this.read("KEEP");
                    if (this.readIf("SHARE") || this.readIf("UPDATE") || this.readIf("EXCLUSIVE")) {
                        // empty if block
                    }
                    this.read("LOCKS");
                }
            } else if (this.readIf("CS") || this.readIf("UR")) {
                // empty if block
            }
        }
    }

    private Query parseQuerySub() {
        if (this.readIf(85)) {
            Query query = this.parseSelectUnion();
            this.read(86);
            return query;
        }
        if (this.readIf(69)) {
            Query query;
            try {
                query = (Query)this.parseWith();
            }
            catch (ClassCastException classCastException) {
                throw DbException.get(42000, "WITH statement supports only SELECT (query) in this context");
            }
            query.setNeverLazy(true);
            return query;
        }
        int n = this.lastParseIndex;
        if (this.readIf(57)) {
            return this.parseSelect(n);
        }
        if (this.readIf(59)) {
            return this.parseExplicitTable(n);
        }
        this.read(66);
        return this.parseValues();
    }

    private void parseSelectFromPart(Select select) {
        do {
            TableFilter tableFilter = this.readTableFilter();
            this.parseJoinTableFilter(tableFilter, select);
        } while (this.readIf(89));
        if (this.session.isForceJoinOrder()) {
            select.getTopFilters().sort(TABLE_FILTER_COMPARATOR);
        }
    }

    private void parseJoinTableFilter(TableFilter tableFilter2, Select select) {
        tableFilter2 = this.readJoin(tableFilter2);
        select.addTableFilter(tableFilter2, true);
        boolean bl = false;
        while (true) {
            TableFilter tableFilter3;
            TableFilter tableFilter4;
            if ((tableFilter4 = tableFilter2.getNestedJoin()) != null) {
                tableFilter4.visit(tableFilter -> select.addTableFilter(tableFilter, false));
            }
            if ((tableFilter3 = tableFilter2.getJoin()) == null) break;
            if (bl |= tableFilter3.isJoinOuter()) {
                select.addTableFilter(tableFilter3, false);
            } else {
                Expression expression = tableFilter3.getJoinCondition();
                if (expression != null) {
                    select.addCondition(expression);
                }
                tableFilter3.removeJoinCondition();
                tableFilter2.removeJoin();
                select.addTableFilter(tableFilter3, true);
            }
            tableFilter2 = tableFilter3;
        }
    }

    private void parseSelectExpressions(Select select) {
        Expression expression;
        ArrayList<Expression> arrayList;
        Select select2 = this.currentSelect;
        this.currentSelect = null;
        if (this.readIf("TOP")) {
            arrayList = this.readTerm().optimize(this.session);
            select.setLimit((Expression)((Object)arrayList));
            if (this.readIf("PERCENT")) {
                select.setFetchPercent(true);
            }
            if (this.readIf(69)) {
                this.read("TIES");
                select.setWithTies(true);
            }
        } else if (this.readIf(39)) {
            arrayList = this.readTerm().optimize(this.session);
            select.setOffset((Expression)((Object)arrayList));
            expression = this.readTerm().optimize(this.session);
            select.setLimit(expression);
        }
        this.currentSelect = select2;
        if (this.readIf(17)) {
            if (this.readIf(49)) {
                this.read(85);
                arrayList = Utils.newSmallArrayList();
                do {
                    arrayList.add(this.readExpression());
                } while (this.readIfMore());
                select.setDistinct(arrayList.toArray(new Expression[0]));
            } else {
                select.setDistinct();
            }
        } else {
            this.readIf(3);
        }
        arrayList = Utils.newSmallArrayList();
        do {
            if (this.readIf(88)) {
                arrayList.add(this.parseWildcard(null, null));
                continue;
            }
            switch (this.currentTokenType) {
                case 21: 
                case 24: 
                case 26: 
                case 27: 
                case 48: 
                case 50: 
                case 52: 
                case 67: 
                case 68: 
                case 73: 
                case 95: {
                    break;
                }
                default: {
                    expression = this.readExpression();
                    if (this.readIf(5) || this.isIdentifier()) {
                        String string = this.readAliasIdentifier();
                        boolean bl = this.database.getSettings().aliasColumnName;
                        expression = new Alias(expression, string, bl |= this.database.getMode().aliasColumnName);
                    }
                    arrayList.add(expression);
                }
            }
        } while (this.readIf(89));
        select.setExpressions(arrayList);
    }

    private Select parseSelect(int n) {
        Object object;
        Select select = new Select(this.session, this.currentSelect);
        Select select2 = this.currentSelect;
        Prepared prepared = this.currentPrepared;
        this.currentSelect = select;
        this.currentPrepared = select;
        this.parseSelectExpressions(select);
        if (!this.readIf(24)) {
            object = new TableFilter(this.session, new DualTable(this.database), null, this.rightsChecked, this.currentSelect, 0, null);
            select.addTableFilter((TableFilter)object, true);
        } else {
            this.parseSelectFromPart(select);
        }
        if (this.readIf(67)) {
            select.addCondition(this.readExpressionWithGlobalConditions());
        }
        this.currentSelect = select2;
        if (this.readIf(26)) {
            this.read("BY");
            select.setGroupQuery();
            object = Utils.newSmallArrayList();
            do {
                if (this.isToken(85) && this.isOrdinaryGroupingSet()) {
                    if (this.readIf(86)) continue;
                    do {
                        ((ArrayList)object).add(this.readExpression());
                    } while (this.readIfMore());
                    continue;
                }
                ((ArrayList)object).add(this.readExpression());
            } while (this.readIf(89));
            if (!((ArrayList)object).isEmpty()) {
                select.setGroupBy((ArrayList<Expression>)object);
            }
        }
        this.currentSelect = select;
        if (this.readIf(27)) {
            select.setGroupQuery();
            select.setHaving(this.readExpressionWithGlobalConditions());
        }
        if (this.readIf(68)) {
            do {
                int n2 = this.parseIndex;
                String string = this.readAliasIdentifier();
                this.read(5);
                Window window = this.readWindowSpecification();
                if (this.currentSelect.addWindow(string, window)) continue;
                throw DbException.getSyntaxError(this.sqlCommand, n2, "unique identifier");
            } while (this.readIf(89));
        }
        if (this.readIf(52)) {
            select.setWindowQuery();
            select.setQualify(this.readExpressionWithGlobalConditions());
        }
        select.setParameterList(this.parameters);
        this.currentSelect = select2;
        this.currentPrepared = prepared;
        this.setSQL(select, n);
        return select;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isOrdinaryGroupingSet() {
        int n = this.lastParseIndex;
        int n2 = this.parseIndex;
        int n3 = 1;
        block8: while (true) {
            this.read();
            switch (this.currentTokenType) {
                case 86: {
                    if (--n3 > 0) break;
                    break block8;
                }
                case 85: {
                    ++n3;
                    break;
                }
                case 73: {
                    this.addExpected(86);
                    throw this.getSyntaxError();
                }
            }
        }
        this.read();
        switch (this.currentTokenType) {
            case 18: 
            case 21: 
            case 22: 
            case 27: 
            case 31: 
            case 39: 
            case 42: 
            case 48: 
            case 50: 
            case 52: 
            case 61: 
            case 68: 
            case 73: 
            case 86: 
            case 89: 
            case 95: {
                this.parseIndex = n2;
                this.read();
                return true;
            }
        }
        this.parseIndex = n;
        this.read();
        return false;
    }

    private Query parseExplicitTable(int n) {
        Table table = this.readTableOrView();
        Select select = new Select(this.session, this.currentSelect);
        TableFilter tableFilter = new TableFilter(this.session, table, null, this.rightsChecked, select, this.orderInFrom++, null);
        select.addTableFilter(tableFilter, true);
        select.setExplicitTable();
        this.setSQL(select, n);
        return select;
    }

    private void setSQL(Prepared prepared, int n) {
        prepared.setSQL(StringUtils.trimSubstring(this.originalSQL, n, this.lastParseIndex));
    }

    private Expression readExpressionOrDefault() {
        if (this.readIf("DEFAULT")) {
            return ValueExpression.DEFAULT;
        }
        return this.readExpression();
    }

    private Expression readExpressionWithGlobalConditions() {
        Expression expression = this.readCondition();
        if (this.readIf("AND")) {
            expression = this.readAnd(new ConditionAndOr(0, expression, this.readCondition()));
        } else if (this.readIf("_LOCAL_AND_GLOBAL_")) {
            expression = this.readAnd(new ConditionLocalAndGlobal(expression, this.readCondition()));
        }
        while (this.readIf("OR")) {
            expression = new ConditionAndOr(1, expression, this.readAnd(this.readCondition()));
        }
        return expression;
    }

    private Expression readExpression() {
        Expression expression = this.readAnd(this.readCondition());
        while (this.readIf("OR")) {
            expression = new ConditionAndOr(1, expression, this.readAnd(this.readCondition()));
        }
        return expression;
    }

    private Expression readAnd(Expression expression) {
        while (this.readIf("AND")) {
            expression = new ConditionAndOr(0, expression, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() {
        switch (this.currentTokenType) {
            case 46: {
                this.read();
                return new ConditionNot(this.readCondition());
            }
            case 19: {
                this.read();
                this.read(85);
                Query query = this.parseQuery();
                this.read(86);
                return new ExistsPredicate(query);
            }
            case 32: {
                this.read();
                this.read(85);
                Expression expression = this.readConcat();
                this.read(89);
                Expression expression2 = this.readConcat();
                this.read(86);
                return new Comparison(9, expression, expression2);
            }
            case 62: {
                this.read();
                this.read(85);
                Query query = this.parseQuery();
                this.read(86);
                return new UniquePredicate(query);
            }
        }
        if (this.expectedList != null) {
            this.addMultipleExpected(46, 19, 32, 62);
        }
        Expression expression = this.readConcat();
        while (true) {
            Object object;
            int n = this.parseIndex;
            boolean bl = this.readIf(46);
            if (bl && this.isToken(47)) {
                this.parseIndex = n;
                this.currentToken = "NOT";
                this.currentTokenType = 46;
                break;
            }
            if (this.readIf(38)) {
                Expression expression3 = this.readConcat();
                Expression expression4 = null;
                if (this.readIf("ESCAPE")) {
                    expression4 = this.readConcat();
                }
                this.recompileAlways = true;
                expression = new CompareLike(this.database, expression, expression3, expression4, false);
            } else if (this.readIf("ILIKE")) {
                Function function = Function.getFunctionWithArgs(this.database, 203, expression);
                function.setDataType(TypeInfo.TYPE_VARCHAR_IGNORECASE);
                expression = function;
                Expression expression5 = this.readConcat();
                object = null;
                if (this.readIf("ESCAPE")) {
                    object = this.readConcat();
                }
                this.recompileAlways = true;
                expression = new CompareLike(this.database, expression, expression5, (Expression)object, false);
            } else if (this.readIf("REGEXP")) {
                Expression expression6 = this.readConcat();
                this.recompileAlways = true;
                expression = new CompareLike(this.database, expression, expression6, null, true);
            } else if (this.readIf(34)) {
                boolean bl2 = this.readIf(46);
                switch (this.currentTokenType) {
                    case 47: {
                        this.read();
                        expression = new NullPredicate(expression, bl2);
                        break;
                    }
                    case 17: {
                        this.read();
                        this.read(24);
                        expression = new Comparison(bl2 ? 16 : 21, expression, this.readConcat());
                        break;
                    }
                    case 60: {
                        this.read();
                        expression = new BooleanTest(expression, bl2, true);
                        break;
                    }
                    case 20: {
                        this.read();
                        expression = new BooleanTest(expression, bl2, false);
                        break;
                    }
                    case 63: {
                        this.read();
                        expression = new BooleanTest(expression, bl2, null);
                        break;
                    }
                    default: {
                        if (this.readIf("OF")) {
                            expression = this.readTypePredicate(expression, bl2);
                            break;
                        }
                        if (this.readIf("JSON")) {
                            expression = this.readJsonPredicate(expression, bl2);
                            break;
                        }
                        if (this.expectedList != null) {
                            this.addMultipleExpected(47, 17, 60, 20, 63);
                        }
                        if (!this.database.isStarting()) {
                            throw this.getSyntaxError();
                        }
                        expression = new Comparison(bl2 ? 21 : 16, expression, this.readConcat());
                        break;
                    }
                }
            } else if (this.readIf("IN")) {
                expression = this.readInPredicate(expression);
            } else if (this.readIf("BETWEEN")) {
                Expression expression7 = this.readConcat();
                this.read("AND");
                Expression expression8 = this.readConcat();
                object = new Comparison(3, expression7, expression);
                Comparison comparison = new Comparison(1, expression8, expression);
                expression = new ConditionAndOr(0, (Expression)object, comparison);
            } else {
                if (bl) {
                    throw this.getSyntaxError();
                }
                int n2 = Parser.getCompareType(this.currentTokenType);
                if (n2 < 0) break;
                this.read();
                int n3 = this.lastParseIndex;
                if (this.readIf(3)) {
                    this.read(85);
                    if (this.isQuery()) {
                        object = this.parseQuery();
                        expression = new ConditionInQuery(expression, (Query)object, true, n2);
                        this.read(86);
                    } else {
                        this.parseIndex = n3;
                        this.read();
                        expression = new Comparison(n2, expression, this.readConcat());
                    }
                } else if (this.readIf("ANY") || this.readIf("SOME")) {
                    this.read(85);
                    if (this.currentTokenType == 72 && n2 == 0) {
                        object = this.readParameter();
                        expression = new ConditionInParameter(expression, (Parameter)object);
                        this.read(86);
                    } else if (this.isQuery()) {
                        object = this.parseQuery();
                        expression = new ConditionInQuery(expression, (Query)object, false, n2);
                        this.read(86);
                    } else {
                        this.parseIndex = n3;
                        this.read();
                        expression = new Comparison(n2, expression, this.readConcat());
                    }
                } else {
                    expression = new Comparison(n2, expression, this.readConcat());
                }
            }
            if (!bl) continue;
            expression = new ConditionNot(expression);
        }
        return expression;
    }

    private TypePredicate readTypePredicate(Expression expression, boolean bl) {
        this.read(85);
        ArrayList<TypeInfo> arrayList = Utils.newSmallArrayList();
        do {
            arrayList.add(this.parseColumnWithType(null).getType());
        } while (this.readIfMore());
        return new TypePredicate(expression, bl, arrayList.toArray(new TypeInfo[0]));
    }

    private Expression readInPredicate(Expression expression) {
        ArrayList<Expression> arrayList;
        this.read(85);
        if (this.database.getMode().allowEmptyInPredicate && this.readIf(86)) {
            return ValueExpression.FALSE;
        }
        if (this.isQuery()) {
            Query query = this.parseQuery();
            if (!this.readIfMore()) {
                return new ConditionInQuery(expression, query, false, 0);
            }
            arrayList = Utils.newSmallArrayList();
            arrayList.add(new Subquery(query));
        } else {
            arrayList = Utils.newSmallArrayList();
        }
        do {
            arrayList.add(this.readExpression());
        } while (this.readIfMore());
        return new ConditionIn(expression, arrayList);
    }

    private IsJsonPredicate readJsonPredicate(Expression expression, boolean bl) {
        JSONItemType jSONItemType = this.readIf(65) ? JSONItemType.VALUE : (this.readIf(4) ? JSONItemType.ARRAY : (this.readIf("OBJECT") ? JSONItemType.OBJECT : (this.readIf("SCALAR") ? JSONItemType.SCALAR : JSONItemType.VALUE)));
        boolean bl2 = false;
        if (this.readIf(69)) {
            this.read(62);
            this.readIf("KEYS");
            bl2 = true;
        } else if (this.readIf("WITHOUT")) {
            this.read(62);
            this.readIf("KEYS");
        }
        return new IsJsonPredicate(expression, bl, bl2, jSONItemType);
    }

    private Expression readConcat() {
        Expression expression = this.readSum();
        while (true) {
            Function function;
            if (this.readIf(84)) {
                expression = new ConcatenationOperation(expression, this.readSum());
                continue;
            }
            if (this.readIf(99)) {
                if (this.readIf(88)) {
                    function = Function.getFunctionWithArgs(this.database, 203, expression);
                    function.setDataType(TypeInfo.TYPE_VARCHAR_IGNORECASE);
                    expression = function;
                }
                expression = new CompareLike(this.database, expression, this.readSum(), null, true);
                continue;
            }
            if (!this.readIf(102)) break;
            if (this.readIf(88)) {
                function = Function.getFunctionWithArgs(this.database, 203, expression);
                function.setDataType(TypeInfo.TYPE_VARCHAR_IGNORECASE);
                expression = function;
            }
            expression = new ConditionNot(new CompareLike(this.database, expression, this.readSum(), null, true));
        }
        return expression;
    }

    private Expression readSum() {
        Expression expression = this.readFactor();
        while (true) {
            if (this.readIf(83)) {
                expression = new BinaryOperation(BinaryOperation.OpType.PLUS, expression, this.readFactor());
                continue;
            }
            if (!this.readIf(82)) break;
            expression = new BinaryOperation(BinaryOperation.OpType.MINUS, expression, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() {
        Expression expression = this.readTerm();
        while (true) {
            if (this.readIf(88)) {
                expression = new BinaryOperation(BinaryOperation.OpType.MULTIPLY, expression, this.readTerm());
                continue;
            }
            if (this.readIf(93)) {
                expression = new BinaryOperation(BinaryOperation.OpType.DIVIDE, expression, this.readTerm());
                continue;
            }
            if (!this.readIf(94)) break;
            expression = new BinaryOperation(BinaryOperation.OpType.MODULUS, expression, this.readTerm());
        }
        return expression;
    }

    private Expression readAggregate(AggregateType aggregateType, String string) {
        Aggregate aggregate;
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        switch (aggregateType) {
            case COUNT: {
                if (this.readIf(88)) {
                    aggregate = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.currentSelect, false);
                    break;
                }
                boolean bl = this.readDistinctAgg();
                Expression expression = this.readExpression();
                if (expression instanceof Wildcard && !bl) {
                    aggregate = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.currentSelect, false);
                    break;
                }
                aggregate = new Aggregate(AggregateType.COUNT, new Expression[]{expression}, this.currentSelect, bl);
                break;
            }
            case HISTOGRAM: {
                aggregate = new Aggregate(aggregateType, new Expression[]{this.readExpression()}, this.currentSelect, false);
                break;
            }
            case LISTAGG: {
                Expression[] expressionArray;
                ArrayList<SelectOrderBy> arrayList;
                boolean bl = this.readDistinctAgg();
                Expression expression = this.readExpression();
                Expression expression2 = null;
                if (this.equalsToken("STRING_AGG", string)) {
                    this.read(89);
                    expression2 = this.readExpression();
                    arrayList = this.readIfOrderBy();
                } else if (this.equalsToken("GROUP_CONCAT", string)) {
                    arrayList = this.readIfOrderBy();
                    if (this.readIf("SEPARATOR")) {
                        expression2 = this.readExpression();
                    }
                } else {
                    if (this.readIf(89)) {
                        expression2 = this.readExpression();
                    }
                    if (this.readIf(49)) {
                        this.read("OVERFLOW");
                        this.read("ERROR");
                    }
                    arrayList = null;
                }
                if (expression2 == null) {
                    Expression[] expressionArray2 = new Expression[1];
                    expressionArray = expressionArray2;
                    expressionArray2[0] = expression;
                } else {
                    Expression[] expressionArray3 = new Expression[2];
                    expressionArray3[0] = expression;
                    expressionArray = expressionArray3;
                    expressionArray3[1] = expression2;
                }
                Expression[] expressionArray4 = expressionArray;
                int n = this.lastParseIndex;
                this.read(86);
                if (arrayList == null && this.isToken("WITHIN")) {
                    aggregate = this.readWithinGroup(aggregateType, expressionArray4, bl, false, false);
                    break;
                }
                this.parseIndex = n;
                this.read();
                aggregate = new Aggregate(AggregateType.LISTAGG, expressionArray4, this.currentSelect, bl);
                if (arrayList == null) break;
                aggregate.setOrderByList(arrayList);
                break;
            }
            case ARRAY_AGG: {
                boolean bl = this.readDistinctAgg();
                aggregate = new Aggregate(AggregateType.ARRAY_AGG, new Expression[]{this.readExpression()}, this.currentSelect, bl);
                aggregate.setOrderByList(this.readIfOrderBy());
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                if (this.isToken(86)) {
                    return this.readWindowFunction(string);
                }
                ArrayList<Expression> arrayList = Utils.newSmallArrayList();
                do {
                    arrayList.add(this.readExpression());
                } while (this.readIfMore());
                aggregate = this.readWithinGroup(aggregateType, arrayList.toArray(new Expression[0]), false, true, false);
                break;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                Expression expression = this.readExpression();
                this.read(86);
                aggregate = this.readWithinGroup(aggregateType, new Expression[]{expression}, false, false, true);
                break;
            }
            case MODE: {
                if (this.readIf(86)) {
                    aggregate = this.readWithinGroup(AggregateType.MODE, new Expression[0], false, false, true);
                    break;
                }
                Expression expression = this.readExpression();
                aggregate = new Aggregate(AggregateType.MODE, new Expression[0], this.currentSelect, false);
                if (this.readIf(50)) {
                    this.read("BY");
                    Expression expression3 = this.readExpression();
                    String string2 = expression.getSQL(0);
                    String string3 = expression3.getSQL(0);
                    if (!string2.equals(string3)) {
                        throw DbException.getSyntaxError(42131, this.sqlCommand, this.lastParseIndex, string2, string3);
                    }
                    this.readAggregateOrder(aggregate, expression, true);
                    break;
                }
                this.readAggregateOrder(aggregate, expression, false);
                break;
            }
            case JSON_OBJECTAGG: {
                boolean bl = this.readIf(36);
                Expression expression = this.readExpression();
                if (bl) {
                    this.read(65);
                } else if (!this.readIf(65)) {
                    this.read(96);
                }
                Expression expression4 = this.readExpression();
                aggregate = new Aggregate(AggregateType.JSON_OBJECTAGG, new Expression[]{expression, expression4}, this.currentSelect, false);
                this.readJsonObjectFunctionFlags(aggregate, false);
                break;
            }
            case JSON_ARRAYAGG: {
                aggregate = new Aggregate(AggregateType.JSON_ARRAYAGG, new Expression[]{this.readExpression()}, this.currentSelect, false);
                aggregate.setOrderByList(this.readIfOrderBy());
                aggregate.setFlags(1);
                this.readJsonObjectFunctionFlags(aggregate, true);
                break;
            }
            default: {
                boolean bl = this.readDistinctAgg();
                aggregate = new Aggregate(aggregateType, new Expression[]{this.readExpression()}, this.currentSelect, bl);
            }
        }
        this.read(86);
        this.readFilterAndOver(aggregate);
        return aggregate;
    }

    private Aggregate readWithinGroup(AggregateType aggregateType, Expression[] expressionArray, boolean bl, boolean bl2, boolean bl3) {
        this.read("WITHIN");
        this.read(26);
        this.read(85);
        this.read(50);
        this.read("BY");
        Aggregate aggregate = new Aggregate(aggregateType, expressionArray, this.currentSelect, bl);
        if (bl2) {
            int n = expressionArray.length;
            ArrayList<SelectOrderBy> arrayList = new ArrayList<SelectOrderBy>(n);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.read(89);
                }
                arrayList.add(this.parseSortSpecification());
            }
            aggregate.setOrderByList(arrayList);
        } else if (bl3) {
            this.readAggregateOrder(aggregate, this.readExpression(), true);
        } else {
            aggregate.setOrderByList(this.parseSortSpecificationList());
        }
        return aggregate;
    }

    private void readAggregateOrder(Aggregate aggregate, Expression expression, boolean bl) {
        ArrayList<SelectOrderBy> arrayList = new ArrayList<SelectOrderBy>(1);
        SelectOrderBy selectOrderBy = new SelectOrderBy();
        selectOrderBy.expression = expression;
        if (bl) {
            selectOrderBy.sortType = this.parseSortType();
        }
        arrayList.add(selectOrderBy);
        aggregate.setOrderByList(arrayList);
    }

    private ArrayList<SelectOrderBy> readIfOrderBy() {
        if (this.readIf(50)) {
            this.read("BY");
            return this.parseSortSpecificationList();
        }
        return null;
    }

    private ArrayList<SelectOrderBy> parseSortSpecificationList() {
        ArrayList<SelectOrderBy> arrayList = Utils.newSmallArrayList();
        do {
            arrayList.add(this.parseSortSpecification());
        } while (this.readIf(89));
        return arrayList;
    }

    private SelectOrderBy parseSortSpecification() {
        SelectOrderBy selectOrderBy = new SelectOrderBy();
        selectOrderBy.expression = this.readExpression();
        selectOrderBy.sortType = this.parseSortType();
        return selectOrderBy;
    }

    private JavaFunction readJavaFunction(Schema schema, String string, boolean bl) {
        FunctionAlias functionAlias = schema != null ? schema.findFunction(string) : this.findFunctionAlias(this.session.getCurrentSchemaName(), string);
        if (functionAlias == null) {
            if (bl) {
                throw DbException.get(90022, string);
            }
            return null;
        }
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        if (!this.readIf(86)) {
            do {
                arrayList.add(this.readExpression());
            } while (this.readIfMore());
        }
        return new JavaFunction(functionAlias, arrayList.toArray(new Expression[0]));
    }

    private JavaAggregate readJavaAggregate(UserAggregate userAggregate) {
        boolean bl = this.readDistinctAgg();
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        do {
            arrayList.add(this.readExpression());
        } while (this.readIfMore());
        Expression[] expressionArray = arrayList.toArray(new Expression[0]);
        JavaAggregate javaAggregate = new JavaAggregate(userAggregate, expressionArray, this.currentSelect, bl);
        this.readFilterAndOver(javaAggregate);
        return javaAggregate;
    }

    private boolean readDistinctAgg() {
        if (this.readIf(17)) {
            return true;
        }
        this.readIf(3);
        return false;
    }

    private void readFilterAndOver(AbstractAggregate abstractAggregate) {
        if (this.readIf("FILTER")) {
            this.read(85);
            this.read(67);
            Expression expression = this.readExpression();
            this.read(86);
            abstractAggregate.setFilterCondition(expression);
        }
        this.readOver(abstractAggregate);
    }

    private void readOver(DataAnalysisOperation dataAnalysisOperation) {
        if (this.readIf("OVER")) {
            dataAnalysisOperation.setOverCondition(this.readWindowNameOrSpecification());
            this.currentSelect.setWindowQuery();
        } else if (dataAnalysisOperation.isAggregate()) {
            this.currentSelect.setGroupQuery();
        } else {
            throw this.getSyntaxError();
        }
    }

    private Window readWindowNameOrSpecification() {
        return this.isToken(85) ? this.readWindowSpecification() : new Window(this.readAliasIdentifier(), null, null, null);
    }

    private Window readWindowSpecification() {
        Object object;
        Object object2;
        this.read(85);
        String string = null;
        if (this.currentTokenType == 2) {
            object2 = this.currentToken;
            if (this.currentTokenQuoted || !this.equalsToken((String)object2, "PARTITION") && !this.equalsToken((String)object2, "ROWS") && !this.equalsToken((String)object2, "RANGE") && !this.equalsToken((String)object2, "GROUPS")) {
                string = object2;
                this.read();
            }
        }
        object2 = null;
        if (this.readIf("PARTITION")) {
            this.read("BY");
            object2 = Utils.newSmallArrayList();
            do {
                object = this.readExpression();
                ((ArrayList)object2).add(object);
            } while (this.readIf(89));
        }
        object = this.readIfOrderBy();
        WindowFrame windowFrame = this.readWindowFrame();
        this.read(86);
        return new Window(string, (ArrayList<Expression>)object2, (ArrayList<SelectOrderBy>)object, windowFrame);
    }

    private WindowFrame readWindowFrame() {
        WindowFrame windowFrame;
        WindowFrameBound windowFrameBound;
        WindowFrameBound windowFrameBound2;
        WindowFrameUnits windowFrameUnits;
        if (this.readIf("ROWS")) {
            windowFrameUnits = WindowFrameUnits.ROWS;
        } else if (this.readIf("RANGE")) {
            windowFrameUnits = WindowFrameUnits.RANGE;
        } else if (this.readIf("GROUPS")) {
            windowFrameUnits = WindowFrameUnits.GROUPS;
        } else {
            return null;
        }
        if (this.readIf("BETWEEN")) {
            windowFrameBound2 = this.readWindowFrameRange();
            this.read("AND");
            windowFrameBound = this.readWindowFrameRange();
        } else {
            windowFrameBound2 = this.readWindowFrameStarting();
            windowFrameBound = null;
        }
        int n = this.lastParseIndex;
        WindowFrameExclusion windowFrameExclusion = WindowFrameExclusion.EXCLUDE_NO_OTHERS;
        if (this.readIf("EXCLUDE")) {
            if (this.readIf("CURRENT")) {
                this.read(54);
                windowFrameExclusion = WindowFrameExclusion.EXCLUDE_CURRENT_ROW;
            } else if (this.readIf(26)) {
                windowFrameExclusion = WindowFrameExclusion.EXCLUDE_GROUP;
            } else if (this.readIf("TIES")) {
                windowFrameExclusion = WindowFrameExclusion.EXCLUDE_TIES;
            } else {
                this.read("NO");
                this.read("OTHERS");
            }
        }
        if (!(windowFrame = new WindowFrame(windowFrameUnits, windowFrameBound2, windowFrameBound, windowFrameExclusion)).isValid()) {
            throw DbException.getSyntaxError(this.sqlCommand, n);
        }
        return windowFrame;
    }

    private WindowFrameBound readWindowFrameStarting() {
        if (this.readIf("UNBOUNDED")) {
            this.read("PRECEDING");
            return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_PRECEDING, null);
        }
        if (this.readIf("CURRENT")) {
            this.read(54);
            return new WindowFrameBound(WindowFrameBoundType.CURRENT_ROW, null);
        }
        Expression expression = this.readExpression();
        this.read("PRECEDING");
        return new WindowFrameBound(WindowFrameBoundType.PRECEDING, expression);
    }

    private WindowFrameBound readWindowFrameRange() {
        if (this.readIf("UNBOUNDED")) {
            if (this.readIf("PRECEDING")) {
                return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_PRECEDING, null);
            }
            this.read("FOLLOWING");
            return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_FOLLOWING, null);
        }
        if (this.readIf("CURRENT")) {
            this.read(54);
            return new WindowFrameBound(WindowFrameBoundType.CURRENT_ROW, null);
        }
        Expression expression = this.readExpression();
        if (this.readIf("PRECEDING")) {
            return new WindowFrameBound(WindowFrameBoundType.PRECEDING, expression);
        }
        this.read("FOLLOWING");
        return new WindowFrameBound(WindowFrameBoundType.FOLLOWING, expression);
    }

    private AggregateType getAggregateType(String string) {
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        return Aggregate.getAggregateType(string);
    }

    private Expression readFunction(Schema schema, String string) {
        Object object;
        if (schema != null) {
            return this.readJavaFunction(schema, string, true);
        }
        boolean bl = this.database.isAllowBuiltinAliasOverride();
        if (bl && (object = this.readJavaFunction(null, string, false)) != null) {
            return object;
        }
        object = this.getAggregateType(string);
        if (object != null) {
            return this.readAggregate((AggregateType)((Object)object), string);
        }
        Function function = Function.getFunction(this.database, string);
        if (function == null) {
            WindowFunction windowFunction = this.readWindowFunction(string);
            if (windowFunction != null) {
                return windowFunction;
            }
            UserAggregate userAggregate = this.database.findAggregate(string);
            if (userAggregate != null) {
                return this.readJavaAggregate(userAggregate);
            }
            if (bl) {
                throw DbException.get(90022, string);
            }
            return this.readJavaFunction(null, string, true);
        }
        return this.readFunctionParameters(function);
    }

    private Function readFunctionParameters(Function function) {
        switch (function.getFunctionType()) {
            case 203: {
                function.addParameter(this.readExpression());
                this.read(5);
                function.setDataType(this.parseColumnWithType(null));
                this.read(86);
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    function.setDataType(this.parseColumnWithType(null));
                    this.read(89);
                    function.addParameter(this.readExpression());
                    this.read(86);
                    break;
                }
                function.addParameter(this.readExpression());
                this.read(89);
                function.setDataType(this.parseColumnWithType(null));
                this.read(86);
                break;
            }
            case 119: {
                function.addParameter(ValueExpression.get(ValueVarchar.get(this.currentToken)));
                this.read();
                this.read(24);
                function.addParameter(this.readExpression());
                this.read(86);
                break;
            }
            case 105: 
            case 106: {
                if (this.currentTokenType == 74) {
                    function.addParameter(ValueExpression.get(this.currentValue.convertTo(TypeInfo.TYPE_VARCHAR)));
                } else {
                    function.addParameter(ValueExpression.get(ValueVarchar.get(this.currentToken)));
                }
                this.read();
                this.read(89);
                function.addParameter(this.readExpression());
                this.read(89);
                function.addParameter(this.readExpression());
                this.read(86);
                break;
            }
            case 73: {
                function.addParameter(this.readExpression());
                if (this.readIf(24)) {
                    function.addParameter(this.readExpression());
                    if (this.readIf(22)) {
                        function.addParameter(this.readExpression());
                    }
                } else if (this.readIf(22)) {
                    function.addParameter(ValueExpression.get(ValueInteger.get(0)));
                    function.addParameter(this.readExpression());
                } else {
                    this.read(89);
                    function.addParameter(this.readExpression());
                    if (this.readIf(89)) {
                        function.addParameter(this.readExpression());
                    }
                }
                this.read(86);
                break;
            }
            case 77: {
                function.addParameter(this.readConcat());
                if (!this.readIf(89)) {
                    this.read("IN");
                }
                function.addParameter(this.readExpression());
                this.read(86);
                break;
            }
            case 78: {
                Expression expression;
                int n;
                boolean bl = false;
                if (this.readIf("LEADING")) {
                    n = 1;
                    bl = true;
                } else if (this.readIf("TRAILING")) {
                    n = 2;
                    bl = true;
                } else {
                    bl = this.readIf("BOTH");
                    n = 3;
                }
                Expression expression2 = null;
                function.setFlags(n);
                if (bl) {
                    if (!this.readIf(24)) {
                        expression2 = this.readExpression();
                        this.read(24);
                    }
                    expression = this.readExpression();
                } else if (this.readIf(24)) {
                    expression = this.readExpression();
                } else {
                    expression = this.readExpression();
                    if (this.readIf(24)) {
                        expression2 = expression;
                        expression = this.readExpression();
                    }
                }
                if (!bl && expression2 == null && this.readIf(89)) {
                    expression2 = this.readExpression();
                }
                function.addParameter(expression);
                if (expression2 != null) {
                    function.addParameter(expression2);
                }
                this.read(86);
                break;
            }
            case 223: 
            case 224: {
                Object object;
                ArrayList<Column> arrayList = Utils.newSmallArrayList();
                do {
                    object = this.readAliasIdentifier();
                    Column column = this.parseColumnWithType((String)object);
                    arrayList.add(column);
                    this.read(75);
                    function.addParameter(this.readExpression());
                } while (this.readIfMore());
                object = (TableFunction)function;
                ((TableFunction)object).setColumns(arrayList);
                break;
            }
            case 233: {
                ArrayList<Column> arrayList = Utils.newSmallArrayList();
                if (!this.readIf(86)) {
                    int n = 0;
                    do {
                        ExtTypeInfoArray extTypeInfoArray;
                        TypeInfo typeInfo;
                        Expression expression = this.readExpression();
                        TypeInfo typeInfo2 = TypeInfo.TYPE_NULL;
                        if (expression.isConstant() && (typeInfo = (expression = expression.optimize(this.session)).getType()).getValueType() == 17 && (extTypeInfoArray = (ExtTypeInfoArray)typeInfo.getExtTypeInfo()) != null) {
                            typeInfo2 = extTypeInfoArray.getComponentType();
                        }
                        function.addParameter(expression);
                        arrayList.add(new Column("C" + ++n, typeInfo2));
                    } while (this.readIfMore());
                }
                if (this.readIf(69)) {
                    this.read("ORDINALITY");
                    arrayList.add(new Column("NORD", 4));
                }
                TableFunction tableFunction = (TableFunction)function;
                tableFunction.setColumns(arrayList);
                break;
            }
            case 251: {
                if (!this.readJsonObjectFunctionFlags(function, false)) {
                    do {
                        boolean bl = this.readIf(36);
                        function.addParameter(this.readExpression());
                        if (bl) {
                            this.read(65);
                        } else if (!this.readIf(65)) {
                            this.read(96);
                        }
                        function.addParameter(this.readExpression());
                    } while (this.readIf(89));
                    this.readJsonObjectFunctionFlags(function, false);
                }
                this.read(86);
                break;
            }
            case 252: {
                function.setFlags(1);
                if (!this.readJsonObjectFunctionFlags(function, true)) {
                    do {
                        function.addParameter(this.readExpression());
                    } while (this.readIf(89));
                    this.readJsonObjectFunctionFlags(function, true);
                }
                this.read(86);
                break;
            }
            default: {
                if (this.readIf(86)) break;
                do {
                    function.addParameter(this.readExpression());
                } while (this.readIfMore());
            }
        }
        function.doneWithParameters();
        return function;
    }

    private WindowFunction readWindowFunction(String string) {
        WindowFunctionType windowFunctionType;
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((windowFunctionType = WindowFunctionType.get(string)) == null) {
            return null;
        }
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        int n = WindowFunction.getMinArgumentCount(windowFunctionType);
        Expression[] expressionArray = null;
        if (n > 0) {
            int n2 = WindowFunction.getMaxArgumentCount(windowFunctionType);
            expressionArray = new Expression[n2];
            if (n == n2) {
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        this.read(89);
                    }
                    expressionArray[i] = this.readExpression();
                }
            } else {
                int n3;
                for (n3 = 0; n3 < n2 && (n3 <= 0 || this.readIf(89)); ++n3) {
                    expressionArray[n3] = this.readExpression();
                }
                if (n3 < n) {
                    throw this.getSyntaxError();
                }
                if (n3 != n2) {
                    expressionArray = Arrays.copyOf(expressionArray, n3);
                }
            }
        }
        this.read(86);
        WindowFunction windowFunction = new WindowFunction(windowFunctionType, this.currentSelect, expressionArray);
        switch (windowFunctionType) {
            case NTH_VALUE: {
                this.readFromFirstOrLast(windowFunction);
            }
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: {
                this.readRespectOrIgnoreNulls(windowFunction);
            }
        }
        this.readOver(windowFunction);
        return windowFunction;
    }

    private void readFromFirstOrLast(WindowFunction windowFunction) {
        if (this.readIf(24) && !this.readIf("FIRST")) {
            this.read("LAST");
            windowFunction.setFromLast(true);
        }
    }

    private void readRespectOrIgnoreNulls(WindowFunction windowFunction) {
        if (this.readIf("RESPECT")) {
            this.read("NULLS");
        } else if (this.readIf("IGNORE")) {
            this.read("NULLS");
            windowFunction.setIgnoreNulls(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readJsonObjectFunctionFlags(ExpressionWithFlags expressionWithFlags, boolean bl) {
        int n = this.lastParseIndex;
        boolean bl2 = false;
        int n2 = expressionWithFlags.getFlags();
        if (this.readIf(47)) {
            if (!this.readIf(49)) {
                this.parseIndex = n;
                this.read();
                return false;
            }
            this.read(47);
            n2 &= 0xFFFFFFFE;
            bl2 = true;
        } else if (this.readIf("ABSENT")) {
            if (!this.readIf(49)) {
                this.parseIndex = n;
                this.read();
                return false;
            }
            this.read(47);
            n2 |= 1;
            bl2 = true;
        }
        if (!bl) {
            if (this.readIf(69)) {
                this.read(62);
                this.read("KEYS");
                n2 |= 2;
                bl2 = true;
            } else if (this.readIf("WITHOUT")) {
                if (this.readIf(62)) {
                    this.read("KEYS");
                    n2 &= 0xFFFFFFFD;
                    bl2 = true;
                } else {
                    if (bl2) {
                        throw this.getSyntaxError();
                    }
                    this.parseIndex = n;
                    this.read();
                    return false;
                }
            }
        }
        if (bl2) {
            expressionWithFlags.setFlags(n2);
        }
        return bl2;
    }

    private Expression readKeywordFunctionOrColumn(int n) {
        boolean bl = this.nonKeywords != null && this.nonKeywords.get(this.currentTokenType);
        String string = this.currentToken;
        this.read();
        if (this.isToken(85)) {
            return this.readKeywordFunction(n);
        }
        if (bl) {
            return this.readIf(90) ? this.readTermObjectDot(string) : new ExpressionColumn(this.database, null, null, string, false);
        }
        throw this.getSyntaxError();
    }

    private Expression readKeywordFunction(int n) {
        FunctionAlias functionAlias;
        Function function = Function.getFunction(this.database, n);
        if (this.readIf(85)) {
            this.readFunctionParameters(function);
        } else {
            function.doneWithParameters();
        }
        if (this.database.isAllowBuiltinAliasOverride() && (functionAlias = this.database.getSchema(this.session.getCurrentSchemaName()).findFunction(function.getName())) != null) {
            return new JavaFunction(functionAlias, function.getArgs());
        }
        return function;
    }

    private Expression readFunctionWithoutParameters(int n) {
        FunctionAlias functionAlias;
        Expression[] expressionArray = new Expression[]{};
        Function function = Function.getFunctionWithArgs(this.database, n, expressionArray);
        if (this.database.isAllowBuiltinAliasOverride() && (functionAlias = this.database.getSchema(this.session.getCurrentSchemaName()).findFunction(function.getName())) != null) {
            return new JavaFunction(functionAlias, expressionArray);
        }
        return function;
    }

    private Expression readWildcardRowidOrSequenceValue(String string, String string2) {
        Sequence sequence;
        if (this.readIf(88)) {
            return this.parseWildcard(string, string2);
        }
        if (this.readIf(71)) {
            return new ExpressionColumn(this.database, string, string2, "_ROWID_", true);
        }
        if (string == null) {
            string = this.session.getCurrentSchemaName();
        }
        if (this.readIf("NEXTVAL")) {
            Sequence sequence2 = this.findSequence(string, string2);
            if (sequence2 != null) {
                return new SequenceValue(sequence2, false);
            }
        } else if (this.readIf("CURRVAL") && (sequence = this.findSequence(string, string2)) != null) {
            return new SequenceValue(sequence, true);
        }
        return null;
    }

    private Wildcard parseWildcard(String string, String string2) {
        Wildcard wildcard = new Wildcard(string, string2);
        if (this.readIf(18)) {
            this.read(85);
            ArrayList<ExpressionColumn> arrayList = Utils.newSmallArrayList();
            do {
                String string3 = null;
                String string4 = null;
                String string5 = this.readColumnIdentifier();
                if (this.readIf(90)) {
                    string4 = string5;
                    string5 = this.readColumnIdentifier();
                    if (this.readIf(90)) {
                        string3 = string4;
                        string4 = string5;
                        string5 = this.readColumnIdentifier();
                        if (this.readIf(90)) {
                            this.checkDatabaseName(string3);
                            string3 = string4;
                            string4 = string5;
                            string5 = this.readColumnIdentifier();
                        }
                    }
                }
                arrayList.add(new ExpressionColumn(this.database, string3, string4, string5, false));
            } while (this.readIfMore());
            wildcard.setExceptColumns(arrayList);
        }
        return wildcard;
    }

    private Expression readTermObjectDot(String string) {
        Expression expression = this.readWildcardRowidOrSequenceValue(null, string);
        if (expression != null) {
            return expression;
        }
        String string2 = this.readColumnIdentifier();
        if (this.readIf(85)) {
            return this.readFunction(this.database.getSchema(string), string2);
        }
        if (this.readIf(90)) {
            String string3 = string;
            expression = this.readWildcardRowidOrSequenceValue(string3, string = string2);
            if (expression != null) {
                return expression;
            }
            string2 = this.readColumnIdentifier();
            if (this.readIf(85)) {
                this.checkDatabaseName(string3);
                return this.readFunction(this.database.getSchema(string), string2);
            }
            if (this.readIf(90)) {
                this.checkDatabaseName(string3);
                string3 = string;
                string = string2;
                expression = this.readWildcardRowidOrSequenceValue(string3, string);
                if (expression != null) {
                    return expression;
                }
                string2 = this.readColumnIdentifier();
            }
            return new ExpressionColumn(this.database, string3, string, string2, false);
        }
        return new ExpressionColumn(this.database, null, string, string2, false);
    }

    private void checkDatabaseName(String string) {
        if (!this.database.getIgnoreCatalogs() && !this.equalsToken(this.database.getShortName(), string)) {
            throw DbException.get(90013, string);
        }
    }

    private Parameter readParameter() {
        Parameter parameter;
        boolean bl = Character.isDigit(this.sqlCommandChars[this.parseIndex]);
        if (bl) {
            int n;
            this.readParameterIndex();
            if (this.indexedParameterList == null) {
                if (this.parameters == null) {
                    throw this.getSyntaxError();
                }
                if (!this.parameters.isEmpty()) {
                    throw DbException.get(90123);
                }
                this.indexedParameterList = Utils.newSmallArrayList();
            }
            if ((n = this.currentValue.getInt() - 1) < 0 || n >= 100000) {
                throw DbException.getInvalidValueException("parameter index", n + 1);
            }
            if (this.indexedParameterList.size() <= n) {
                this.indexedParameterList.ensureCapacity(n + 1);
                while (this.indexedParameterList.size() <= n) {
                    this.indexedParameterList.add(null);
                }
            }
            if ((parameter = this.indexedParameterList.get(n)) == null) {
                parameter = new Parameter(n);
                this.indexedParameterList.set(n, parameter);
                this.parameters.add(parameter);
            }
            this.read();
        } else {
            this.read();
            if (this.indexedParameterList != null) {
                throw DbException.get(90123);
            }
            parameter = new Parameter(this.parameters.size());
            this.parameters.add(parameter);
        }
        return parameter;
    }

    private Expression readTerm() {
        Object object;
        block69: {
            int n;
            Expression[] expressionArray;
            Object object2;
            switch (this.currentTokenType) {
                case 81: {
                    this.read();
                    object = new Variable(this.session, this.readAliasIdentifier());
                    if (!this.readIf(101)) break;
                    object2 = this.readExpression();
                    expressionArray = Function.getFunctionWithArgs(this.database, 222, new Expression[]{object, object2});
                    object = expressionArray;
                    break;
                }
                case 72: {
                    object = this.readParameter();
                    break;
                }
                case 57: 
                case 69: {
                    object = new Subquery(this.parseQuery());
                    break;
                }
                case 59: {
                    int n2 = this.lastParseIndex;
                    this.read();
                    if (this.readIf(85)) {
                        object = this.readFunctionParameters(Function.getFunction(this.database, 223));
                        break;
                    }
                    this.parseIndex = n2;
                    this.read();
                    object = new Subquery(this.parseQuery());
                    break;
                }
                case 82: {
                    this.read();
                    if (this.currentTokenType == 74) {
                        object = ValueExpression.get(this.currentValue.negate());
                        int n3 = ((Expression)object).getType().getValueType();
                        if (n3 == 5 && ((Expression)object).getValue(this.session).getLong() == Integer.MIN_VALUE) {
                            object = ValueExpression.get(ValueInteger.get(Integer.MIN_VALUE));
                        } else if (n3 == 6 && ((Expression)object).getValue(this.session).getBigDecimal().compareTo(Value.MIN_LONG_DECIMAL) == 0) {
                            object = ValueExpression.get(ValueBigint.MIN);
                        }
                        this.read();
                        break;
                    }
                    object = new UnaryOperation(this.readTerm());
                    break;
                }
                case 83: {
                    this.read();
                    object = this.readTerm();
                    break;
                }
                case 85: {
                    TypeInfo typeInfo;
                    this.read();
                    if (this.readIf(86)) {
                        object = ValueExpression.get(ValueRow.EMPTY);
                        break;
                    }
                    object = this.readExpression();
                    if (this.readIfMore()) {
                        expressionArray = Utils.newSmallArrayList();
                        expressionArray.add(object);
                        do {
                            expressionArray.add(this.readExpression());
                        } while (this.readIfMore());
                        object = new ExpressionList(expressionArray.toArray(new Expression[0]), false);
                        break;
                    }
                    if (!(object instanceof BinaryOperation) || (expressionArray = (BinaryOperation)object).getOperationType() != BinaryOperation.OpType.MINUS || (typeInfo = (TypeInfo)this.readIntervalQualifier(null, false)) == null) break;
                    expressionArray.setForcedType(typeInfo);
                    break;
                }
                case 4: {
                    this.read();
                    this.read(97);
                    if (this.readIf(98)) {
                        object = ValueExpression.get(ValueArray.EMPTY);
                        break;
                    }
                    expressionArray = Utils.newSmallArrayList();
                    do {
                        expressionArray.add(this.readExpression());
                    } while (this.readIf(89));
                    this.read(98);
                    object = new ExpressionList(expressionArray.toArray(new Expression[0]), true);
                    break;
                }
                case 33: {
                    this.read();
                    object = this.readInterval();
                    break;
                }
                case 54: {
                    this.read();
                    this.read(85);
                    if (this.readIf(86)) {
                        object = ValueExpression.get(ValueRow.EMPTY);
                        break;
                    }
                    expressionArray = Utils.newSmallArrayList();
                    do {
                        expressionArray.add(this.readExpression());
                    } while (this.readIfMore());
                    object = new ExpressionList(expressionArray.toArray(new Expression[0]), false);
                    break;
                }
                case 60: {
                    this.read();
                    object = ValueExpression.TRUE;
                    break;
                }
                case 20: {
                    this.read();
                    object = ValueExpression.FALSE;
                    break;
                }
                case 63: {
                    this.read();
                    object = TypedValueExpression.UNKNOWN;
                    break;
                }
                case 55: {
                    this.read();
                    if (this.readIf(85)) {
                        this.read(86);
                    }
                    if (this.currentSelect == null && this.currentPrepared == null) {
                        throw this.getSyntaxError();
                    }
                    object = new Rownum(this.currentSelect == null ? this.currentPrepared : this.currentSelect);
                    break;
                }
                case 47: {
                    this.read();
                    object = ValueExpression.NULL;
                    break;
                }
                case 71: {
                    this.read();
                    object = new ExpressionColumn(this.database, null, null, "_ROWID_", true);
                    break;
                }
                case 74: {
                    if (this.currentValue.getValueType() == 13) {
                        object = ValueExpression.get(this.readCharacterStringLiteral());
                        break;
                    }
                    object = ValueExpression.get(this.currentValue);
                    this.read();
                    break;
                }
                case 66: {
                    if (this.database.getMode().onDuplicateKeyUpdate) {
                        this.read();
                        object = this.readKeywordFunction(250);
                        break;
                    }
                    object = new Subquery(this.parseQuery());
                    break;
                }
                case 6: {
                    this.read();
                    object = this.readCase();
                    break;
                }
                case 10: {
                    this.read();
                    object = this.readKeywordFunction(150);
                    break;
                }
                case 11: {
                    this.read();
                    object = this.readKeywordFunction(100);
                    break;
                }
                case 12: {
                    this.read();
                    object = this.readKeywordFunction(215);
                    break;
                }
                case 13: {
                    this.read();
                    object = this.readKeywordFunction(101);
                    break;
                }
                case 14: {
                    this.read();
                    object = this.readKeywordFunction(103);
                    break;
                }
                case 15: {
                    this.read();
                    object = this.readKeywordFunction(152);
                    break;
                }
                case 16: {
                    object = this.readKeywordFunctionOrColumn(108);
                    break;
                }
                case 28: {
                    object = this.readKeywordFunctionOrColumn(111);
                    break;
                }
                case 37: {
                    object = this.readKeywordFunctionOrColumn(60);
                    break;
                }
                case 40: {
                    this.read();
                    object = this.readKeywordFunction(102);
                    break;
                }
                case 41: {
                    this.read();
                    object = this.readKeywordFunction(104);
                    break;
                }
                case 43: {
                    object = this.readKeywordFunctionOrColumn(112);
                    break;
                }
                case 44: {
                    object = this.readKeywordFunctionOrColumn(113);
                    break;
                }
                case 53: {
                    object = this.readKeywordFunctionOrColumn(68);
                    break;
                }
                case 56: {
                    object = this.readKeywordFunctionOrColumn(116);
                    break;
                }
                case 58: {
                    object = this.readKeywordFunctionOrColumn(222);
                    break;
                }
                case 70: {
                    object = this.readKeywordFunctionOrColumn(118);
                    break;
                }
                case 65: {
                    if (this.parseDomainConstraint) {
                        this.read();
                        object = new DomainValueExpression();
                        break;
                    }
                }
                default: {
                    if (!this.isIdentifier()) {
                        throw this.getSyntaxError();
                    }
                }
                case 2: {
                    expressionArray = this.currentToken;
                    boolean bl = this.currentTokenQuoted;
                    this.read();
                    object = this.readIf(85) ? this.readFunction(null, (String)expressionArray) : (this.readIf(90) ? this.readTermObjectDot((String)expressionArray) : (bl ? new ExpressionColumn(this.database, null, null, (String)expressionArray, false) : this.readTermWithIdentifier((String)expressionArray)));
                }
            }
            if (this.readIf(97)) {
                object = Function.getFunctionWithArgs(this.database, 209, new Expression[]{object, this.readExpression()});
                this.read(98);
            }
            if (this.readIf(100)) {
                if (this.isToken("PG_CATALOG")) {
                    this.read("PG_CATALOG");
                    this.read(90);
                }
                if (this.readIf("REGCLASS")) {
                    object2 = this.findFunctionAlias(this.database.getMainSchema().getName(), "PG_GET_OID");
                    if (object2 == null) {
                        throw this.getSyntaxError();
                    }
                    expressionArray = new Expression[]{object};
                    object = new JavaFunction((FunctionAlias)object2, expressionArray);
                } else {
                    object2 = Function.getFunctionWithArgs(this.database, 203, new Expression[]{object});
                    ((Function)object2).setDataType(this.parseColumnWithType(null));
                    object = object2;
                }
            }
            while (true) {
                if ((object2 = (TypeInfo)this.readIntervalQualifier(null, false)) != null) {
                    expressionArray = Function.getFunctionWithArgs(this.database, 203, new Expression[]{object});
                    expressionArray.setDataType((TypeInfo)object2);
                    object = expressionArray;
                }
                n = this.lastParseIndex;
                if (this.readIf("AT")) {
                    if (this.readIf("TIME")) {
                        this.read("ZONE");
                        object = new TimeZoneOperation((Expression)object, this.readExpression());
                        continue;
                    }
                    if (this.readIf("LOCAL")) {
                        object = new TimeZoneOperation((Expression)object);
                        continue;
                    }
                    this.parseIndex = n;
                    this.read();
                    break block69;
                }
                if (!this.readIf("FORMAT")) break block69;
                if (!this.readIf("JSON")) break;
                object = new Format((Expression)object, Format.FormatEnum.JSON);
            }
            this.parseIndex = n;
            this.read();
        }
        return object;
    }

    private Expression readTermWithIdentifier(String string) {
        switch (string.charAt(0) & 0xFFDF) {
            case 67: {
                if (!this.equalsToken("CURRENT", string)) break;
                int n = this.lastParseIndex;
                if (this.readIf(65) && this.readIf(22)) {
                    return new SequenceValue(this.readSequence(), true);
                }
                this.parseIndex = n;
                this.read();
                if (this.database.getMode().getEnum() != Mode.ModeEnum.DB2) break;
                return this.parseDB2SpecialRegisters(string);
            }
            case 68: {
                if (this.currentTokenType != 74 || this.currentValue.getValueType() != 13 || !this.equalsToken("DATE", string) && !this.equalsToken("D", string)) break;
                String string2 = this.currentValue.getString();
                this.read();
                return ValueExpression.get(ValueDate.parse(string2));
            }
            case 69: {
                if (this.currentTokenType != 74 || this.currentValue.getValueType() != 13 || !this.equalsToken("E", string)) break;
                String string3 = this.currentValue.getString();
                string3 = StringUtils.replaceAll(string3, "\\\\", "\\");
                this.read();
                return ValueExpression.get(ValueVarchar.get(string3));
            }
            case 74: {
                if (this.currentTokenType == 74) {
                    if (this.currentValue.getValueType() != 13 || !this.equalsToken("JSON", string)) break;
                    return ValueExpression.get(ValueJson.fromJson(this.readCharacterStringLiteral().getString()));
                }
                if (this.currentTokenType != 2 || !this.equalsToken("JSON", string) || !this.equalsToken("X", this.currentToken)) break;
                int n = this.lastParseIndex;
                this.read();
                if (this.currentTokenType == 74 && this.currentValue.getValueType() == 13) {
                    return ValueExpression.get(ValueJson.fromJson(this.readBinaryLiteral()));
                }
                this.parseIndex = n;
                this.read();
                break;
            }
            case 78: {
                if (this.equalsToken("NEXT", string)) {
                    int n = this.lastParseIndex;
                    if (this.readIf(65) && this.readIf(22)) {
                        return new SequenceValue(this.readSequence(), false);
                    }
                    this.parseIndex = n;
                    this.read();
                    break;
                }
                if (this.currentTokenType != 74 || this.currentValue.getValueType() != 13 || !this.equalsToken("N", string)) break;
                return ValueExpression.get(this.readCharacterStringLiteral());
            }
            case 83: {
                if (this.equalsToken("SYSDATE", string)) {
                    return this.readFunctionWithoutParameters(103);
                }
                if (this.equalsToken("SYSTIME", string)) {
                    return this.readFunctionWithoutParameters(102);
                }
                if (!this.equalsToken("SYSTIMESTAMP", string)) break;
                return this.readFunctionWithoutParameters(103);
            }
            case 84: {
                if (this.equalsToken("TIME", string)) {
                    if (this.readIf(69)) {
                        this.read("TIME");
                        this.read("ZONE");
                        if (this.currentTokenType != 74 || this.currentValue.getValueType() != 13) {
                            throw this.getSyntaxError();
                        }
                        String string4 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTimeTimeZone.parse(string4));
                    }
                    boolean bl = this.readIf("WITHOUT");
                    if (bl) {
                        this.read("TIME");
                        this.read("ZONE");
                    }
                    if (this.currentTokenType == 74 && this.currentValue.getValueType() == 13) {
                        String string5 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTime.parse(string5));
                    }
                    if (!bl) break;
                    throw this.getSyntaxError();
                }
                if (this.equalsToken("TIMESTAMP", string)) {
                    if (this.readIf(69)) {
                        this.read("TIME");
                        this.read("ZONE");
                        if (this.currentTokenType != 74 || this.currentValue.getValueType() != 13) {
                            throw this.getSyntaxError();
                        }
                        String string6 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTimestampTimeZone.parse(string6, this.session));
                    }
                    boolean bl = this.readIf("WITHOUT");
                    if (bl) {
                        this.read("TIME");
                        this.read("ZONE");
                    }
                    if (this.currentTokenType == 74 && this.currentValue.getValueType() == 13) {
                        String string7 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTimestamp.parse(string7, this.session));
                    }
                    if (!bl) break;
                    throw this.getSyntaxError();
                }
                if (this.equalsToken("TODAY", string)) {
                    return this.readFunctionWithoutParameters(100);
                }
                if (this.currentTokenType != 74 || this.currentValue.getValueType() != 13) break;
                if (this.equalsToken("T", string)) {
                    String string8 = this.currentValue.getString();
                    this.read();
                    return ValueExpression.get(ValueTime.parse(string8));
                }
                if (!this.equalsToken("TS", string)) break;
                String string9 = this.currentValue.getString();
                this.read();
                return ValueExpression.get(ValueTimestamp.parse(string9, this.session));
            }
            case 88: {
                if (this.currentTokenType != 74 || this.currentValue.getValueType() != 13 || !this.equalsToken("X", string)) break;
                return ValueExpression.get(ValueVarbinary.getNoCopy(this.readBinaryLiteral()));
            }
        }
        return new ExpressionColumn(this.database, null, null, string, false);
    }

    private byte[] readBinaryLiteral() {
        ByteArrayOutputStream byteArrayOutputStream = null;
        do {
            byteArrayOutputStream = StringUtils.convertHexWithSpacesToBytes(byteArrayOutputStream, this.currentValue.getString());
            this.read();
        } while (this.currentTokenType == 74 && this.currentValue.getValueType() == 13);
        return byteArrayOutputStream.toByteArray();
    }

    private Value readCharacterStringLiteral() {
        Value value = this.currentValue;
        this.read();
        if (this.currentTokenType == 74 && this.currentValue.getValueType() == 13) {
            StringBuilder stringBuilder = new StringBuilder(value.getString());
            do {
                stringBuilder.append(this.currentValue.getString());
                this.read();
            } while (this.currentTokenType == 74 && this.currentValue.getValueType() == 13);
            return ValueVarchar.get(stringBuilder.toString());
        }
        return value;
    }

    private Expression readInterval() {
        IntervalQualifier intervalQualifier;
        boolean bl = this.readIf(82);
        if (!bl) {
            this.readIf(83);
        }
        if (this.currentTokenType != 74 || this.currentValue.getValueType() != 13) {
            this.addExpected("string");
            throw this.getSyntaxError();
        }
        String string = this.currentValue.getString();
        this.read();
        switch (this.currentTokenType) {
            case 70: {
                this.read();
                if (this.readIf("TO")) {
                    this.read(44);
                    intervalQualifier = IntervalQualifier.YEAR_TO_MONTH;
                    break;
                }
                intervalQualifier = IntervalQualifier.YEAR;
                break;
            }
            case 44: {
                this.read();
                intervalQualifier = IntervalQualifier.MONTH;
                break;
            }
            case 16: {
                this.read();
                if (this.readIf("TO")) {
                    switch (this.currentTokenType) {
                        case 28: {
                            intervalQualifier = IntervalQualifier.DAY_TO_HOUR;
                            break;
                        }
                        case 43: {
                            intervalQualifier = IntervalQualifier.DAY_TO_MINUTE;
                            break;
                        }
                        case 56: {
                            intervalQualifier = IntervalQualifier.DAY_TO_SECOND;
                            break;
                        }
                        default: {
                            throw this.intervalDayError();
                        }
                    }
                    this.read();
                    break;
                }
                intervalQualifier = IntervalQualifier.DAY;
                break;
            }
            case 28: {
                this.read();
                if (this.readIf("TO")) {
                    switch (this.currentTokenType) {
                        case 43: {
                            intervalQualifier = IntervalQualifier.HOUR_TO_MINUTE;
                            break;
                        }
                        case 56: {
                            intervalQualifier = IntervalQualifier.HOUR_TO_SECOND;
                            break;
                        }
                        default: {
                            throw this.intervalHourError();
                        }
                    }
                    this.read();
                    break;
                }
                intervalQualifier = IntervalQualifier.HOUR;
                break;
            }
            case 43: {
                this.read();
                if (this.readIf("TO")) {
                    this.read(56);
                    intervalQualifier = IntervalQualifier.MINUTE_TO_SECOND;
                    break;
                }
                intervalQualifier = IntervalQualifier.MINUTE;
                break;
            }
            case 56: {
                this.read();
                intervalQualifier = IntervalQualifier.SECOND;
                break;
            }
            default: {
                throw this.intervalQualifierError();
            }
        }
        try {
            return ValueExpression.get(IntervalUtils.parseInterval(intervalQualifier, bl, string));
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "INTERVAL", string);
        }
    }

    private Expression parseDB2SpecialRegisters(String string) {
        if (this.readIf("TIMESTAMP")) {
            if (this.readIf(69)) {
                this.read("TIME");
                this.read("ZONE");
                return this.readKeywordFunction(103);
            }
            return this.readKeywordFunction(104);
        }
        if (this.readIf("TIME")) {
            return this.readFunctionWithoutParameters(102);
        }
        if (this.readIf("DATE")) {
            return this.readFunctionWithoutParameters(100);
        }
        return new ExpressionColumn(this.database, null, null, string, false);
    }

    private Expression readCase() {
        Function function;
        if (this.readIf("END")) {
            this.readIf(6);
            return ValueExpression.NULL;
        }
        if (this.readIf("ELSE")) {
            Expression expression = this.readExpression().optimize(this.session);
            this.read("END");
            this.readIf(6);
            return expression;
        }
        if (this.readIf("WHEN")) {
            function = Function.getFunction(this.database, 206);
            function.addParameter(null);
            do {
                function.addParameter(this.readExpression());
                this.read("THEN");
                function.addParameter(this.readExpression());
            } while (this.readIf("WHEN"));
        } else {
            Expression expression = this.readExpression();
            if (this.readIf("END")) {
                this.readIf(6);
                return ValueExpression.NULL;
            }
            if (this.readIf("ELSE")) {
                Expression expression2 = this.readExpression().optimize(this.session);
                this.read("END");
                this.readIf(6);
                return expression2;
            }
            function = Function.getFunction(this.database, 206);
            function.addParameter(expression);
            this.read("WHEN");
            do {
                function.addParameter(this.readExpression());
                this.read("THEN");
                function.addParameter(this.readExpression());
            } while (this.readIf("WHEN"));
        }
        if (this.readIf("ELSE")) {
            function.addParameter(this.readExpression());
        }
        this.read("END");
        this.readIf("CASE");
        function.doneWithParameters();
        return function;
    }

    private int readNonNegativeInt() {
        int n = this.readInt();
        if (n < 0) {
            throw DbException.getInvalidValueException("non-negative integer", n);
        }
        return n;
    }

    private int readInt() {
        boolean bl = false;
        if (this.currentTokenType == 82) {
            bl = true;
            this.read();
        } else if (this.currentTokenType == 83) {
            this.read();
        }
        if (this.currentTokenType != 74) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "integer");
        }
        if (bl) {
            this.currentValue = this.currentValue.negate();
        }
        int n = this.currentValue.getInt();
        this.read();
        return n;
    }

    private long readPositiveLong() {
        long l = this.readLong();
        if (l <= 0L) {
            throw DbException.getInvalidValueException("positive long", l);
        }
        return l;
    }

    private long readLong() {
        boolean bl = false;
        if (this.currentTokenType == 82) {
            bl = true;
            this.read();
        } else if (this.currentTokenType == 83) {
            this.read();
        }
        if (this.currentTokenType != 74) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "long");
        }
        if (bl) {
            this.currentValue = this.currentValue.negate();
        }
        long l = this.currentValue.getLong();
        this.read();
        return l;
    }

    private boolean readBooleanSetting() {
        switch (this.currentTokenType) {
            case 49: 
            case 60: {
                this.read();
                return true;
            }
            case 20: {
                this.read();
                return false;
            }
            case 74: {
                boolean bl = this.currentValue.getBoolean();
                this.read();
                return bl;
            }
        }
        if (this.readIf("OFF")) {
            return false;
        }
        if (this.expectedList != null) {
            this.addMultipleExpected(49, 60, 20);
        }
        throw this.getSyntaxError();
    }

    private String readString() {
        Expression expression = this.readExpression().optimize(this.session);
        if (!(expression instanceof ValueExpression)) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "string");
        }
        return expression.getValue(this.session).getString();
    }

    private String readIdentifierWithSchema(String string) {
        String string2 = this.readColumnIdentifier();
        this.schemaName = string;
        if (this.readIf(90)) {
            string2 = this.readIdentifierWithSchema2(string2);
        }
        return string2;
    }

    private String readIdentifierWithSchema2(String string) {
        this.schemaName = string;
        if (this.database.getMode().allowEmptySchemaValuesAsDefaultSchema && this.readIf(90)) {
            if (this.equalsToken(this.schemaName, this.database.getShortName()) || this.database.getIgnoreCatalogs()) {
                this.schemaName = this.session.getCurrentSchemaName();
                string = this.readColumnIdentifier();
            }
        } else {
            string = this.readColumnIdentifier();
            if (this.currentTokenType == 90 && (this.equalsToken(this.schemaName, this.database.getShortName()) || this.database.getIgnoreCatalogs())) {
                this.read();
                this.schemaName = string;
                string = this.readColumnIdentifier();
            }
        }
        return string;
    }

    private String readIdentifierWithSchema() {
        return this.readIdentifierWithSchema(this.session.getCurrentSchemaName());
    }

    private String readAliasIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readUniqueIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readColumnIdentifier() {
        if (!(this.isIdentifier() || this.database.isStarting() && this.isKeyword(this.currentToken))) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String string = this.currentToken;
        this.read();
        return string;
    }

    private void read(String string) {
        if (this.currentTokenQuoted || !this.equalsToken(string, this.currentToken)) {
            this.addExpected(string);
            throw this.getSyntaxError();
        }
        this.read();
    }

    private void read(int n) {
        if (n != this.currentTokenType) {
            this.addExpected(n);
            throw this.getSyntaxError();
        }
        this.read();
    }

    private boolean readIf(String string) {
        if (!this.currentTokenQuoted && this.equalsToken(string, this.currentToken)) {
            this.read();
            return true;
        }
        this.addExpected(string);
        return false;
    }

    private boolean readIf(int n) {
        if (n == this.currentTokenType) {
            this.read();
            return true;
        }
        this.addExpected(n);
        return false;
    }

    private boolean isToken(String string) {
        if (!this.currentTokenQuoted && this.equalsToken(string, this.currentToken)) {
            return true;
        }
        this.addExpected(string);
        return false;
    }

    private boolean isToken(int n) {
        if (n == this.currentTokenType) {
            return true;
        }
        this.addExpected(n);
        return false;
    }

    private boolean equalsToken(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2) || !this.identifiersToUpper && string.equalsIgnoreCase(string2);
    }

    private boolean isIdentifier() {
        return this.currentTokenType == 2 || this.nonKeywords != null && this.nonKeywords.get(this.currentTokenType);
    }

    private void addExpected(String string) {
        if (this.expectedList != null) {
            this.expectedList.add(string);
        }
    }

    private void addExpected(int n) {
        if (this.expectedList != null) {
            this.expectedList.add(TOKENS[n]);
        }
    }

    private void addMultipleExpected(int ... nArray) {
        for (int n : nArray) {
            this.expectedList.add(TOKENS[n]);
        }
    }

    private void read() {
        int n;
        this.currentTokenQuoted = false;
        if (this.expectedList != null) {
            this.expectedList.clear();
        }
        int[] nArray = this.characterTypes;
        this.lastParseIndex = this.parseIndex;
        int n2 = this.parseIndex;
        while ((n = nArray[n2]) == 0) {
            ++n2;
        }
        int n3 = n2;
        char[] cArray = this.sqlCommandChars;
        char c = cArray[n2++];
        this.currentToken = "";
        switch (n) {
            case 4: {
                while ((n = nArray[n2]) == 4 || n == 2) {
                    ++n2;
                }
                this.currentTokenType = ParserUtil.getSaveTokenType(this.sqlCommand, !this.identifiersToUpper, n3, n2, false);
                this.currentToken = this.isIdentifier() ? StringUtils.cache(this.sqlCommand.substring(n3, n2)) : TOKENS[this.currentTokenType];
                this.parseIndex = n2;
                return;
            }
            case 3: {
                String string = null;
                while (true) {
                    int n4 = ++n2;
                    while (cArray[n2] != c) {
                        ++n2;
                    }
                    string = string == null ? this.sqlCommand.substring(n4, n2) : string + this.sqlCommand.substring(n4 - 1, n2);
                    if (cArray[++n2] != c) break;
                }
                this.currentToken = StringUtils.cache(string);
                this.parseIndex = n2;
                this.currentTokenQuoted = true;
                this.currentTokenType = 2;
                return;
            }
            case 6: {
                if (nArray[n2] == 6) {
                    char c2 = cArray[n2++];
                    this.currentTokenType = this.getSpecialType2(c, c2);
                } else {
                    this.currentTokenType = this.getSpecialType1(c);
                }
                this.parseIndex = n2;
                return;
            }
            case 5: {
                this.currentTokenType = this.getSpecialType1(c);
                this.parseIndex = n2;
                return;
            }
            case 2: {
                if (c == '0' && (cArray[n2] == 'X' || cArray[n2] == 'x')) {
                    this.readHexNumber(n2 + 1, n3 + 2, cArray, nArray);
                    return;
                }
                long l = c - 48;
                while (true) {
                    if ((c = cArray[n2]) < '0' || c > '9') {
                        switch (c) {
                            case '.': 
                            case 'E': 
                            case 'e': {
                                this.readDecimal(n3, n2, false);
                                break;
                            }
                            case 'L': 
                            case 'l': {
                                this.readDecimal(n3, n2, true);
                                break;
                            }
                            default: {
                                this.checkLiterals(false);
                                this.currentValue = ValueInteger.get((int)l);
                                this.currentTokenType = 74;
                                this.currentToken = "0";
                                this.parseIndex = n2;
                                break;
                            }
                        }
                        break;
                    }
                    if ((l = l * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        this.readDecimal(n3, n2, true);
                        break;
                    }
                    ++n2;
                }
                return;
            }
            case 8: {
                if (nArray[n2] != 2) {
                    this.currentTokenType = 90;
                    this.currentToken = ".";
                    this.parseIndex = n2;
                    return;
                }
                this.readDecimal(n2 - 1, n2, false);
                return;
            }
            case 7: {
                String string = null;
                while (true) {
                    int n5 = ++n2;
                    while (cArray[n2] != '\'') {
                        ++n2;
                    }
                    string = string == null ? this.sqlCommand.substring(n5, n2) : string + this.sqlCommand.substring(n5 - 1, n2);
                    if (cArray[++n2] != '\'') break;
                }
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueVarchar.get(string, this.database);
                this.parseIndex = n2;
                this.currentTokenType = 74;
                return;
            }
            case 9: {
                int n6 = n2 - 1;
                while (nArray[n2] == 9) {
                    ++n2;
                }
                String string = this.sqlCommand.substring(n6, n2);
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueVarchar.get(string, this.database);
                this.parseIndex = n2;
                this.currentTokenType = 74;
                return;
            }
            case 1: {
                this.currentTokenType = 73;
                this.parseIndex = n2;
                return;
            }
        }
        throw this.getSyntaxError();
    }

    private void readParameterIndex() {
        int n = this.parseIndex;
        char[] cArray = this.sqlCommandChars;
        char c = cArray[n++];
        long l = c - 48;
        while ((c = cArray[n]) >= '0' && c <= '9') {
            if ((l = l * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                throw DbException.getInvalidValueException("parameter index", l);
            }
            ++n;
        }
        this.currentValue = ValueInteger.get((int)l);
        this.currentTokenType = 74;
        this.currentToken = "0";
        this.parseIndex = n;
    }

    private void checkLiterals(boolean bl) {
        int n;
        if (!this.literalsChecked && this.session != null && !this.session.getAllowLiterals() && ((n = this.database.getAllowLiterals()) == 0 || bl && n != 2)) {
            throw DbException.get(90116);
        }
    }

    private void readHexNumber(int n, int n2, char[] cArray, int[] nArray) {
        if (this.database.getMode().zeroExLiteralsAreBinaryStrings) {
            char c;
            while ((c = cArray[n]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'z') {
                ++n;
            }
            if (nArray[n] == 4) {
                throw DbException.get(90004, this.sqlCommand.substring(n, n + 1));
            }
            this.checkLiterals(true);
            this.currentValue = ValueVarbinary.getNoCopy(StringUtils.convertHexToBytes(this.sqlCommand.substring(n2, n)));
            this.parseIndex = n;
        } else {
            char c;
            long l = 0L;
            while (true) {
                if ((c = cArray[n]) >= '0' && c <= '9') {
                    l = (l << 4) + (long)c - 48L;
                } else if (c >= 'A' && c <= 'F') {
                    l = (l << 4) + (long)c - 55L;
                } else if (c >= 'a' && c <= 'f') {
                    l = (l << 4) + (long)c - 87L;
                } else {
                    if (n == n2) {
                        this.parseIndex = n;
                        this.addExpected("Hex number");
                        throw this.getSyntaxError();
                    }
                    this.currentValue = ValueInteger.get((int)l);
                    break;
                }
                if (l > Integer.MAX_VALUE) {
                    while ((c = cArray[++n]) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
                    }
                    String string = this.sqlCommand.substring(n2, n);
                    this.currentValue = ValueNumeric.get(new BigInteger(string, 16));
                    break;
                }
                ++n;
            }
            c = cArray[n];
            if (c == 'L' || c == 'l') {
                ++n;
            }
            this.parseIndex = n;
            if (nArray[n] == 4) {
                this.addExpected("Hex number");
                throw this.getSyntaxError();
            }
            this.checkLiterals(false);
        }
        this.currentTokenType = 74;
        this.currentToken = "0";
    }

    private void readDecimal(int n, int n2, boolean bl) {
        int n3;
        char[] cArray = this.sqlCommandChars;
        int[] nArray = this.characterTypes;
        while (true) {
            if ((n3 = nArray[n2]) == 8) {
                bl = false;
            } else if (n3 != 2) break;
            ++n2;
        }
        n3 = cArray[n2];
        if (n3 == 69 || n3 == 101) {
            bl = false;
            if ((n3 = cArray[++n2]) == 43 || n3 == 45) {
                ++n2;
            }
            if (nArray[n2] != 2) {
                throw this.getSyntaxError();
            }
            while (nArray[++n2] == 2) {
            }
        }
        this.parseIndex = n2;
        this.checkLiterals(false);
        if (bl && n2 - n <= 19) {
            BigInteger bigInteger = new BigInteger(this.sqlCommand.substring(n, n2));
            if (bigInteger.compareTo(ValueBigint.MAX_BI) <= 0) {
                n3 = cArray[n2];
                if (n3 == 76 || n3 == 108) {
                    ++this.parseIndex;
                }
                this.currentValue = ValueBigint.get(bigInteger.longValue());
                this.currentTokenType = 74;
                return;
            }
            this.currentValue = ValueNumeric.get(bigInteger);
        } else {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(this.sqlCommandChars, n, n2 - n);
            }
            catch (NumberFormatException numberFormatException) {
                throw DbException.get(22018, numberFormatException, this.sqlCommand.substring(n, n2));
            }
            this.currentValue = ValueNumeric.get(bigDecimal);
        }
        this.currentTokenType = 74;
    }

    private void initialize(String string) {
        if (string == null) {
            string = "";
        }
        this.originalSQL = string;
        this.sqlCommand = string;
        int n = string.length() + 1;
        char[] cArray = new char[n];
        int[] nArray = new int[n];
        string.getChars(0, --n, cArray, 0);
        boolean bl = false;
        cArray[n] = 32;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = cArray[i];
            int n5 = 0;
            switch (n4) {
                case 47: {
                    int n6;
                    if (cArray[i + 1] == '*') {
                        bl = true;
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        n2 = i;
                        i += 2;
                        for (n6 = 1; n6 > 0; --n6) {
                            while (true) {
                                this.checkRunOver(i, n, n2);
                                char c = cArray[i];
                                cArray[i++] = 32;
                                if (c == '*') {
                                    if (cArray[i] != '/') continue;
                                    break;
                                }
                                if (c != '/' || cArray[i] != '*') continue;
                                ++n6;
                                cArray[i++] = 32;
                            }
                            cArray[i] = 32;
                        }
                        break;
                    }
                    if (cArray[i + 1] == '/') {
                        bl = true;
                        n2 = i;
                        while ((n4 = cArray[i]) != 10 && n4 != 13 && i < n - 1) {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        break;
                    }
                    n5 = 5;
                    break;
                }
                case 45: {
                    if (cArray[i + 1] == '-') {
                        bl = true;
                        n2 = i;
                        while ((n4 = cArray[i]) != 10 && n4 != 13 && i < n - 1) {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        break;
                    }
                    n5 = 5;
                    break;
                }
                case 36: {
                    if (cArray[i + 1] == '$' && (i == 0 || cArray[i - 1] <= ' ')) {
                        bl = true;
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        n2 = i;
                        this.checkRunOver(i += 2, n, n2);
                        while (cArray[i] != '$' || cArray[i + 1] != '$') {
                            nArray[i++] = 9;
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (n3 == 4 || n3 == 2) {
                        n5 = 4;
                        break;
                    }
                    n5 = 5;
                    break;
                }
                case 37: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 63: 
                case 64: 
                case 93: 
                case 123: 
                case 125: {
                    n5 = 5;
                    break;
                }
                case 33: 
                case 38: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 124: 
                case 126: {
                    n5 = 6;
                    break;
                }
                case 46: {
                    n5 = 8;
                    break;
                }
                case 39: {
                    nArray[i] = 7;
                    n5 = 7;
                    n2 = i;
                    while (cArray[++i] != '\'') {
                        this.checkRunOver(i, n, n2);
                    }
                    break;
                }
                case 91: {
                    if (this.database.getMode().squareBracketQuotedNames) {
                        cArray[i] = 34;
                        bl = true;
                        nArray[i] = 3;
                        n5 = 3;
                        n2 = i;
                        while (cArray[++i] != ']') {
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 34;
                        break;
                    }
                    n5 = 5;
                    break;
                }
                case 96: {
                    int n6;
                    nArray[i] = 3;
                    n5 = 3;
                    n2 = i;
                    while (cArray[++i] != '`') {
                        this.checkRunOver(i, n, n2);
                        n4 = cArray[i];
                        if (!this.identifiersToUpper && !this.identifiersToLower || (n6 = (int)(this.identifiersToUpper ? Character.toUpperCase((char)n4) : Character.toLowerCase((char)n4))) == n4) continue;
                        cArray[i] = n6;
                        bl = true;
                    }
                    break;
                }
                case 34: {
                    nArray[i] = 3;
                    n5 = 3;
                    n2 = i;
                    while (cArray[++i] != '\"') {
                        this.checkRunOver(i, n, n2);
                    }
                    break;
                }
                case 95: {
                    n5 = 4;
                    break;
                }
                case 35: {
                    if (this.database.getMode().supportPoundSymbolForColumnNames) {
                        n5 = 4;
                        break;
                    }
                    n5 = 5;
                    break;
                }
                default: {
                    int n6;
                    if (n4 >= 97 && n4 <= 122) {
                        if (this.identifiersToUpper) {
                            cArray[i] = (char)(n4 - 32);
                            bl = true;
                        }
                        n5 = 4;
                        break;
                    }
                    if (n4 >= 65 && n4 <= 90) {
                        if (this.identifiersToLower) {
                            cArray[i] = (char)(n4 + 32);
                            bl = true;
                        }
                        n5 = 4;
                        break;
                    }
                    if (n4 >= 48 && n4 <= 57) {
                        n5 = 2;
                        break;
                    }
                    if (n4 <= 32 || Character.isSpaceChar((char)n4)) break;
                    if (Character.isJavaIdentifierPart((char)n4)) {
                        n5 = 4;
                        if (!this.identifiersToUpper && !this.identifiersToLower || (n6 = (int)(this.identifiersToUpper ? Character.toUpperCase((char)n4) : Character.toLowerCase((char)n4))) == n4) break;
                        cArray[i] = n6;
                        bl = true;
                        break;
                    }
                    n5 = 5;
                }
            }
            nArray[i] = n5;
            n3 = n5;
        }
        this.sqlCommandChars = cArray;
        nArray[n] = 1;
        this.characterTypes = nArray;
        if (bl) {
            this.sqlCommand = new String(cArray, 0, n);
        }
        this.parseIndex = 0;
    }

    private void checkRunOver(int n, int n2, int n3) {
        if (n >= n2) {
            this.parseIndex = n3;
            throw this.getSyntaxError();
        }
    }

    private int getSpecialType1(char c) {
        switch (c) {
            case '$': 
            case '?': {
                return 72;
            }
            case '@': {
                return 81;
            }
            case '+': {
                return 83;
            }
            case '-': {
                return 82;
            }
            case '*': {
                return 88;
            }
            case ',': {
                return 89;
            }
            case '{': {
                return 91;
            }
            case '}': {
                return 92;
            }
            case '/': {
                return 93;
            }
            case '%': {
                return 94;
            }
            case ';': {
                return 95;
            }
            case ':': {
                return 96;
            }
            case '[': {
                return 97;
            }
            case ']': {
                return 98;
            }
            case '~': {
                return 99;
            }
            case '(': {
                return 85;
            }
            case ')': {
                return 86;
            }
            case '<': {
                return 78;
            }
            case '>': {
                return 77;
            }
            case '=': {
                return 75;
            }
        }
        throw this.getSyntaxError();
    }

    private int getSpecialType2(char c, char c2) {
        switch (c) {
            case ':': {
                if (c2 == ':') {
                    return 100;
                }
                if (c2 != '=') break;
                return 101;
            }
            case '>': {
                if (c2 != '=') break;
                return 76;
            }
            case '<': {
                if (c2 == '=') {
                    return 79;
                }
                if (c2 != '>') break;
                return 80;
            }
            case '!': {
                if (c2 == '=') {
                    return 80;
                }
                if (c2 != '~') break;
                return 102;
            }
            case '|': {
                if (c2 != '|') break;
                return 84;
            }
            case '&': {
                if (c2 != '&') break;
                return 87;
            }
        }
        throw this.getSyntaxError();
    }

    private boolean isKeyword(String string) {
        return ParserUtil.isKeyword(string, !this.identifiersToUpper);
    }

    private Column parseColumnForTable(String string, boolean bl) {
        String string2;
        int n;
        Column column;
        boolean bl2 = this.readIf("IDENTITY");
        if (bl2 || this.readIf("BIGSERIAL")) {
            if (bl2 && this.database.getMode().disallowedTypes.contains("IDENTITY")) {
                throw DbException.get(50004, this.currentToken);
            }
            column = new Column(string, TypeInfo.TYPE_BIGINT, "IDENTITY");
            this.parseAutoIncrement(column);
            if (!this.database.getMode().serialColumnIsNotPK) {
                column.setPrimaryKey(true);
            }
        } else if (this.readIf("SERIAL")) {
            column = new Column(string, TypeInfo.TYPE_INTEGER, "SERIAL");
            this.parseAutoIncrement(column);
            if (!this.database.getMode().serialColumnIsNotPK) {
                column.setPrimaryKey(true);
            }
        } else {
            column = this.parseColumnWithType(string);
        }
        if (this.readIf("INVISIBLE")) {
            column.setVisible(false);
        } else if (this.readIf("VISIBLE")) {
            column.setVisible(true);
        }
        NullConstraintType nullConstraintType = this.parseNotNullConstraint();
        switch (nullConstraintType) {
            case NULL_IS_ALLOWED: {
                column.setNullable(true);
                break;
            }
            case NULL_IS_NOT_ALLOWED: {
                column.setNullable(false);
                break;
            }
            case NO_NULL_CONSTRAINT_FOUND: {
                column.setNullable(bl);
                break;
            }
            default: {
                throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraintType.name());
            }
        }
        if (!bl2 && this.readIf(5)) {
            column.setGeneratedExpression(this.readExpression());
        } else if (this.readIf("DEFAULT")) {
            column.setDefaultExpression(this.session, this.readExpression());
        } else if (this.readIf("GENERATED")) {
            n = this.readIf("ALWAYS");
            if (n == 0) {
                this.read("BY");
                this.read("DEFAULT");
            }
            this.read(5);
            if (this.readIf("IDENTITY")) {
                SequenceOptions sequenceOptions = new SequenceOptions();
                if (this.readIf(85)) {
                    this.parseSequenceOptions(sequenceOptions, null, true);
                    this.read(86);
                }
                column.setAutoIncrementOptions(sequenceOptions);
            } else {
                if (n == 0 || bl2) {
                    throw this.getSyntaxError();
                }
                column.setGeneratedExpression(this.readExpression());
            }
        }
        if (this.readIf(49)) {
            this.read("UPDATE");
            column.setOnUpdateExpression(this.session, this.readExpression());
        }
        if (NullConstraintType.NULL_IS_NOT_ALLOWED == this.parseNotNullConstraint()) {
            column.setNullable(false);
        }
        if (this.readIf("AUTO_INCREMENT") || this.readIf("BIGSERIAL") || this.readIf("SERIAL")) {
            this.parseAutoIncrement(column);
            this.parseNotNullConstraint();
        } else if (this.readIf("IDENTITY")) {
            this.parseAutoIncrement(column);
            column.setPrimaryKey(true);
            this.parseNotNullConstraint();
        }
        if (this.readIf("NULL_TO_DEFAULT")) {
            column.setConvertNullToDefault(true);
        }
        if (this.readIf("SEQUENCE")) {
            Sequence sequence = this.readSequence();
            column.setSequence(sequence);
        }
        if (this.readIf("SELECTIVITY")) {
            n = this.readNonNegativeInt();
            column.setSelectivity(n);
        }
        if ((string2 = this.readCommentIf()) != null) {
            column.setComment(string2);
        }
        return column;
    }

    private void parseAutoIncrement(Column column) {
        SequenceOptions sequenceOptions = new SequenceOptions();
        if (this.readIf(85)) {
            sequenceOptions.setStartValue(ValueExpression.get(ValueBigint.get(this.readLong())));
            if (this.readIf(89)) {
                sequenceOptions.setIncrement(ValueExpression.get(ValueBigint.get(this.readLong())));
            }
            this.read(86);
        }
        column.setAutoIncrementOptions(sequenceOptions);
    }

    private String readCommentIf() {
        if (this.readIf("COMMENT")) {
            this.readIf(34);
            return this.readString();
        }
        return null;
    }

    private Column parseColumnWithType(String string) {
        Column column = this.parseColumnWithType1(string);
        while (this.readIf(4)) {
            column = this.parseArrayType(string, column.getType());
        }
        return column;
    }

    private Column parseColumnWithType1(String string) {
        Object object;
        switch (this.currentTokenType) {
            case 2: {
                break;
            }
            case 4: {
                this.read();
                return this.parseArrayType(string, null);
            }
            case 33: {
                this.read();
                return (Column)this.readIntervalQualifier(string, true);
            }
            case 47: {
                this.read();
                return new Column(string, TypeInfo.TYPE_NULL, "NULL");
            }
            default: {
                this.addExpected("data type");
                throw this.getSyntaxError();
            }
        }
        int n = this.lastParseIndex;
        String string2 = this.currentToken;
        boolean bl = this.currentTokenQuoted;
        this.read();
        if (this.currentTokenType == 90) {
            this.parseIndex = n;
            this.read();
            string2 = this.readIdentifierWithSchema();
            return this.getColumnWithDomain(string, this.getSchema().getDomain(string2));
        }
        if (bl) {
            return this.getColumnWithDomain(string, this.database.getSchema(this.session.getCurrentSchemaName()).getDomain(string2));
        }
        String string3 = this.identifiersToUpper ? string2 : StringUtils.toUpperEnglish(string2);
        switch (string3) {
            case "BINARY": {
                if (this.readIf("VARYING")) {
                    string3 = "BINARY VARYING";
                    break;
                }
                if (this.readIf("LARGE")) {
                    this.read("OBJECT");
                    string3 = "BINARY LARGE OBJECT";
                    break;
                }
                if (!this.variableBinary) break;
                string3 = "VARBINARY";
                break;
            }
            case "CHAR": {
                if (this.readIf("VARYING")) {
                    string3 = "CHAR VARYING";
                    break;
                }
                if (!this.readIf("LARGE")) break;
                this.read("OBJECT");
                string3 = "CHAR LARGE OBJECT";
                break;
            }
            case "CHARACTER": {
                if (this.readIf("VARYING")) {
                    string3 = "CHARACTER VARYING";
                    break;
                }
                if (!this.readIf("LARGE")) break;
                this.read("OBJECT");
                string3 = "CHARACTER LARGE OBJECT";
                break;
            }
            case "DATETIME": 
            case "DATETIME2": {
                return this.parseDateTimeType(string, string3, false);
            }
            case "DOUBLE": {
                if (!this.readIf("PRECISION")) break;
                string3 = "DOUBLE PRECISION";
                break;
            }
            case "ENUM": {
                return this.parseEnumType(string);
            }
            case "FLOAT": {
                return this.parseFloatType(string);
            }
            case "GEOMETRY": {
                return this.parseGeometryType(string);
            }
            case "LONG": {
                if (!this.readIf("RAW")) break;
                string3 = "LONG RAW";
                break;
            }
            case "NATIONAL": {
                if (this.readIf("CHARACTER")) {
                    if (this.readIf("VARYING")) {
                        string3 = "NATIONAL CHARACTER VARYING";
                        break;
                    }
                    if (this.readIf("LARGE")) {
                        this.read("OBJECT");
                        string3 = "NATIONAL CHARACTER LARGE OBJECT";
                        break;
                    }
                    string3 = "NATIONAL CHARACTER";
                    break;
                }
                this.read("CHAR");
                if (this.readIf("VARYING")) {
                    string3 = "NATIONAL CHAR VARYING";
                    break;
                }
                string3 = "NATIONAL CHAR";
                break;
            }
            case "NCHAR": {
                if (this.readIf("VARYING")) {
                    string3 = "NCHAR VARYING";
                    break;
                }
                if (!this.readIf("LARGE")) break;
                this.read("OBJECT");
                string3 = "NCHAR LARGE OBJECT";
                break;
            }
            case "SMALLDATETIME": {
                return this.parseDateTimeType(string, string3, true);
            }
            case "TIME": {
                return this.parseTimeType(string);
            }
            case "TIMESTAMP": {
                return this.parseTimestampType(string);
            }
        }
        if (string2.length() == string3.length() && (object = this.database.getSchema(this.session.getCurrentSchemaName()).findDomain(string2)) != null) {
            return this.getColumnWithDomain(string, (Domain)object);
        }
        object = this.database.getMode();
        DataType dataType = DataType.getTypeByName(string3, (Mode)object);
        if (dataType == null || ((Mode)object).disallowedTypes.contains(string3)) {
            throw DbException.get(50004, string3);
        }
        long l = dataType.defaultPrecision;
        int n2 = dataType.defaultScale;
        int n3 = dataType.type;
        if (this.database.getIgnoreCase() && n3 == 13 && !this.equalsToken("VARCHAR_CASESENSITIVE", string3)) {
            string3 = "VARCHAR_IGNORECASE";
            n3 = 14;
            dataType = DataType.getDataType(14);
        }
        if ((dataType.supportsPrecision || dataType.supportsScale) && this.readIf(85)) {
            if (!this.readIf("MAX")) {
                if (dataType.supportsPrecision) {
                    l = this.readPrecision(n3);
                    if (dataType.supportsScale) {
                        if (this.readIf(89)) {
                            n2 = this.readInt();
                            string3 = string3 + '(' + l + ", " + n2 + ')';
                        } else {
                            n2 = 0;
                            string3 = string3 + '(' + l + ')';
                        }
                    } else {
                        string3 = string3 + '(' + l + ')';
                    }
                } else {
                    n2 = this.readInt();
                    string3 = string3 + '(' + n2 + ')';
                }
            }
            this.read(86);
            if (dataType.supportsPrecision && (l < dataType.minPrecision || l > dataType.maxPrecision)) {
                throw DbException.get(90150, Long.toString(l), Long.toString(dataType.minPrecision), Long.toString(dataType.maxPrecision));
            }
            if (dataType.supportsScale && (n2 < dataType.minScale || n2 > dataType.maxScale)) {
                throw DbException.get(90151, Integer.toString(n2), Integer.toString(dataType.minScale), Integer.toString(dataType.maxScale));
            }
        }
        if (((Mode)object).allNumericTypesHavePrecision && dataType.decimal) {
            if (this.readIf(85)) {
                this.readNonNegativeInt();
                this.read(86);
            }
            this.readIf("UNSIGNED");
        }
        if (((Mode)object).forBitData && DataType.isStringType(n3) && this.readIf(22)) {
            this.read("BIT");
            this.read("DATA");
            n3 = 12;
            dataType = DataType.getDataType(12);
        }
        return new Column(string, TypeInfo.getTypeInfo(n3, l, n2, null), string3);
    }

    private Column getColumnWithDomain(String string, Domain domain) {
        Column column = domain.getColumn();
        Column column2 = new Column(string, column.getType(), domain.getSQL(0));
        column2.setNullable(column.isNullable());
        column2.setDefaultExpression(this.session, column.getDefaultExpression());
        column2.setOnUpdateExpression(this.session, column.getOnUpdateExpression());
        int n = column.getSelectivity();
        if (n != 50) {
            column2.setSelectivity(n);
        }
        column2.setComment(column.getComment());
        column2.setDomain(domain);
        return column2;
    }

    private Column parseFloatType(String string) {
        int n = 7;
        int n2 = -1;
        if (this.readIf(85)) {
            n2 = this.readNonNegativeInt();
            this.read(86);
            if (n2 < 1 || n2 > 53) {
                throw DbException.get(90150, Integer.toString(n2), "1", "53");
            }
            if (n2 <= 24) {
                n = 8;
            }
        }
        return new Column(string, TypeInfo.getTypeInfo(n, -1L, -1, null), n2 >= 0 ? "FLOAT(" + n2 + ')' : "FLOAT");
    }

    private Column parseTimeType(String string) {
        String string2;
        int n = -1;
        if (this.readIf(85)) {
            n = this.readNonNegativeInt();
            if (n > 9) {
                throw DbException.get(90151, Integer.toString(n), "0", "9");
            }
            this.read(86);
        }
        int n2 = 9;
        if (this.readIf(69)) {
            this.read("TIME");
            this.read("ZONE");
            n2 = 41;
            string2 = n >= 0 ? "TIME(" + n + ") WITH TIME ZONE" : "TIME WITH TIME ZONE";
        } else if (this.readIf("WITHOUT")) {
            this.read("TIME");
            this.read("ZONE");
            string2 = n >= 0 ? "TIME(" + n + ") WITHOUT TIME ZONE" : "TIME WITHOUT TIME ZONE";
        } else {
            string2 = n >= 0 ? "TIME(" + n + ')' : "TIME";
        }
        return new Column(string, TypeInfo.getTypeInfo(n2, -1L, n < 0 ? 0 : n, null), string2);
    }

    private Column parseTimestampType(String string) {
        String string2;
        int n = -1;
        if (this.readIf(85)) {
            n = this.readNonNegativeInt();
            if (this.readIf(89)) {
                n = this.readNonNegativeInt();
            }
            if (n > 9) {
                throw DbException.get(90151, Integer.toString(n), "0", "9");
            }
            this.read(86);
        }
        int n2 = 11;
        if (this.readIf(69)) {
            this.read("TIME");
            this.read("ZONE");
            n2 = 24;
            string2 = n >= 0 ? "TIMESTAMP(" + n + ") WITH TIME ZONE" : "TIMESTAMP WITH TIME ZONE";
        } else if (this.readIf("WITHOUT")) {
            this.read("TIME");
            this.read("ZONE");
            string2 = n >= 0 ? "TIMESTAMP(" + n + ") WITHOUT TIME ZONE" : "TIMESTAMP WITHOUT TIME ZONE";
        } else {
            string2 = n >= 0 ? "TIMESTAMP(" + n + ')' : "TIMESTAMP";
        }
        return new Column(string, TypeInfo.getTypeInfo(n2, -1L, n < 0 ? 6 : n, null), string2);
    }

    private Column parseDateTimeType(String string, String string2, boolean bl) {
        int n;
        if (bl) {
            n = 0;
        } else {
            n = 6;
            if (this.readIf(85)) {
                n = this.readNonNegativeInt();
                if (n > 9) {
                    throw DbException.get(90151, Integer.toString(n), "0", "9");
                }
                this.read(86);
                string2 = string2 + '(' + n + ')';
            }
        }
        return new Column(string, TypeInfo.getTypeInfo(11, -1L, n, null), string2);
    }

    private Object readIntervalQualifier(String string, boolean bl) {
        IntervalQualifier intervalQualifier;
        int n = -1;
        int n2 = -1;
        block0 : switch (this.currentTokenType) {
            case 70: {
                this.read();
                if (this.readIf(85)) {
                    n = this.readNonNegativeInt();
                    this.read(86);
                }
                if (this.readIf("TO")) {
                    this.read(44);
                    intervalQualifier = IntervalQualifier.YEAR_TO_MONTH;
                    break;
                }
                intervalQualifier = IntervalQualifier.YEAR;
                break;
            }
            case 44: {
                this.read();
                if (this.readIf(85)) {
                    n = this.readNonNegativeInt();
                    this.read(86);
                }
                intervalQualifier = IntervalQualifier.MONTH;
                break;
            }
            case 16: {
                this.read();
                if (this.readIf(85)) {
                    n = this.readNonNegativeInt();
                    this.read(86);
                }
                if (this.readIf("TO")) {
                    switch (this.currentTokenType) {
                        case 28: {
                            this.read();
                            intervalQualifier = IntervalQualifier.DAY_TO_HOUR;
                            break block0;
                        }
                        case 43: {
                            this.read();
                            intervalQualifier = IntervalQualifier.DAY_TO_MINUTE;
                            break block0;
                        }
                        case 56: {
                            this.read();
                            if (this.readIf(85)) {
                                n2 = this.readNonNegativeInt();
                                this.read(86);
                            }
                            intervalQualifier = IntervalQualifier.DAY_TO_SECOND;
                            break block0;
                        }
                    }
                    throw this.intervalDayError();
                }
                intervalQualifier = IntervalQualifier.DAY;
                break;
            }
            case 28: {
                this.read();
                if (this.readIf(85)) {
                    n = this.readNonNegativeInt();
                    this.read(86);
                }
                if (this.readIf("TO")) {
                    switch (this.currentTokenType) {
                        case 43: {
                            this.read();
                            intervalQualifier = IntervalQualifier.HOUR_TO_MINUTE;
                            break block0;
                        }
                        case 56: {
                            this.read();
                            if (this.readIf(85)) {
                                n2 = this.readNonNegativeInt();
                                this.read(86);
                            }
                            intervalQualifier = IntervalQualifier.HOUR_TO_SECOND;
                            break block0;
                        }
                    }
                    throw this.intervalHourError();
                }
                intervalQualifier = IntervalQualifier.HOUR;
                break;
            }
            case 43: {
                this.read();
                if (this.readIf(85)) {
                    n = this.readNonNegativeInt();
                    this.read(86);
                }
                if (this.readIf("TO")) {
                    this.read(56);
                    if (this.readIf(85)) {
                        n2 = this.readNonNegativeInt();
                        this.read(86);
                    }
                    intervalQualifier = IntervalQualifier.MINUTE_TO_SECOND;
                    break;
                }
                intervalQualifier = IntervalQualifier.MINUTE;
                break;
            }
            case 56: {
                this.read();
                if (this.readIf(85)) {
                    n = this.readNonNegativeInt();
                    if (this.readIf(89)) {
                        n2 = this.readNonNegativeInt();
                    }
                    this.read(86);
                }
                intervalQualifier = IntervalQualifier.SECOND;
                break;
            }
            default: {
                if (bl) {
                    throw this.intervalQualifierError();
                }
                return null;
            }
        }
        if (n >= 0 && (n == 0 || n > 18)) {
            throw DbException.get(90150, Integer.toString(n), "1", "18");
        }
        if (n2 >= 0 && n2 > 9) {
            throw DbException.get(90151, Integer.toString(n2), "0", "9");
        }
        TypeInfo typeInfo = TypeInfo.getTypeInfo(intervalQualifier.ordinal() + 26, n < 0 ? 2L : (long)n, n2 < 0 ? 6 : n2, null);
        return bl ? new Column(string, typeInfo, intervalQualifier.getTypeName(n, n2)) : typeInfo;
    }

    private DbException intervalQualifierError() {
        if (this.expectedList != null) {
            this.addMultipleExpected(70, 44, 16, 28, 43, 56);
        }
        return this.getSyntaxError();
    }

    private DbException intervalDayError() {
        if (this.expectedList != null) {
            this.addMultipleExpected(28, 43, 56);
        }
        return this.getSyntaxError();
    }

    private DbException intervalHourError() {
        if (this.expectedList != null) {
            this.addMultipleExpected(43, 56);
        }
        return this.getSyntaxError();
    }

    private Column parseArrayType(String string, TypeInfo typeInfo) {
        int n = -1;
        if (this.readIf(97)) {
            n = this.readNonNegativeInt();
            this.read(98);
        }
        TypeInfo typeInfo2 = TypeInfo.getTypeInfo(17, n, -1, typeInfo != null ? new ExtTypeInfoArray(typeInfo) : null);
        return new Column(string, typeInfo2, typeInfo2.toString());
    }

    private Column parseEnumType(String string) {
        this.read(85);
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            arrayList.add(this.readString());
        } while (this.readIfMore());
        ExtTypeInfoEnum extTypeInfoEnum = new ExtTypeInfoEnum(arrayList.toArray(new String[0]));
        return new Column(string, TypeInfo.getTypeInfo(25, -1L, -1, extTypeInfoEnum), "ENUM" + extTypeInfoEnum.getCreateSQL());
    }

    private Column parseGeometryType(String string) {
        ExtTypeInfoGeometry extTypeInfoGeometry;
        if (this.readIf(85)) {
            int n = 0;
            if (this.currentTokenType != 2 || this.currentTokenQuoted) {
                throw this.getSyntaxError();
            }
            if (!this.readIf("GEOMETRY")) {
                try {
                    n = EWKTUtils.parseGeometryType(this.currentToken);
                    this.read();
                    if (n / 1000 == 0 && this.currentTokenType == 2 && !this.currentTokenQuoted) {
                        n += EWKTUtils.parseDimensionSystem(this.currentToken) * 1000;
                        this.read();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw this.getSyntaxError();
                }
            }
            Integer n2 = null;
            if (this.readIf(89)) {
                n2 = this.readInt();
            }
            this.read(86);
            extTypeInfoGeometry = new ExtTypeInfoGeometry(n, n2);
        } else {
            extTypeInfoGeometry = null;
        }
        return new Column(string, TypeInfo.getTypeInfo(22, -1L, -1, extTypeInfoGeometry), extTypeInfoGeometry != null ? "GEOMETRY" + extTypeInfoGeometry.getCreateSQL() : "GEOMETRY");
    }

    private long readPrecision(int n) {
        long l = this.readPositiveLong();
        if (this.currentTokenType != 2 || this.currentTokenQuoted) {
            return l;
        }
        if ((n == 15 || n == 16) && this.currentToken.length() == 1) {
            long l2;
            switch (this.currentToken.charAt(0) & 0xFFDF) {
                case 75: {
                    l2 = 1024L;
                    break;
                }
                case 77: {
                    l2 = 0x100000L;
                    break;
                }
                case 71: {
                    l2 = 0x40000000L;
                    break;
                }
                case 84: {
                    l2 = 0x10000000000L;
                    break;
                }
                case 80: {
                    l2 = 0x4000000000000L;
                    break;
                }
                default: {
                    throw this.getSyntaxError();
                }
            }
            if (l > Long.MAX_VALUE / l2) {
                throw DbException.getInvalidValueException("precision", l + this.currentToken);
            }
            l *= l2;
            this.read();
            if (this.currentTokenType != 2 || this.currentTokenQuoted) {
                return l;
            }
        }
        switch (n) {
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                if (this.readIf("CHARACTERS") || this.readIf("OCTETS") || !this.database.getMode().charAndByteLengthUnits || this.readIf("CHAR")) break;
                this.readIf("BYTE");
            }
        }
        return l;
    }

    private Prepared parseCreate() {
        boolean bl = false;
        if (this.readIf("OR")) {
            this.read("REPLACE");
            bl = true;
        }
        boolean bl2 = this.readIf("FORCE");
        if (this.readIf("VIEW")) {
            return this.parseCreateView(bl2, bl);
        }
        if (this.readIf("ALIAS")) {
            return this.parseCreateFunctionAlias(bl2);
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseCreateSequence();
        }
        if (this.readIf("USER")) {
            return this.parseCreateUser();
        }
        if (this.readIf("TRIGGER")) {
            return this.parseCreateTrigger(bl2);
        }
        if (this.readIf("ROLE")) {
            return this.parseCreateRole();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseCreateSchema();
        }
        if (this.readIf("CONSTANT")) {
            return this.parseCreateConstant();
        }
        if (this.readIf("DOMAIN") || this.readIf("TYPE") || this.readIf("DATATYPE")) {
            return this.parseCreateDomain();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseCreateAggregate(bl2);
        }
        if (this.readIf("LINKED")) {
            return this.parseCreateLinkedTable(false, false, bl2);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.readIf("MEMORY")) {
            bl3 = true;
        } else if (this.readIf("CACHED")) {
            bl4 = true;
        }
        if (this.readIf("LOCAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, false, bl2);
            }
            this.read(59);
            return this.parseCreateTable(true, false, bl4);
        }
        if (this.readIf("GLOBAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, bl2);
            }
            this.read(59);
            return this.parseCreateTable(true, true, bl4);
        }
        if (this.readIf("TEMP") || this.readIf("TEMPORARY")) {
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, bl2);
            }
            this.read(59);
            return this.parseCreateTable(true, true, bl4);
        }
        if (this.readIf(59)) {
            if (!bl4 && !bl3) {
                bl4 = this.database.getDefaultTableType() == 0;
            }
            return this.parseCreateTable(false, false, bl4);
        }
        if (this.readIf("SYNONYM")) {
            return this.parseCreateSynonym(bl);
        }
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        String string = null;
        Schema schema = null;
        boolean bl9 = false;
        if (this.readIf(51)) {
            this.read(36);
            if (this.readIf("HASH")) {
                bl5 = true;
            }
            bl6 = true;
            if (!this.isToken(49)) {
                bl9 = this.readIfNotExists();
                string = this.readIdentifierWithSchema(null);
                schema = this.getSchema();
            }
        } else {
            if (this.readIf(62)) {
                bl7 = true;
            }
            if (this.readIf("HASH")) {
                bl5 = true;
            }
            if (this.readIf("SPATIAL")) {
                bl8 = true;
            }
            if (this.readIf("INDEX")) {
                if (!this.isToken(49)) {
                    bl9 = this.readIfNotExists();
                    string = this.readIdentifierWithSchema(null);
                    schema = this.getSchema();
                }
            } else {
                throw this.getSyntaxError();
            }
        }
        this.read(49);
        String string2 = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        String string3 = this.readCommentIf();
        if (!this.readIf(85)) {
            if (bl5 || bl8) {
                throw this.getSyntaxError();
            }
            this.read(64);
            if (!this.readIf("BTREE")) {
                if (this.readIf("HASH")) {
                    bl5 = true;
                } else {
                    this.read("RTREE");
                    bl8 = true;
                }
            }
            this.read(85);
        }
        CreateIndex createIndex = new CreateIndex(this.session, this.getSchema());
        createIndex.setIfNotExists(bl9);
        createIndex.setPrimaryKey(bl6);
        createIndex.setTableName(string2);
        createIndex.setUnique(bl7);
        createIndex.setHash(bl5);
        createIndex.setSpatial(bl8);
        createIndex.setIndexName(string);
        createIndex.setComment(string3);
        createIndex.setIndexColumns(this.parseIndexColumnList());
        return createIndex;
    }

    private boolean addRoleOrRight(GrantRevoke grantRevoke) {
        if (this.readIf(57)) {
            grantRevoke.addRight(1);
            return true;
        }
        if (this.readIf("DELETE")) {
            grantRevoke.addRight(2);
            return true;
        }
        if (this.readIf("INSERT")) {
            grantRevoke.addRight(4);
            return true;
        }
        if (this.readIf("UPDATE")) {
            grantRevoke.addRight(8);
            return true;
        }
        if (this.readIf("CONNECT")) {
            return true;
        }
        if (this.readIf("RESOURCE")) {
            return true;
        }
        grantRevoke.addRoleName(this.readUniqueIdentifier());
        return false;
    }

    private GrantRevoke parseGrantRevoke(int n) {
        boolean bl;
        GrantRevoke grantRevoke = new GrantRevoke(this.session);
        grantRevoke.setOperationType(n);
        if (this.readIf(3)) {
            this.readIf("PRIVILEGES");
            grantRevoke.addRight(15);
            bl = true;
        } else if (this.readIf("ALTER")) {
            this.read("ANY");
            this.read("SCHEMA");
            grantRevoke.addRight(16);
            grantRevoke.addTable(null);
            bl = false;
        } else {
            bl = this.addRoleOrRight(grantRevoke);
            while (this.readIf(89)) {
                if (this.addRoleOrRight(grantRevoke) == bl) continue;
                throw DbException.get(90072);
            }
        }
        if (bl && this.readIf(49)) {
            if (this.readIf("SCHEMA")) {
                Schema schema = this.database.getSchema(this.readAliasIdentifier());
                grantRevoke.setSchema(schema);
            } else {
                this.readIf(59);
                do {
                    Table table = this.readTableOrView();
                    grantRevoke.addTable(table);
                } while (this.readIf(89));
            }
        }
        if (n == 49) {
            this.read("TO");
        } else {
            this.read(24);
        }
        grantRevoke.setGranteeName(this.readUniqueIdentifier());
        return grantRevoke;
    }

    private TableValueConstructor parseValues() {
        int n;
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        ArrayList<ArrayList<Expression>> arrayList2 = Utils.newSmallArrayList();
        do {
            boolean bl;
            n = 0;
            ArrayList arrayList3 = Utils.newSmallArrayList();
            if (this.readIf(54)) {
                this.read(85);
                bl = true;
            } else {
                bl = this.readIf(85);
            }
            do {
                Column column;
                Expression expression = this.readExpression();
                expression = expression.optimize(this.session);
                TypeInfo typeInfo = expression.getType();
                String string = "C" + (n + 1);
                if (arrayList2.isEmpty()) {
                    if (typeInfo.getValueType() == -1) {
                        typeInfo = TypeInfo.TYPE_VARCHAR;
                    }
                    column = new Column(string, typeInfo);
                    arrayList.add(column);
                } else {
                    if (n >= arrayList.size()) {
                        throw DbException.get(21002);
                    }
                    typeInfo = Value.getHigherType(((Column)arrayList.get(n)).getType(), typeInfo);
                    column = new Column(string, typeInfo);
                    arrayList.set(n, column);
                }
                arrayList3.add(expression);
                ++n;
            } while (bl && this.readIfMore());
            arrayList2.add(arrayList3);
        } while (this.readIf(89));
        n = arrayList.size();
        for (ArrayList arrayList4 : arrayList2) {
            if (arrayList4.size() == n) continue;
            throw DbException.get(21002);
        }
        for (int i = 0; i < n; ++i) {
            Column column = (Column)arrayList.get(i);
            if (column.getType().getValueType() != -1) continue;
            Column column2 = new Column(column.getName(), 13);
            arrayList.set(i, column2);
        }
        return new TableValueConstructor(this.session, arrayList.toArray(new Column[0]), arrayList2);
    }

    private Call parseCall() {
        Call call = new Call(this.session);
        this.currentPrepared = call;
        call.setExpression(this.readExpression());
        return call;
    }

    private CreateRole parseCreateRole() {
        CreateRole createRole = new CreateRole(this.session);
        createRole.setIfNotExists(this.readIfNotExists());
        createRole.setRoleName(this.readUniqueIdentifier());
        return createRole;
    }

    private CreateSchema parseCreateSchema() {
        CreateSchema createSchema = new CreateSchema(this.session);
        createSchema.setIfNotExists(this.readIfNotExists());
        createSchema.setSchemaName(this.readUniqueIdentifier());
        if (this.readIf("AUTHORIZATION")) {
            createSchema.setAuthorization(this.readUniqueIdentifier());
        } else {
            createSchema.setAuthorization(this.session.getUser().getName());
        }
        if (this.readIf(69)) {
            createSchema.setTableEngineParams(this.readTableEngineParams());
        }
        return createSchema;
    }

    private ArrayList<String> readTableEngineParams() {
        ArrayList<String> arrayList = Utils.newSmallArrayList();
        do {
            arrayList.add(this.readUniqueIdentifier());
        } while (this.readIf(89));
        return arrayList;
    }

    private CreateSequence parseCreateSequence() {
        boolean bl = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        CreateSequence createSequence = new CreateSequence(this.session, this.getSchema());
        createSequence.setIfNotExists(bl);
        createSequence.setSequenceName(string);
        SequenceOptions sequenceOptions = new SequenceOptions();
        this.parseSequenceOptions(sequenceOptions, createSequence, true);
        createSequence.setOptions(sequenceOptions);
        return createSequence;
    }

    private boolean readIfNotExists() {
        if (this.readIf(29)) {
            this.read(46);
            this.read(19);
            return true;
        }
        return false;
    }

    private CreateConstant parseCreateConstant() {
        boolean bl = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.isKeyword(string)) {
            throw DbException.get(90114, string);
        }
        this.read(65);
        Expression expression = this.readExpression();
        CreateConstant createConstant = new CreateConstant(this.session, schema);
        createConstant.setConstantName(string);
        createConstant.setExpression(expression);
        createConstant.setIfNotExists(bl);
        return createConstant;
    }

    private CreateAggregate parseCreateAggregate(boolean bl) {
        boolean bl2 = this.readIfNotExists();
        CreateAggregate createAggregate = new CreateAggregate(this.session);
        createAggregate.setForce(bl);
        String string = this.readIdentifierWithSchema();
        if (this.isKeyword(string) || Function.getFunction(this.database, string) != null || this.getAggregateType(string) != null) {
            throw DbException.get(90076, string);
        }
        createAggregate.setName(string);
        createAggregate.setSchema(this.getSchema());
        createAggregate.setIfNotExists(bl2);
        this.read(22);
        createAggregate.setJavaClassMethod(this.readUniqueIdentifier());
        return createAggregate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateDomain parseCreateDomain() {
        String string;
        boolean bl = this.readIfNotExists();
        String string2 = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        CreateDomain createDomain = new CreateDomain(this.session, schema);
        createDomain.setTypeName(string2);
        this.readIf(5);
        Column column = this.parseColumnWithType("VALUE");
        if (this.readIf("DEFAULT")) {
            column.setDefaultExpression(this.session, this.readExpression());
        }
        if (this.readIf(49)) {
            this.read("UPDATE");
            column.setOnUpdateExpression(this.session, this.readExpression());
        }
        if (this.readIf("SELECTIVITY")) {
            column.setSelectivity(this.readNonNegativeInt());
        }
        if ((string = this.readCommentIf()) != null) {
            column.setComment(string);
        }
        while (true) {
            String string3;
            if (this.readIf(8)) {
                string3 = this.readColumnIdentifier();
                this.read(7);
            } else {
                if (!this.readIf(7)) break;
                string3 = null;
            }
            AlterDomainAddConstraint alterDomainAddConstraint = new AlterDomainAddConstraint(this.session, schema, bl);
            alterDomainAddConstraint.setConstraintName(string3);
            alterDomainAddConstraint.setDomainName(string2);
            this.parseDomainConstraint = true;
            try {
                alterDomainAddConstraint.setCheckExpression(this.readExpression());
            }
            finally {
                this.parseDomainConstraint = false;
            }
            createDomain.addConstraintCommand(alterDomainAddConstraint);
        }
        column.rename(null);
        createDomain.setColumn(column);
        createDomain.setIfNotExists(bl);
        return createDomain;
    }

    private CreateTrigger parseCreateTrigger(boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema(null);
        Schema schema = this.getSchema();
        if (this.readIf("INSTEAD")) {
            this.read("OF");
            bl3 = true;
            bl2 = true;
        } else if (this.readIf("BEFORE")) {
            bl2 = false;
            bl3 = true;
        } else {
            this.read("AFTER");
            bl2 = false;
            bl3 = false;
        }
        int n = 0;
        boolean bl5 = false;
        do {
            if (this.readIf("INSERT")) {
                n |= 1;
                continue;
            }
            if (this.readIf("UPDATE")) {
                n |= 2;
                continue;
            }
            if (this.readIf("DELETE")) {
                n |= 4;
                continue;
            }
            if (this.readIf(57)) {
                n |= 8;
                continue;
            }
            if (this.readIf("ROLLBACK")) {
                bl5 = true;
                continue;
            }
            throw this.getSyntaxError();
        } while (this.readIf(89) || this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL && this.readIf("OR"));
        this.read(49);
        String string2 = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateTrigger createTrigger = new CreateTrigger(this.session, this.getSchema());
        createTrigger.setForce(bl);
        createTrigger.setTriggerName(string);
        createTrigger.setIfNotExists(bl4);
        createTrigger.setInsteadOf(bl2);
        createTrigger.setBefore(bl3);
        createTrigger.setOnRollback(bl5);
        createTrigger.setTypeMask(n);
        createTrigger.setTableName(string2);
        if (this.readIf(22)) {
            this.read("EACH");
            if (this.readIf(54)) {
                createTrigger.setRowBased(true);
            } else {
                this.read("STATEMENT");
            }
        }
        if (this.readIf("QUEUE")) {
            createTrigger.setQueueSize(this.readNonNegativeInt());
        }
        createTrigger.setNoWait(this.readIf("NOWAIT"));
        if (this.readIf(5)) {
            createTrigger.setTriggerSource(this.readString());
        } else {
            this.read("CALL");
            createTrigger.setTriggerClassName(this.readUniqueIdentifier());
        }
        return createTrigger;
    }

    private CreateUser parseCreateUser() {
        CreateUser createUser = new CreateUser(this.session);
        createUser.setIfNotExists(this.readIfNotExists());
        createUser.setUserName(this.readUniqueIdentifier());
        createUser.setComment(this.readCommentIf());
        if (this.readIf("PASSWORD")) {
            createUser.setPassword(this.readExpression());
        } else if (this.readIf("SALT")) {
            createUser.setSalt(this.readExpression());
            this.read("HASH");
            createUser.setHash(this.readExpression());
        } else if (this.readIf("IDENTIFIED")) {
            this.read("BY");
            createUser.setPassword(ValueExpression.get(ValueVarchar.get(this.readColumnIdentifier())));
        } else {
            throw this.getSyntaxError();
        }
        if (this.readIf("ADMIN")) {
            createUser.setAdmin(true);
        }
        return createUser;
    }

    private CreateFunctionAlias parseCreateFunctionAlias(boolean bl) {
        boolean bl2;
        String string;
        boolean bl3 = this.readIfNotExists();
        if (this.currentTokenType != 2) {
            string = this.currentToken;
            this.read();
            this.schemaName = this.session.getCurrentSchemaName();
        } else {
            string = this.readIdentifierWithSchema();
        }
        boolean bl4 = bl2 = Function.getFunction(this.database, string) != null;
        if (!(this.database.isAllowBuiltinAliasOverride() && bl2 || !this.isKeyword(string) && !bl2 && this.getAggregateType(string) == null)) {
            throw DbException.get(90076, string);
        }
        CreateFunctionAlias createFunctionAlias = new CreateFunctionAlias(this.session, this.getSchema());
        createFunctionAlias.setForce(bl);
        createFunctionAlias.setAliasName(string);
        createFunctionAlias.setIfNotExists(bl3);
        createFunctionAlias.setDeterministic(this.readIf("DETERMINISTIC"));
        this.readIf("NOBUFFER");
        if (this.readIf(5)) {
            createFunctionAlias.setSource(this.readString());
        } else {
            this.read(22);
            createFunctionAlias.setJavaClassMethod(this.readUniqueIdentifier());
        }
        return createFunctionAlias;
    }

    private Prepared parseWith() {
        ArrayList<TableView> arrayList = new ArrayList<TableView>();
        try {
            return this.parseWith1(arrayList);
        }
        catch (Throwable throwable) {
            CommandContainer.clearCTE(this.session, arrayList);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Prepared parseWith1(List<TableView> list) {
        Prepared prepared;
        this.readIf("RECURSIVE");
        boolean bl = !this.session.isParsingCreateView();
        do {
            list.add(this.parseSingleCommonTableExpression(bl));
        } while (this.readIf(89));
        Collections.reverse(list);
        int n = 0;
        while (this.readIf(85)) {
            ++n;
        }
        int n2 = this.lastParseIndex;
        if (this.isToken(57) || this.isToken(66)) {
            prepared = this.parseWithQuery();
        } else if (this.isToken(59)) {
            int n3 = this.lastParseIndex;
            this.read();
            if (this.isToken(85)) throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            this.parseIndex = n3;
            this.read();
            prepared = this.parseWithQuery();
        } else if (this.readIf("INSERT")) {
            prepared = this.parseInsert(n2);
            prepared.setPrepareAlways(true);
        } else if (this.readIf("UPDATE")) {
            prepared = this.parseUpdate(n2);
            prepared.setPrepareAlways(true);
        } else if (this.readIf("MERGE")) {
            prepared = this.parseMerge(n2);
            prepared.setPrepareAlways(true);
        } else if (this.readIf("DELETE")) {
            prepared = this.parseDelete(n2);
            prepared.setPrepareAlways(true);
        } else {
            if (!this.readIf("CREATE")) throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            if (!this.isToken(59)) {
                throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            }
            prepared = this.parseCreate();
            prepared.setPrepareAlways(true);
        }
        while (n > 0) {
            this.read(86);
            --n;
        }
        if (!bl) return prepared;
        prepared.setCteCleanups(list);
        return prepared;
    }

    private Prepared parseWithQuery() {
        Query query = this.parseSelectUnion();
        query.setPrepareAlways(true);
        query.setNeverLazy(true);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableView parseSingleCommonTableExpression(boolean bl) {
        List<Column> list;
        String[] stringArray;
        Object object;
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        String[] stringArray2 = null;
        if (this.readIf(85)) {
            stringArray2 = this.parseColumnList();
            object = stringArray2;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                stringArray = object[i];
                arrayList.add(new Column((String)stringArray, 13));
            }
        }
        if ((object = !bl ? this.getSchema().findTableOrView(this.session, string) : this.session.findLocalTempTable(string)) != null) {
            if (!(object instanceof TableView)) {
                throw DbException.get(42101, string);
            }
            TableView tableView = (TableView)object;
            if (!tableView.isTableExpression()) {
                throw DbException.get(42101, string);
            }
            if (!bl) {
                ((Table)object).lock(this.session, true, true);
                this.database.removeSchemaObject(this.session, (SchemaObject)object);
            } else {
                this.session.removeLocalTempTable((Table)object);
            }
        }
        Table table = TableView.createShadowTableForRecursiveTableExpression(bl, this.session, string, schema, arrayList, this.database);
        stringArray = new String[]{null};
        try {
            this.read(5);
            this.read(85);
            Query query = this.parseQuery();
            if (!bl) {
                query.session = this.session;
            }
            this.read(86);
            list = TableView.createQueryColumnTemplateList(stringArray2, query, stringArray);
        }
        finally {
            TableView.destroyShadowTableForRecursiveExpression(bl, this.session, table);
        }
        return this.createCTEView(string, stringArray[0], list, true, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableView createCTEView(String string, String string2, List<Column> list, boolean bl, boolean bl2, boolean bl3) {
        TableView tableView;
        Schema schema = this.getSchemaWithDefault();
        int n = this.database.allocateObjectId();
        Column[] columnArray = list.toArray(new Column[0]);
        Session session = this.session;
        synchronized (session) {
            tableView = new TableView(schema, n, string, string2, this.parameters, columnArray, this.session, bl, false, true, bl3);
            if (!tableView.isRecursiveQueryDetected() && bl) {
                if (!bl3) {
                    this.database.addSchemaObject(this.session, tableView);
                    tableView.lock(this.session, true, true);
                    this.database.removeSchemaObject(this.session, tableView);
                } else {
                    this.session.removeLocalTempTable(tableView);
                }
                tableView = new TableView(schema, n, string, string2, this.parameters, columnArray, this.session, false, false, true, bl3);
            }
            this.database.unlockMeta(this.session);
        }
        tableView.setTableExpression(true);
        tableView.setTemporary(bl3);
        tableView.setHidden(true);
        tableView.setOnCommitDrop(false);
        if (bl2) {
            if (!bl3) {
                this.database.addSchemaObject(this.session, tableView);
                tableView.unlock(this.session);
                this.database.unlockMeta(this.session);
            } else {
                this.session.addLocalTempTable(tableView);
            }
        }
        return tableView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateView parseCreateView(boolean bl, boolean bl2) {
        Object object;
        CreateView createView;
        boolean bl3 = this.readIfNotExists();
        boolean bl4 = this.readIf("TABLE_EXPRESSION");
        String string = this.readIdentifierWithSchema();
        this.createView = createView = new CreateView(this.session, this.getSchema());
        createView.setViewName(string);
        createView.setIfNotExists(bl3);
        createView.setComment(this.readCommentIf());
        createView.setOrReplace(bl2);
        createView.setForce(bl);
        createView.setTableExpression(bl4);
        if (this.readIf(85)) {
            object = this.parseColumnList();
            createView.setColumnNames((String[])object);
        }
        object = StringUtils.cache(this.sqlCommand.substring(this.parseIndex));
        this.read(5);
        try {
            Query query;
            this.session.setParsingCreateView(true, string);
            try {
                query = this.parseQuery();
                query.prepare();
            }
            finally {
                this.session.setParsingCreateView(false, string);
            }
            createView.setSelect(query);
        }
        catch (DbException dbException) {
            if (bl) {
                createView.setSelectSQL((String)object);
                while (this.currentTokenType != 73) {
                    this.read();
                }
            }
            throw dbException;
        }
        return createView;
    }

    private TransactionCommand parseCheckpoint() {
        TransactionCommand transactionCommand = this.readIf("SYNC") ? new TransactionCommand(this.session, 76) : new TransactionCommand(this.session, 73);
        return transactionCommand;
    }

    private Prepared parseAlter() {
        if (this.readIf(59)) {
            return this.parseAlterTable();
        }
        if (this.readIf("USER")) {
            return this.parseAlterUser();
        }
        if (this.readIf("INDEX")) {
            return this.parseAlterIndex();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseAlterSchema();
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseAlterSequence();
        }
        if (this.readIf("VIEW")) {
            return this.parseAlterView();
        }
        if (this.readIf("DOMAIN")) {
            return this.parseAlterDomain();
        }
        throw this.getSyntaxError();
    }

    private void checkSchema(Schema schema) {
        if (schema != null && this.getSchema() != schema) {
            throw DbException.get(90080);
        }
    }

    private AlterIndexRename parseAlterIndex() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        AlterIndexRename alterIndexRename = new AlterIndexRename(this.session);
        alterIndexRename.setOldSchema(schema);
        alterIndexRename.setOldName(string);
        alterIndexRename.setIfExists(bl);
        this.read("RENAME");
        this.read("TO");
        String string2 = this.readIdentifierWithSchema(schema.getName());
        this.checkSchema(schema);
        alterIndexRename.setNewName(string2);
        return alterIndexRename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefineCommand parseAlterDomain() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        Domain domain = schema.findDomain(string);
        if (domain == null && !bl) {
            throw DbException.get(90120, string);
        }
        if (this.readIf("ADD")) {
            boolean bl2 = false;
            String string2 = null;
            String string3 = null;
            if (this.readIf(8)) {
                bl2 = this.readIfNotExists();
                string2 = this.readIdentifierWithSchema(schema.getName());
                this.checkSchema(schema);
                string3 = this.readCommentIf();
            }
            this.read(7);
            AlterDomainAddConstraint alterDomainAddConstraint = new AlterDomainAddConstraint(this.session, schema, bl2);
            alterDomainAddConstraint.setDomainName(string);
            alterDomainAddConstraint.setConstraintName(string2);
            this.parseDomainConstraint = true;
            try {
                alterDomainAddConstraint.setCheckExpression(this.readExpression());
            }
            finally {
                this.parseDomainConstraint = false;
            }
            alterDomainAddConstraint.setIfDomainExists(bl);
            alterDomainAddConstraint.setComment(string3);
            if (this.readIf("NOCHECK")) {
                alterDomainAddConstraint.setCheckExisting(false);
            } else {
                this.readIf(7);
                alterDomainAddConstraint.setCheckExisting(true);
            }
            return alterDomainAddConstraint;
        }
        this.read("DROP");
        this.read(8);
        boolean bl3 = this.readIfExists(false);
        String string4 = this.readIdentifierWithSchema(schema.getName());
        this.checkSchema(schema);
        AlterDomainDropConstraint alterDomainDropConstraint = new AlterDomainDropConstraint(this.session, this.getSchema(), bl3);
        alterDomainDropConstraint.setConstraintName(string4);
        alterDomainDropConstraint.setDomainName(string);
        alterDomainDropConstraint.setIfDomainExists(bl);
        return alterDomainDropConstraint;
    }

    private DefineCommand parseAlterView() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        Table table = schema.findTableOrView(this.session, string);
        if (!(table instanceof TableView) && !bl) {
            throw DbException.get(90037, string);
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            String string2 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            AlterTableRename alterTableRename = new AlterTableRename(this.session, this.getSchema());
            alterTableRename.setOldTableName(string);
            alterTableRename.setNewTableName(string2);
            alterTableRename.setIfTableExists(bl);
            return alterTableRename;
        }
        this.read("RECOMPILE");
        TableView tableView = (TableView)table;
        AlterView alterView = new AlterView(this.session);
        alterView.setIfExists(bl);
        alterView.setView(tableView);
        return alterView;
    }

    private Prepared parseAlterSchema() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        this.read("RENAME");
        this.read("TO");
        String string2 = this.readIdentifierWithSchema(schema.getName());
        Schema schema2 = this.findSchema(string);
        if (schema2 == null) {
            if (bl) {
                return new NoOperation(this.session);
            }
            throw DbException.get(90079, string);
        }
        AlterSchemaRename alterSchemaRename = new AlterSchemaRename(this.session);
        alterSchemaRename.setOldSchema(schema2);
        this.checkSchema(schema);
        alterSchemaRename.setNewName(string2);
        return alterSchemaRename;
    }

    private AlterSequence parseAlterSequence() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        AlterSequence alterSequence = new AlterSequence(this.session, this.getSchema());
        alterSequence.setSequenceName(string);
        alterSequence.setIfExists(bl);
        SequenceOptions sequenceOptions = new SequenceOptions();
        this.parseSequenceOptions(sequenceOptions, null, false);
        alterSequence.setOptions(sequenceOptions);
        return alterSequence;
    }

    private void parseSequenceOptions(SequenceOptions sequenceOptions, CreateSequence createSequence, boolean bl) {
        while (true) {
            if (this.readIf("START")) {
                this.read(69);
                sequenceOptions.setStartValue(this.readExpression());
                continue;
            }
            if (this.readIf("RESTART")) {
                sequenceOptions.setRestartValue(this.readIf(69) ? this.readExpression() : ValueExpression.DEFAULT);
                continue;
            }
            if (this.readIf("INCREMENT")) {
                this.readIf("BY");
                sequenceOptions.setIncrement(this.readExpression());
                continue;
            }
            if (this.readIf("MINVALUE")) {
                sequenceOptions.setMinValue(this.readExpression());
                continue;
            }
            if (this.readIf("NOMINVALUE")) {
                sequenceOptions.setMinValue(ValueExpression.NULL);
                continue;
            }
            if (this.readIf("MAXVALUE")) {
                sequenceOptions.setMaxValue(this.readExpression());
                continue;
            }
            if (this.readIf("NOMAXVALUE")) {
                sequenceOptions.setMaxValue(ValueExpression.NULL);
                continue;
            }
            if (this.readIf("CYCLE")) {
                sequenceOptions.setCycle(true);
                continue;
            }
            if (this.readIf("NOCYCLE")) {
                sequenceOptions.setCycle(false);
                continue;
            }
            if (this.readIf("NO")) {
                if (this.readIf("MINVALUE")) {
                    sequenceOptions.setMinValue(ValueExpression.NULL);
                    continue;
                }
                if (this.readIf("MAXVALUE")) {
                    sequenceOptions.setMaxValue(ValueExpression.NULL);
                    continue;
                }
                if (this.readIf("CYCLE")) {
                    sequenceOptions.setCycle(false);
                    continue;
                }
                if (!this.readIf("CACHE")) break;
                sequenceOptions.setCacheSize(ValueExpression.get(ValueBigint.get(1L)));
                continue;
            }
            if (this.readIf("CACHE")) {
                sequenceOptions.setCacheSize(this.readExpression());
                continue;
            }
            if (this.readIf("NOCACHE")) {
                sequenceOptions.setCacheSize(ValueExpression.get(ValueBigint.get(1L)));
                continue;
            }
            if (createSequence == null) break;
            if (this.readIf("BELONGS_TO_TABLE")) {
                createSequence.setBelongsToTable(true);
                continue;
            }
            if (!this.readIf(50)) break;
        }
    }

    private AlterUser parseAlterUser() {
        String string = this.readUniqueIdentifier();
        if (this.readIf(58)) {
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(19);
            alterUser.setUser(this.database.getUser(string));
            if (this.readIf("PASSWORD")) {
                alterUser.setPassword(this.readExpression());
            } else if (this.readIf("SALT")) {
                alterUser.setSalt(this.readExpression());
                this.read("HASH");
                alterUser.setHash(this.readExpression());
            } else {
                throw this.getSyntaxError();
            }
            return alterUser;
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(18);
            alterUser.setUser(this.database.getUser(string));
            String string2 = this.readUniqueIdentifier();
            alterUser.setNewName(string2);
            return alterUser;
        }
        if (this.readIf("ADMIN")) {
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(17);
            User user = this.database.getUser(string);
            alterUser.setUser(user);
            if (this.readIf(60)) {
                alterUser.setAdmin(true);
            } else if (this.readIf(20)) {
                alterUser.setAdmin(false);
            } else {
                throw this.getSyntaxError();
            }
            return alterUser;
        }
        throw this.getSyntaxError();
    }

    private void readIfEqualOrTo() {
        if (!this.readIf(75)) {
            this.readIf("TO");
        }
    }

    private Prepared parseSet() {
        int n;
        if (this.readIf(81)) {
            Set set = new Set(this.session, 33);
            set.setString(this.readAliasIdentifier());
            this.readIfEqualOrTo();
            set.setExpression(this.readExpression());
            return set;
        }
        if (this.readIf("AUTOCOMMIT")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            int n2 = bl ? 69 : 70;
            return new TransactionCommand(this.session, n2);
        }
        if (this.readIf("EXCLUSIVE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 31);
            set.setExpression(this.readExpression());
            return set;
        }
        if (this.readIf("IGNORECASE")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            Set set = new Set(this.session, 1);
            set.setInt(bl ? 1 : 0);
            return set;
        }
        if (this.readIf("PASSWORD")) {
            this.readIfEqualOrTo();
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(19);
            alterUser.setUser(this.session.getUser());
            alterUser.setPassword(this.readExpression());
            return alterUser;
        }
        if (this.readIf("SALT")) {
            this.readIfEqualOrTo();
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(19);
            alterUser.setUser(this.session.getUser());
            alterUser.setSalt(this.readExpression());
            this.read("HASH");
            alterUser.setHash(this.readExpression());
            return alterUser;
        }
        if (this.readIf("MODE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 3);
            set.setString(this.readAliasIdentifier());
            return set;
        }
        if (this.readIf("COMPRESS_LOB")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 23);
            if (this.currentTokenType == 74) {
                set.setString(this.readString());
            } else {
                set.setString(this.readUniqueIdentifier());
            }
            return set;
        }
        if (this.readIf("DATABASE")) {
            this.readIfEqualOrTo();
            this.read("COLLATION");
            return this.parseSetCollation();
        }
        if (this.readIf("COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetCollation();
        }
        if (this.readIf("BINARY_COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetBinaryCollation(36);
        }
        if (this.readIf("UUID_COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetBinaryCollation(46);
        }
        if (this.readIf("CLUSTER")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 13);
            set.setString(this.readString());
            return set;
        }
        if (this.readIf("DATABASE_EVENT_LISTENER")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 15);
            set.setString(this.readString());
            return set;
        }
        if (this.readIf("ALLOW_LITERALS")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 24);
            if (this.readIf("NONE")) {
                set.setInt(0);
            } else if (this.readIf(3)) {
                set.setInt(2);
            } else if (this.readIf("NUMBERS")) {
                set.setInt(1);
            } else {
                set.setInt(this.readNonNegativeInt());
            }
            return set;
        }
        if (this.readIf("DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 7);
            if (this.readIf("MEMORY")) {
                set.setInt(1);
            } else if (this.readIf("CACHED")) {
                set.setInt(0);
            } else {
                set.setInt(this.readNonNegativeInt());
            }
            return set;
        }
        if (this.readIf("CREATE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("HSQLDB.DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_STORE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("CACHE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("FILE_LOCK")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("DB_CLOSE_ON_EXIT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("NETWORK_TIMEOUT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("STATEMENT_TIMEOUT")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 34);
            set.setInt(this.readNonNegativeInt());
            return set;
        }
        if (this.readIf("AUTO_SERVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_SERVER_PORT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_RECONNECT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ASSERT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ACCESS_MODE_DATA")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("OPEN_NEW")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("JMX")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_SIZE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("RECOVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("NAMES")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCOPE_GENERATED_KEYS")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCHEMA")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 25);
            set.setExpression(this.readExpressionOrIdentifier());
            return set;
        }
        if (this.readIf("CATALOG")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 48);
            set.setExpression(this.readExpressionOrIdentifier());
            return set;
        }
        if (this.readIf("DATESTYLE")) {
            String string;
            this.readIfEqualOrTo();
            if (!this.readIf("ISO") && !this.equalsToken(string = this.readString(), "ISO")) {
                throw this.getSyntaxError();
            }
            return new NoOperation(this.session);
        }
        if (this.readIf("SEARCH_PATH") || this.readIf(SetTypes.getTypeName(27))) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 27);
            ArrayList<String> arrayList = Utils.newSmallArrayList();
            do {
                arrayList.add(this.readAliasIdentifier());
            } while (this.readIf(89));
            set.setStringArray(arrayList.toArray(new String[0]));
            return set;
        }
        if (this.readIf("JAVA_OBJECT_SERIALIZER")) {
            this.readIfEqualOrTo();
            return this.parseSetJavaObjectSerializer();
        }
        if (this.readIf("IGNORE_CATALOGS")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            Set set = new Set(this.session, 47);
            set.setInt(bl ? 1 : 0);
            return set;
        }
        if (this.readIf("SESSION")) {
            this.read("CHARACTERISTICS");
            this.read(5);
            this.read("TRANSACTION");
            return this.parseSetTransactionMode();
        }
        if (this.readIf("TRANSACTION")) {
            return this.parseSetTransactionMode();
        }
        if (this.readIf("TIME")) {
            this.read("ZONE");
            Set set = new Set(this.session, 50);
            if (!this.readIf("LOCAL")) {
                set.setExpression(this.readExpression());
            }
            return set;
        }
        if (this.readIf("NON_KEYWORDS")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 49);
            ArrayList<String> arrayList = Utils.newSmallArrayList();
            if (this.currentTokenType != 73 && this.currentTokenType != 95) {
                do {
                    if (this.currentTokenType < 2 || this.currentTokenType > 71) {
                        throw this.getSyntaxError();
                    }
                    arrayList.add(StringUtils.toUpperEnglish(this.currentToken));
                    this.read();
                } while (this.readIf(89));
            }
            set.setStringArray(arrayList.toArray(new String[0]));
            return set;
        }
        if (this.isToken("LOGSIZE")) {
            this.currentToken = SetTypes.getTypeName(2);
        }
        if (this.isToken("FOREIGN_KEY_CHECKS")) {
            this.currentToken = SetTypes.getTypeName(29);
        }
        String string = this.currentToken;
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((n = SetTypes.getType(string)) < 0) {
            throw this.getSyntaxError();
        }
        this.read();
        this.readIfEqualOrTo();
        Set set = new Set(this.session, n);
        set.setExpression(this.readExpression());
        return set;
    }

    private Prepared parseSetTransactionMode() {
        IsolationLevel isolationLevel;
        this.read("ISOLATION");
        this.read("LEVEL");
        if (this.readIf("READ")) {
            if (this.readIf("UNCOMMITTED")) {
                isolationLevel = IsolationLevel.READ_UNCOMMITTED;
            } else {
                this.read("COMMITTED");
                isolationLevel = IsolationLevel.READ_COMMITTED;
            }
        } else if (this.readIf("REPEATABLE")) {
            this.read("READ");
            isolationLevel = IsolationLevel.REPEATABLE_READ;
        } else if (this.readIf("SNAPSHOT")) {
            isolationLevel = IsolationLevel.SNAPSHOT;
        } else {
            this.read("SERIALIZABLE");
            isolationLevel = IsolationLevel.SERIALIZABLE;
        }
        return new SetSessionCharacteristics(this.session, isolationLevel);
    }

    private Expression readExpressionOrIdentifier() {
        if (this.isIdentifier()) {
            return ValueExpression.get(ValueVarchar.get(this.readAliasIdentifier()));
        }
        return this.readExpression();
    }

    private Prepared parseUse() {
        this.readIfEqualOrTo();
        Set set = new Set(this.session, 25);
        set.setExpression(ValueExpression.get(ValueVarchar.get(this.readAliasIdentifier())));
        return set;
    }

    private Set parseSetCollation() {
        Set set = new Set(this.session, 12);
        String string = this.readAliasIdentifier();
        set.setString(string);
        if (this.equalsToken(string, "OFF")) {
            return set;
        }
        Collator collator = CompareMode.getCollator(string);
        if (collator == null) {
            throw DbException.getInvalidValueException("collation", string);
        }
        if (this.readIf("STRENGTH")) {
            if (this.readIf(51)) {
                set.setInt(0);
            } else if (this.readIf("SECONDARY")) {
                set.setInt(1);
            } else if (this.readIf("TERTIARY")) {
                set.setInt(2);
            } else if (this.readIf("IDENTICAL")) {
                set.setInt(3);
            }
        } else {
            set.setInt(collator.getStrength());
        }
        return set;
    }

    private Set parseSetBinaryCollation(int n) {
        String string = this.readAliasIdentifier();
        if (this.equalsToken(string, "UNSIGNED") || this.equalsToken(string, "SIGNED")) {
            Set set = new Set(this.session, n);
            set.setString(string);
            return set;
        }
        throw DbException.getInvalidValueException(SetTypes.getTypeName(n), string);
    }

    private Set parseSetJavaObjectSerializer() {
        Set set = new Set(this.session, 37);
        String string = this.readString();
        set.setString(string);
        return set;
    }

    private RunScriptCommand parseRunScript() {
        RunScriptCommand runScriptCommand = new RunScriptCommand(this.session);
        this.read(24);
        runScriptCommand.setFileNameExpr(this.readExpression());
        if (this.readIf("COMPRESSION")) {
            runScriptCommand.setCompressionAlgorithm(this.readUniqueIdentifier());
        }
        if (this.readIf("CIPHER")) {
            runScriptCommand.setCipher(this.readUniqueIdentifier());
            if (this.readIf("PASSWORD")) {
                runScriptCommand.setPassword(this.readExpression());
            }
        }
        if (this.readIf("CHARSET")) {
            runScriptCommand.setCharset(Charset.forName(this.readString()));
        }
        if (this.readIf("VARIABLE_BINARY")) {
            runScriptCommand.setVariableBinary(true);
        }
        return runScriptCommand;
    }

    private ScriptCommand parseScript() {
        ScriptCommand scriptCommand = new ScriptCommand(this.session);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (this.readIf("NODATA")) {
            bl = false;
        } else {
            if (this.readIf("SIMPLE")) {
                bl5 = true;
            }
            if (this.readIf("COLUMNS")) {
                bl6 = true;
            }
        }
        if (this.readIf("NOPASSWORDS")) {
            bl2 = false;
        }
        if (this.readIf("NOSETTINGS")) {
            bl3 = false;
        }
        if (this.readIf("DROP")) {
            bl4 = true;
        }
        if (this.readIf("BLOCKSIZE")) {
            long l = this.readLong();
            scriptCommand.setLobBlockSize(l);
        }
        scriptCommand.setData(bl);
        scriptCommand.setPasswords(bl2);
        scriptCommand.setSettings(bl3);
        scriptCommand.setDrop(bl4);
        scriptCommand.setSimple(bl5);
        scriptCommand.setWithColumns(bl6);
        if (this.readIf("TO")) {
            scriptCommand.setFileNameExpr(this.readExpression());
            if (this.readIf("COMPRESSION")) {
                scriptCommand.setCompressionAlgorithm(this.readUniqueIdentifier());
            }
            if (this.readIf("CIPHER")) {
                scriptCommand.setCipher(this.readUniqueIdentifier());
                if (this.readIf("PASSWORD")) {
                    scriptCommand.setPassword(this.readExpression());
                }
            }
            if (this.readIf("CHARSET")) {
                scriptCommand.setCharset(Charset.forName(this.readString()));
            }
        }
        if (this.readIf("SCHEMA")) {
            HashSet<String> hashSet = new HashSet<String>();
            do {
                hashSet.add(this.readUniqueIdentifier());
            } while (this.readIf(89));
            scriptCommand.setSchemaNames(hashSet);
        } else if (this.readIf(59)) {
            ArrayList<Table> arrayList = Utils.newSmallArrayList();
            do {
                arrayList.add(this.readTableOrView());
            } while (this.readIf(89));
            scriptCommand.setTables(arrayList);
        }
        return scriptCommand;
    }

    private boolean isDualTable(String string) {
        return (this.schemaName == null || this.equalsToken(this.schemaName, "SYS")) && this.equalsToken("DUAL", string) || this.database.getMode().sysDummy1 && (this.schemaName == null || this.equalsToken(this.schemaName, "SYSIBM")) && this.equalsToken("SYSDUMMY1", string);
    }

    private Table readTableOrView() {
        return this.readTableOrView(this.readIdentifierWithSchema(null));
    }

    private Table readTableOrView(String string) {
        if (this.schemaName != null) {
            Table table = this.getSchema().resolveTableOrView(this.session, string);
            if (table != null) {
                return table;
            }
        } else {
            Table table = this.database.getSchema(this.session.getCurrentSchemaName()).resolveTableOrView(this.session, string);
            if (table != null) {
                return table;
            }
            String[] stringArray = this.session.getSchemaSearchPath();
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    Schema schema = this.database.getSchema(string2);
                    table = schema.resolveTableOrView(this.session, string);
                    if (table == null) continue;
                    return table;
                }
            }
        }
        if (this.isDualTable(string)) {
            return new DualTable(this.database);
        }
        throw DbException.get(42102, string);
    }

    private FunctionAlias findFunctionAlias(String string, String string2) {
        FunctionAlias functionAlias = this.database.getSchema(string).findFunction(string2);
        if (functionAlias != null) {
            return functionAlias;
        }
        String[] stringArray = this.session.getSchemaSearchPath();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                functionAlias = this.database.getSchema(string3).findFunction(string2);
                if (functionAlias == null) continue;
                return functionAlias;
            }
        }
        return null;
    }

    private Sequence findSequence(String string, String string2) {
        Sequence sequence = this.database.getSchema(string).findSequence(string2);
        if (sequence != null) {
            return sequence;
        }
        String[] stringArray = this.session.getSchemaSearchPath();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                sequence = this.database.getSchema(string3).findSequence(string2);
                if (sequence == null) continue;
                return sequence;
            }
        }
        return null;
    }

    private Sequence readSequence() {
        String string = this.readIdentifierWithSchema(null);
        if (this.schemaName != null) {
            return this.getSchema().getSequence(string);
        }
        Sequence sequence = this.findSequence(this.session.getCurrentSchemaName(), string);
        if (sequence != null) {
            return sequence;
        }
        throw DbException.get(90036, string);
    }

    private Prepared parseAlterTable() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.readIf("ADD")) {
            DefineCommand defineCommand = this.parseAlterTableAddConstraintIf(string, schema, bl);
            if (defineCommand != null) {
                return defineCommand;
            }
            return this.parseAlterTableAddColumn(string, schema, bl);
        }
        if (this.readIf(58)) {
            return this.parseAlterTableSet(schema, string, bl);
        }
        if (this.readIf("RENAME")) {
            return this.parseAlterTableRename(schema, string, bl);
        }
        if (this.readIf("DROP")) {
            return this.parseAlterTableDrop(schema, string, bl);
        }
        if (this.readIf("ALTER")) {
            return this.parseAlterTableAlter(schema, string, bl);
        }
        Mode mode = this.database.getMode();
        if (mode.alterTableExtensionsMySQL || mode.alterTableModifyColumn) {
            return this.parseAlterTableCompatibility(schema, string, bl, mode);
        }
        throw this.getSyntaxError();
    }

    private Prepared parseAlterTableAlter(Schema schema, String string, boolean bl) {
        this.readIf("COLUMN");
        boolean bl2 = this.readIfExists(false);
        String string2 = this.readColumnIdentifier();
        Column column = this.columnIfTableExists(schema, string, string2, bl, bl2);
        if (this.readIf("RENAME")) {
            this.read("TO");
            AlterTableRenameColumn alterTableRenameColumn = new AlterTableRenameColumn(this.session, schema);
            alterTableRenameColumn.setTableName(string);
            alterTableRenameColumn.setIfTableExists(bl);
            alterTableRenameColumn.setIfExists(bl2);
            alterTableRenameColumn.setOldColumnName(string2);
            String string3 = this.readColumnIdentifier();
            alterTableRenameColumn.setNewColumnName(string3);
            return alterTableRenameColumn;
        }
        if (this.readIf("DROP")) {
            if (this.readIf("DEFAULT")) {
                AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                alterTableAlterColumn.setTableName(string);
                alterTableAlterColumn.setIfTableExists(bl);
                alterTableAlterColumn.setOldColumn(column);
                alterTableAlterColumn.setType(10);
                alterTableAlterColumn.setDefaultExpression(null);
                return alterTableAlterColumn;
            }
            if (this.readIf(49)) {
                this.read("UPDATE");
                AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                alterTableAlterColumn.setTableName(string);
                alterTableAlterColumn.setIfTableExists(bl);
                alterTableAlterColumn.setOldColumn(column);
                alterTableAlterColumn.setType(90);
                alterTableAlterColumn.setDefaultExpression(null);
                return alterTableAlterColumn;
            }
            this.read(46);
            this.read(47);
            AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
            alterTableAlterColumn.setTableName(string);
            alterTableAlterColumn.setIfTableExists(bl);
            alterTableAlterColumn.setOldColumn(column);
            alterTableAlterColumn.setType(9);
            return alterTableAlterColumn;
        }
        if (this.readIf("TYPE")) {
            return this.parseAlterTableAlterColumnDataType(schema, string, string2, bl, bl2);
        }
        if (this.readIf(58)) {
            if (this.readIf("DATA")) {
                this.read("TYPE");
                return this.parseAlterTableAlterColumnDataType(schema, string, string2, bl, bl2);
            }
            AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
            alterTableAlterColumn.setTableName(string);
            alterTableAlterColumn.setIfTableExists(bl);
            alterTableAlterColumn.setOldColumn(column);
            NullConstraintType nullConstraintType = this.parseNotNullConstraint();
            switch (nullConstraintType) {
                case NULL_IS_ALLOWED: {
                    alterTableAlterColumn.setType(9);
                    break;
                }
                case NULL_IS_NOT_ALLOWED: {
                    alterTableAlterColumn.setType(8);
                    break;
                }
                case NO_NULL_CONSTRAINT_FOUND: {
                    if (this.readIf("DEFAULT")) {
                        Expression expression = this.readExpression();
                        alterTableAlterColumn.setType(10);
                        alterTableAlterColumn.setDefaultExpression(expression);
                        break;
                    }
                    if (this.readIf(49)) {
                        this.read("UPDATE");
                        Expression expression = this.readExpression();
                        alterTableAlterColumn.setType(90);
                        alterTableAlterColumn.setDefaultExpression(expression);
                        break;
                    }
                    if (this.readIf("INVISIBLE")) {
                        alterTableAlterColumn.setType(87);
                        alterTableAlterColumn.setVisible(false);
                        break;
                    }
                    if (!this.readIf("VISIBLE")) break;
                    alterTableAlterColumn.setType(87);
                    alterTableAlterColumn.setVisible(true);
                    break;
                }
                default: {
                    throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraintType.name());
                }
            }
            return alterTableAlterColumn;
        }
        if (this.readIf("RESTART")) {
            Prepared prepared = this.readAlterColumnRestartWith(schema, column, true);
            return this.commandIfTableExists(schema, string, bl, prepared);
        }
        if (this.readIf("SELECTIVITY")) {
            AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
            alterTableAlterColumn.setTableName(string);
            alterTableAlterColumn.setIfTableExists(bl);
            alterTableAlterColumn.setType(13);
            alterTableAlterColumn.setOldColumn(column);
            alterTableAlterColumn.setSelectivity(this.readExpression());
            return alterTableAlterColumn;
        }
        return this.parseAlterTableAlterColumnType(schema, string, string2, bl, bl2, true);
    }

    private Prepared parseAlterTableDrop(Schema schema, String string, boolean bl) {
        Object object;
        Prepared prepared;
        if (this.readIf(8)) {
            boolean bl2 = this.readIfExists(false);
            String string2 = this.readIdentifierWithSchema(schema.getName());
            bl2 = this.readIfExists(bl2);
            this.checkSchema(schema);
            AlterTableDropConstraint alterTableDropConstraint = new AlterTableDropConstraint(this.session, this.getSchema(), bl2);
            alterTableDropConstraint.setConstraintName(string2);
            ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
            if (constraintActionType != null) {
                alterTableDropConstraint.setDropAction(constraintActionType);
            }
            return this.commandIfTableExists(schema, string, bl, alterTableDropConstraint);
        }
        if (this.readIf(51)) {
            this.read(36);
            Table table = this.tableIfTableExists(schema, string, bl);
            if (table == null) {
                return new NoOperation(this.session);
            }
            Index index = table.getPrimaryKey();
            DropIndex dropIndex = new DropIndex(this.session, schema);
            dropIndex.setIndexName(index.getName());
            return dropIndex;
        }
        if (this.database.getMode().alterTableExtensionsMySQL && (prepared = this.parseAlterTableDropCompatibility(schema, string, bl)) != null) {
            return prepared;
        }
        this.readIf("COLUMN");
        boolean bl3 = this.readIfExists(false);
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Table table = this.tableIfTableExists(schema, string, bl);
        boolean bl4 = this.readIf(85);
        do {
            Column column;
            object = this.readColumnIdentifier();
            if (table == null || (column = table.getColumn((String)object, bl3)) == null) continue;
            arrayList.add(column);
        } while (this.readIf(89));
        if (bl4) {
            this.read(86);
        }
        if (table == null || arrayList.isEmpty()) {
            return new NoOperation(this.session);
        }
        object = new AlterTableAlterColumn(this.session, schema);
        ((AlterTableAlterColumn)object).setType(12);
        ((AlterTableAlterColumn)object).setTableName(string);
        ((AlterTableAlterColumn)object).setIfTableExists(bl);
        ((AlterTableAlterColumn)object).setColumnsToRemove(arrayList);
        return object;
    }

    private Prepared parseAlterTableDropCompatibility(Schema schema, String string, boolean bl) {
        if (this.readIf(23)) {
            this.read(36);
            boolean bl2 = this.readIfExists(false);
            String string2 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            AlterTableDropConstraint alterTableDropConstraint = new AlterTableDropConstraint(this.session, this.getSchema(), bl2);
            alterTableDropConstraint.setConstraintName(string2);
            return this.commandIfTableExists(schema, string, bl, alterTableDropConstraint);
        }
        if (this.readIf("INDEX")) {
            SchemaCommand schemaCommand;
            boolean bl3 = this.readIfExists(false);
            String string3 = this.readIdentifierWithSchema(schema.getName());
            if (schema.findIndex(this.session, string3) != null) {
                DropIndex dropIndex = new DropIndex(this.session, this.getSchema());
                dropIndex.setIndexName(string3);
                schemaCommand = dropIndex;
            } else {
                AlterTableDropConstraint alterTableDropConstraint = new AlterTableDropConstraint(this.session, this.getSchema(), bl3);
                alterTableDropConstraint.setConstraintName(string3);
                schemaCommand = alterTableDropConstraint;
            }
            return this.commandIfTableExists(schema, string, bl, schemaCommand);
        }
        return null;
    }

    private Prepared parseAlterTableRename(Schema schema, String string, boolean bl) {
        if (this.readIf("COLUMN")) {
            String string2 = this.readColumnIdentifier();
            this.read("TO");
            AlterTableRenameColumn alterTableRenameColumn = new AlterTableRenameColumn(this.session, schema);
            alterTableRenameColumn.setTableName(string);
            alterTableRenameColumn.setIfTableExists(bl);
            alterTableRenameColumn.setOldColumnName(string2);
            String string3 = this.readColumnIdentifier();
            alterTableRenameColumn.setNewColumnName(string3);
            return alterTableRenameColumn;
        }
        if (this.readIf(8)) {
            String string4 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            this.read("TO");
            AlterTableRenameConstraint alterTableRenameConstraint = new AlterTableRenameConstraint(this.session, schema);
            alterTableRenameConstraint.setConstraintName(string4);
            String string5 = this.readColumnIdentifier();
            alterTableRenameConstraint.setNewConstraintName(string5);
            return this.commandIfTableExists(schema, string, bl, alterTableRenameConstraint);
        }
        this.read("TO");
        String string6 = this.readIdentifierWithSchema(schema.getName());
        this.checkSchema(schema);
        AlterTableRename alterTableRename = new AlterTableRename(this.session, this.getSchema());
        alterTableRename.setOldTableName(string);
        alterTableRename.setNewTableName(string6);
        alterTableRename.setIfTableExists(bl);
        alterTableRename.setHidden(this.readIf("HIDDEN"));
        return alterTableRename;
    }

    private Prepared parseAlterTableSet(Schema schema, String string, boolean bl) {
        this.read("REFERENTIAL_INTEGRITY");
        int n = 55;
        boolean bl2 = this.readBooleanSetting();
        AlterTableSet alterTableSet = new AlterTableSet(this.session, schema, n, bl2);
        alterTableSet.setTableName(string);
        alterTableSet.setIfTableExists(bl);
        if (this.readIf(7)) {
            alterTableSet.setCheckExisting(true);
        } else if (this.readIf("NOCHECK")) {
            alterTableSet.setCheckExisting(false);
        }
        return alterTableSet;
    }

    private Prepared parseAlterTableCompatibility(Schema schema, String string, boolean bl, Mode mode) {
        if (mode.alterTableExtensionsMySQL) {
            if (this.readIf("AUTO_INCREMENT")) {
                this.readIf(75);
                Table table = this.tableIfTableExists(schema, string, bl);
                if (table == null) {
                    return new NoOperation(this.session);
                }
                Index index = table.findPrimaryKey();
                if (index != null) {
                    for (IndexColumn indexColumn : index.getIndexColumns()) {
                        Column column = indexColumn.column;
                        if (column.getSequence() == null) continue;
                        return this.readAlterColumnRestartWith(schema, column, false);
                    }
                }
                throw DbException.get(42122, "AUTO_INCREMENT PRIMARY KEY");
            }
            if (this.readIf("CHANGE")) {
                this.readIf("COLUMN");
                String string2 = this.readColumnIdentifier();
                String string3 = this.readColumnIdentifier();
                Column column = this.columnIfTableExists(schema, string, string2, bl, false);
                boolean bl2 = column == null ? true : column.isNullable();
                this.parseColumnForTable(string3, bl2);
                AlterTableRenameColumn alterTableRenameColumn = new AlterTableRenameColumn(this.session, schema);
                alterTableRenameColumn.setTableName(string);
                alterTableRenameColumn.setIfTableExists(bl);
                alterTableRenameColumn.setOldColumnName(string2);
                alterTableRenameColumn.setNewColumnName(string3);
                return alterTableRenameColumn;
            }
        }
        if (mode.alterTableModifyColumn && this.readIf("MODIFY")) {
            AlterTableAlterColumn alterTableAlterColumn;
            this.readIf("COLUMN");
            boolean bl3 = this.readIf(85);
            String string4 = this.readColumnIdentifier();
            NullConstraintType nullConstraintType = this.parseNotNullConstraint();
            switch (nullConstraintType) {
                case NULL_IS_ALLOWED: 
                case NULL_IS_NOT_ALLOWED: {
                    alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                    alterTableAlterColumn.setTableName(string);
                    alterTableAlterColumn.setIfTableExists(bl);
                    Column column = this.columnIfTableExists(schema, string, string4, bl, false);
                    alterTableAlterColumn.setOldColumn(column);
                    if (nullConstraintType == NullConstraintType.NULL_IS_ALLOWED) {
                        alterTableAlterColumn.setType(9);
                        break;
                    }
                    alterTableAlterColumn.setType(8);
                    break;
                }
                case NO_NULL_CONSTRAINT_FOUND: {
                    alterTableAlterColumn = this.parseAlterTableAlterColumnType(schema, string, string4, bl, false, mode.getEnum() != Mode.ModeEnum.MySQL);
                    break;
                }
                default: {
                    throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraintType.name());
                }
            }
            if (bl3) {
                this.read(86);
            }
            return alterTableAlterColumn;
        }
        throw this.getSyntaxError();
    }

    private Prepared readAlterColumnRestartWith(Schema schema, Column column, boolean bl) {
        Expression expression;
        Expression expression2 = expression = !bl || this.readIf(69) ? this.readExpression() : ValueExpression.DEFAULT;
        if (column == null) {
            return new NoOperation(this.session);
        }
        AlterSequence alterSequence = new AlterSequence(this.session, schema);
        alterSequence.setColumn(column);
        SequenceOptions sequenceOptions = new SequenceOptions();
        sequenceOptions.setRestartValue(expression);
        alterSequence.setOptions(sequenceOptions);
        return alterSequence;
    }

    private Table tableIfTableExists(Schema schema, String string, boolean bl) {
        Table table = schema.resolveTableOrView(this.session, string);
        if (table == null && !bl) {
            throw DbException.get(42102, string);
        }
        return table;
    }

    private Column columnIfTableExists(Schema schema, String string, String string2, boolean bl, boolean bl2) {
        Table table = this.tableIfTableExists(schema, string, bl);
        if (table == null) {
            return null;
        }
        return table.getColumn(string2, bl2);
    }

    private Prepared commandIfTableExists(Schema schema, String string, boolean bl, Prepared prepared) {
        return this.tableIfTableExists(schema, string, bl) == null ? new NoOperation(this.session) : prepared;
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnType(Schema schema, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        Column column = this.columnIfTableExists(schema, string, string2, bl, bl2);
        Column column2 = this.parseColumnForTable(string2, !bl3 || column == null || column.isNullable());
        AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
        this.parseAlterColumnUsingIf(alterTableAlterColumn);
        alterTableAlterColumn.setTableName(string);
        alterTableAlterColumn.setIfTableExists(bl);
        alterTableAlterColumn.setType(11);
        alterTableAlterColumn.setOldColumn(column);
        alterTableAlterColumn.setNewColumn(column2);
        return alterTableAlterColumn;
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnDataType(Schema schema, String string, String string2, boolean bl, boolean bl2) {
        Object object;
        Column column = this.columnIfTableExists(schema, string, string2, bl, bl2);
        Column column2 = this.parseColumnWithType(string2);
        if (column != null) {
            String string3;
            if (!column.isNullable()) {
                column2.setNullable(false);
            }
            if (!column.getVisible()) {
                column2.setVisible(false);
            }
            if ((object = column.getDefaultExpression()) != null) {
                column2.setDefaultExpression(this.session, (Expression)object);
            }
            if ((object = column.getOnUpdateExpression()) != null) {
                column2.setOnUpdateExpression(this.session, (Expression)object);
            }
            if ((string3 = column.getComment()) != null) {
                column2.setComment(string3);
            }
        }
        object = new AlterTableAlterColumn(this.session, schema);
        this.parseAlterColumnUsingIf((AlterTableAlterColumn)object);
        ((AlterTableAlterColumn)object).setTableName(string);
        ((AlterTableAlterColumn)object).setIfTableExists(bl);
        ((AlterTableAlterColumn)object).setType(11);
        ((AlterTableAlterColumn)object).setOldColumn(column);
        ((AlterTableAlterColumn)object).setNewColumn(column2);
        return object;
    }

    private AlterTableAlterColumn parseAlterTableAddColumn(String string, Schema schema, boolean bl) {
        this.readIf("COLUMN");
        AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
        alterTableAlterColumn.setType(7);
        alterTableAlterColumn.setTableName(string);
        alterTableAlterColumn.setIfTableExists(bl);
        if (this.readIf(85)) {
            alterTableAlterColumn.setIfNotExists(false);
            do {
                this.parseTableColumnDefinition(alterTableAlterColumn, schema, string, false);
            } while (this.readIfMore());
        } else {
            boolean bl2 = this.readIfNotExists();
            alterTableAlterColumn.setIfNotExists(bl2);
            this.parseTableColumnDefinition(alterTableAlterColumn, schema, string, false);
            this.parseAlterColumnUsingIf(alterTableAlterColumn);
        }
        if (this.readIf("BEFORE")) {
            alterTableAlterColumn.setAddBefore(this.readColumnIdentifier());
        } else if (this.readIf("AFTER")) {
            alterTableAlterColumn.setAddAfter(this.readColumnIdentifier());
        } else if (this.readIf("FIRST")) {
            alterTableAlterColumn.setAddFirst();
        }
        return alterTableAlterColumn;
    }

    private void parseAlterColumnUsingIf(AlterTableAlterColumn alterTableAlterColumn) {
        if (this.readIf(64)) {
            alterTableAlterColumn.setUsingExpression(this.readExpression());
        }
    }

    private ConstraintActionType parseAction() {
        ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
        if (constraintActionType != null) {
            return constraintActionType;
        }
        if (this.readIf("NO")) {
            this.read("ACTION");
            return ConstraintActionType.RESTRICT;
        }
        this.read(58);
        if (this.readIf(47)) {
            return ConstraintActionType.SET_NULL;
        }
        this.read("DEFAULT");
        return ConstraintActionType.SET_DEFAULT;
    }

    private ConstraintActionType parseCascadeOrRestrict() {
        if (this.readIf("CASCADE")) {
            return ConstraintActionType.CASCADE;
        }
        if (this.readIf("RESTRICT")) {
            return ConstraintActionType.RESTRICT;
        }
        return null;
    }

    private DefineCommand parseAlterTableAddConstraintIf(String string, Schema schema, boolean bl) {
        AlterTableAddConstraint alterTableAddConstraint;
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        if (this.readIf(8)) {
            bl2 = this.readIfNotExists();
            string2 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            string3 = this.readCommentIf();
        }
        switch (this.currentTokenType) {
            case 51: {
                this.read();
                this.read(36);
                alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, 6, bl2);
                if (this.readIf("HASH")) {
                    alterTableAddConstraint.setPrimaryKeyHash(true);
                }
                this.read(85);
                alterTableAddConstraint.setIndexColumns(this.parseIndexColumnList());
                if (!this.readIf("INDEX")) break;
                String string4 = this.readIdentifierWithSchema();
                alterTableAddConstraint.setIndex(this.getSchema().findIndex(this.session, string4));
                break;
            }
            case 62: {
                this.read();
                boolean bl3 = this.database.getMode().indexDefinitionInCreateTable;
                if (bl3) {
                    if (!this.readIf(36)) {
                        this.readIf("INDEX");
                    }
                    if (!this.isToken(85)) {
                        string2 = this.readUniqueIdentifier();
                    }
                }
                this.read(85);
                alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, 4, bl2);
                alterTableAddConstraint.setIndexColumns(this.parseIndexColumnList());
                if (this.readIf("INDEX")) {
                    String string5 = this.readIdentifierWithSchema();
                    alterTableAddConstraint.setIndex(this.getSchema().findIndex(this.session, string5));
                }
                if (!bl3 || !this.readIf(64)) break;
                this.read("BTREE");
                break;
            }
            case 23: {
                this.read();
                alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, 5, bl2);
                this.read(36);
                this.read(85);
                alterTableAddConstraint.setIndexColumns(this.parseIndexColumnList());
                if (this.readIf("INDEX")) {
                    String string6 = this.readIdentifierWithSchema();
                    alterTableAddConstraint.setIndex(schema.findIndex(this.session, string6));
                }
                this.read("REFERENCES");
                this.parseReferences(alterTableAddConstraint, schema, string);
                break;
            }
            case 7: {
                this.read();
                alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, 3, bl2);
                alterTableAddConstraint.setCheckExpression(this.readExpression());
                break;
            }
            default: {
                if (string2 == null) {
                    Mode mode = this.database.getMode();
                    if (mode.indexDefinitionInCreateTable) {
                        int n = this.lastParseIndex;
                        if (this.readIf(36) || this.readIf("INDEX")) {
                            if (DataType.getTypeByName(this.currentToken, mode) == null) {
                                CreateIndex createIndex = new CreateIndex(this.session, schema);
                                createIndex.setComment(string3);
                                createIndex.setTableName(string);
                                createIndex.setIfTableExists(bl);
                                if (!this.readIf(85)) {
                                    createIndex.setIndexName(this.readUniqueIdentifier());
                                    this.read(85);
                                }
                                createIndex.setIndexColumns(this.parseIndexColumnList());
                                if (this.readIf(64)) {
                                    this.read("BTREE");
                                }
                                return createIndex;
                            }
                            this.parseIndex = n;
                            this.read();
                        }
                    }
                    return null;
                }
                if (this.expectedList != null) {
                    this.addMultipleExpected(51, 62, 23, 7);
                }
                throw this.getSyntaxError();
            }
        }
        if (alterTableAddConstraint.getType() != 6) {
            if (this.readIf("NOCHECK")) {
                alterTableAddConstraint.setCheckExisting(false);
            } else {
                this.readIf(7);
                alterTableAddConstraint.setCheckExisting(true);
            }
        }
        alterTableAddConstraint.setTableName(string);
        alterTableAddConstraint.setIfTableExists(bl);
        alterTableAddConstraint.setConstraintName(string2);
        alterTableAddConstraint.setComment(string3);
        return alterTableAddConstraint;
    }

    private void parseReferences(AlterTableAddConstraint alterTableAddConstraint, Schema schema, String string) {
        String string2;
        if (this.readIf(85)) {
            alterTableAddConstraint.setRefTableName(schema, string);
            alterTableAddConstraint.setRefIndexColumns(this.parseIndexColumnList());
        } else {
            string2 = this.readIdentifierWithSchema(schema.getName());
            alterTableAddConstraint.setRefTableName(this.getSchema(), string2);
            if (this.readIf(85)) {
                alterTableAddConstraint.setRefIndexColumns(this.parseIndexColumnList());
            }
        }
        if (this.readIf("INDEX")) {
            string2 = this.readIdentifierWithSchema();
            alterTableAddConstraint.setRefIndex(this.getSchema().findIndex(this.session, string2));
        }
        while (this.readIf(49)) {
            if (this.readIf("DELETE")) {
                alterTableAddConstraint.setDeleteAction(this.parseAction());
                continue;
            }
            this.read("UPDATE");
            alterTableAddConstraint.setUpdateAction(this.parseAction());
        }
        if (this.readIf(46)) {
            this.read("DEFERRABLE");
        } else {
            this.readIf("DEFERRABLE");
        }
    }

    private CreateLinkedTable parseCreateLinkedTable(boolean bl, boolean bl2, boolean bl3) {
        this.read(59);
        boolean bl4 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        CreateLinkedTable createLinkedTable = new CreateLinkedTable(this.session, this.getSchema());
        createLinkedTable.setTemporary(bl);
        createLinkedTable.setGlobalTemporary(bl2);
        createLinkedTable.setForce(bl3);
        createLinkedTable.setIfNotExists(bl4);
        createLinkedTable.setTableName(string);
        createLinkedTable.setComment(this.readCommentIf());
        this.read(85);
        createLinkedTable.setDriver(this.readString());
        this.read(89);
        createLinkedTable.setUrl(this.readString());
        this.read(89);
        createLinkedTable.setUser(this.readString());
        this.read(89);
        createLinkedTable.setPassword(this.readString());
        this.read(89);
        String string2 = this.readString();
        if (this.readIf(89)) {
            createLinkedTable.setOriginalSchema(string2);
            string2 = this.readString();
        }
        createLinkedTable.setOriginalTable(string2);
        this.read(86);
        if (this.readIf("EMIT")) {
            this.read("UPDATES");
            createLinkedTable.setEmitUpdates(true);
        } else if (this.readIf("READONLY")) {
            createLinkedTable.setReadOnly(true);
        }
        return createLinkedTable;
    }

    private CreateTable parseCreateTable(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        if (bl && bl2 && this.equalsToken("SESSION", this.schemaName)) {
            this.schemaName = this.session.getCurrentSchemaName();
            bl2 = false;
        }
        Schema schema = this.getSchema();
        CreateTable createTable = new CreateTable(this.session, schema);
        createTable.setPersistIndexes(bl3);
        createTable.setTemporary(bl);
        createTable.setGlobalTemporary(bl2);
        createTable.setIfNotExists(bl4);
        createTable.setTableName(string);
        createTable.setComment(this.readCommentIf());
        if (this.readIf(85) && !this.readIf(86)) {
            do {
                this.parseTableColumnDefinition(createTable, schema, string, true);
            } while (this.readIfMore());
        }
        if (this.database.getMode().getEnum() == Mode.ModeEnum.MySQL) {
            this.parseCreateTableMySQLTableOptions(createTable);
        }
        if (this.readIf("ENGINE")) {
            createTable.setTableEngine(this.readUniqueIdentifier());
        }
        if (this.readIf(69)) {
            createTable.setTableEngineParams(this.readTableEngineParams());
        }
        if (bl) {
            if (this.readIf(49)) {
                this.read("COMMIT");
                if (this.readIf("DROP")) {
                    createTable.setOnCommitDrop();
                } else if (this.readIf("DELETE")) {
                    this.read("ROWS");
                    createTable.setOnCommitTruncate();
                }
            } else if (this.readIf(46)) {
                if (this.readIf("PERSISTENT")) {
                    createTable.setPersistData(false);
                } else {
                    this.read("LOGGED");
                }
            }
            if (this.readIf("TRANSACTIONAL")) {
                createTable.setTransactional(true);
            }
        } else if (!bl3 && this.readIf(46)) {
            this.read("PERSISTENT");
            createTable.setPersistData(false);
        }
        if (this.readIf("HIDDEN")) {
            createTable.setHidden(true);
        }
        if (this.readIf(5)) {
            if (this.readIf("SORTED")) {
                createTable.setSortedInsertMode(true);
            }
            createTable.setQuery(this.parseQuery());
            if (this.readIf(69)) {
                createTable.setWithNoData(this.readIf("NO"));
                this.read("DATA");
            }
        }
        return createTable;
    }

    private void parseTableColumnDefinition(CommandWithColumns commandWithColumns, Schema schema, String string, boolean bl) {
        DefineCommand defineCommand = this.parseAlterTableAddConstraintIf(string, schema, false);
        if (defineCommand != null) {
            commandWithColumns.addConstraintCommand(defineCommand);
            return;
        }
        String string2 = this.readColumnIdentifier();
        if (bl && (this.currentTokenType == 89 || this.currentTokenType == 86)) {
            commandWithColumns.addColumn(new Column(string2, TypeInfo.TYPE_UNKNOWN));
            return;
        }
        Column column = this.parseColumnForTable(string2, true);
        if (column.isAutoIncrement() && column.isPrimaryKey()) {
            column.setPrimaryKey(false);
            AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, 6, false);
            alterTableAddConstraint.setTableName(string);
            alterTableAddConstraint.setIndexColumns(new IndexColumn[]{new IndexColumn(column.getName())});
            commandWithColumns.addConstraintCommand(alterTableAddConstraint);
        }
        commandWithColumns.addColumn(column);
        this.readColumnConstraints(commandWithColumns, schema, string, column);
    }

    private void readColumnConstraints(CommandWithColumns commandWithColumns, Schema schema, String string, Column column) {
        String string2;
        String string3 = column.getComment();
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            NullConstraintType nullConstraintType;
            IndexColumn[] indexColumnArray;
            if (this.readIf(8)) {
                string2 = this.readColumnIdentifier();
            } else {
                if (string3 == null && (string3 = this.readCommentIf()) != null) {
                    column.setComment(string3);
                    continue;
                }
                string2 = null;
            }
            if (!bl && this.readIf(51)) {
                this.read(36);
                bl = true;
                boolean bl3 = this.readIf("HASH");
                indexColumnArray = new AlterTableAddConstraint(this.session, schema, 6, false);
                indexColumnArray.setConstraintName(string2);
                indexColumnArray.setPrimaryKeyHash(bl3);
                indexColumnArray.setTableName(string);
                indexColumnArray.setIndexColumns(new IndexColumn[]{new IndexColumn(column.getName())});
                commandWithColumns.addConstraintCommand((DefineCommand)indexColumnArray);
                if (this.readIf("AUTO_INCREMENT")) {
                    this.parseAutoIncrement(column);
                }
                if (!this.database.getMode().useIdentityAsAutoIncrement) continue;
                if (this.readIf(46)) {
                    this.read(47);
                    column.setNullable(false);
                }
                if (!this.readIf("IDENTITY")) continue;
                this.parseAutoIncrement(column);
                continue;
            }
            if (this.readIf(62)) {
                AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, 4, false);
                alterTableAddConstraint.setConstraintName(string2);
                alterTableAddConstraint.setIndexColumns(new IndexColumn[]{new IndexColumn(column.getName())});
                alterTableAddConstraint.setTableName(string);
                commandWithColumns.addConstraintCommand(alterTableAddConstraint);
                continue;
            }
            if (!bl2 && (nullConstraintType = this.parseNotNullConstraint()) != NullConstraintType.NO_NULL_CONSTRAINT_FOUND) {
                bl2 = true;
                if (nullConstraintType == NullConstraintType.NULL_IS_NOT_ALLOWED) {
                    column.setNullable(false);
                    continue;
                }
                if (nullConstraintType != NullConstraintType.NULL_IS_ALLOWED) continue;
                column.setNullable(true);
                continue;
            }
            if (this.readIf(7)) {
                AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, 3, false);
                alterTableAddConstraint.setConstraintName(string2);
                alterTableAddConstraint.setTableName(string);
                alterTableAddConstraint.setCheckExpression(this.readExpression());
                commandWithColumns.addConstraintCommand(alterTableAddConstraint);
                continue;
            }
            if (!this.readIf("REFERENCES")) break;
            AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, 5, false);
            alterTableAddConstraint.setConstraintName(string2);
            indexColumnArray = new IndexColumn[]{new IndexColumn(column.getName())};
            alterTableAddConstraint.setIndexColumns(indexColumnArray);
            alterTableAddConstraint.setTableName(string);
            this.parseReferences(alterTableAddConstraint, schema, string);
            commandWithColumns.addConstraintCommand(alterTableAddConstraint);
        }
        if (string2 == null) {
            return;
        }
        throw this.getSyntaxError();
    }

    private void parseCreateTableMySQLTableOptions(CreateTable createTable) {
        boolean bl = false;
        while (true) {
            block19: {
                if (this.readIf("AUTO_INCREMENT")) {
                    this.readIf(75);
                    Expression expression = this.readExpression();
                    AlterTableAddConstraint alterTableAddConstraint = createTable.getPrimaryKey();
                    if (alterTableAddConstraint != null) {
                        for (IndexColumn indexColumn : alterTableAddConstraint.getIndexColumns()) {
                            String string = indexColumn.columnName;
                            for (Column column : createTable.getColumns()) {
                                SequenceOptions sequenceOptions;
                                if (!this.database.equalsIdentifiers(column.getName(), string) || (sequenceOptions = column.getAutoIncrementOptions()) == null) continue;
                                sequenceOptions.setStartValue(expression);
                                break block19;
                            }
                        }
                    }
                    throw DbException.get(42122, "AUTO_INCREMENT PRIMARY KEY");
                }
                if (this.readIf("DEFAULT")) {
                    if (this.readIf("CHARACTER")) {
                        this.read(58);
                    } else {
                        this.read("CHARSET");
                    }
                    this.readMySQLCharset();
                } else if (this.readIf("CHARACTER")) {
                    this.read(58);
                    this.readMySQLCharset();
                } else if (this.readIf("CHARSET")) {
                    this.readMySQLCharset();
                } else if (this.readIf("COMMENT")) {
                    this.readIf(75);
                    createTable.setComment(this.readString());
                } else if (this.readIf("ENGINE")) {
                    this.readIf(75);
                    this.readUniqueIdentifier();
                } else if (this.readIf("ROW_FORMAT")) {
                    this.readIf(75);
                    this.readColumnIdentifier();
                } else {
                    if (!bl) break;
                    throw this.getSyntaxError();
                }
            }
            bl = this.readIf(89);
        }
    }

    private void readMySQLCharset() {
        this.readIf(75);
        if (!this.readIf("UTF8")) {
            this.read("UTF8MB4");
        }
    }

    private NullConstraintType parseNotNullConstraint() {
        NullConstraintType nullConstraintType = NullConstraintType.NO_NULL_CONSTRAINT_FOUND;
        if (this.isToken(46) || this.isToken(47)) {
            if (this.readIf(46)) {
                this.read(47);
                nullConstraintType = NullConstraintType.NULL_IS_NOT_ALLOWED;
            } else {
                this.read(47);
                nullConstraintType = NullConstraintType.NULL_IS_ALLOWED;
            }
            if (this.database.getMode().getEnum() == Mode.ModeEnum.Oracle) {
                if (this.readIf("ENABLE")) {
                    this.readIf("VALIDATE");
                    if (this.readIf("NOVALIDATE")) {
                        nullConstraintType = NullConstraintType.NULL_IS_ALLOWED;
                    }
                }
                if (this.readIf("DISABLE")) {
                    nullConstraintType = NullConstraintType.NULL_IS_ALLOWED;
                    this.readIf("VALIDATE");
                    this.readIf("NOVALIDATE");
                }
            }
        }
        return nullConstraintType;
    }

    private CreateSynonym parseCreateSynonym(boolean bl) {
        boolean bl2 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        this.read(22);
        String string2 = this.readIdentifierWithSchema();
        Schema schema2 = this.getSchema();
        CreateSynonym createSynonym = new CreateSynonym(this.session, schema);
        createSynonym.setName(string);
        createSynonym.setSynonymFor(string2);
        createSynonym.setSynonymForSchema(schema2);
        createSynonym.setComment(this.readCommentIf());
        createSynonym.setIfNotExists(bl2);
        createSynonym.setOrReplace(bl);
        return createSynonym;
    }

    private static int getCompareType(int n) {
        switch (n) {
            case 75: {
                return 0;
            }
            case 76: {
                return 1;
            }
            case 77: {
                return 2;
            }
            case 78: {
                return 4;
            }
            case 79: {
                return 3;
            }
            case 80: {
                return 5;
            }
            case 87: {
                return 9;
            }
        }
        return -1;
    }

    public static String quoteIdentifier(String string, int n) {
        if (string == null) {
            return "\"\"";
        }
        if ((n & 1) != 0 && ParserUtil.isSimpleIdentifier(string, false, false)) {
            return string;
        }
        return StringUtils.quoteIdentifier(string);
    }

    public static StringBuilder quoteIdentifier(StringBuilder stringBuilder, String string, int n) {
        if (string == null) {
            return stringBuilder.append("\"\"");
        }
        if ((n & 1) != 0 && ParserUtil.isSimpleIdentifier(string, false, false)) {
            return stringBuilder.append(string);
        }
        return StringUtils.quoteIdentifier(stringBuilder, string);
    }

    public void setLiteralsChecked(boolean bl) {
        this.literalsChecked = bl;
    }

    public void setRightsChecked(boolean bl) {
        this.rightsChecked = bl;
    }

    public void setSuppliedParameterList(ArrayList<Parameter> arrayList) {
        this.suppliedParameterList = arrayList;
    }

    public Expression parseExpression(String string) {
        this.parameters = Utils.newSmallArrayList();
        this.initialize(string);
        this.read();
        return this.readExpression();
    }

    public Expression parseDomainConstraintExpression(String string) {
        this.parameters = Utils.newSmallArrayList();
        this.initialize(string);
        this.read();
        try {
            this.parseDomainConstraint = true;
            Expression expression = this.readExpression();
            return expression;
        }
        finally {
            this.parseDomainConstraint = false;
        }
    }

    public Table parseTableName(String string) {
        this.parameters = Utils.newSmallArrayList();
        this.initialize(string);
        this.read();
        return this.readTableOrView();
    }

    public Object parseColumnList(String string, int n) {
        this.initialize(string);
        this.parseIndex = n;
        this.read();
        this.read(85);
        if (this.readIf(86)) {
            return Utils.EMPTY_INT_ARRAY;
        }
        if (this.isIdentifier()) {
            ArrayList<String> arrayList = Utils.newSmallArrayList();
            do {
                if (!this.isIdentifier()) {
                    throw this.getSyntaxError();
                }
                arrayList.add(this.currentToken);
                this.read();
            } while (this.readIfMore());
            return arrayList.toArray(new String[0]);
        }
        if (this.currentTokenType == 74) {
            ArrayList arrayList = Utils.newSmallArrayList();
            do {
                arrayList.add(this.readInt());
            } while (this.readIfMore());
            int n2 = arrayList.size();
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            return nArray;
        }
        throw this.getSyntaxError();
    }

    public int getLastParseIndex() {
        return this.lastParseIndex;
    }

    public String toString() {
        return StringUtils.addAsterisk(this.sqlCommand, this.parseIndex);
    }

    private static enum NullConstraintType {
        NULL_IS_ALLOWED,
        NULL_IS_NOT_ALLOWED,
        NO_NULL_CONSTRAINT_FOUND;

    }
}

