/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.predicates;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;

public class ST_Intersects
extends DeterministicScalarFunction {
    public ST_Intersects() {
        this.addProperty("remarks", "Return true if the geometry A intersects the geometry B.");
    }

    public String getJavaStaticMethod() {
        return "isIntersects";
    }

    public static Boolean isIntersects(Geometry surface, Geometry testGeometry) throws SQLException {
        if (surface == null) {
            return null;
        }
        if (testGeometry == null) {
            return false;
        }
        if (surface.getSRID() != testGeometry.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return surface.intersects(testGeometry);
    }
}

