/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.jts_utils.CoordinateUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ST_RemoveRepeatedPoints
extends DeterministicScalarFunction {
    public ST_RemoveRepeatedPoints() {
        this.addProperty("remarks", "Returns a version of the given geometry with duplicated points removed.\nIf the tolerance parameter is provided, vertices within the tolerance of one another will be considered the same for the purposes of removal. ");
    }

    public String getJavaStaticMethod() {
        return "removeRepeatedPoints";
    }

    public static Geometry removeRepeatedPoints(Geometry geometry) throws SQLException, SQLException {
        return ST_RemoveRepeatedPoints.removeDuplicateCoordinates(geometry, 0.0);
    }

    public static Geometry removeRepeatedPoints(Geometry geometry, double tolerance) throws SQLException {
        return ST_RemoveRepeatedPoints.removeDuplicateCoordinates(geometry, tolerance);
    }

    public static Geometry removeDuplicateCoordinates(Geometry geom, double tolerance) throws SQLException {
        if (geom == null) {
            return null;
        }
        if (geom.isEmpty()) {
            return geom;
        }
        if (geom instanceof Point) {
            return geom;
        }
        if (geom instanceof MultiPoint) {
            return geom;
        }
        if (geom instanceof LineString) {
            return ST_RemoveRepeatedPoints.removeDuplicateCoordinates((LineString)geom, tolerance);
        }
        if (geom instanceof MultiLineString) {
            return ST_RemoveRepeatedPoints.removeDuplicateCoordinates((MultiLineString)geom, tolerance);
        }
        if (geom instanceof Polygon) {
            return ST_RemoveRepeatedPoints.removeDuplicateCoordinates((Polygon)geom, tolerance);
        }
        if (geom instanceof MultiPolygon) {
            return ST_RemoveRepeatedPoints.removeDuplicateCoordinates((MultiPolygon)geom, tolerance);
        }
        if (geom instanceof GeometryCollection) {
            return ST_RemoveRepeatedPoints.removeDuplicateCoordinates((GeometryCollection)geom, tolerance);
        }
        return null;
    }

    public static LineString removeDuplicateCoordinates(LineString linestring, double tolerance) throws SQLException {
        Coordinate[] coords = CoordinateUtils.removeRepeatedCoordinates((Coordinate[])linestring.getCoordinates(), (double)tolerance, (boolean)false);
        if (coords.length < 2) {
            throw new SQLException("Not enough coordinates to build a new LineString.\n Please adjust the tolerance");
        }
        return linestring.getFactory().createLineString(coords);
    }

    public static LinearRing removeDuplicateCoordinates(LinearRing linearRing, double tolerance) {
        Coordinate[] coords = CoordinateUtils.removeRepeatedCoordinates((Coordinate[])linearRing.getCoordinates(), (double)tolerance, (boolean)true);
        return linearRing.getFactory().createLinearRing(coords);
    }

    public static MultiLineString removeDuplicateCoordinates(MultiLineString multiLineString, double tolerance) throws SQLException {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            LineString line = (LineString)multiLineString.getGeometryN(i);
            lines.add(ST_RemoveRepeatedPoints.removeDuplicateCoordinates(line, tolerance));
        }
        return multiLineString.getFactory().createMultiLineString(GeometryFactory.toLineStringArray(lines));
    }

    public static Polygon removeDuplicateCoordinates(Polygon polygon, double tolerance) throws SQLException {
        GeometryFactory factory = polygon.getFactory();
        Coordinate[] shellCoords = CoordinateUtils.removeRepeatedCoordinates((Coordinate[])polygon.getExteriorRing().getCoordinates(), (double)tolerance, (boolean)true);
        LinearRing shell = factory.createLinearRing(shellCoords);
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            Coordinate[] holeCoords = CoordinateUtils.removeRepeatedCoordinates((Coordinate[])polygon.getInteriorRingN(i).getCoordinates(), (double)tolerance, (boolean)true);
            if (holeCoords.length < 4) {
                throw new SQLException("Not enough coordinates to build a new LinearRing.\n Please adjust the tolerance");
            }
            holes.add(factory.createLinearRing(holeCoords));
        }
        return factory.createPolygon(shell, GeometryFactory.toLinearRingArray(holes));
    }

    public static MultiPolygon removeDuplicateCoordinates(MultiPolygon multiPolygon, double tolerance) throws SQLException {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)multiPolygon.getGeometryN(i);
            polys.add(ST_RemoveRepeatedPoints.removeDuplicateCoordinates(poly, tolerance));
        }
        return multiPolygon.getFactory().createMultiPolygon(GeometryFactory.toPolygonArray(polys));
    }

    public static GeometryCollection removeDuplicateCoordinates(GeometryCollection geometryCollection, double tolerance) throws SQLException {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geom = geometryCollection.getGeometryN(i);
            geoms.add(ST_RemoveRepeatedPoints.removeDuplicateCoordinates(geom, tolerance));
        }
        return geometryCollection.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(geoms));
    }
}

