/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.affine_transformations;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class ST_Scale
extends DeterministicScalarFunction {
    public ST_Scale() {
        this.addProperty("remarks", "Scales the given geometry by multiplying the coordinates by the indicated scale factors");
    }

    public String getJavaStaticMethod() {
        return "scale";
    }

    public static Geometry scale(Geometry geom, double xFactor, double yFactor) {
        if (geom != null) {
            Geometry scaledGeom = geom.copy();
            for (Coordinate c : scaledGeom.getCoordinates()) {
                c.setOrdinate(0, c.getOrdinate(0) * xFactor);
                c.setOrdinate(1, c.getOrdinate(1) * yFactor);
            }
            return scaledGeom;
        }
        return null;
    }

    public static Geometry scale(Geometry geom, double xFactor, double yFactor, double zFactor) {
        if (geom != null) {
            Geometry scaledGeom = geom.copy();
            for (Coordinate c : scaledGeom.getCoordinates()) {
                c.setOrdinate(0, c.getOrdinate(0) * xFactor);
                c.setOrdinate(1, c.getOrdinate(1) * yFactor);
                c.setOrdinate(2, c.getOrdinate(2) * zFactor);
            }
            return scaledGeom;
        }
        return null;
    }
}

