/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWriteDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonWriteDriver.class);
    private final Connection connection;

    public JsonWriteDriver(Connection connection) {
        this.connection = connection;
    }

    public void write(ProgressVisitor progress, ResultSet rs, File file, boolean deleteFile) throws SQLException, IOException {
        this.write((ProgressVisitor)(progress != null ? progress : new EmptyProgressVisitor()), rs, file, deleteFile, null);
    }

    public void write(ProgressVisitor progress, ResultSet rs, File file, boolean deleteFile, String encoding) throws SQLException, IOException {
        block65: {
            if (deleteFile && !Files.deleteIfExists(file.toPath())) {
                LOGGER.warn("Unable to delete file '" + file.getAbsolutePath() + "'");
            }
            if (rs == null) {
                throw new SQLException("The ResultSet to save is null or empty : no data to write.");
            }
            if (FileUtilities.isExtensionWellFormated((File)file, (String)"json")) {
                try (FileOutputStream fos = new FileOutputStream(file);){
                    this.jsonWrite(progress, rs, (OutputStream)fos, encoding);
                }
            }
            if (FileUtilities.isExtensionWellFormated((File)file, (String)"gz")) {
                try (FileOutputStream fos = new FileOutputStream(file);
                     GZIPOutputStream gzos = new GZIPOutputStream(fos);){
                    this.jsonWrite(progress, rs, (OutputStream)gzos, encoding);
                    break block65;
                }
            }
            if (FileUtilities.isExtensionWellFormated((File)file, (String)"zip")) {
                try (FileOutputStream fos = new FileOutputStream(file);
                     ZipOutputStream zip = new ZipOutputStream(fos);){
                    zip.putNextEntry(new ZipEntry(file.getName().substring(0, file.getName().length() - 4)));
                    this.jsonWrite(progress, rs, (OutputStream)zip, encoding);
                    break block65;
                }
            }
            throw new SQLException("Only .json, .gz, .zip extension is supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(ProgressVisitor progress, String tableName, File fileName, boolean deleteFile, String encoding) throws SQLException, IOException {
        if (tableName == null) {
            throw new SQLException("The select query or the table name must not be null.");
        }
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableName);
        if (matcher.find()) {
            if (!tableName.startsWith("(") || !tableName.endsWith(")")) throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
            if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"json")) {
                if (deleteFile) {
                    Files.deleteIfExists(fileName.toPath());
                } else if (fileName.exists()) {
                    throw new IOException("The json file already exist.");
                }
                PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
                ResultSet rs = ps.executeQuery();
                this.jsonWrite(progress, rs, (OutputStream)new FileOutputStream(fileName), encoding);
                return;
            }
            if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"gz")) {
                if (deleteFile) {
                    Files.deleteIfExists(fileName.toPath());
                } else if (fileName.exists()) {
                    throw new IOException("The gz file already exist.");
                }
                DeflaterOutputStream gzos = null;
                try {
                    FileOutputStream fos = new FileOutputStream(fileName);
                    gzos = new GZIPOutputStream(fos);
                    PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
                    ResultSet rs = ps.executeQuery();
                    this.jsonWrite(progress, rs, (OutputStream)gzos, encoding);
                    return;
                }
                finally {
                    try {
                        if (gzos != null) {
                            gzos.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new SQLException(ex);
                    }
                }
            }
            if (!FileUtilities.isExtensionWellFormated((File)fileName, (String)"zip")) throw new SQLException("Only .json , .gz or .zip extensions are supported");
            if (deleteFile) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The zip file already exist.");
            }
            ZipOutputStream zip = null;
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                zip = new ZipOutputStream(fos);
                zip.putNextEntry(new ZipEntry(fileName.getName().substring(0, fileName.getName().length() - 4)));
                PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
                ResultSet rs = ps.executeQuery();
                this.jsonWrite(progress, rs, (OutputStream)zip, encoding);
                return;
            }
            finally {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
        if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"json")) {
            if (deleteFile) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The json file already exist.");
            }
            this.jsonWrite(progress, tableName, (OutputStream)new FileOutputStream(fileName), encoding);
            return;
        }
        if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"gz")) {
            if (deleteFile) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The gz file already exist.");
            }
            DeflaterOutputStream gzos = null;
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                gzos = new GZIPOutputStream(fos);
                this.jsonWrite(progress, tableName, (OutputStream)gzos, encoding);
                return;
            }
            finally {
                try {
                    if (gzos != null) {
                        gzos.close();
                    }
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
        if (!FileUtilities.isExtensionWellFormated((File)fileName, (String)"zip")) throw new SQLException("Only .json , .gz or .zip extensions are supported");
        if (deleteFile) {
            Files.deleteIfExists(fileName.toPath());
        } else if (fileName.exists()) {
            throw new IOException("The zip file already exist.");
        }
        ZipOutputStream zip = null;
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            zip = new ZipOutputStream(fos);
            zip.putNextEntry(new ZipEntry(fileName.getName().substring(0, fileName.getName().length() - 4)));
            this.jsonWrite(progress, tableName, (OutputStream)zip, encoding);
            return;
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jsonWrite(ProgressVisitor progress, String tableName, OutputStream fos, String encoding) throws SQLException, IOException {
        block25: {
            JsonEncoding jsonEncoding = this.getEncoding(encoding);
            try {
                DBTypes dbTypes = DBUtils.getDBType((Connection)this.connection);
                TableLocation parse = TableLocation.parse((String)tableName, (DBTypes)dbTypes);
                String outputTable = parse.toString();
                int recordCount = JDBCUtilities.getRowCount((Connection)this.connection, (String)outputTable);
                if (recordCount <= 0) break block25;
                ProgressVisitor copyProgress = progress.subProcess(recordCount);
                try (Statement st = this.connection.createStatement();){
                    JsonFactory jsonFactory = new JsonFactory();
                    JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)new BufferedOutputStream(fos), jsonEncoding);
                    try (ResultSet rs = st.executeQuery(String.format("select * from %s", outputTable));){
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int numColumns = rsmd.getColumnCount();
                        while (rs.next()) {
                            jsonGenerator.writeStartObject();
                            for (int i = 1; i < numColumns + 1; ++i) {
                                String columnName = rsmd.getColumnName(i);
                                int t = rsmd.getColumnType(i);
                                this.writeObject(t, rs, i, jsonGenerator, columnName);
                            }
                            jsonGenerator.writeEndObject();
                            copyProgress.endStep();
                        }
                        copyProgress.endOfProgress();
                        jsonGenerator.flush();
                        jsonGenerator.close();
                    }
                }
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
    }

    private void jsonWrite(ProgressVisitor progress, ResultSet rs, OutputStream os, String encoding) throws SQLException, IOException {
        ProgressVisitor p = progress != null ? progress : new EmptyProgressVisitor();
        JsonEncoding jsonEncoding = this.getEncoding(encoding);
        int rowCount = 0;
        int type = rs.getType();
        if (type == 1004 || type == 1005) {
            rs.last();
            rowCount = rs.getRow();
            rs.beforeFirst();
        }
        ProgressVisitor copyProgress = p.subProcess(rowCount);
        JsonFactory jsonFactory = new JsonFactory();
        JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)new BufferedOutputStream(os), jsonEncoding);
        ResultSetMetaData rsmd = rs.getMetaData();
        int numColumns = rsmd.getColumnCount();
        while (rs.next()) {
            jsonGenerator.writeStartObject();
            for (int i = 1; i < numColumns + 1; ++i) {
                String columnName = rsmd.getColumnName(i);
                int t = rsmd.getColumnType(i);
                this.writeObject(t, rs, i, jsonGenerator, columnName);
            }
            jsonGenerator.writeEndObject();
            copyProgress.endStep();
        }
        copyProgress.endOfProgress();
        jsonGenerator.flush();
        jsonGenerator.close();
    }

    private JsonEncoding getEncoding(String encoding) {
        if (encoding == null) {
            return JsonEncoding.UTF8;
        }
        switch (encoding.toUpperCase()) {
            default: {
                LOGGER.warn("Encoding '" + encoding + "' is not detected, use UTF-8 instead.");
            }
            case "UTF8": 
            case "UTF-8": {
                return JsonEncoding.UTF8;
            }
            case "UTF16": 
            case "UTF-16": 
            case "UTF16LE": 
            case "UTF-16LE": {
                return JsonEncoding.UTF16_LE;
            }
            case "UTF16BE": 
            case "UTF-16BE": {
                return JsonEncoding.UTF16_BE;
            }
            case "UTF32": 
            case "UTF-32": 
            case "UTF32LE": 
            case "UTF-32LE": {
                return JsonEncoding.UTF32_LE;
            }
            case "UTF32BE": 
            case "UTF-32BE": 
        }
        return JsonEncoding.UTF32_BE;
    }

    private void writeObject(int type, ResultSet rs, int index, JsonGenerator jsonGenerator, String columnName) throws IOException, SQLException {
        switch (type) {
            case 2003: {
                Object[] values = (Object[])rs.getArray(index).getArray();
                if (values == null) break;
                jsonGenerator.writeArrayFieldStart(columnName);
                for (Object value : values) {
                    jsonGenerator.writeObject(value);
                }
                jsonGenerator.writeEndArray();
                break;
            }
            case -5: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getLong(index));
                break;
            }
            case 7: {
                jsonGenerator.writeObjectField(columnName, (Object)Float.valueOf(rs.getFloat(index)));
                break;
            }
            case -7: 
            case 16: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getBoolean(index));
                break;
            }
            case 2004: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getBlob(index));
                break;
            }
            case 6: 
            case 8: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getDouble(index));
                break;
            }
            case 4: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getInt(index));
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getNString(index));
                break;
            }
            case -6: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getByte(index));
                break;
            }
            case 5: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getShort(index));
                break;
            }
            case 91: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getDate(index));
                break;
            }
            case 92: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getTime(index));
                break;
            }
            case 93: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getTimestamp(index));
                break;
            }
            case -2: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getBytes(index));
                break;
            }
            case -3: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getBytes(index));
                break;
            }
            case -4: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getBinaryStream(index));
                break;
            }
            case 2005: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getClob(index));
                break;
            }
            case 2: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getBigDecimal(index));
                break;
            }
            case 3: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getBigDecimal(index));
                break;
            }
            case 70: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getURL(index));
                break;
            }
            case 2006: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getRef(index));
                break;
            }
            case 2002: {
                jsonGenerator.writeObjectField(columnName, rs.getObject(index));
                break;
            }
            case 2001: {
                jsonGenerator.writeObjectField(columnName, rs.getObject(index));
                break;
            }
            case 2000: {
                jsonGenerator.writeObjectField(columnName, rs.getObject(index));
                break;
            }
            default: {
                jsonGenerator.writeObjectField(columnName, (Object)rs.getString(index));
            }
        }
    }
}

