/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.file_table;

import java.io.IOException;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2gis.api.FileDriver;

public class H2TableIndex
extends BaseIndex {
    public static final String PK_COLUMN_NAME = "PK";
    private FileDriver driver;
    private final boolean isScanIndex;

    public H2TableIndex(FileDriver driver, Table table, int id, IndexColumn indexColumn) {
        super(table, id, table.getName() + "_ROWID_", new IndexColumn[]{indexColumn}, IndexType.createScan((boolean)true));
        this.isScanIndex = true;
        this.driver = driver;
    }

    public H2TableIndex(FileDriver driver, Table table, int id, String indexName, IndexColumn indexColumn) {
        super(table, id, indexName, new IndexColumn[]{indexColumn}, IndexType.createPrimaryKey((boolean)true, (boolean)false));
        this.isScanIndex = false;
        this.driver = driver;
    }

    public void checkRename() {
    }

    public FileDriver getDriver() {
        return this.driver;
    }

    public Row getRow(Session session, long key) {
        return new DriverRow(this.driver, key);
    }

    public void close(Session session) {
    }

    public void add(Session session, Row row) {
    }

    public void remove(Session session, Row row) {
        throw DbException.get((int)50100, (String)"remove in file");
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) {
        if (!this.isScanIndex) {
            Row remakefirst = Row.get(null, (int)0);
            if (first != null) {
                remakefirst.setKey(first.getValue(0).getLong());
            } else {
                remakefirst.setKey(1L);
            }
            Row remakeLast = Row.get(null, (int)0);
            if (last != null) {
                remakeLast.setKey(last.getValue(0).getLong());
            } else {
                remakeLast.setKey(this.getRowCount(session));
            }
            first = remakefirst;
            last = remakeLast;
        }
        return new SHPCursor(this, first, last, session);
    }

    public double getCost(Session session, int[] masks, TableFilter[] tableFilters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        try {
            return 10L * this.getCostRangeIndex(masks, this.driver.getRowCount(), tableFilters, filter, sortOrder, true, allColumnsForPlan);
        }
        catch (IllegalStateException e) {
            throw DbException.get((int)90007, (Throwable)e, (String[])new String[0]);
        }
    }

    public void remove(Session session) {
        throw DbException.get((int)50100, (String)"remove in Shape files");
    }

    public void truncate(Session session) {
        throw DbException.get((int)50100, (String)"truncate in Shape files");
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session session, boolean first) {
        return new SHPCursor(this, first ? 0L : this.getRowCount(session), session);
    }

    public boolean needRebuild() {
        return false;
    }

    public long getRowCount(Session session) {
        return this.driver.getRowCount();
    }

    public long getRowCountApproximation() {
        return this.driver.getRowCount();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public boolean isRowIdIndex() {
        return this.isScanIndex;
    }

    public static class DriverRow
    extends Row {
        FileDriver driver;
        int memory;

        public DriverRow(FileDriver driver, long key) {
            this.driver = driver;
            this.key = key;
        }

        public Value[] getValueList() {
            try {
                Value[] values = new Value[this.getColumnCount()];
                values[0] = ValueBigint.get((long)this.key);
                for (int i = 1; i < values.length; ++i) {
                    values[i] = (Value)this.driver.getField(this.key - 1L, i - 1);
                }
                return values;
            }
            catch (IOException ex) {
                throw DbException.get((int)90028, (Throwable)ex, (String[])new String[0]);
            }
        }

        public int getColumnCount() {
            return this.driver.getFieldCount() + 1;
        }

        public Value getValue(int column) {
            if (column == -1) {
                return ValueBigint.get((long)this.key);
            }
            try {
                if (column == 0) {
                    return ValueBigint.get((long)this.key);
                }
                return (Value)this.driver.getField(this.key - 1L, column - 1);
            }
            catch (IOException ex) {
                throw DbException.get((int)90028, (Throwable)ex, (String[])new String[0]);
            }
        }

        public void setValue(int i, Value value) {
            if (i == -1) {
                this.key = value.getLong();
            }
        }

        public int getMemory() {
            if (this.memory != -1) {
                return this.memory;
            }
            this.memory = this.calculateMemory();
            return this.memory;
        }

        public void copyFrom(SearchRow source) {
            this.setKey(source.getKey());
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.setValue(i, source.getValue(i));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("( /* key:").append(this.key).append(" */ ");
            int length = this.getColumnCount();
            for (int i = 0; i < length; ++i) {
                Value v;
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append((v = this.getValue(i)) == null ? "null" : v.getTraceSQL());
            }
            return builder.append(')').toString();
        }

        int calculateMemory() {
            int m = 64 + this.getColumnCount() * 8;
            return m += this.driver.getEstimatedRowSize(this.key - 1L);
        }
    }

    private static class SHPCursor
    implements Cursor {
        private H2TableIndex tIndex;
        private long rowIndex;
        private Session session;
        private SearchRow begin;
        private SearchRow end;

        private SHPCursor(H2TableIndex tIndex, long rowIndex, Session session) {
            this.tIndex = tIndex;
            this.rowIndex = rowIndex;
            this.session = session;
        }

        private SHPCursor(H2TableIndex tIndex, SearchRow begin, SearchRow end, Session session) {
            this.tIndex = tIndex;
            this.session = session;
            this.begin = begin;
            this.end = end;
            this.rowIndex = begin == null ? 0L : begin.getKey() - 1L;
        }

        public Row get() {
            return this.tIndex.getRow(this.session, this.rowIndex);
        }

        public SearchRow getSearchRow() {
            Row row = Row.get((Value[])new Value[this.tIndex.getTable().getColumns().length], (int)-1);
            row.setKey(this.rowIndex);
            for (IndexColumn column : this.tIndex.getIndexColumns()) {
                if (column.column.getColumnId() < 0) continue;
                row.setValue(column.column.getColumnId(), (Value)ValueBigint.get((long)this.rowIndex));
            }
            return row;
        }

        public boolean next() {
            if (this.rowIndex < this.tIndex.getRowCount(this.session) && (this.end == null || this.rowIndex < this.end.getKey())) {
                ++this.rowIndex;
                return true;
            }
            return false;
        }

        public boolean previous() {
            if (this.rowIndex > 0L && (this.begin == null || this.rowIndex >= this.begin.getKey())) {
                --this.rowIndex;
                return true;
            }
            return false;
        }
    }
}

