/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.Objects;
import org.h2.command.Parser;
import org.h2.command.ddl.SequenceOptions;
import org.h2.engine.CastDataProvider;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.SequenceValue;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.table.GeneratedColumnResolver;
import org.h2.table.Table;
import org.h2.util.HasSQL;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueNull;
import org.h2.value.ValueUuid;

public class Column
implements HasSQL {
    public static final String ROWID = "_ROWID_";
    public static final int NOT_NULLABLE = 0;
    public static final int NULLABLE = 1;
    public static final int NULLABLE_UNKNOWN = 2;
    private TypeInfo type;
    private Table table;
    private String name;
    private int columnId;
    private boolean nullable = true;
    private Expression defaultExpression;
    private Expression onUpdateExpression;
    private String originalSQL;
    private SequenceOptions autoIncrementOptions;
    private boolean convertNullToDefault;
    private Sequence sequence;
    private boolean isGenerated;
    private GeneratedColumnResolver generatedTableFilter;
    private int selectivity;
    private String comment;
    private boolean primaryKey;
    private boolean visible = true;
    private boolean rowId;
    private Domain domain;

    public static StringBuilder writeColumns(StringBuilder stringBuilder, Column[] columnArray, int n) {
        int n2 = columnArray.length;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            columnArray[i].getSQL(stringBuilder, n);
        }
        return stringBuilder;
    }

    public static StringBuilder writeColumns(StringBuilder stringBuilder, Column[] columnArray, String string, String string2, int n) {
        int n2 = columnArray.length;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            columnArray[i].getSQL(stringBuilder, n).append(string2);
        }
        return stringBuilder;
    }

    public Column(String string, int n) {
        this(string, TypeInfo.getTypeInfo(n));
    }

    public Column(String string, TypeInfo typeInfo) {
        this.name = string;
        this.type = typeInfo;
    }

    public Column(String string, TypeInfo typeInfo, String string2) {
        this.name = string;
        this.type = typeInfo;
        this.originalSQL = string2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Column)) {
            return false;
        }
        Column column = (Column)object;
        if (this.table == null || column.table == null || this.name == null || column.name == null) {
            return false;
        }
        if (this.table != column.table) {
            return false;
        }
        return this.name.equals(column.name);
    }

    public int hashCode() {
        if (this.table == null || this.name == null) {
            return 0;
        }
        return this.table.getId() ^ this.name.hashCode();
    }

    public Column getClone() {
        Column column = new Column(this.name, this.type);
        column.copy(this);
        return column;
    }

    public Value convert(CastDataProvider castDataProvider, Value value) {
        try {
            return value.convertTo(this.type, castDataProvider, this);
        }
        catch (DbException dbException) {
            DbException dbException2;
            if (dbException.getErrorCode() == 22018) {
                dbException2 = this.getDataConversionError(value, dbException);
            }
            throw dbException2;
        }
    }

    public boolean getGenerated() {
        return this.isGenerated;
    }

    public void setGeneratedExpression(Expression expression) {
        this.isGenerated = true;
        this.defaultExpression = expression;
    }

    public void setTable(Table table, int n) {
        this.table = table;
        this.columnId = n;
    }

    public Table getTable() {
        return this.table;
    }

    public void setDefaultExpression(Session session, Expression expression) {
        if (expression != null && (expression = expression.optimize(session)).isConstant()) {
            expression = ValueExpression.get(expression.getValue(session));
        }
        this.defaultExpression = expression;
    }

    public void setOnUpdateExpression(Session session, Expression expression) {
        if (expression != null && (expression = expression.optimize(session)).isConstant()) {
            expression = ValueExpression.get(expression.getValue(session));
        }
        this.onUpdateExpression = expression;
    }

    public int getColumnId() {
        return this.columnId;
    }

    @Override
    public String getSQL(int n) {
        return this.rowId ? this.name : Parser.quoteIdentifier(this.name, n);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        return this.rowId ? stringBuilder.append(this.name) : Parser.quoteIdentifier(stringBuilder, this.name, n);
    }

    public StringBuilder getSQLWithTable(StringBuilder stringBuilder, int n) {
        return this.getSQL(this.table.getSQL(stringBuilder, n).append('.'), n);
    }

    public String getName() {
        return this.name;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public boolean isRowId() {
        return this.rowId;
    }

    public void setRowId(boolean bl) {
        this.rowId = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value validateConvertUpdateSequence(Session session, Value value, Row row) {
        Expression expression = this.defaultExpression;
        boolean bl = false;
        if (value == null) {
            if (expression == null) {
                if (!this.nullable) {
                    throw DbException.get(23502, this.name);
                }
                value = ValueNull.INSTANCE;
            } else {
                if (this.isGenerated) {
                    Column column = this;
                    synchronized (column) {
                        this.generatedTableFilter.set(row);
                        try {
                            value = expression.getValue(session);
                        }
                        finally {
                            this.generatedTableFilter.set(null);
                        }
                    }
                }
                value = expression.getValue(session);
                if (value == ValueNull.INSTANCE && !this.nullable) {
                    throw DbException.get(23502, this.name);
                }
                bl = true;
            }
        } else if (value == ValueNull.INSTANCE) {
            if (this.convertNullToDefault) {
                value = expression.getValue(session);
                bl = true;
            }
            if (value == ValueNull.INSTANCE && !this.nullable) {
                throw DbException.get(23502, this.name);
            }
        }
        try {
            value = value.convertForAssignTo(this.type, session, this.name);
        }
        catch (DbException dbException) {
            DbException dbException2;
            if (dbException.getErrorCode() == 22018) {
                dbException2 = this.getDataConversionError(value, dbException);
            }
            throw dbException2;
        }
        if (this.domain != null) {
            this.domain.checkConstraints(session, value);
        }
        if (bl && !expression.isConstant() && this.primaryKey) {
            session.setLastIdentity(value);
        }
        this.updateSequenceIfRequired(session, value);
        return value;
    }

    private DbException getDataConversionError(Value value, DbException dbException) {
        StringBuilder stringBuilder = new StringBuilder().append(value.getTraceSQL()).append(" (");
        if (this.table != null) {
            stringBuilder.append(this.table.getName()).append(": ");
        }
        stringBuilder.append(this.getCreateSQL()).append(')');
        return DbException.get(22018, dbException, stringBuilder.toString());
    }

    private void updateSequenceIfRequired(Session session, Value value) {
        if (this.sequence != null) {
            long l = this.sequence.getCurrentValue();
            long l2 = this.sequence.getIncrement();
            long l3 = value.getLong();
            boolean bl = false;
            if (l2 > 0L && l3 > l) {
                bl = true;
            } else if (l2 < 0L && l3 < l) {
                bl = true;
            }
            if (bl) {
                this.sequence.modify(null, l3 + l2, null, null, null);
                session.setLastIdentity(ValueBigint.get(l3));
                this.sequence.flush(session);
            }
        }
    }

    public void convertAutoIncrementToSequence(Session session, Schema schema, int n, boolean bl) {
        HasSQL hasSQL;
        Object object;
        String string;
        if (this.autoIncrementOptions == null) {
            DbException.throwInternalError();
        }
        if ("IDENTITY".equals(this.originalSQL)) {
            this.originalSQL = "BIGINT";
        } else if ("SERIAL".equals(this.originalSQL)) {
            this.originalSQL = "INT";
        }
        do {
            hasSQL = ValueUuid.getNewRandom();
            object = ((ValueUuid)hasSQL).getString();
            object = StringUtils.toUpperEnglish(((String)object).replace('-', '_'));
        } while (schema.findSequence(string = "SYSTEM_SEQUENCE_" + (String)object) != null);
        hasSQL = new Sequence(session, schema, n, string, this.autoIncrementOptions, true);
        ((DbObjectBase)hasSQL).setTemporary(bl);
        session.getDatabase().addSchemaObject(session, (SchemaObject)hasSQL);
        this.setAutoIncrementOptions(null);
        object = new SequenceValue((Sequence)hasSQL, false);
        this.setDefaultExpression(session, (Expression)object);
        this.setSequence((Sequence)hasSQL);
    }

    public void prepareExpression(Session session) {
        if (this.defaultExpression != null) {
            if (this.isGenerated) {
                this.generatedTableFilter = new GeneratedColumnResolver(this.table);
                this.defaultExpression.mapColumns(this.generatedTableFilter, 0, 0);
            }
            this.defaultExpression = this.defaultExpression.optimize(session);
        }
        if (this.onUpdateExpression != null) {
            this.onUpdateExpression = this.onUpdateExpression.optimize(session);
        }
    }

    public String getCreateSQLWithoutName() {
        return this.getCreateSQL(false);
    }

    public String getCreateSQL() {
        return this.getCreateSQL(true);
    }

    private String getCreateSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl && this.name != null) {
            Parser.quoteIdentifier(stringBuilder, this.name, 0).append(' ');
        }
        if (this.originalSQL != null) {
            stringBuilder.append(this.originalSQL);
        } else {
            this.type.getSQL(stringBuilder);
        }
        if (!this.visible) {
            stringBuilder.append(" INVISIBLE ");
        }
        if (this.defaultExpression != null) {
            if (this.isGenerated) {
                stringBuilder.append(" GENERATED ALWAYS AS ");
                this.defaultExpression.getEnclosedSQL(stringBuilder, 0);
            } else {
                stringBuilder.append(" DEFAULT ");
                this.defaultExpression.getSQL(stringBuilder, 0);
            }
        }
        if (this.onUpdateExpression != null) {
            stringBuilder.append(" ON UPDATE ");
            this.onUpdateExpression.getSQL(stringBuilder, 0);
        }
        if (this.convertNullToDefault) {
            stringBuilder.append(" NULL_TO_DEFAULT");
        }
        if (this.sequence != null) {
            stringBuilder.append(" SEQUENCE ");
            this.sequence.getSQL(stringBuilder, 0);
        }
        if (this.selectivity != 0) {
            stringBuilder.append(" SELECTIVITY ").append(this.selectivity);
        }
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        if (!this.nullable) {
            stringBuilder.append(" NOT NULL");
        }
        return stringBuilder.toString();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setOriginalSQL(String string) {
        this.originalSQL = string;
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public Expression getOnUpdateExpression() {
        return this.onUpdateExpression;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrementOptions != null;
    }

    public void setAutoIncrementOptions(SequenceOptions sequenceOptions) {
        this.autoIncrementOptions = sequenceOptions;
        this.nullable = false;
        if (sequenceOptions != null) {
            this.convertNullToDefault = true;
        }
    }

    public SequenceOptions getAutoIncrementOptions() {
        return this.autoIncrementOptions;
    }

    public void setConvertNullToDefault(boolean bl) {
        this.convertNullToDefault = bl;
    }

    public void rename(String string) {
        this.name = string;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int getSelectivity() {
        return this.selectivity == 0 ? 50 : this.selectivity;
    }

    public void setSelectivity(int n) {
        this.selectivity = n = n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    String getDefaultSQL() {
        return this.defaultExpression == null ? null : this.defaultExpression.getSQL(0);
    }

    String getOnUpdateSQL() {
        return this.onUpdateExpression == null ? null : this.onUpdateExpression.getSQL(0);
    }

    int getPrecisionAsInt() {
        return MathUtils.convertLongToInt(this.type.getPrecision());
    }

    DataType getDataType() {
        return DataType.getDataType(this.type.getValueType());
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPrimaryKey(boolean bl) {
        this.primaryKey = bl;
    }

    boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.getType() == 7 && this.sequence != null) {
            expressionVisitor.getDependencies().add(this.sequence);
        }
        if (this.defaultExpression != null && !this.defaultExpression.isEverything(expressionVisitor)) {
            return false;
        }
        return this.onUpdateExpression == null || this.onUpdateExpression.isEverything(expressionVisitor);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String toString() {
        return this.name;
    }

    public boolean isWideningConversion(Column column) {
        if (this.type.getValueType() != column.type.getValueType()) {
            return false;
        }
        if (this.type.getPrecision() > column.type.getPrecision()) {
            return false;
        }
        if (this.type.getScale() != column.type.getScale()) {
            return false;
        }
        if (!Objects.equals(this.type.getExtTypeInfo(), column.type.getExtTypeInfo())) {
            return false;
        }
        if (this.nullable && !column.nullable) {
            return false;
        }
        if (this.convertNullToDefault != column.convertNullToDefault) {
            return false;
        }
        if (this.primaryKey != column.primaryKey) {
            return false;
        }
        if (this.autoIncrementOptions != null || column.autoIncrementOptions != null) {
            return false;
        }
        if (this.domain != column.domain) {
            return false;
        }
        if (this.convertNullToDefault || column.convertNullToDefault) {
            return false;
        }
        if (this.defaultExpression != null || column.defaultExpression != null) {
            return false;
        }
        if (this.isGenerated || column.isGenerated) {
            return false;
        }
        if (this.onUpdateExpression != null || column.onUpdateExpression != null) {
            return false;
        }
        return Objects.equals(this.type.getExtTypeInfo(), column.type.getExtTypeInfo());
    }

    public void copy(Column column) {
        this.name = column.name;
        this.type = column.type;
        this.nullable = column.nullable;
        this.defaultExpression = column.defaultExpression;
        this.onUpdateExpression = column.onUpdateExpression;
        this.originalSQL = column.originalSQL;
        this.convertNullToDefault = column.convertNullToDefault;
        this.sequence = column.sequence;
        this.comment = column.comment;
        this.generatedTableFilter = column.generatedTableFilter;
        this.isGenerated = column.isGenerated;
        this.selectivity = column.selectivity;
        this.primaryKey = column.primaryKey;
        this.visible = column.visible;
    }
}

