/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.ConstraintDomain;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Domain;
import org.h2.schema.Schema;

public class AlterDomainAddConstraint
extends SchemaCommand {
    private String constraintName;
    private String domainName;
    private Expression checkExpression;
    private String comment;
    private boolean checkExisting;
    private boolean ifDomainExists;
    private final boolean ifNotExists;

    public AlterDomainAddConstraint(Session session, Schema schema, boolean bl) {
        super(session, schema);
        this.ifNotExists = bl;
    }

    public void setIfDomainExists(boolean bl) {
        this.ifDomainExists = bl;
    }

    private String generateConstraintName(Domain domain) {
        if (this.constraintName == null) {
            this.constraintName = this.getSchema().getUniqueDomainConstraintName(this.session, domain);
        }
        return this.constraintName;
    }

    @Override
    public int update() {
        try {
            int n = this.tryUpdate();
            return n;
        }
        finally {
            this.getSchema().freeUniqueName(this.constraintName);
        }
    }

    private int tryUpdate() {
        this.session.commit(true);
        Domain domain = this.getSchema().findDomain(this.domainName);
        if (domain == null) {
            if (this.ifDomainExists) {
                return 0;
            }
            throw DbException.get(90120, this.domainName);
        }
        if (this.constraintName != null && this.getSchema().findConstraint(this.session, this.constraintName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90045, this.constraintName);
        }
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        database.lockMeta(this.session);
        int n = this.getObjectId();
        String string = this.generateConstraintName(domain);
        ConstraintDomain constraintDomain = new ConstraintDomain(this.getSchema(), n, string, domain);
        constraintDomain.setExpression(this.session, this.checkExpression);
        if (this.checkExisting) {
            constraintDomain.checkExistingData(this.session);
        }
        constraintDomain.setComment(this.comment);
        database.addSchemaObject(this.session, constraintDomain);
        domain.addConstraint(constraintDomain);
        return 0;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public int getType() {
        return 92;
    }

    public void setCheckExpression(Expression expression) {
        this.checkExpression = expression;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setCheckExisting(boolean bl) {
        this.checkExisting = bl;
    }
}

