/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.alg;

import java.util.LinkedList;
import java.util.Set;
import org.javanetworkanalyzer.alg.GraphSearchAlgorithm;
import org.javanetworkanalyzer.data.VBFS;
import org.javanetworkanalyzer.data.VPredImpl;
import org.javanetworkanalyzer.model.EdgeSPT;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

public class BFS<V extends VBFS, E extends EdgeSPT>
extends GraphSearchAlgorithm<V, E> {
    private final LinkedList<V> queue = new LinkedList();

    public BFS(Graph<V, E> graph) {
        super(graph);
    }

    @Override
    public void calculate(V startNode) {
        this.init(startNode);
        while (!this.queue.isEmpty()) {
            V current = this.dequeueStep(this.queue);
            Set outgoingEdges = this.outgoingEdgesOf(current);
            for (EdgeSPT e : outgoingEdges) {
                VBFS neighbor = (VBFS)Graphs.getOppositeVertex((Graph)this.graph, (Object)e, current);
                if (neighbor.getDistance() < 0) {
                    this.enqueueAndUpdateDistance(current, neighbor, this.queue);
                    this.firstTimeFoundStep(current, neighbor);
                }
                if (neighbor.getDistance() != ((VBFS)current).getDistance() + 1) continue;
                this.shortestPathStep(current, neighbor, e);
            }
        }
    }

    @Override
    protected void init(V startNode) {
        super.init(startNode);
        for (VBFS node : this.graph.vertexSet()) {
            node.reset();
        }
        ((VBFS)startNode).setSource();
        this.queue.clear();
        this.queue.add(startNode);
    }

    protected V dequeueStep(LinkedList<V> queue) {
        return (V)((VBFS)queue.poll());
    }

    protected void enqueueAndUpdateDistance(V current, V neighbor, LinkedList<V> queue) {
        ((VBFS)neighbor).setDistance(((VBFS)current).getDistance() + 1);
        queue.add(neighbor);
    }

    protected void firstTimeFoundStep(V current, V neighbor) {
    }

    protected void shortestPathStep(V current, V neighbor, E e) {
        ((VPredImpl)neighbor).addPredecessor(current);
        ((VPredImpl)neighbor).addPredecessorEdge(e);
    }
}

