/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.predicates;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;

public class ST_Contains
extends DeterministicScalarFunction {
    public ST_Contains() {
        this.addProperty("remarks", "Return true if Geometry A contains Geometry B");
    }

    public String getJavaStaticMethod() {
        return "isContains";
    }

    public static Boolean isContains(Geometry surface, Geometry testGeometry) throws SQLException {
        if (surface == null) {
            return null;
        }
        if (testGeometry == null) {
            return false;
        }
        if (surface.getSRID() != testGeometry.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return surface.contains(testGeometry);
    }
}

