/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.crs;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.GeographyUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class ST_FindUTMSRID
extends DeterministicScalarFunction {
    public ST_FindUTMSRID() {
        this.addProperty("remarks", "ST_FindUTMSRID takes a geometry and find the UTM SRID code from its centroid.");
    }

    public String getJavaStaticMethod() {
        return "findSRID";
    }

    public static int findSRID(Connection connection, Geometry geometry) throws SQLException {
        if (geometry == null) {
            return -1;
        }
        Point coord = geometry.getCentroid();
        return GeographyUtilities.getSRID((Connection)connection, (float)((float)coord.getY()), (float)((float)coord.getX()));
    }
}

