/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.shape.random.RandomPointsBuilder;

public class ST_GeneratePoints
extends DeterministicScalarFunction {
    static PointOnGeometryLocator extentLocator;

    public ST_GeneratePoints() {
        this.addProperty("remarks", "ST_GeneratePoints(Geometry geom, int nPts), generates pseudo-random points until \n the requested number are found within the input polygon or multipolygon.");
    }

    public String getJavaStaticMethod() {
        return "generatePoints";
    }

    public static Geometry generatePoints(Geometry geom, int nPts) throws SQLException {
        if (geom == null) {
            return null;
        }
        if (geom.isEmpty()) {
            return null;
        }
        if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            if (geom.getArea() > 0.0) {
                RandomPointsBuilder shapeBuilder = new RandomPointsBuilder(geom.getFactory());
                shapeBuilder.setExtent(geom);
                shapeBuilder.setNumPoints(nPts);
                return shapeBuilder.getGeometry();
            }
            return null;
        }
        throw new SQLException("Only polygon or multipolygon is supported");
    }
}

