/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.kml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.kml.ExtrudeMode;
import org.h2gis.functions.io.kml.KMLGeometry;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.Tuple;
import org.locationtech.jts.geom.Geometry;

public class KMLWriterDriver {
    private final Connection connection;
    private final File fileName;
    private final String encoding;
    private final boolean deleteFile;
    private HashMap<Integer, String> kmlFields;
    private int columnCount = -1;
    private String tableName;

    public KMLWriterDriver(Connection connection, File fileName, String encoding, boolean deleteFile) {
        this.connection = connection;
        this.fileName = fileName;
        this.encoding = encoding;
        this.deleteFile = deleteFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(String tableName, ProgressVisitor progress) throws SQLException, IOException {
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableName);
        if (matcher.find()) {
            if (!tableName.startsWith("(") || !tableName.endsWith(")")) throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
            if (FileUtilities.isExtensionWellFormated((File)this.fileName, (String)"kml")) {
                if (this.deleteFile) {
                    Files.deleteIfExists(this.fileName.toPath());
                } else if (this.fileName.exists()) {
                    throw new IOException("The kml file already exist.");
                }
                PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
                ResultSet resultSet = ps.executeQuery();
                Tuple spatialFieldName = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((ResultSet)resultSet);
                int rowCount = 0;
                int type = resultSet.getType();
                if (type == 1004 || type == 1005) {
                    resultSet.last();
                    rowCount = resultSet.getRow();
                    resultSet.beforeFirst();
                }
                this.tableName = "QUERY_" + System.currentTimeMillis();
                this.writeKML(progress.subProcess(rowCount), this.fileName, resultSet, (String)spatialFieldName.first(), this.encoding);
                return;
            } else {
                if (!FileUtilities.isExtensionWellFormated((File)this.fileName, (String)"kmz")) throw new SQLException("Please use the extensions .kml or kmz.");
                if (this.deleteFile) {
                    Files.deleteIfExists(this.fileName.toPath());
                } else if (this.fileName.exists()) {
                    throw new IOException("The kmz file already exist.");
                }
                PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
                ResultSet resultSet = ps.executeQuery();
                Tuple spatialFieldName = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((ResultSet)resultSet);
                int rowCount = 0;
                int type = resultSet.getType();
                if (type == 1004 || type == 1005) {
                    resultSet.last();
                    rowCount = resultSet.getRow();
                    resultSet.beforeFirst();
                }
                this.tableName = "QUERY_" + System.currentTimeMillis();
                String name = this.fileName.getName();
                int pos = name.lastIndexOf(".");
                this.writeKMZ(progress.subProcess(rowCount), this.fileName, name.substring(0, pos) + ".kmz", resultSet, (String)spatialFieldName.first(), this.encoding);
            }
            return;
        } else {
            Statement st = this.connection.createStatement();
            ResultSet resultSet = st.executeQuery(String.format("select * from %s", tableName));
            Tuple spatialFieldName = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((ResultSet)resultSet);
            this.tableName = tableName;
            if (FileUtilities.isExtensionWellFormated((File)this.fileName, (String)"kml")) {
                if (this.deleteFile) {
                    Files.deleteIfExists(this.fileName.toPath());
                } else if (this.fileName.exists()) {
                    throw new IOException("The kml file already exist.");
                }
                this.writeKML(progress, this.fileName, resultSet, (String)spatialFieldName.first(), this.encoding);
                return;
            } else {
                if (!FileUtilities.isExtensionWellFormated((File)this.fileName, (String)"kmz")) throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
                if (this.deleteFile) {
                    Files.deleteIfExists(this.fileName.toPath());
                } else if (this.fileName.exists()) {
                    throw new IOException("The kmz file already exist.");
                }
                String name = this.fileName.getName();
                int pos = name.lastIndexOf(".");
                this.writeKMZ(progress, this.fileName, name.substring(0, pos) + ".kmz", resultSet, (String)spatialFieldName.first(), this.encoding);
            }
        }
    }

    private void writeKML(ProgressVisitor progress, File fileName, ResultSet rs, String geomField, String encoding) throws SQLException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            this.writeKMLDocument(progress, fos, rs, geomField, encoding);
        }
        catch (FileNotFoundException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeKMZ(ProgressVisitor progress, File fileName, String fileNameWithExtension, ResultSet rs, String geomField, String encoding) throws SQLException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(fileName));
            zos.putNextEntry(new ZipEntry(fileNameWithExtension));
            this.writeKMLDocument(progress, zos, rs, geomField, encoding);
            return;
        }
        catch (FileNotFoundException ex) {
            throw new SQLException(ex);
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                if (zos != null) {
                    zos.closeEntry();
                    zos.finish();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
            finally {
                try {
                    if (zos != null) {
                        zos.close();
                    }
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKMLDocument(ProgressVisitor progress, OutputStream outputStream, ResultSet rs, String geomField, String encoding) throws SQLException {
        try {
            XMLOutputFactory streamWriterFactory = XMLOutputFactory.newFactory();
            streamWriterFactory.setProperty("escapeCharacters", false);
            String newEncoding = encoding;
            if (newEncoding == null || newEncoding.isEmpty()) {
                newEncoding = "UTF-8";
            }
            XMLStreamWriter xmlOut = streamWriterFactory.createXMLStreamWriter(new BufferedOutputStream(outputStream), newEncoding);
            xmlOut.writeStartDocument(newEncoding, "1.0");
            xmlOut.writeStartElement("kml");
            xmlOut.writeDefaultNamespace("http://www.opengis.net/kml/2.2");
            xmlOut.writeNamespace("atom", "http://www.w3.org/2005/Atom");
            xmlOut.writeNamespace("kml", "http://www.opengis.net/kml/2.2");
            xmlOut.writeNamespace("gx", "http://www.google.com/kml/ext/2.2");
            xmlOut.writeNamespace("xal", "urn:oasis:names:tc:ciq:xsdschema:xAL:2.0");
            xmlOut.writeStartElement("Document");
            try {
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                this.writeSchema(xmlOut, resultSetMetaData);
                xmlOut.writeStartElement("Folder");
                xmlOut.writeStartElement("name");
                xmlOut.writeCharacters(this.tableName);
                xmlOut.writeEndElement();
                while (rs.next()) {
                    this.writePlacemark(xmlOut, rs, geomField);
                    progress.endStep();
                }
            }
            finally {
                rs.close();
            }
            xmlOut.writeEndElement();
            xmlOut.writeEndElement();
            xmlOut.writeEndDocument();
            xmlOut.close();
        }
        catch (XMLStreamException ex) {
            throw new SQLException(ex);
        }
    }

    private void writeSchema(XMLStreamWriter xmlOut, ResultSetMetaData metaData) throws XMLStreamException, SQLException {
        this.columnCount = metaData.getColumnCount();
        if (this.columnCount > 1) {
            xmlOut.writeStartElement("Schema");
            xmlOut.writeAttribute("name", this.tableName);
            xmlOut.writeAttribute("id", this.tableName);
            this.kmlFields = new HashMap();
            for (int fieldId = 1; fieldId <= metaData.getColumnCount(); ++fieldId) {
                String fieldTypeName = metaData.getColumnTypeName(fieldId);
                if (fieldTypeName.equalsIgnoreCase("geometry")) continue;
                String fieldName = metaData.getColumnName(fieldId);
                this.writeSimpleField(xmlOut, fieldName, KMLWriterDriver.getKMLType(metaData.getColumnType(fieldId), fieldTypeName));
                this.kmlFields.put(fieldId, fieldName);
            }
            xmlOut.writeEndElement();
        }
    }

    private void writeSimpleField(XMLStreamWriter xmlOut, String columnName, String columnType) throws XMLStreamException {
        xmlOut.writeStartElement("SimpleField");
        xmlOut.writeAttribute("name", columnName);
        xmlOut.writeAttribute("type", columnType);
        xmlOut.writeEndElement();
    }

    public void writePlacemark(XMLStreamWriter xmlOut, ResultSet rs, String geomField) throws XMLStreamException, SQLException {
        xmlOut.writeStartElement("Placemark");
        if (this.columnCount > 1) {
            this.writeExtendedData(xmlOut, rs);
        }
        StringBuilder sb = new StringBuilder();
        Geometry geom = (Geometry)rs.getObject(geomField);
        int inputSRID = geom.getSRID();
        if (inputSRID == 0) {
            throw new SQLException("A coordinate reference system must be set to save the KML file");
        }
        if (inputSRID != 4326) {
            throw new SQLException("The kml format supports only the WGS84 projection.");
        }
        KMLGeometry.toKMLGeometry(geom, ExtrudeMode.NONE, 0, sb);
        xmlOut.writeCharacters(sb.toString());
        xmlOut.writeEndElement();
    }

    public void writeExtendedData(XMLStreamWriter xmlOut, ResultSet rs) throws XMLStreamException, SQLException {
        xmlOut.writeStartElement("ExtendedData");
        xmlOut.writeStartElement("SchemaData");
        xmlOut.writeAttribute("schemaUrl", "#" + this.tableName);
        for (Map.Entry<Integer, String> entry : this.kmlFields.entrySet()) {
            Integer fieldIndex = entry.getKey();
            String fieldName = entry.getValue();
            this.writeSimpleData(xmlOut, fieldName, rs.getString(fieldIndex));
        }
        xmlOut.writeEndElement();
        xmlOut.writeEndElement();
    }

    public void writeSimpleData(XMLStreamWriter xmlOut, String columnName, String value) throws XMLStreamException {
        xmlOut.writeStartElement("SimpleData");
        xmlOut.writeAttribute("name", columnName);
        xmlOut.writeCharacters(value);
        xmlOut.writeEndElement();
    }

    private static String getKMLType(int sqlTypeId, String sqlTypeName) throws SQLException {
        switch (sqlTypeId) {
            case 16: {
                return "bool";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case -5: 
            case 4: {
                return "int";
            }
            case 5: {
                return "short";
            }
            case -15: 
            case 1: 
            case 12: 
            case 91: {
                return "string";
            }
        }
        throw new SQLException("Field type not supported by KML : " + sqlTypeName);
    }
}

