/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class ST_GeomFromWKB
extends DeterministicScalarFunction {
    public ST_GeomFromWKB() {
        this.addProperty("remarks", "Convert a binary large object to a geometry object.\nAn optional integer parameter could be used to specify the SRID.");
    }

    public String getJavaStaticMethod() {
        return "toGeometry";
    }

    public static Geometry toGeometry(byte[] bytes, int srid) throws SQLException {
        if (bytes == null) {
            return null;
        }
        WKBReader wkbReader = new WKBReader();
        try {
            Geometry geometry = wkbReader.read(bytes);
            geometry.setSRID(srid);
            return geometry;
        }
        catch (ParseException ex) {
            throw new SQLException("Cannot parse the input bytes", ex);
        }
    }

    public static Geometry toGeometry(byte[] bytes) throws SQLException {
        return ST_GeomFromWKB.toGeometry(bytes, 0);
    }
}

